/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.util.python;

import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JOptionPane;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.python.core.ClassDictInit;
import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyObject;
import org.python.core.PyString;

public class JUMP_GIS_Framework
implements ClassDictInit {
    public static WorkbenchContext workbenchContext = null;
    private static boolean logInited = false;

    public static void setWorkbenchContext(WorkbenchContext workContext) {
        workbenchContext = workContext;
    }

    public static void classDictInit(PyObject dict) {
        Field[] fields = JUMP_GIS_Framework.class.getFields();
        String doc = new String();
        for (int i = 0; i < fields.length; ++i) {
            doc = doc + "\n" + fields[i];
        }
        dict.__setitem__("__doc__", (PyObject)new PyString(doc));
        dict.__delitem__("classDictInit");
        dict.__delitem__("setWorkbenchContext");
    }

    public static Collection getLayers() {
        return workbenchContext.getLayerNamePanel().getLayerManager().getLayers();
    }

    public static Collection getLayersWithSelectedItems() {
        Collection<Layer> layers = workbenchContext.getLayerViewPanel().getSelectionManager().getLayersWithSelectedItems();
        ArrayList<Layer> al = new ArrayList<Layer>();
        Iterator<Layer> i = layers.iterator();
        while (i.hasNext()) {
            al.add(i.next());
        }
        return al;
    }

    public static Collection getSelectedLayers() {
        return workbenchContext.getLayerNamePanel().selectedNodes(Layer.class);
    }

    public static Collection getSelectedFeatures() {
        return workbenchContext.getLayerViewPanel().getSelectionManager().getFeaturesWithSelectedItems();
    }

    public static Collection featuresOnLayer(Layer layer) {
        try {
            Collection<Feature> features = workbenchContext.getLayerViewPanel().getSelectionManager().getFeaturesWithSelectedItems(layer);
            ArrayList<Feature> al = new ArrayList<Feature>();
            Iterator<Feature> i = features.iterator();
            while (i.hasNext()) {
                al.add(i.next());
            }
            return al;
        }
        catch (Exception ex) {
            throw new PyException(Py.ValueError, (PyObject)new PyString("Invalid Layer"));
        }
    }

    public static Collection filterFeatures(Collection features, String[] types) {
        boolean selectEmpty = false;
        boolean selectPoint = false;
        boolean selectMultiPoint = false;
        boolean selectLineString = false;
        boolean selectLinearRing = false;
        boolean selectMultiLineString = false;
        boolean selectPolygon = false;
        boolean selectMultiPolygon = false;
        boolean selectGeometryCollection = false;
        ArrayList<Feature> filteredFeatures = new ArrayList<Feature>();
        try {
            for (int i = 0; i < types.length; ++i) {
                if (types[i] == null) continue;
                if (types[i].equalsIgnoreCase("POINT")) {
                    selectPoint = true;
                    continue;
                }
                if (types[i].equalsIgnoreCase("MULTIPOINT")) {
                    selectMultiPoint = true;
                    continue;
                }
                if (types[i].equalsIgnoreCase("LINESTRING")) {
                    selectLineString = true;
                    continue;
                }
                if (types[i].equalsIgnoreCase("LINEARRING")) {
                    selectLinearRing = true;
                    continue;
                }
                if (types[i].equalsIgnoreCase("MULTILINESTRING")) {
                    selectMultiLineString = true;
                    continue;
                }
                if (types[i].equalsIgnoreCase("POLYGON")) {
                    selectPolygon = true;
                    continue;
                }
                if (types[i].equalsIgnoreCase("MULTIPOLYGON")) {
                    selectMultiPolygon = true;
                    continue;
                }
                if (types[i].equalsIgnoreCase("GEOMETRYCOLLECTION")) {
                    selectGeometryCollection = true;
                    continue;
                }
                if (!types[i].equalsIgnoreCase("EMPTY")) continue;
                selectEmpty = true;
            }
        }
        catch (Exception ex) {
            throw new PyException(Py.ValueError, (PyObject)new PyString("Invalid String in list"));
        }
        try {
            for (Feature feature : features) {
                if (feature == null || !(feature instanceof Feature)) continue;
                boolean addFeature = false;
                Geometry geo = feature.getGeometry();
                if (selectPoint && geo instanceof Point) {
                    addFeature = true;
                } else if (selectMultiPoint && geo instanceof MultiPoint) {
                    addFeature = true;
                } else if (selectLineString && geo instanceof LineString) {
                    addFeature = true;
                } else if (selectLinearRing && geo instanceof LinearRing) {
                    addFeature = true;
                } else if (selectMultiLineString && geo instanceof MultiLineString) {
                    addFeature = true;
                } else if (selectPolygon && geo instanceof Polygon) {
                    addFeature = true;
                } else if (selectMultiPolygon && geo instanceof MultiPolygon) {
                    addFeature = true;
                } else if (selectGeometryCollection && geo instanceof GeometryCollection) {
                    addFeature = true;
                } else if (selectEmpty && geo.isEmpty()) {
                    addFeature = true;
                }
                if (!addFeature) continue;
                filteredFeatures.add(feature);
            }
        }
        catch (Exception ex) {
            throw new PyException(Py.ValueError, (PyObject)new PyString("Invalid Feature in list"));
        }
        return filteredFeatures;
    }

    public static void clearSelection() {
        workbenchContext.getLayerViewPanel().getSelectionManager().clear();
    }

    public static void selectFeatures(Collection features) {
        try {
            LayerViewPanel layerViewPanel = workbenchContext.getLayerViewPanel();
            List<Layer> layers = workbenchContext.getLayerNamePanel().getLayerManager().getLayers();
            for (Layer layer : layers) {
                layerViewPanel.getSelectionManager().getFeatureSelection().selectItems(layer, features);
            }
        }
        catch (Exception ex) {
            throw new PyException(Py.ValueError, (PyObject)new PyString("Invalid Feature in list"));
        }
    }

    public static void warnUser(String statusMessage) {
        workbenchContext.getLayerViewPanel().getContext().warnUser(statusMessage);
    }

    public static void showMessage(String message) {
        JOptionPane.showMessageDialog(workbenchContext.getLayerViewPanel(), message);
    }

    public static int confirmMessage(String message, String title) {
        return JOptionPane.showConfirmDialog(workbenchContext.getLayerViewPanel(), message, title, 2);
    }

    public static void logMessage(String message, boolean startNewPage) {
        if (!logInited || startNewPage) {
            logInited = true;
            workbenchContext.getWorkbench().getFrame().getOutputFrame().createNewDocument();
        }
        workbenchContext.getWorkbench().getFrame().getOutputFrame().addText(message);
    }

    public static int getInput(String[] map, String title) {
        MultiInputDialog dialog = new MultiInputDialog(workbenchContext.getWorkbench().getFrame(), title, true);
        for (int i = 0; i < map.length; i += 2) {
            dialog.addTextField(map[i], map[i + 1], 10, null, "");
        }
        dialog.setVisible(true);
        boolean okClicked = dialog.wasOKPressed();
        if (okClicked) {
            for (int i = 0; i < map.length; i += 2) {
                map[i + 1] = dialog.getText(map[i]);
            }
            return 0;
        }
        return 2;
    }

    public static void repaint() {
        workbenchContext.getLayerViewPanel().repaint();
    }
}

