/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.tools;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.BasicFeature;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.AttributeTypeFilter;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.plugin.clipboard.PasteItemsPlugIn;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JRadioButton;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.geom.util.GeometryFixer;
import org.locationtech.jts.operation.linemerge.LineMerger;
import org.locationtech.jts.operation.overlayng.OverlayNGRobust;
import org.locationtech.jts.operation.overlayng.UnaryUnionNG;
import org.openjump.core.ui.plugin.AbstractThreadedUiPlugIn;

public class UnionByAttributePlugIn
extends AbstractThreadedUiPlugIn {
    private static final String LAYER = I18N.getInstance().get("ui.plugin.analysis.UnionByAttributePlugIn.layer");
    private static final String SELECTION = I18N.getInstance().get("ui.plugin.analysis.UnionByAttributePlugIn.selection");
    private static final String SELECTION_HELP = I18N.getInstance().get("ui.plugin.analysis.UnionByAttributePlugIn.selection-help");
    private static final String USE_ATTRIBUTE = I18N.getInstance().get("ui.plugin.analysis.UnionByAttributePlugIn.use-attribute");
    private static final String ATTRIBUTE = I18N.getInstance().get("ui.plugin.analysis.UnionByAttributePlugIn.attribute");
    private static final String IGNORE_EMPTY = I18N.getInstance().get("ui.plugin.analysis.UnionByAttributePlugIn.ignore-empty");
    private static final String MERGE_LINESTRINGS = I18N.getInstance().get("ui.plugin.analysis.UnionByAttributePlugIn.merge-linestrings");
    private static final String AGG_UNUSED_FIELDS = I18N.getInstance().get("ui.plugin.analysis.UnionByAttributePlugIn.aggregate-unused-fields");
    private final String FLOATING_PRECISION_MODEL = I18N.JUMP.get("jts.use-floating-point-precision-model");
    private final String FLOATING_PRECISION_MODEL_TT = I18N.JUMP.get("jts.use-floating-point-precision-model-tt");
    private final String FIXED_PRECISION_MODEL = I18N.JUMP.get("jts.use-fixed-precision-model");
    private final String FIXED_PRECISION_MODEL_TT = I18N.JUMP.get("jts.use-fixed-precision-model-tt");
    private final String PRECISION = I18N.JUMP.get("jts.fixed-precision");
    private final String PRECISION_TT = I18N.JUMP.get("jts.fixed-precision-tt");
    private Layer layer;
    private boolean use_selection = false;
    private boolean use_attribute = false;
    private String attribute;
    private boolean ignore_empty = false;
    private boolean merge_linestrings = true;
    private boolean aggregate_unused_fields = false;
    private boolean floatingPrecision = true;
    private boolean fixedPrecision = false;
    private double precision = 1000.0;
    private GeometryFactory factory;

    @Override
    public String getName() {
        return I18N.getInstance().get("ui.plugin.analysis.UnionByAttributePlugIn");
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
        context.getFeatureInstaller().addMainMenuPlugin(this, new String[]{MenuNames.TOOLS, MenuNames.TOOLS_ANALYSIS}, this.getName() + "...", false, IconLoader.icon("union_layer_icon.gif"), UnionByAttributePlugIn.createEnableCheck(context.getWorkbenchContext()), -1);
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createTaskWindowMustBeActiveCheck()).add(checkFactory.createAtLeastNLayersMustExistCheck(1));
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        MultiInputDialog dialog = new MultiInputDialog(context.getWorkbenchFrame(), this.getName(), true);
        int n = context.getLayerViewPanel().getSelectionManager().getFeaturesWithSelectedItems().size();
        this.use_selection = n > 0;
        this.initDialog(dialog, context);
        GUIUtil.centreOnWindow(dialog);
        dialog.setVisible(true);
        if (!dialog.wasOKPressed()) {
            return false;
        }
        this.getDialogValues(dialog);
        return true;
    }

    private void initDialog(final MultiInputDialog dialog, PlugInContext context) {
        dialog.addSubTitle(I18N.JUMP.get("ui.plugin.analysis.UnionByAttributePlugIn.processed-data"));
        dialog.addLabel(SELECTION);
        dialog.addLabel(SELECTION_HELP);
        final JComboBox<Layer> layerComboBox = dialog.addLayerComboBox(LAYER, context.getCandidateLayer(0), context.getLayerManager());
        JCheckBox useAttributeCheckBox = dialog.addCheckBox(USE_ATTRIBUTE, false, "");
        dialog.addAttributeComboBox(ATTRIBUTE, LAYER, AttributeTypeFilter.NO_GEOMETRY_FILTER, null);
        dialog.addCheckBox(IGNORE_EMPTY, true);
        dialog.addSeparator();
        JRadioButton floatingPrecisionRB = dialog.addRadioButton(this.FLOATING_PRECISION_MODEL, "MODEL", this.floatingPrecision, this.FLOATING_PRECISION_MODEL_TT);
        JRadioButton fixedPrecisionRB = dialog.addRadioButton(this.FIXED_PRECISION_MODEL, "MODEL", this.fixedPrecision, this.FIXED_PRECISION_MODEL_TT);
        dialog.addDoubleField(this.PRECISION, this.precision, 12, this.PRECISION_TT);
        floatingPrecisionRB.addActionListener(e -> this.updateControls(dialog));
        fixedPrecisionRB.addActionListener(e -> this.updateControls(dialog));
        dialog.addSeparator();
        JCheckBox mergeLineStringsCheckBox = dialog.addCheckBox(MERGE_LINESTRINGS, this.merge_linestrings, I18N.JUMP.get("ui.plugin.analysis.UnionByAttributePlugIn.merge-linestrings-tooltip"));
        dialog.addCheckBox(AGG_UNUSED_FIELDS, this.aggregate_unused_fields, I18N.JUMP.get("ui.plugin.analysis.UnionByAttributePlugIn.aggregation-tooltip"));
        this.updateControls(dialog);
        useAttributeCheckBox.addActionListener(e -> this.updateControls(dialog));
        layerComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (ActionListener listener : layerComboBox.getActionListeners()) {
                    if (listener == this) continue;
                    listener.actionPerformed(e);
                }
                UnionByAttributePlugIn.this.updateControls(dialog);
            }
        });
        mergeLineStringsCheckBox.addActionListener(e -> this.updateControls(dialog));
    }

    private void getDialogValues(MultiInputDialog dialog) {
        this.layer = dialog.getLayer(LAYER);
        this.use_attribute = dialog.getBoolean(USE_ATTRIBUTE);
        this.attribute = dialog.getText(ATTRIBUTE);
        this.ignore_empty = dialog.getBoolean(IGNORE_EMPTY) && this.use_attribute;
        this.merge_linestrings = dialog.getBoolean(MERGE_LINESTRINGS);
        this.aggregate_unused_fields = dialog.getBoolean(AGG_UNUSED_FIELDS);
        this.floatingPrecision = dialog.getBoolean(this.FLOATING_PRECISION_MODEL);
        this.fixedPrecision = dialog.getBoolean(this.FIXED_PRECISION_MODEL);
        this.precision = dialog.getDouble(this.PRECISION);
    }

    private void updateControls(MultiInputDialog dialog) {
        this.getDialogValues(dialog);
        FeatureSchema schema = this.layer.getFeatureCollectionWrapper().getFeatureSchema();
        boolean has_attributes = !AttributeTypeFilter.NO_GEOMETRY_FILTER.filter(schema).isEmpty();
        int other_fields = AttributeTypeFilter.NUMSTRING_FILTER.filter(schema).size();
        if (this.use_attribute) {
            --other_fields;
        }
        dialog.setFieldVisible(SELECTION, this.use_selection);
        dialog.setFieldVisible(SELECTION_HELP, this.use_selection);
        dialog.setFieldVisible(LAYER, !this.use_selection);
        dialog.setFieldEnabled(USE_ATTRIBUTE, has_attributes && !this.use_selection);
        dialog.setFieldEnabled(ATTRIBUTE, has_attributes && !this.use_selection);
        dialog.setFieldEnabled(IGNORE_EMPTY, has_attributes && !this.use_selection);
        dialog.setFieldEnabled(AGG_UNUSED_FIELDS, has_attributes && !this.use_selection);
        dialog.setFieldEnabled(USE_ATTRIBUTE, has_attributes);
        dialog.setFieldEnabled(ATTRIBUTE, has_attributes && this.use_attribute);
        dialog.setFieldEnabled(IGNORE_EMPTY, has_attributes && this.use_attribute);
        dialog.setFieldEnabled(AGG_UNUSED_FIELDS, other_fields > 0);
        if (this.use_selection) {
            dialog.setSideBarDescription(I18N.getInstance().get("ui.plugin.analysis.UnionByAttributePlugIn.union-selection-description"));
            if (this.merge_linestrings) {
                dialog.setSideBarImage(IconLoader.icon("union_selection_merge.png"));
            } else {
                dialog.setSideBarImage(IconLoader.icon("union_selection_no_merge.png"));
            }
        } else if (!this.use_attribute || !has_attributes) {
            dialog.setSideBarDescription(I18N.getInstance().get("ui.plugin.analysis.UnionByAttributePlugIn.union-layer-description", this.layer.getName()));
            if (this.merge_linestrings) {
                dialog.setSideBarImage(IconLoader.icon("union_layer_merge.png"));
            } else {
                dialog.setSideBarImage(IconLoader.icon("union_layer_no_merge.png"));
            }
        } else {
            dialog.setSideBarDescription(I18N.getInstance().get("ui.plugin.analysis.UnionByAttributePlugIn.union-layer-by-attribute-description", this.layer.getName(), this.attribute));
            if (this.merge_linestrings) {
                dialog.setSideBarImage(IconLoader.icon("dissolve_layer_merge.png"));
            } else {
                dialog.setSideBarImage(IconLoader.icon("dissolve_layer_no_merge.png"));
            }
        }
        dialog.setFieldEnabled(this.PRECISION, dialog.getBoolean(this.FIXED_PRECISION_MODEL));
        dialog.pack();
    }

    @Override
    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        FeatureSchema schema;
        Collection inputC;
        monitor.allowCancellationRequests();
        if (this.use_selection) {
            inputC = context.getLayerViewPanel().getSelectionManager().getFeaturesWithSelectedItems();
            Feature feature = inputC.iterator().next();
            schema = feature.getSchema();
            inputC = PasteItemsPlugIn.conform(inputC, schema);
        } else {
            inputC = this.layer.getFeatureCollectionWrapper().getFeatures();
            schema = this.layer.getFeatureCollectionWrapper().getFeatureSchema();
        }
        FeatureDataset inputFC = new FeatureDataset(inputC, schema);
        if (inputFC.getFeatures().size() <= 1 || inputFC.getFeatures().get(0).getGeometry() == null) {
            context.getWorkbenchFrame().warnUser(I18N.getInstance().get("ui.plugin.analysis.UnionByAttributePlugIn.needs-two-features-or-more"));
            return;
        }
        this.factory = inputFC.getFeatures().get(0).getGeometry().getFactory();
        this.writeReport(context);
        FeatureSchema newSchema = new FeatureSchema();
        newSchema.addAttribute(schema.getAttributeName(schema.getGeometryIndex()), AttributeType.GEOMETRY);
        if (this.use_attribute && !this.attribute.equals(MultiInputDialog.NO_VALID_ATTRIBUTE)) {
            newSchema.addAttribute(this.attribute, schema.getAttributeType(this.attribute));
        }
        if (this.aggregate_unused_fields) {
            int max = schema.getAttributeCount();
            for (int i = 0; i < max; ++i) {
                if (schema.getAttributeType(i) != AttributeType.INTEGER && schema.getAttributeType(i) != AttributeType.DOUBLE && schema.getAttributeType(i) != AttributeType.STRING || this.use_attribute && !this.attribute.equals(MultiInputDialog.NO_VALID_ATTRIBUTE) && this.attribute.equals(schema.getAttributeName(i))) continue;
                newSchema.addAttribute(schema.getAttributeName(i), schema.getAttributeType(i));
            }
        }
        HashMap map = new HashMap();
        monitor.report(I18N.getInstance().get("ui.plugin.analysis.UnionByAttributePlugIn"));
        for (Feature f : inputFC.getFeatures()) {
            Iterator key;
            Iterator iterator = key = this.use_attribute ? f.getAttribute(this.attribute) : null;
            if (this.ignore_empty && (key == null || key.toString().trim().length() == 0)) continue;
            if (!map.containsKey(key)) {
                FeatureDataset fd = new FeatureDataset(inputFC.getFeatureSchema());
                fd.add(f);
                map.put(key, fd);
                continue;
            }
            ((FeatureCollection)map.get(key)).add(f);
        }
        int count = 1;
        FeatureDataset resultfc = new FeatureDataset(newSchema);
        for (Object key : map.keySet()) {
            monitor.report(I18N.getInstance().get("ui.plugin.analysis.UnionByAttributePlugIn.computing-union") + " (" + count++ + "/" + map.size() + ")");
            FeatureCollection fca = (FeatureCollection)map.get(key);
            if (fca.size() <= 0) continue;
            Feature feature = this.union(context, monitor, fca);
            if (this.use_attribute) {
                feature.setAttribute(this.attribute, key);
            }
            BasicFeature newFeature = new BasicFeature(newSchema);
            int max = newSchema.getAttributeCount();
            for (int j = 0; j < max; ++j) {
                newFeature.setAttribute(j, feature.getAttribute(newSchema.getAttributeName(j)));
            }
            resultfc.add(newFeature);
        }
        context.getLayerManager().addCategory(StandardCategoryNames.RESULT);
        String newLayerName = this.layer.getName() + (this.use_attribute ? "-" + this.attribute + " (dissolve)" : " (union)");
        context.addLayer(StandardCategoryNames.RESULT, newLayerName, resultfc);
        context.getOutputFrame().append("<h3>" + I18N.getInstance().get("ui.plugin.analysis.UnionByAttributePlugIn.end-of-process") + " " + I18N.getInstance().get("ui.plugin.analysis.UnionByAttributePlugIn") + "</h3>");
    }

    private Feature union(PlugInContext context, TaskMonitor monitor, FeatureCollection fc) {
        ArrayList<Geometry> geometries = new ArrayList<Geometry>();
        for (Feature f : fc.getFeatures()) {
            Geometry g = f.getGeometry();
            if (g.isValid()) {
                geometries.add(g);
                continue;
            }
            geometries.add(GeometryFixer.fix((Geometry)g));
        }
        Geometry unioned = this.floatingPrecision ? OverlayNGRobust.union(geometries) : UnaryUnionNG.union(geometries, (PrecisionModel)new PrecisionModel(this.precision));
        if (this.merge_linestrings) {
            geometries.clear();
            ArrayList<Geometry> points = new ArrayList<Geometry>();
            ArrayList<Geometry> lineStrings = new ArrayList<Geometry>();
            ArrayList<Geometry> polygons = new ArrayList<Geometry>();
            this.decompose(unioned, points, lineStrings, polygons);
            LineMerger merger = new LineMerger();
            merger.add(lineStrings);
            geometries.addAll(points);
            geometries.addAll(merger.getMergedLineStrings());
            geometries.addAll(polygons);
            unioned = unioned.getFactory().buildGeometry(geometries);
        }
        FeatureSchema schema = fc.getFeatureSchema();
        Feature feature = new BasicFeature(schema);
        if (geometries.size() == 0) {
            feature.setGeometry((Geometry)this.factory.createGeometryCollection(new Geometry[0]));
        } else {
            feature.setGeometry(unioned);
        }
        if (this.aggregate_unused_fields) {
            feature = this.aggregateValues(context, fc, feature);
        }
        return feature;
    }

    private void decompose(Geometry geometry, List<Geometry> dim0, List<Geometry> dim1, List<Geometry> dim2) {
        if (geometry instanceof GeometryCollection) {
            for (int i = 0; i < geometry.getNumGeometries(); ++i) {
                this.decompose(geometry.getGeometryN(i), dim0, dim1, dim2);
            }
        } else if (geometry.getDimension() == 2) {
            dim2.add(geometry);
        } else if (geometry.getDimension() == 1) {
            dim1.add(geometry);
        } else if (geometry.getDimension() == 0) {
            dim0.add(geometry);
        } else assert (false) : "Should never reach here";
    }

    private Feature aggregateValues(PlugInContext context, FeatureCollection fc, Feature feature) {
        FeatureSchema schema = fc.getFeatureSchema();
        int max = schema.getAttributeCount();
        for (int i = 0; i < max; ++i) {
            Object val;
            if (schema.getAttributeType(i) == AttributeType.INTEGER) {
                int total = 0;
                for (Feature feature2 : fc.getFeatures()) {
                    Object val2 = feature2.getAttribute(i);
                    if (val2 == null) continue;
                    total += ((Integer)val2).intValue();
                }
                feature.setAttribute(i, (Object)total);
            }
            if (schema.getAttributeType(i) == AttributeType.LONG) {
                long total = 0L;
                for (Feature f : fc.getFeatures()) {
                    val = f.getAttribute(i);
                    if (val == null) continue;
                    total += ((Long)val).longValue();
                }
                feature.setAttribute(i, (Object)total);
                continue;
            }
            if (schema.getAttributeType(i) == AttributeType.DOUBLE) {
                double total = 0.0;
                for (Feature f : fc.getFeatures()) {
                    val = f.getAttribute(i);
                    if (val == null) continue;
                    total += ((Double)val).doubleValue();
                }
                feature.setAttribute(i, (Object)total);
                continue;
            }
            if (schema.getAttributeType(i) == AttributeType.STRING) {
                TreeSet<String> set = new TreeSet<String>();
                for (Feature feature3 : fc.getFeatures()) {
                    String val2 = feature3.getString(i);
                    if (val2 == null) continue;
                    set.add(val2);
                }
                feature.setAttribute(i, (Object)Arrays.toString(set.toArray()));
                continue;
            }
            if (schema.getAttributeType(i) == AttributeType.GEOMETRY) continue;
            context.getOutputFrame().addText(I18N.getInstance().get("ui.plugin.analysis.UnionByAttributePlugIn.cannot-be-aggregated", schema.getAttributeName(i), schema.getAttributeType(i)));
        }
        return feature;
    }

    private void writeReport(PlugInContext context) {
        context.getOutputFrame().createNewDocument();
        context.getOutputFrame().append("<h1>" + I18N.getInstance().get("ui.plugin.analysis.UnionByAttributePlugIn") + "</h1>");
        context.getOutputFrame().addText(I18N.getInstance().get("ui.plugin.analysis.UnionByAttributePlugIn.processed-data") + " : " + (this.use_selection ? I18N.getInstance().get("ui.plugin.analysis.UnionByAttributePlugIn.selection") : this.layer.getName()));
        context.getOutputFrame().addText(I18N.getInstance().get("ui.plugin.analysis.UnionByAttributePlugIn.use-attribute") + " : " + (this.use_attribute ? this.attribute : I18N.getInstance().get("ui.plugin.analysis.UnionByAttributePlugIn.no-attribute-used")));
        context.getOutputFrame().addText(I18N.getInstance().get("ui.plugin.analysis.UnionByAttributePlugIn.empty-values") + " : " + (this.ignore_empty ? I18N.getInstance().get("ui.plugin.analysis.UnionByAttributePlugIn.ignore") : I18N.getInstance().get("ui.plugin.analysis.UnionByAttributePlugIn.process")));
        context.getOutputFrame().addText(I18N.getInstance().get("ui.plugin.analysis.UnionByAttributePlugIn.merge-linestrings") + " : " + (this.merge_linestrings ? I18N.getInstance().get("ui.plugin.analysis.UnionByAttributePlugIn.yes") : I18N.getInstance().get("ui.plugin.analysis.UnionByAttributePlugIn.no")));
        context.getOutputFrame().addText(I18N.getInstance().get("ui.plugin.analysis.UnionByAttributePlugIn.aggregate-unused-fields") + " : " + (this.aggregate_unused_fields ? I18N.getInstance().get("ui.plugin.analysis.UnionByAttributePlugIn.yes") : I18N.getInstance().get("ui.plugin.analysis.UnionByAttributePlugIn.no")));
        context.getOutputFrame().append("<h3>" + I18N.getInstance().get("ui.plugin.analysis.UnionByAttributePlugIn.warnings") + "</h3>");
    }
}

