/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.tools;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedBasePlugIn;
import com.vividsolutions.jump.workbench.ui.ErrorDialog;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.GenericNames;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;
import java.util.ArrayList;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.openjump.sigle.plugin.joinTable.JoinTable;

public class JoinTablePlugIn
extends ThreadedBasePlugIn {
    protected static String name = "JoinTable";
    public static FileFilter JOIN_TABLE_FILE_FILTER = null;
    private Layer layer;
    private JFileChooser fileChooser;
    private MultiInputDialog dialog;
    private MultiInputDialog layerdialog;
    private String LAYER_ATTRIBUTES = null;
    private String TABLE_ATTRIBUTES = null;
    private String sLAYER = GenericNames.LAYER;

    @Override
    public void initialize(PlugInContext context) throws Exception {
        JOIN_TABLE_FILE_FILTER = GUIUtil.createFileFilter(I18N.getInstance().get("org.openjump.sigle.plugin.joinTable.text_file"), new String[]{"txt", "text"});
        this.LAYER_ATTRIBUTES = I18N.getInstance().get("org.openjump.sigle.plugin.joinTable.layer_field");
        this.TABLE_ATTRIBUTES = I18N.getInstance().get("org.openjump.sigle.plugin.joinTable.table_field");
        FeatureInstaller featureInstaller = context.getFeatureInstaller();
        featureInstaller.addMainMenuItem(this, new String[]{MenuNames.TOOLS, MenuNames.TOOLS_EDIT_ATTRIBUTES}, this.getName() + "...", false, null, EnableCheckFactory.getInstance(context.getWorkbenchContext()).createAtLeastNLayersMustExistCheck(1));
        this.fileChooser = GUIUtil.createJFileChooserWithExistenceChecking();
        this.fileChooser.setDialogTitle(I18N.getInstance().get("org.openjump.sigle.plugin.joinTable.Choose_file_data_to_join"));
        this.fileChooser.setDialogType(0);
        this.fileChooser.setFileSelectionMode(0);
        this.fileChooser.setMultiSelectionEnabled(false);
        GUIUtil.removeChoosableFileFilters(this.fileChooser);
        this.fileChooser.addChoosableFileFilter(JOIN_TABLE_FILE_FILTER);
        this.fileChooser.addChoosableFileFilter(GUIUtil.ALL_FILES_FILTER);
        this.fileChooser.setFileFilter(JOIN_TABLE_FILE_FILTER);
    }

    @Override
    public String getName() {
        return I18N.getInstance().get("org.openjump.sigle.plugin.joinTable.Join_data");
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.reportNothingToUndoYet(context);
        if (0 != this.fileChooser.showOpenDialog(context.getWorkbenchFrame())) {
            return false;
        }
        this.sLAYER = GenericNames.LAYER;
        this.initLayerDialog(context);
        this.layerdialog.setVisible(true);
        if (!this.layerdialog.wasOKPressed()) {
            return false;
        }
        this.layer = this.layerdialog.getLayer(this.sLAYER);
        if (this.layer.getFeatureCollectionWrapper().getFeatureSchema().getAttributeCount() == 0) {
            ErrorDialog.show(context.getWorkbenchFrame(), I18N.getInstance().get("org.openjump.sigle.plugin.joinTable.Unable_to_join_data"), I18N.getInstance().get("org.openjump.sigle.plugin.joinTable.Layer_has_no_field"), "");
            return false;
        }
        JoinTable jt = new JoinTable(this.fileChooser.getSelectedFile().getAbsolutePath());
        this.initDialog(context, jt, this.layer);
        this.dialog.setVisible(true);
        if (!this.dialog.wasOKPressed()) {
            jt.dispose();
            return false;
        }
        jt.setKeyIndex(this.dialog.getComboBox(this.TABLE_ATTRIBUTES).getSelectedIndex());
        jt.build();
        jt.join(this.layer, this.dialog.getComboBox(this.LAYER_ATTRIBUTES).getSelectedIndex());
        jt.dispose();
        System.gc();
        return true;
    }

    @Override
    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
    }

    private void initDialog(PlugInContext context, JoinTable jt, Layer layer) {
        FeatureSchema schema = layer.getFeatureCollectionWrapper().getFeatureSchema();
        ArrayList<String> layerAttributes = new ArrayList<String>(schema.getAttributeCount());
        for (int i = 0; i < schema.getAttributeCount(); ++i) {
            layerAttributes.add(i, schema.getAttributeName(i));
        }
        this.dialog = new MultiInputDialog(context.getWorkbenchFrame(), I18N.getInstance().get("org.openjump.sigle.plugin.joinTable.Matching_fields"), true);
        this.dialog.setSideBarDescription(I18N.getInstance().get("org.openjump.sigle.plugin.joinTable.Choose_fields_to_join"));
        this.dialog.addComboBox(this.LAYER_ATTRIBUTES, layerAttributes.get(0), layerAttributes, null);
        this.dialog.addComboBox(this.TABLE_ATTRIBUTES, jt.getFieldName(0), jt.getFieldNames(), null);
        GUIUtil.centreOnWindow(this.dialog);
    }

    private void initLayerDialog(PlugInContext context) {
        this.layerdialog = new MultiInputDialog(context.getWorkbenchFrame(), "", true);
        this.layerdialog.setSideBarDescription(I18N.getInstance().get("org.openjump.sigle.plugin.joinTable.MenuName"));
        String fieldName = this.sLAYER;
        JComboBox<Layer> addLayerComboBox = this.layerdialog.addLayerComboBox(fieldName, context.getCandidateLayer(0), null, context.getLayerManager());
        GUIUtil.centreOnWindow(this.layerdialog);
    }
}

