/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.tools;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.FeatureEventType;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.UndoableCommand;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.AttributeTypeFilter;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.OKCancelDialog;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.openjump.core.ui.plugin.AbstractUiPlugIn;
import org.openjump.core.ui.plugin.tools.AutoAssignAttributePlugIn;

public class GenerateRandomStringPlugIn
extends AbstractUiPlugIn {
    private static String LAYER = I18N.getInstance().get("ui.GenericNames.select-layer");
    private static String ATTRIBUTE = I18N.getInstance().get("ui.GenericNames.select-attribute");
    private static String RANDOM = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.GenerateRandom");
    private static String MIN_LENGTH = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.GenerateRandomStringPlugIn.min-length");
    private static String MIN_LENGTH_TT = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.GenerateRandomStringPlugIn.min-length-tooltip");
    private static String MAX_LENGTH = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.GenerateRandomStringPlugIn.max-length");
    private static String MAX_LENGTH_TT = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.GenerateRandomStringPlugIn.max-length-tooltip");
    private static String LETTER_BASED = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.GenerateRandomStringPlugIn.letter-based");
    private static String WORD_BASED = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.GenerateRandomStringPlugIn.word-based");
    private static String DIGITS = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.GenerateRandomStringPlugIn.digits");
    private static String HEXA = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.GenerateRandomStringPlugIn.hexa");
    private static String ASCII = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.GenerateRandomStringPlugIn.ascii");
    private static String CITIES = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.GenerateRandomStringPlugIn.cities");
    private static String NAMES = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.GenerateRandomStringPlugIn.names");
    private static String NO_CANDIDATE = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.GenerateRandomStringPlugIn.no-editable-layer-with-string-attribute");
    private static String NON_EMPTY_ATT = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.GenerateRandomStringPlugIn.non-empty-attribute");
    private static String OVERWRITE_PROMPT = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.GenerateRandomStringPlugIn.overwrite-prompt");
    private Layer layer;
    private String attribute;
    private int min;
    private int max;
    private boolean digits = true;
    private boolean hexa;
    private boolean ascii;
    private boolean cities;
    private boolean names;
    private Random rnd = new Random();
    private char[] digitsArray = "0123456789".toCharArray();
    private char[] hexaArray = "0123456789ABCDEF".toCharArray();
    private char[] asciiArray = " !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~".toCharArray();
    private String[] cityArray = new String[]{"Shanghai", "Karachi", "Beijing", "Delhi", "Lagos", "Tianjin", "Istanbul", "Tokyo", "Guangzhou", "Mumbai", "Moscow", "S\u00e3o Paulo", "Shenzhen", "Jakarta", "Lahore", "Seoul", "Kinshasa", "Cairo", "Mexico City", "Lima", "London", "New York City", "Bengaluru", "Bangkok", "Ho Chi Minh City", "Dongguan", "Chongqing", "5,473[d]", "Nanjing", "Tehran", "Shenyang", "Bogot\u00e1", "Ningbo", "Hong Kong", "Hanoi", "Baghdad", "Changsha", "Dhaka", "Wuhan", "Hyderabad", "Chennai", "Rio de Janeiro", "Faisalabad", "Foshan", "Zunyi", "Santiago", "Riyadh", "Ahmedabad", "Singapore", "Shantou", "Yangon", "Saint Petersburg"};
    private String[] surnames = new String[]{"SMITH", "JOHNSON", "WILLIAMS", "BROWN", "JONES", "MILLER", "DAVIS", "GARCIA", "RODRIGUEZ", "WILSON", "MARTINEZ", "ANDERSON", "TAYLOR", "THOMAS", "HERNANDEZ", "MOORE", "MARTIN", "JACKSON", "THOMPSON", "WHITE", "LOPEZ", "LEE", "GONZALEZ", "HARRIS", "CLARK", "LEWIS", "ROBINSON", "WALKER", "PEREZ", "HALL", "YOUNG", "ALLEN", "SANCHEZ", "WRIGHT", "KING", "SCOTT", "GREEN", "BAKER", "ADAMS", "NELSON", "HILL", "RAMIREZ", "CAMPBELL", "MITCHELL", "ROBERTS", "CARTER", "PHILLIPS", "EVANS", "TURNER", "TORRES", "PARKER", "COLLINS", "EDWARDS", "STEWART", "FLORES", "MORRIS", "NGUYEN", "MURPHY", "RIVERA", "COOK", "ROGERS", "MORGAN", "PETERSON", "COOPER", "REED", "BAILEY", "BELL", "GOMEZ", "KELLY", "HOWARD", "WARD", "COX", "DIAZ", "RICHARDSON", "WOOD", "WATSON", "BROOKS", "BENNETT", "GRAY", "JAMES", "REYES", "CRUZ", "HUGHES", "PRICE", "MYERS", "LONG", "FOSTER", "SANDERS", "ROSS", "MORALES", "POWELL", "SULLIVAN", "RUSSELL", "ORTIZ", "JENKINS", "GUTIERREZ", "PERRY", "BUTLER", "BARNES", "FISHER"};
    private String[] firstNames = new String[]{"James", "Mary", "John", "Patricia", "Robert", "Jennifer", "Michael", "Elizabeth", "William", "Linda", "David", "Barbara", "Richard", "Susan", "Joseph", "Jessica", "Thomas", "Margaret", "Charles", "Sarah", "Christopher", "Karen", "Daniel", "Nancy", "Matthew", "Betty", "Anthony", "Dorothy", "Donald", "Lisa", "Mark", "Sandra", "Paul", "Ashley", "Steven", "Kimberly", "George", "Donna", "Kenneth", "Carol", "Andrew", "Michelle", "Joshua", "Emily", "Edward", "Helen", "Brian", "Amanda", "Kevin", "Melissa", "Ronald", "Deborah", "Timothy", "Stephanie", "Jason", "Laura", "Jeffrey", "Rebecca", "Ryan", "Sharon", "Gary", "Cynthia", "Jacob", "Kathleen", "Nicholas", "Shirley", "Eric", "Amy", "Stephen", "Anna", "Jonathan", "Angela", "Larry", "Ruth", "Scott", "Brenda", "Frank", "Pamela", "Justin", "Virginia", "Brandon", "Katherine", "Raymond", "Nicole", "Gregory", "Catherine", "Samuel", "Christine", "Benjamin", "Samantha", "Patrick", "Debra", "Jack", "Janet", "Alexander", "Carolyn", "Dennis", "Rachel", "Jerry", "Heather"};

    @Override
    public void initialize(PlugInContext context) throws Exception {
        FeatureInstaller featureInstaller = context.getFeatureInstaller();
        featureInstaller.addMainMenuPlugin(this, new String[]{MenuNames.TOOLS, MenuNames.TOOLS_EDIT_ATTRIBUTES, RANDOM}, this.getName() + "...", false, null, GenerateRandomStringPlugIn.createEnableCheck(context.getWorkbenchContext()));
    }

    public static MultiEnableCheck createEnableCheck(final WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createAtLeastNLayersMustExistCheck(1)).add(checkFactory.createAtLeastNLayersMustBeEditableCheck(1)).add(new EnableCheck(){

            @Override
            public String check(JComponent component) {
                if (AttributeTypeFilter.STRING_FILTER.filter(workbenchContext.getLayerManager().getEditableLayers()).size() == 0) {
                    return NO_CANDIDATE;
                }
                return null;
            }
        });
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.reportNothingToUndoYet(context);
        MultiInputDialog dialog = new MultiInputDialog(context.getWorkbenchFrame(), this.getName(), true);
        this.setDialogValues(dialog, context);
        GUIUtil.centreOnWindow(dialog);
        dialog.setVisible(true);
        if (!dialog.wasOKPressed()) {
            return false;
        }
        this.getDialogValues(dialog);
        boolean empty = this.checkAttributeEmpty();
        if (!empty) {
            JLabel label = new JLabel();
            label.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            label.setText("<html><body>" + NON_EMPTY_ATT + "<br/>" + OVERWRITE_PROMPT + "</body></html>");
            OKCancelDialog okCancelDialog = new OKCancelDialog(dialog, NON_EMPTY_ATT, true, (Component)label, new OKCancelDialog.Validator(){

                @Override
                public String validateInput(Component component) {
                    return null;
                }
            });
            okCancelDialog.setVisible(true);
            if (!okCancelDialog.wasOKPressed()) {
                return false;
            }
        }
        this.computeRandomValues(context);
        return true;
    }

    private boolean checkAttributeEmpty() {
        for (Feature f : this.layer.getFeatureCollectionWrapper().getFeatures()) {
            if (f.getAttribute(this.attribute) == null) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeRandomValues(PlugInContext context) {
        final ArrayList<Feature> oldFeatures = new ArrayList<Feature>();
        final ArrayList<Feature> newFeatures = new ArrayList<Feature>();
        this.reportNothingToUndoYet(context);
        for (Feature f : this.layer.getFeatureCollectionWrapper().getFeatures()) {
            oldFeatures.add(f.clone(true, true));
            f = f.clone(true, true);
            f.setAttribute(this.attribute, (Object)this.generate(this.min, this.max));
            newFeatures.add(f);
        }
        context.getLayerManager().getUndoableEditReceiver().startReceiving();
        try {
            UndoableCommand command = new UndoableCommand(I18N.getInstance().get(AutoAssignAttributePlugIn.class.getName())){

                @Override
                public void execute() {
                    Iterator newFeatIterator = newFeatures.iterator();
                    for (Feature f : GenerateRandomStringPlugIn.this.layer.getFeatureCollectionWrapper().getFeatures()) {
                        f.setAttribute(GenerateRandomStringPlugIn.this.attribute, ((Feature)newFeatIterator.next()).getAttribute(GenerateRandomStringPlugIn.this.attribute));
                    }
                    GenerateRandomStringPlugIn.this.layer.getLayerManager().fireFeaturesAttChanged(newFeatures, FeatureEventType.ATTRIBUTES_MODIFIED, GenerateRandomStringPlugIn.this.layer, oldFeatures);
                }

                @Override
                public void unexecute() {
                    Iterator oldFeatIterator = oldFeatures.iterator();
                    for (Feature f : GenerateRandomStringPlugIn.this.layer.getFeatureCollectionWrapper().getFeatures()) {
                        f.setAttribute(GenerateRandomStringPlugIn.this.attribute, ((Feature)oldFeatIterator.next()).getAttribute(GenerateRandomStringPlugIn.this.attribute));
                    }
                    GenerateRandomStringPlugIn.this.layer.getLayerManager().fireFeaturesAttChanged(GenerateRandomStringPlugIn.this.layer.getFeatureCollectionWrapper().getFeatures(), FeatureEventType.ATTRIBUTES_MODIFIED, GenerateRandomStringPlugIn.this.layer, newFeatures);
                }
            };
            command.execute();
            this.layer.getLayerManager().getUndoableEditReceiver().receive(command.toUndoableEdit());
        }
        finally {
            this.layer.getLayerManager().getUndoableEditReceiver().stopReceiving();
        }
    }

    private String generate(int min, int max) {
        int l = min + this.rnd.nextInt(1 + Math.max(max - min, 0));
        StringBuilder sb = new StringBuilder(l);
        if (this.digits || this.hexa || this.ascii) {
            char[] array = this.digits ? this.digitsArray : (this.hexa ? this.hexaArray : this.asciiArray);
            for (int i = 0; i < l; ++i) {
                sb.append(array[this.rnd.nextInt(array.length)]);
            }
        } else if (this.cities) {
            sb.append(this.cityArray[this.rnd.nextInt(this.cityArray.length)]);
        } else if (this.names) {
            sb.append(this.firstNames[this.rnd.nextInt(this.cityArray.length)]).append(" ").append(this.surnames[this.rnd.nextInt(this.surnames.length)]);
        }
        return sb.toString();
    }

    private void setDialogValues(MultiInputDialog dialog, PlugInContext context) {
        this.layer = context.getLayerableNamePanel().chooseEditableLayer();
        dialog.addLayerComboBox(LAYER, this.layer, null, AttributeTypeFilter.STRING_FILTER.filter(context.getLayerManager().getEditableLayers()));
        dialog.addAttributeComboBox(ATTRIBUTE, LAYER, AttributeTypeFilter.STRING_FILTER, null);
        String GROUP = "group";
        dialog.addSubTitle(LETTER_BASED);
        dialog.addIntegerField(MIN_LENGTH, this.min, 12, MIN_LENGTH_TT);
        dialog.addIntegerField(MAX_LENGTH, this.max, 12, MAX_LENGTH_TT);
        dialog.addRadioButton(DIGITS, GROUP, this.digits, null);
        dialog.addRadioButton(HEXA, GROUP, this.hexa, null);
        dialog.addRadioButton(ASCII, GROUP, this.ascii, null);
        dialog.addSubTitle(WORD_BASED);
        dialog.addRadioButton(CITIES, GROUP, this.cities, null);
        dialog.addRadioButton(NAMES, GROUP, this.names, null);
    }

    private void getDialogValues(MultiInputDialog dialog) {
        this.layer = dialog.getLayer(LAYER);
        this.attribute = dialog.getText(ATTRIBUTE);
        this.min = dialog.getInteger(MIN_LENGTH);
        this.max = dialog.getInteger(MAX_LENGTH);
        this.digits = dialog.getBoolean(DIGITS);
        this.hexa = dialog.getBoolean(HEXA);
        this.ascii = dialog.getBoolean(ASCII);
        this.cities = dialog.getBoolean(CITIES);
        this.names = dialog.getBoolean(NAMES);
    }
}

