/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.tools;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.MeasureLayerFinder;
import com.vividsolutions.jump.workbench.ui.FontChooser;
import com.vividsolutions.jump.workbench.ui.OKCancelDialog;
import com.vividsolutions.jump.workbench.ui.OptionsDialog;
import com.vividsolutions.jump.workbench.ui.OptionsPanel;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import com.vividsolutions.jump.workbench.ui.renderer.style.BasicStyle;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openjump.core.ui.plugin.tools.MeasurementStyle;
import org.openjump.core.ui.swing.VertexStylePanel;

public class AdvancedMeasureOptionsPanel
extends JPanel
implements OptionsPanel {
    public static final String BB_SUMMARY_PAINT_LENGTH = AdvancedMeasureOptionsPanel.class.getName() + " - SUMMARY_PAINT_LENGTH";
    public static final String BB_SUMMARY_PAINT_AREA = AdvancedMeasureOptionsPanel.class.getName() + " - SUMMARY_PAINT_AREA";
    public static final String BB_SUMMARY_FONT = AdvancedMeasureOptionsPanel.class.getName() + " - SUMMARY_FONT";
    public static final String BB_SUMMARY_FONT_COLOR = AdvancedMeasureOptionsPanel.class.getName() + " - SUMMARY_FONT_COLOR";
    public static final String BB_VERTEX_PAINT_DISTANCE = AdvancedMeasureOptionsPanel.class.getName() + " - VERTEX_PAINT_DISTANCE";
    public static final String BB_VERTEX_PAINT_DISTANCE_RELATIVE = AdvancedMeasureOptionsPanel.class.getName() + " - VERTEX_PAINT_DISTANCE_RELATIVE";
    public static final String BB_VERTEX_FONT = AdvancedMeasureOptionsPanel.class.getName() + " - VERTEX_FONT";
    public static final String BB_VERTEX_FONT_COLOR = AdvancedMeasureOptionsPanel.class.getName() + " - VERTEX_FONT_COLOR";
    public static final String BB_VERTEX_PAINT = AdvancedMeasureOptionsPanel.class.getName() + " - VERTEX_PAINT";
    public static final String BB_VERTEX_FIRST_COLOR = AdvancedMeasureOptionsPanel.class.getName() + " - VERTEX_FIRST_COLOR";
    public static final String BB_VERTEX_FIRST_FORM = AdvancedMeasureOptionsPanel.class.getName() + " - VERTEX_FIRST_FORM";
    public static final String BB_VERTEX_FIRST_SIZE = AdvancedMeasureOptionsPanel.class.getName() + " - VERTEX_FIRST_SIZE";
    public static final String BB_VERTEX_FOLLOWING_COLOR = AdvancedMeasureOptionsPanel.class.getName() + " - VERTEX_FOLLOWING_COLOR";
    public static final String BB_VERTEX_FOLLOWING_FORM = AdvancedMeasureOptionsPanel.class.getName() + " - VERTEX_FOLLOWING_FORM";
    public static final String BB_VERTEX_FOLLOWING_SIZE = AdvancedMeasureOptionsPanel.class.getName() + " - VERTEX_FOLLOWING_SIZE";
    public static final String BB_LINE_PAINT = AdvancedMeasureOptionsPanel.class.getName() + " - LINE_PAINT";
    public static final String BB_LINE_COLOR = AdvancedMeasureOptionsPanel.class.getName() + " - LINE_COLOR";
    public static final String BB_FILL_PAINT = AdvancedMeasureOptionsPanel.class.getName() + " - FILL_PAINT";
    public static final String BB_FILL_COLOR = AdvancedMeasureOptionsPanel.class.getName() + " - FILL_COLOR";
    public static final Font DEFAULT_SUMMARY_FONT = new Font("Dialog", 0, 24);
    public static final Color DEFAULT_SUMMARY_COLOR = Color.black;
    public static final boolean DEFAULT_SUMMARY_PAINT_LENGTH = true;
    public static final boolean DEFAULT_SUMMARY_PAINT_AREA = true;
    public static final boolean DEFAULT_VERTEX_PAINT_DISTANCE = true;
    public static final boolean DEFAULT_VERTEX_PAINT_DISTANCE_RELATIVE = false;
    public static final Font DEFAULT_VERTEX_FONT = new Font("Dialog", 0, 12);
    public static final Color DEFAULT_VERTEX_FONT_COLOR = Color.black;
    public static final boolean DEFAULT_VERTEX_PAINT = true;
    public static final Color DEFAULT_VERTEX_FIRST_COLOR = Color.orange;
    public static final String DEFAULT_VERTEX_FIRST_FORM = "SQUARE";
    public static final int DEFAULT_VERTEX_FIRST_SIZE = 10;
    public static final Color DEFAULT_VERTEX_FOLLOWING_COLOR = Color.red;
    public static final String DEFAULT_VERTEX_FOLLOWING_FORM = "SQUARE";
    public static final int DEFAULT_VERTEX_FOLLOWING_SIZE = 5;
    public static final boolean DEFAULT_LINE_PAINT = true;
    public static final Color DEFAULT_LINE_COLOR = Color.red;
    public static final boolean DEFAULT_FILL_PAINT = true;
    public static final Color DEFAULT_FILL_COLOR = Color.red;
    private WorkbenchContext context = null;
    private Blackboard blackboard = null;
    private JPanel mainPanel;
    private JButton summaryFontButton;
    private JButton summaryFontColorButton;
    private JCheckBox paintSummaryLengthCheckBox;
    private JCheckBox paintSummaryAreaCheckBox;
    private JCheckBox paintVertexDistanceCheckBox;
    private JCheckBox paintVertexDistanceRelativeCheckBox;
    private JButton vertexFontButton;
    private JButton vertexFontColorButton;
    private JCheckBox paintVertexCheckBox;
    private JButton vertexStyleButton;
    private JPanel vertexStylePanels;
    private VertexStylePanel vertexStylePanelFirst;
    private VertexStylePanel vertexStylePanelFollowing;
    private JCheckBox paintLineCheckBox;
    private JButton lineColorButton;
    private JCheckBox paintFillCheckBox;
    private JButton fillColorButton;
    private Font summaryFont = DEFAULT_SUMMARY_FONT;
    private Color summaryFontColor = DEFAULT_SUMMARY_COLOR;
    private Font vertexFont = DEFAULT_VERTEX_FONT;
    private Color vertexFontColor = DEFAULT_VERTEX_FONT_COLOR;
    private Color lineColor = DEFAULT_LINE_COLOR;
    private Color fillColor = DEFAULT_FILL_COLOR;

    public AdvancedMeasureOptionsPanel(WorkbenchContext context) {
        this.context = context;
        this.blackboard = PersistentBlackboardPlugIn.get(this.context);
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(new Insets(5, 10, 5, 10)));
        this.mainPanel = new JPanel(new GridBagLayout());
        this.add((Component)this.mainPanel, "Center");
        JPanel summaryPanel = new JPanel(new GridBagLayout());
        summaryPanel.setBorder(new TitledBorder(I18N.getInstance().get("org.openjump.core.ui.plugin.tools.AdvancedMeasureOptionsPanel.summary")));
        JPanel summaryContentPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        summaryPanel.add((Component)summaryContentPanel, gridBagConstraints);
        this.summaryFontButton = new JButton(I18N.getInstance().get("org.openjump.core.ui.plugin.tools.AdvancedMeasureOptionsPanel.choose-font"));
        this.summaryFontColorButton = new JButton(I18N.getInstance().get("org.openjump.core.ui.plugin.tools.AdvancedMeasureOptionsPanel.choose-color"));
        this.paintSummaryLengthCheckBox = new JCheckBox(I18N.getInstance().get("org.openjump.core.ui.plugin.tools.AdvancedMeasureOptionsPanel.paint-summary-length"));
        this.paintSummaryAreaCheckBox = new JCheckBox(I18N.getInstance().get("org.openjump.core.ui.plugin.tools.AdvancedMeasureOptionsPanel.paint-summary-area"));
        this.paintSummaryLengthCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                AdvancedMeasureOptionsPanel.this.summaryFontButton.setEnabled(AdvancedMeasureOptionsPanel.this.paintSummaryLengthCheckBox.isSelected() || AdvancedMeasureOptionsPanel.this.paintSummaryAreaCheckBox.isSelected());
                AdvancedMeasureOptionsPanel.this.summaryFontColorButton.setEnabled(AdvancedMeasureOptionsPanel.this.paintSummaryLengthCheckBox.isSelected() || AdvancedMeasureOptionsPanel.this.paintSummaryAreaCheckBox.isSelected());
            }
        });
        this.paintSummaryLengthCheckBox.setSelected(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        summaryContentPanel.add((Component)this.paintSummaryLengthCheckBox, gridBagConstraints);
        this.paintSummaryAreaCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                AdvancedMeasureOptionsPanel.this.summaryFontButton.setEnabled(AdvancedMeasureOptionsPanel.this.paintSummaryLengthCheckBox.isSelected() || AdvancedMeasureOptionsPanel.this.paintSummaryAreaCheckBox.isSelected());
                AdvancedMeasureOptionsPanel.this.summaryFontColorButton.setEnabled(AdvancedMeasureOptionsPanel.this.paintSummaryLengthCheckBox.isSelected() || AdvancedMeasureOptionsPanel.this.paintSummaryAreaCheckBox.isSelected());
            }
        });
        this.paintSummaryAreaCheckBox.setSelected(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        summaryContentPanel.add((Component)this.paintSummaryAreaCheckBox, gridBagConstraints);
        JLabel summaryFontLabel = new JLabel(I18N.getInstance().get("org.openjump.core.ui.plugin.tools.AdvancedMeasureOptionsPanel.font"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 26, 0, 0);
        summaryContentPanel.add((Component)summaryFontLabel, gridBagConstraints);
        this.summaryFontButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Font newFont = FontChooser.showDialog(OptionsDialog.instance(AdvancedMeasureOptionsPanel.this.context.getWorkbench()), I18N.getInstance().get("org.openjump.core.ui.plugin.tools.AdvancedMeasureOptionsPanel.choose-font"), AdvancedMeasureOptionsPanel.this.summaryFont, true);
                if (newFont != null) {
                    AdvancedMeasureOptionsPanel.this.summaryFont = newFont;
                }
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        summaryContentPanel.add((Component)this.summaryFontButton, gridBagConstraints);
        JLabel fontColorLabel = new JLabel(I18N.getInstance().get("org.openjump.core.ui.plugin.tools.AdvancedMeasureOptionsPanel.fontcolor"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 26, 0, 0);
        summaryContentPanel.add((Component)fontColorLabel, gridBagConstraints);
        this.summaryFontColorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AdvancedMeasureOptionsPanel.this.summaryFontColor = JColorChooser.showDialog(OptionsDialog.instance(AdvancedMeasureOptionsPanel.this.context.getWorkbench()), I18N.getInstance().get("org.openjump.core.ui.plugin.tools.AdvancedMeasureOptionsPanel.choose-color"), AdvancedMeasureOptionsPanel.this.summaryFontColor);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        summaryContentPanel.add((Component)this.summaryFontColorButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)summaryPanel, gridBagConstraints);
        JPanel vertexPanel = new JPanel(new GridBagLayout());
        vertexPanel.setBorder(new TitledBorder(I18N.getInstance().get("org.openjump.core.ui.plugin.tools.AdvancedMeasureOptionsPanel.vertex")));
        JPanel vertexContentPanel = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        vertexPanel.add((Component)vertexContentPanel, gridBagConstraints);
        this.vertexFontButton = new JButton(I18N.getInstance().get("org.openjump.core.ui.plugin.tools.AdvancedMeasureOptionsPanel.choose-font"));
        this.vertexFontColorButton = new JButton(I18N.getInstance().get("org.openjump.core.ui.plugin.tools.AdvancedMeasureOptionsPanel.choose-color"));
        this.paintVertexDistanceCheckBox = new JCheckBox(I18N.getInstance().get("org.openjump.core.ui.plugin.tools.AdvancedMeasureOptionsPanel.paint-vertex-distance"));
        this.paintVertexDistanceRelativeCheckBox = new JCheckBox(I18N.getInstance().get("org.openjump.core.ui.plugin.tools.AdvancedMeasureOptionsPanel.paint-vertex-distance-relative"));
        this.paintVertexDistanceCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                AdvancedMeasureOptionsPanel.this.vertexFontButton.setEnabled(AdvancedMeasureOptionsPanel.this.paintVertexDistanceCheckBox.isSelected() | AdvancedMeasureOptionsPanel.this.paintVertexDistanceRelativeCheckBox.isSelected());
                AdvancedMeasureOptionsPanel.this.vertexFontColorButton.setEnabled(AdvancedMeasureOptionsPanel.this.paintVertexDistanceCheckBox.isSelected() | AdvancedMeasureOptionsPanel.this.paintVertexDistanceRelativeCheckBox.isSelected());
            }
        });
        this.paintVertexDistanceCheckBox.setSelected(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        vertexContentPanel.add((Component)this.paintVertexDistanceCheckBox, gridBagConstraints);
        this.paintVertexDistanceRelativeCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                AdvancedMeasureOptionsPanel.this.vertexFontButton.setEnabled(AdvancedMeasureOptionsPanel.this.paintVertexDistanceCheckBox.isSelected() | AdvancedMeasureOptionsPanel.this.paintVertexDistanceRelativeCheckBox.isSelected());
                AdvancedMeasureOptionsPanel.this.vertexFontColorButton.setEnabled(AdvancedMeasureOptionsPanel.this.paintVertexDistanceCheckBox.isSelected() | AdvancedMeasureOptionsPanel.this.paintVertexDistanceRelativeCheckBox.isSelected());
            }
        });
        this.paintVertexDistanceRelativeCheckBox.setSelected(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        vertexContentPanel.add((Component)this.paintVertexDistanceRelativeCheckBox, gridBagConstraints);
        JLabel vertexFontLabel = new JLabel(I18N.getInstance().get("org.openjump.core.ui.plugin.tools.AdvancedMeasureOptionsPanel.font"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 26, 0, 0);
        vertexContentPanel.add((Component)vertexFontLabel, gridBagConstraints);
        this.vertexFontButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Font newFont = FontChooser.showDialog(OptionsDialog.instance(AdvancedMeasureOptionsPanel.this.context.getWorkbench()), I18N.getInstance().get("org.openjump.core.ui.plugin.tools.AdvancedMeasureOptionsPanel.choose-font"), AdvancedMeasureOptionsPanel.this.vertexFont, true);
                if (newFont != null) {
                    AdvancedMeasureOptionsPanel.this.vertexFont = newFont;
                }
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        vertexContentPanel.add((Component)this.vertexFontButton, gridBagConstraints);
        JLabel vertexFontColorLabel = new JLabel(I18N.getInstance().get("org.openjump.core.ui.plugin.tools.AdvancedMeasureOptionsPanel.fontcolor"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 26, 0, 0);
        vertexContentPanel.add((Component)vertexFontColorLabel, gridBagConstraints);
        this.vertexFontColorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AdvancedMeasureOptionsPanel.this.vertexFontColor = JColorChooser.showDialog(OptionsDialog.instance(AdvancedMeasureOptionsPanel.this.context.getWorkbench()), I18N.getInstance().get("org.openjump.core.ui.plugin.tools.AdvancedMeasureOptionsPanel.choose-color"), AdvancedMeasureOptionsPanel.this.vertexFontColor);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        vertexContentPanel.add((Component)this.vertexFontColorButton, gridBagConstraints);
        this.vertexStyleButton = new JButton(I18N.getInstance().get("org.openjump.core.ui.plugin.tools.AdvancedMeasureOptionsPanel.change-style"));
        this.paintVertexCheckBox = new JCheckBox(I18N.getInstance().get("org.openjump.core.ui.plugin.tools.AdvancedMeasureOptionsPanel.paint-vertex"));
        this.paintVertexCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                AdvancedMeasureOptionsPanel.this.vertexStyleButton.setEnabled(AdvancedMeasureOptionsPanel.this.paintVertexCheckBox.isSelected());
            }
        });
        this.paintVertexCheckBox.setSelected(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        vertexContentPanel.add((Component)this.paintVertexCheckBox, gridBagConstraints);
        JLabel vertexStyleLabel = new JLabel(I18N.getInstance().get("org.openjump.core.ui.plugin.tools.AdvancedMeasureOptionsPanel.vertexstyle"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 26, 0, 0);
        vertexContentPanel.add((Component)vertexStyleLabel, gridBagConstraints);
        this.vertexStylePanels = new JPanel(new FlowLayout());
        this.vertexStylePanelFirst = new VertexStylePanel(false);
        this.vertexStylePanelFirst.setBorder(new TitledBorder(I18N.getInstance().get("org.openjump.core.ui.plugin.tools.AdvancedMeasureOptionsPanel.first-vertex")));
        this.vertexStylePanelFollowing = new VertexStylePanel(false);
        this.vertexStylePanelFollowing.setBorder(new TitledBorder(I18N.getInstance().get("org.openjump.core.ui.plugin.tools.AdvancedMeasureOptionsPanel.following-vertexes")));
        this.vertexStylePanels.add(this.vertexStylePanelFirst);
        this.vertexStylePanels.add(this.vertexStylePanelFollowing);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        gridBagConstraints.anchor = 17;
        this.vertexStyleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color firstVertexColor = AdvancedMeasureOptionsPanel.this.vertexStylePanelFirst.getVertexColor();
                String firstVertexForm = AdvancedMeasureOptionsPanel.this.vertexStylePanelFirst.getVertexForm();
                int firstVertexSize = AdvancedMeasureOptionsPanel.this.vertexStylePanelFirst.getVertexSize();
                Color followingVertexColor = AdvancedMeasureOptionsPanel.this.vertexStylePanelFollowing.getVertexColor();
                String followingVertexForm = AdvancedMeasureOptionsPanel.this.vertexStylePanelFollowing.getVertexForm();
                int followingVertexSize = AdvancedMeasureOptionsPanel.this.vertexStylePanelFollowing.getVertexSize();
                OKCancelDialog vertexStyleDialog = new OKCancelDialog(AdvancedMeasureOptionsPanel.this.context.getWorkbench().getFrame(), I18N.getInstance().get("org.openjump.core.ui.plugin.tools.AdvancedMeasureOptionsPanel.change-style"), true, (Component)AdvancedMeasureOptionsPanel.this.vertexStylePanels, new OKCancelDialog.Validator(){

                    @Override
                    public String validateInput(Component component) {
                        return null;
                    }
                });
                vertexStyleDialog.setVisible(true);
                if (!vertexStyleDialog.wasOKPressed()) {
                    AdvancedMeasureOptionsPanel.this.vertexStylePanelFirst.setVertexColor(firstVertexColor);
                    AdvancedMeasureOptionsPanel.this.vertexStylePanelFirst.setVertexForm(firstVertexForm);
                    AdvancedMeasureOptionsPanel.this.vertexStylePanelFirst.setVertexSize(firstVertexSize);
                    AdvancedMeasureOptionsPanel.this.vertexStylePanelFollowing.setVertexColor(followingVertexColor);
                    AdvancedMeasureOptionsPanel.this.vertexStylePanelFollowing.setVertexForm(followingVertexForm);
                    AdvancedMeasureOptionsPanel.this.vertexStylePanelFollowing.setVertexSize(followingVertexSize);
                }
            }
        });
        vertexContentPanel.add((Component)this.vertexStyleButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)vertexPanel, gridBagConstraints);
        JPanel lineFillPanel = new JPanel(new GridBagLayout());
        lineFillPanel.setBorder(new TitledBorder(I18N.getInstance().get("org.openjump.core.ui.plugin.tools.AdvancedMeasureOptionsPanel.line-and-fill")));
        JPanel lineFillContentPanel = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        lineFillPanel.add((Component)lineFillContentPanel, gridBagConstraints);
        this.lineColorButton = new JButton(I18N.getInstance().get("org.openjump.core.ui.plugin.tools.AdvancedMeasureOptionsPanel.choose-color"));
        this.fillColorButton = new JButton(I18N.getInstance().get("org.openjump.core.ui.plugin.tools.AdvancedMeasureOptionsPanel.choose-color"));
        this.paintLineCheckBox = new JCheckBox(I18N.getInstance().get("org.openjump.core.ui.plugin.tools.AdvancedMeasureOptionsPanel.paint-line"));
        this.paintLineCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                AdvancedMeasureOptionsPanel.this.lineColorButton.setEnabled(AdvancedMeasureOptionsPanel.this.paintLineCheckBox.isSelected());
            }
        });
        this.paintLineCheckBox.setSelected(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        lineFillContentPanel.add((Component)this.paintLineCheckBox, gridBagConstraints);
        JLabel lineColorLabel = new JLabel(I18N.getInstance().get("org.openjump.core.ui.plugin.tools.AdvancedMeasureOptionsPanel.linecolor"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 26, 0, 0);
        lineFillContentPanel.add((Component)lineColorLabel, gridBagConstraints);
        this.lineColorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AdvancedMeasureOptionsPanel.this.lineColor = JColorChooser.showDialog(OptionsDialog.instance(AdvancedMeasureOptionsPanel.this.context.getWorkbench()), I18N.getInstance().get("org.openjump.core.ui.plugin.tools.AdvancedMeasureOptionsPanel.choose-color"), AdvancedMeasureOptionsPanel.this.lineColor);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        lineFillContentPanel.add((Component)this.lineColorButton, gridBagConstraints);
        this.paintFillCheckBox = new JCheckBox(I18N.getInstance().get("org.openjump.core.ui.plugin.tools.AdvancedMeasureOptionsPanel.filling"));
        this.paintFillCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                AdvancedMeasureOptionsPanel.this.fillColorButton.setEnabled(AdvancedMeasureOptionsPanel.this.paintFillCheckBox.isSelected());
            }
        });
        this.paintFillCheckBox.setSelected(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        lineFillContentPanel.add((Component)this.paintFillCheckBox, gridBagConstraints);
        JLabel fillColorLabel = new JLabel(I18N.getInstance().get("org.openjump.core.ui.plugin.tools.AdvancedMeasureOptionsPanel.fillcolor"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 26, 0, 0);
        lineFillContentPanel.add((Component)fillColorLabel, gridBagConstraints);
        this.fillColorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AdvancedMeasureOptionsPanel.this.fillColor = JColorChooser.showDialog(OptionsDialog.instance(AdvancedMeasureOptionsPanel.this.context.getWorkbench()), I18N.getInstance().get("org.openjump.core.ui.plugin.tools.AdvancedMeasureOptionsPanel.choose-color"), AdvancedMeasureOptionsPanel.this.fillColor);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        lineFillContentPanel.add((Component)this.fillColorButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.mainPanel.add((Component)lineFillPanel, gridBagConstraints);
        JPanel fillPanel = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.mainPanel.add((Component)fillPanel, gridBagConstraints);
    }

    @Override
    public String validateInput() {
        return null;
    }

    @Override
    public void okPressed() {
        this.blackboard.put(BB_SUMMARY_FONT_COLOR, this.summaryFontColor);
        this.blackboard.put(BB_SUMMARY_FONT, this.summaryFont);
        this.blackboard.put(BB_SUMMARY_PAINT_LENGTH, this.paintSummaryLengthCheckBox.isSelected());
        this.blackboard.put(BB_SUMMARY_PAINT_AREA, this.paintSummaryAreaCheckBox.isSelected());
        this.blackboard.put(BB_VERTEX_FONT, this.vertexFont);
        this.blackboard.put(BB_VERTEX_FONT_COLOR, this.vertexFontColor);
        this.blackboard.put(BB_VERTEX_PAINT_DISTANCE, this.paintVertexDistanceCheckBox.isSelected());
        this.blackboard.put(BB_VERTEX_PAINT_DISTANCE_RELATIVE, this.paintVertexDistanceRelativeCheckBox.isSelected());
        this.blackboard.put(BB_VERTEX_PAINT, this.paintVertexCheckBox.isSelected());
        this.blackboard.put(BB_VERTEX_FIRST_COLOR, this.vertexStylePanelFirst.getVertexColor());
        this.blackboard.put(BB_VERTEX_FIRST_FORM, this.vertexStylePanelFirst.getVertexForm());
        this.blackboard.put(BB_VERTEX_FIRST_SIZE, this.vertexStylePanelFirst.getVertexSize());
        this.blackboard.put(BB_VERTEX_FOLLOWING_COLOR, this.vertexStylePanelFollowing.getVertexColor());
        this.blackboard.put(BB_VERTEX_FOLLOWING_FORM, this.vertexStylePanelFollowing.getVertexForm());
        this.blackboard.put(BB_VERTEX_FOLLOWING_SIZE, this.vertexStylePanelFollowing.getVertexSize());
        this.blackboard.put(BB_LINE_PAINT, this.paintLineCheckBox.isSelected());
        this.blackboard.put(BB_LINE_COLOR, this.lineColor);
        this.blackboard.put(BB_FILL_PAINT, this.paintFillCheckBox.isSelected());
        this.blackboard.put(BB_FILL_COLOR, this.fillColor);
        Layer layer = new MeasureLayerFinder(this.context, this.context).getLayer();
        if (layer != null) {
            MeasurementStyle style = (MeasurementStyle)layer.getStyle(MeasurementStyle.class);
            style.setSummaryFont(this.summaryFont);
            style.setSummaryColor(this.summaryFontColor);
            style.setPaintSummaryLength(this.paintSummaryLengthCheckBox.isSelected());
            style.setPaintSummaryArea(this.paintSummaryAreaCheckBox.isSelected());
            style.setVertexFont(this.vertexFont);
            style.setVertexFontColor(this.vertexFontColor);
            style.setVertexPaintDistance(this.paintVertexDistanceCheckBox.isSelected());
            style.setVertexPaintDistanceRelative(this.paintVertexDistanceRelativeCheckBox.isSelected());
            style.setVertexPaint(this.paintVertexCheckBox.isSelected());
            style.setVertexFirstColor(this.vertexStylePanelFirst.getVertexColor());
            style.setVertexFirstForm(this.vertexStylePanelFirst.getVertexForm());
            style.setVertexFirstSize(this.vertexStylePanelFirst.getVertexSize());
            style.setVertexFollowingColor(this.vertexStylePanelFollowing.getVertexColor());
            style.setVertexFollowingForm(this.vertexStylePanelFollowing.getVertexForm());
            style.setVertexFollowingSize(this.vertexStylePanelFollowing.getVertexSize());
            BasicStyle basicStyle = layer.getBasicStyle();
            basicStyle.setRenderingLine(this.paintLineCheckBox.isSelected());
            basicStyle.setLineColor(this.lineColor);
            basicStyle.setRenderingFill(this.paintFillCheckBox.isSelected());
            basicStyle.setFillColor(this.fillColor);
            this.context.getLayerViewPanel().repaint();
        }
    }

    @Override
    public void init() {
        Object string;
        Object color;
        this.paintSummaryLengthCheckBox.setSelected(this.blackboard.get(BB_SUMMARY_PAINT_LENGTH, true));
        this.paintSummaryAreaCheckBox.setSelected(this.blackboard.get(BB_SUMMARY_PAINT_AREA, true));
        Object font = this.blackboard.get(BB_SUMMARY_FONT, DEFAULT_SUMMARY_FONT);
        if (font instanceof Font) {
            this.summaryFont = (Font)font;
        }
        if ((color = this.blackboard.get(BB_SUMMARY_FONT_COLOR, DEFAULT_SUMMARY_COLOR)) instanceof Color) {
            this.summaryFontColor = (Color)color;
        }
        this.paintVertexDistanceCheckBox.setSelected(this.blackboard.get(BB_VERTEX_PAINT_DISTANCE, true));
        this.paintVertexDistanceRelativeCheckBox.setSelected(this.blackboard.get(BB_VERTEX_PAINT_DISTANCE_RELATIVE, false));
        font = this.blackboard.get(BB_VERTEX_FONT, DEFAULT_VERTEX_FONT);
        if (font instanceof Font) {
            this.vertexFont = (Font)font;
        }
        if ((color = this.blackboard.get(BB_VERTEX_FONT_COLOR, DEFAULT_VERTEX_FONT_COLOR)) instanceof Color) {
            this.vertexFontColor = (Color)color;
        }
        this.paintVertexCheckBox.setSelected(this.blackboard.get(BB_VERTEX_PAINT, true));
        color = this.blackboard.get(BB_VERTEX_FIRST_COLOR, DEFAULT_VERTEX_FIRST_COLOR);
        if (color instanceof Color) {
            this.vertexStylePanelFirst.setVertexColor((Color)color);
        }
        if ((string = this.blackboard.get(BB_VERTEX_FIRST_FORM, "SQUARE")) instanceof String) {
            this.vertexStylePanelFirst.setVertexForm((String)string);
        }
        this.vertexStylePanelFirst.setVertexSize(this.blackboard.get(BB_VERTEX_FIRST_SIZE, 10));
        color = this.blackboard.get(BB_VERTEX_FOLLOWING_COLOR, DEFAULT_VERTEX_FOLLOWING_COLOR);
        if (color instanceof Color) {
            this.vertexStylePanelFollowing.setVertexColor((Color)color);
        }
        if ((string = this.blackboard.get(BB_VERTEX_FOLLOWING_FORM, "SQUARE")) instanceof String) {
            this.vertexStylePanelFollowing.setVertexForm((String)string);
        }
        this.vertexStylePanelFollowing.setVertexSize(this.blackboard.get(BB_VERTEX_FOLLOWING_SIZE, 5));
        this.paintLineCheckBox.setSelected(this.blackboard.get(BB_LINE_PAINT, true));
        color = this.blackboard.get(BB_LINE_COLOR, DEFAULT_LINE_COLOR);
        if (color instanceof Color) {
            this.lineColor = (Color)color;
        }
        this.paintFillCheckBox.setSelected(this.blackboard.get(BB_FILL_PAINT, true));
        color = this.blackboard.get(BB_FILL_COLOR, DEFAULT_FILL_COLOR);
        if (color instanceof Color) {
            this.fillColor = (Color)color;
        }
    }
}

