/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.tools;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.BasicFeature;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollectionWrapper;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;
import org.locationtech.jts.algorithm.MinimumDiameter;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygon;
import org.openjump.core.ui.plugin.AbstractThreadedUiPlugIn;

public class AddGeometryAttributesPlugIn
extends AbstractThreadedUiPlugIn {
    private static final String LAYER = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.AddGeometryAttributesPlugIn.layer");
    private static final String X = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.AddGeometryAttributesPlugIn.x");
    private static final String Y = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.AddGeometryAttributesPlugIn.y");
    private static final String ADD_XY = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.AddGeometryAttributesPlugIn.add-xy");
    private static final String Z = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.AddGeometryAttributesPlugIn.z");
    private static final String ADD_Z = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.AddGeometryAttributesPlugIn.add-z");
    private static final String NB_POINTS = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.AddGeometryAttributesPlugIn.nb-points");
    private static final String ADD_NB_POINTS = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.AddGeometryAttributesPlugIn.add-nb-of-points");
    private static final String NB_HOLES = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.AddGeometryAttributesPlugIn.nb-of-holes");
    private static final String ADD_NB_HOLES = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.AddGeometryAttributesPlugIn.add-nb-of-holes");
    private static final String NB_COMPONENTS = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.AddGeometryAttributesPlugIn.nb-of-components");
    private static final String ADD_NB_COMPONENTS = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.AddGeometryAttributesPlugIn.add-nb-of-components");
    private static final String LENGTH = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.AddGeometryAttributesPlugIn.length");
    private static final String ADD_LENGTH = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.AddGeometryAttributesPlugIn.add-length");
    private static final String AREA = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.AddGeometryAttributesPlugIn.area");
    private static final String ADD_AREA = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.AddGeometryAttributesPlugIn.add-area");
    private static final String GEOM_TYPE = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.AddGeometryAttributesPlugIn.geo-type");
    private static final String ADD_GEOMETRY_TYPE = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.AddGeometryAttributesPlugIn.add-geom-type");
    private static final String WKT = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.AddGeometryAttributesPlugIn.wkt");
    private static final String ADD_WKT = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.AddGeometryAttributesPlugIn.add-wkt");
    private static final String POLY_WIDTH = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.AddGeometryAttributesPlugIn.poly-width");
    private static final String ADD_POLY_WIDTH = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.AddGeometryAttributesPlugIn.add-poly-width");
    private static final String POLY_LENGTH = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.AddGeometryAttributesPlugIn.poly-length");
    private static final String ADD_POLY_LENGTH = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.AddGeometryAttributesPlugIn.add-poly-length");
    private static final String CIRCULARITY = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.AddGeometryAttributesPlugIn.circularity");
    private static final String ADD_CIRCULARITY = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.AddGeometryAttributesPlugIn.add-circularity");
    private static final String COMPACITY = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.AddGeometryAttributesPlugIn.compacity");
    private static final String ADD_COMPACITY = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.AddGeometryAttributesPlugIn.add-compacity");
    private static final String GEOM_ATTRIBUTES = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.AddGeometryAttributesPlugIn.geometry-attributes");
    private static final String COMPUTE_ATTRIBUTES = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.AddGeometryAttributesPlugIn.compute-attributes");
    String layer;
    private boolean addXY = true;
    private boolean addZ = false;
    private boolean addNbPoints = false;
    private boolean addNbHoles = false;
    private boolean addNbComponents = false;
    private boolean addLength = false;
    private boolean addArea = false;
    private boolean addGeometryType = false;
    private boolean addWKT = false;
    private boolean addPolyWidth = false;
    private boolean addPolyLength = false;
    private boolean addCircularity = false;
    private boolean addCompacity = false;

    @Override
    public void initialize(PlugInContext context) throws Exception {
        FeatureInstaller featureInstaller = context.getFeatureInstaller();
        featureInstaller.addMainMenuPlugin(this, new String[]{MenuNames.TOOLS, MenuNames.TOOLS_EDIT_ATTRIBUTES}, this.getName() + "...", false, null, AddGeometryAttributesPlugIn.createEnableCheck(context.getWorkbenchContext()));
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createAtLeastNLayersMustExistCheck(1));
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.reportNothingToUndoYet(context);
        MultiInputDialog dialog = new MultiInputDialog(context.getWorkbenchFrame(), this.getName(), true);
        this.setDialogValues(dialog, context);
        GUIUtil.centreOnWindow(dialog);
        dialog.setVisible(true);
        if (!dialog.wasOKPressed()) {
            return false;
        }
        this.getDialogValues(dialog);
        return true;
    }

    public void setLayer(String sitesLayer) {
        this.layer = sitesLayer;
    }

    public void setAddXY(boolean addXY) {
        this.addXY = addXY;
    }

    public void setAddZ(boolean addZ) {
        this.addZ = addZ;
    }

    public void setAddNbPoints(boolean addNbPoints) {
        this.addNbPoints = addNbPoints;
    }

    public void setAddNbHoles(boolean addNbHoles) {
        this.addNbHoles = addNbHoles;
    }

    public void setAddNbComponents(boolean addNbComponents) {
        this.addNbComponents = addNbComponents;
    }

    public void setAddLength(boolean addLength) {
        this.addLength = addLength;
    }

    public void setAddArea(boolean addArea) {
        this.addArea = addArea;
    }

    public void setAddPolyWidth(boolean addPolyWidth) {
        this.addPolyWidth = addPolyWidth;
    }

    public void setAddPolyLength(boolean addPolyLength) {
        this.addPolyLength = addPolyLength;
    }

    public void setAddCircularity(boolean addCircularity) {
        this.addCircularity = addCircularity;
    }

    public void setAddCompacity(boolean addCompacity) {
        this.addCompacity = addCompacity;
    }

    public void setAddGeometryType(boolean addGeometryType) {
        this.addGeometryType = addGeometryType;
    }

    public void setAddWKT(boolean addWKT) {
        this.addWKT = addWKT;
    }

    private void setDialogValues(MultiInputDialog dialog, PlugInContext context) {
        this.layer = context.getCandidateLayer(0).getName();
        dialog.addLayerComboBox(LAYER, context.getLayerManager().getLayer(this.layer), null, context.getLayerManager());
        dialog.addCheckBox(ADD_XY, this.addXY);
        dialog.addCheckBox(ADD_Z, this.addZ);
        dialog.addCheckBox(ADD_NB_POINTS, this.addNbPoints);
        dialog.addCheckBox(ADD_NB_HOLES, this.addNbHoles);
        dialog.addCheckBox(ADD_NB_COMPONENTS, this.addNbComponents);
        dialog.addCheckBox(ADD_LENGTH, this.addLength);
        dialog.addCheckBox(ADD_AREA, this.addArea);
        dialog.addCheckBox(ADD_POLY_WIDTH, this.addPolyWidth);
        dialog.addCheckBox(ADD_POLY_LENGTH, this.addPolyLength);
        dialog.addCheckBox(ADD_CIRCULARITY, this.addCircularity);
        dialog.addCheckBox(ADD_COMPACITY, this.addCompacity);
        dialog.addCheckBox(ADD_GEOMETRY_TYPE, this.addGeometryType);
        dialog.addCheckBox(ADD_WKT, this.addWKT);
    }

    private void getDialogValues(MultiInputDialog dialog) {
        this.layer = dialog.getLayer(LAYER).getName();
        this.addXY = dialog.getBoolean(ADD_XY);
        this.addZ = dialog.getBoolean(ADD_Z);
        this.addNbPoints = dialog.getBoolean(ADD_NB_POINTS);
        this.addNbHoles = dialog.getBoolean(ADD_NB_HOLES);
        this.addNbComponents = dialog.getBoolean(ADD_NB_COMPONENTS);
        this.addLength = dialog.getBoolean(ADD_LENGTH);
        this.addArea = dialog.getBoolean(ADD_AREA);
        this.addPolyWidth = dialog.getBoolean(ADD_POLY_WIDTH);
        this.addPolyLength = dialog.getBoolean(ADD_POLY_LENGTH);
        this.addCircularity = dialog.getBoolean(ADD_CIRCULARITY);
        this.addCompacity = dialog.getBoolean(ADD_COMPACITY);
        this.addGeometryType = dialog.getBoolean(ADD_GEOMETRY_TYPE);
        this.addWKT = dialog.getBoolean(ADD_WKT);
    }

    @Override
    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        monitor.report(COMPUTE_ATTRIBUTES + "...");
        LayerManager layerManager = context.getLayerManager();
        FeatureCollectionWrapper inputFC = layerManager.getLayer(this.layer).getFeatureCollectionWrapper();
        FeatureDataset result = new FeatureDataset(this.getNewSchema(layerManager.getLayer(this.layer)));
        for (Feature f : inputFC.getFeatures()) {
            BasicFeature bf = new BasicFeature(result.getFeatureSchema());
            Object[] attributes = new Object[result.getFeatureSchema().getAttributeCount()];
            System.arraycopy(f.getAttributes(), 0, attributes, 0, f.getSchema().getAttributeCount());
            bf.setAttributes(attributes);
            this.setGeometryAttributes(bf);
            result.add(bf);
        }
        context.getLayerManager().addLayer(StandardCategoryNames.RESULT, this.layer + "-" + GEOM_ATTRIBUTES, result);
    }

    private FeatureSchema getNewSchema(Layer layer) {
        FeatureSchema schema = layer.getFeatureCollectionWrapper().getFeatureSchema().clone();
        if (this.addXY) {
            schema.addAttribute(X, AttributeType.DOUBLE);
            schema.addAttribute(Y, AttributeType.DOUBLE);
        }
        if (this.addZ) {
            schema.addAttribute(Z, AttributeType.DOUBLE);
        }
        if (this.addNbPoints) {
            schema.addAttribute(NB_POINTS, AttributeType.INTEGER);
        }
        if (this.addNbHoles) {
            schema.addAttribute(NB_HOLES, AttributeType.INTEGER);
        }
        if (this.addNbComponents) {
            schema.addAttribute(NB_COMPONENTS, AttributeType.INTEGER);
        }
        if (this.addLength) {
            schema.addAttribute(LENGTH, AttributeType.DOUBLE);
        }
        if (this.addArea) {
            schema.addAttribute(AREA, AttributeType.DOUBLE);
        }
        if (this.addPolyWidth) {
            schema.addAttribute(POLY_WIDTH, AttributeType.DOUBLE);
        }
        if (this.addPolyLength) {
            schema.addAttribute(POLY_LENGTH, AttributeType.DOUBLE);
        }
        if (this.addCircularity) {
            schema.addAttribute(CIRCULARITY, AttributeType.DOUBLE);
        }
        if (this.addCompacity) {
            schema.addAttribute(COMPACITY, AttributeType.DOUBLE);
        }
        if (this.addGeometryType) {
            schema.addAttribute(GEOM_TYPE, AttributeType.STRING);
        }
        if (this.addWKT) {
            schema.addAttribute(WKT, AttributeType.STRING);
        }
        return schema;
    }

    private void setGeometryAttributes(Feature f) {
        Geometry g = f.getGeometry();
        if (this.addXY) {
            f.setAttribute(X, (Object)g.getCoordinate().x);
            f.setAttribute(Y, (Object)g.getCoordinate().y);
        }
        if (this.addZ) {
            f.setAttribute(Z, (Object)g.getCoordinate().z);
        }
        if (this.addNbPoints) {
            f.setAttribute(NB_POINTS, (Object)g.getCoordinates().length);
        }
        if (this.addNbHoles) {
            int h = 0;
            for (int i = 0; i < g.getNumGeometries(); ++i) {
                Geometry component = g.getGeometryN(i);
                if (!(component instanceof Polygon)) continue;
                h += ((Polygon)component).getNumInteriorRing();
            }
            f.setAttribute(NB_HOLES, (Object)h);
        }
        if (this.addNbComponents) {
            f.setAttribute(NB_COMPONENTS, (Object)g.getNumGeometries());
        }
        if (this.addLength) {
            f.setAttribute(LENGTH, (Object)g.getLength());
        }
        if (this.addArea) {
            f.setAttribute(AREA, (Object)g.getArea());
        }
        if (this.addPolyWidth) {
            f.setAttribute(POLY_WIDTH, (Object)this.getPolyWidth(g));
        }
        if (this.addPolyLength) {
            f.setAttribute(POLY_LENGTH, (Object)this.getPolyLength(g));
        }
        if (this.addCircularity) {
            f.setAttribute(CIRCULARITY, (Object)this.getCircularity(g));
        }
        if (this.addCompacity) {
            f.setAttribute(COMPACITY, (Object)this.getCompacity(g));
        }
        if (this.addGeometryType) {
            f.setAttribute(GEOM_TYPE, (Object)g.getGeometryType());
        }
        if (this.addWKT) {
            f.setAttribute(WKT, (Object)g.toString());
        }
    }

    private Double getPolyWidth(Geometry g) {
        if (g.getDimension() == 2) {
            double area;
            double length = g.getLength();
            double val = length * length / 4.0 - 4.0 * (area = g.getArea());
            if (val >= 0.0) {
                return (length / 2.0 - Math.sqrt(val)) / 2.0;
            }
            MinimumDiameter diameter = new MinimumDiameter(g);
            Geometry minRectangle = diameter.getMinimumRectangle();
            double ratio = Math.sqrt(minRectangle.getArea() / g.getArea());
            return diameter.getLength() / ratio;
        }
        return null;
    }

    private Double getPolyLength(Geometry g) {
        if (g.getDimension() == 2) {
            double area;
            double length = g.getLength();
            double val = length * length / 4.0 - 4.0 * (area = g.getArea());
            if (val >= 0.0) {
                return area / ((length / 2.0 - Math.sqrt(val)) / 2.0);
            }
            MinimumDiameter diameter = new MinimumDiameter(g);
            Geometry minRectangle = diameter.getMinimumRectangle();
            double ratio = Math.sqrt(minRectangle.getArea() / g.getArea());
            return g.getArea() / (diameter.getLength() / ratio);
        }
        return null;
    }

    private Double getCircularity(Geometry g) {
        if (g.getDimension() == 2) {
            if (g.isEmpty()) {
                return 0.0;
            }
            double length = g.getLength();
            return Math.PI * 4 * g.getArea() / length / length;
        }
        return null;
    }

    private Double getCompacity(Geometry g) {
        if (g.getDimension() == 2) {
            double area = g.getArea();
            return area == 0.0 ? 0.0 : g.getLength() / (2.0 * Math.sqrt(Math.PI * area));
        }
        return null;
    }
}

