/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.raster;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.util.StatisticIndices;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedPlugIn;
import com.vividsolutions.jump.workbench.ui.ColorChooserPanel;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.HTMLFrame;
import com.vividsolutions.jump.workbench.ui.HTMLPanel;
import com.vividsolutions.jump.workbench.ui.JTablePanel;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.TableFrame;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.math.plot.plotObjects.BaseLabel;
import org.math.plot.plotObjects.Plotable;
import org.math.plot.plots.Plot;
import org.math.plot.render.AbstractDrawer;
import org.openjump.core.apitools.LayerTools;
import org.openjump.core.rasterimage.RasterImageLayer;
import org.openjump.core.rasterimage.sextante.OpenJUMPSextanteRasterLayer;
import org.openjump.core.rasterimage.sextante.rasterWrappers.GridRasterWrapper;
import org.openjump.core.ui.plot.Plot2DPanelOJ;
import org.openjump.sextante.gui.additionalResults.AdditionalResults;

public class HistogramPlugIn
extends AbstractPlugIn
implements ThreadedPlugIn {
    private final String sSaved = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.RasterImageLayerPropertiesPlugIn.file.saved");
    private final String SCouldNotSave = I18N.getInstance().get("org.openjump.sextante.gui.additionalResults.AdditionalResultsPlugIn.Could-not-save-selected-result");
    private final String NAME = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.statistics.CreateHistogramPlugIn");
    private final String CLAYER = I18N.getInstance().get("ui.GenericNames.Source-Layer");
    private final String HISTOGRAM_PLOT = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.statistics.CreateHistogramPlugIn.Histogram-Plot");
    private final String HISTOGRAM_OPTIONS = I18N.getInstance().get("com.vividsolutions.jump.workbench.ui.plugin.OptionsPlugIn");
    private final String NUM_CLASS = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.statistics.ClassifyAttributesPlugin.Number-of-classes");
    private final String LAYER_STATISTICS = I18N.getInstance().get("com.vividsolutions.jump.workbench.ui.plugin.LayerStatisticsPlugIn");
    private final String NODATA = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.RasterImageLayerPropertiesPlugIn.cell.nodata");
    private static final String VALUES = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.ProfileGraphTool.values");
    private final String DESCRIPTION = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.HistogramPlugIn.description");
    private final String MAXMINPINS = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.HistogramPlugIn.max-min-pins");
    private final String MEDIANPIN = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.HistogramPlugIn.median-25-75-pins");
    private final String SHOW_FREQUENCY = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.HistogramPlugIn.show-frequency");
    private final String SHOW_STATISTICS = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.HistogramPlugIn.show-descriptive-stat");
    private final String SELECT_BAND = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.HistogramPlugIn.select-one-band");
    private final String FREQUENCY = I18N.getInstance().get("com.vividsolutions.jump.util.Frequency.frequency");
    private final String CLASSIFICATION_METHOD = I18N.getInstance().get("ui.renderer.style.ColorThemingStylePanel.Classification-Method");
    private final String COLOR = I18N.getInstance().get("ui.renderer.style.ColorThemingTableModel.colour");
    private final String CHOOSE_COLOR = I18N.getInstance().get("ui.ColorChooserPanel.choose-color");
    private final String EXECUTING = I18N.getInstance().get("plugin.AbstractPlugIn.executing");
    private final String ANALISYS_INTERVAL = I18N.getInstance().get("ui.GenericNames.interval-of-data-analysis");
    private final String HIST_AS_LINE = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.HistogramPlugIn.show-histogram-as-line");
    private final String UNIQUE_VALUES = I18N.getInstance().get("ui.GenericNames.unique-values");
    private Color color = Color.blue.brighter();
    private static ColorChooserPanel colorChooserPanel = new ColorChooserPanel();
    private static JTextField field;
    private static JTextField minField;
    private static JTextField maxField;
    private final Font darkLabelFont = AbstractDrawer.DEFAULT_FONT;
    private final Font bold_font = new Font("BitStream Vera Sans", 1, 10);
    private final Font big_font = new Font("BitStream Vera Sans", 0, 14);
    private String layerName;
    private int numIntervals = 100;
    private double min = 0.0;
    private double max = 0.0;
    private static RasterImageLayer rLayer;
    private final Icon ICON = IconLoader.icon("histogramme.png");
    private static String UNIT;
    private static JComboBox<String> comboBox;
    private JComboBox<RasterImageLayer> layerableComboBox = new JComboBox();
    JCheckBox typeHistogram;
    JCheckBox tableBox;
    JCheckBox rasterMaxMinLimitsBox;
    JCheckBox rasterCentralTendencyBox;
    JCheckBox rasterStatisticsBox;
    JCheckBox statisticsBox;
    JCheckBox analisysBox;
    JButton chooseElemetsBtn;
    private double[] data;

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
        context.getFeatureInstaller().addMainMenuPlugin(this, new String[]{MenuNames.RASTER}, this.NAME + "...", false, null, HistogramPlugIn.check(context));
    }

    @Override
    public Icon getIcon() {
        return this.ICON;
    }

    public static MultiEnableCheck check(PlugInContext c) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(c.getWorkbenchContext());
        return new MultiEnableCheck().add(checkFactory.createWindowWithAssociatedTaskFrameMustBeActiveCheck()).add(checkFactory.createAtLeastNLayerablesOfTypeMustExistCheck(1, RasterImageLayer.class));
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.reportNothingToUndoYet(context);
        MultiInputDialog dialog = new MultiInputDialog(context.getWorkbenchFrame(), this.NAME, true);
        this.setDialogValues(dialog, context);
        GUIUtil.centreOnWindow(dialog);
        dialog.setVisible(true);
        if (!dialog.wasOKPressed()) {
            return false;
        }
        this.getDialogValues(dialog);
        return true;
    }

    @Override
    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        monitor.report(this.EXECUTING);
        OpenJUMPSextanteRasterLayer rstLayer = new OpenJUMPSextanteRasterLayer();
        rstLayer.create(rLayer, true);
        Integer band = 0;
        if (rLayer.getNumBands() > 1) {
            Object[] bands = new String[]{"0", "1", "2"};
            String stringInput = (String)JOptionPane.showInputDialog(JUMPWorkbench.getInstance().getFrame(), this.SELECT_BAND, this.NAME, -1, null, bands, "0");
            try {
                band = Integer.parseInt(stringInput);
            }
            catch (NumberFormatException e) {
                return;
            }
        }
        this.data = this.analisysBox.isSelected() ? GridRasterWrapper.rasterToArray(rstLayer, band, this.min, this.max) : GridRasterWrapper.rasterToArray(rstLayer, band);
        if (UNIT.equals(this.UNIQUE_VALUES)) {
            this.drawHistContinuous(context);
        } else if (UNIT.equals(this.NUM_CLASS)) {
            this.drawHistIntervals(context, this.numIntervals);
        }
    }

    private void setDialogValues(final MultiInputDialog dialog, PlugInContext context) {
        rLayer = !context.getLayerNamePanel().selectedNodes(RasterImageLayer.class).isEmpty() ? (RasterImageLayer)LayerTools.getSelectedLayerable(context, RasterImageLayer.class) : context.getTask().getLayerManager().getLayerables(RasterImageLayer.class).get(0);
        ArrayList<String> srsArray = new ArrayList<String>();
        srsArray.add(this.UNIQUE_VALUES);
        srsArray.add(this.NUM_CLASS);
        List<RasterImageLayer> rlayers = context.getTask().getLayerManager().getLayerables(RasterImageLayer.class);
        dialog.setSideBarImage(new ImageIcon(IconLoader.image("histdisplay.png").getScaledInstance(172, 127, 4)));
        dialog.setSideBarDescription(this.DESCRIPTION);
        dialog.addSubTitle(this.HISTOGRAM_PLOT);
        this.layerableComboBox = dialog.addLayerableComboBox(this.CLAYER, rLayer, "", rlayers);
        this.layerableComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HistogramPlugIn.this.updateMinMaxValues(e, dialog);
                dialog.repaint();
            }
        });
        this.analisysBox = dialog.addCheckBox(this.ANALISYS_INTERVAL, false, this.ANALISYS_INTERVAL);
        this.analisysBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HistogramPlugIn.this.updateComponents1(e, dialog);
                dialog.repaint();
            }
        });
        this.min = rLayer.getMetadata().getStats().getMin(0);
        this.max = rLayer.getMetadata().getStats().getMax(0);
        minField = dialog.addDoubleField("min", this.min, 13, "");
        minField.setEnabled(false);
        minField.setEditable(false);
        maxField = dialog.addDoubleField("max", this.max, 13, "");
        maxField.setEnabled(false);
        maxField.setEditable(false);
        comboBox = dialog.addComboBox(this.CLASSIFICATION_METHOD, "", srsArray, null);
        comboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HistogramPlugIn.this.updateComponents(e);
                dialog.repaint();
            }
        });
        field = dialog.addIntegerField(this.NUM_CLASS, this.numIntervals, 13, this.NUM_CLASS);
        field.setEnabled(false);
        field.setEditable(false);
        this.typeHistogram = dialog.addCheckBox(this.HIST_AS_LINE, false, this.HIST_AS_LINE);
        this.typeHistogram.setEnabled(true);
        dialog.addSubTitle(this.HISTOGRAM_OPTIONS);
        this.rasterStatisticsBox = dialog.addCheckBox(this.LAYER_STATISTICS, false, this.SHOW_STATISTICS);
        this.rasterMaxMinLimitsBox = dialog.addCheckBox(this.MAXMINPINS, false, this.MAXMINPINS);
        this.rasterCentralTendencyBox = dialog.addCheckBox(this.MEDIANPIN, false, this.MEDIANPIN);
        colorChooserPanel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HistogramPlugIn.this.color = colorChooserPanel.getColor();
            }
        });
        colorChooserPanel.setColor(this.color);
        colorChooserPanel.setAlpha(255);
        dialog.addRow("CheckColor", new JLabel(this.COLOR + " (" + this.HISTOGRAM_PLOT + ")"), colorChooserPanel, null, this.CHOOSE_COLOR);
        dialog.pack();
    }

    private void updateMinMaxValues(ActionEvent evt, MultiInputDialog dialog) {
        RasterImageLayer rasLayer = (RasterImageLayer)dialog.getLayerable(this.CLAYER);
        minField.setText(rasLayer.getMetadata().getStats().getMin(0) + "");
        maxField.setText(rasLayer.getMetadata().getStats().getMax(0) + "");
    }

    private void updateComponents1(ActionEvent evt, MultiInputDialog dialog) {
        if (this.analisysBox.isSelected()) {
            minField.setEnabled(true);
            minField.setEditable(true);
            maxField.setEnabled(true);
            maxField.setEditable(true);
        } else {
            minField.setEnabled(false);
            minField.setEditable(false);
            maxField.setEnabled(false);
            maxField.setEditable(false);
        }
    }

    private void updateComponents(ActionEvent evt) {
        switch (comboBox.getSelectedIndex()) {
            case 0: {
                this.typeHistogram.setEnabled(true);
                field.setEnabled(false);
                field.setEditable(false);
                break;
            }
            case 1: {
                this.typeHistogram.setEnabled(false);
                field.setEnabled(true);
                field.setEditable(true);
            }
        }
    }

    private void getDialogValues(MultiInputDialog dialog) {
        this.numIntervals = dialog.getInteger(this.NUM_CLASS);
        rLayer = (RasterImageLayer)dialog.getLayerable(this.CLAYER);
        this.layerName = rLayer.getName();
        UNIT = dialog.getText(this.CLASSIFICATION_METHOD);
        this.min = dialog.getDouble("min");
        this.max = dialog.getDouble("max");
    }

    private boolean drawHistContinuous(final PlugInContext context) throws Exception {
        final StatisticIndices statUtils = new StatisticIndices();
        statUtils.calculateDescriptiveStatistics(this.data);
        Map<Double, Integer> datas = statUtils.getCounts();
        Set<Map.Entry<Double, Integer>> entries = datas.entrySet();
        double[] X = new double[datas.size()];
        int count = 0;
        double[][] plotdata = new double[datas.size()][2];
        for (Map.Entry<Double, Integer> entry : entries) {
            plotdata[count][0] = entry.getKey();
            plotdata[count][1] = ((Number)entry.getValue()).doubleValue();
            X[count] = 1.0;
            ++count;
        }
        Plot2DPanelOJ plot = new Plot2DPanelOJ();
        if (this.typeHistogram.isSelected()) {
            plot.addLinePlot(this.HISTOGRAM_PLOT, this.color, plotdata);
        } else {
            plot.addHistogramPlot(this.HISTOGRAM_PLOT, this.color, plotdata, X);
        }
        plot.setFixedBounds(0, statUtils.getMin(), statUtils.getMax());
        plot.setFixedBounds(0, statUtils.getMin(), statUtils.getMax());
        plot.setEditable(false);
        plot.setNotable(true);
        plot.setName(rLayer.getFilePath());
        plot.setToolTipText(rLayer.getFilePath());
        plot.plotToolBar.setVisible(true);
        plot.setAxisLabel(0, VALUES);
        plot.setAxisLabel(1, this.FREQUENCY);
        plot.getAxis(0).setLightLabelFont(this.bold_font);
        plot.getAxis(0).setLabelFont(this.darkLabelFont);
        plot.getAxis(1).setLightLabelFont(this.bold_font);
        plot.getAxis(1).setLabelFont(this.darkLabelFont);
        plot.getAxis(0).setLabelPosition(new double[]{0.5, -0.15});
        plot.getAxis(1).setLabelPosition(new double[]{-0.15, 0.5});
        plot.getAxis(1).setLabelAngle(-1.5707963267948966);
        this.addPlotAccessories(statUtils, plot, rLayer);
        JButton statBtn = new JButton(IconLoader.icon("statistics16.png"));
        statBtn.setToolTipText(this.SHOW_STATISTICS);
        statBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HistogramPlugIn.this.calcStatistics(context, statUtils);
            }
        });
        JButton classesBtn = new JButton(IconLoader.icon("Row_16.gif"));
        classesBtn.setToolTipText(this.SHOW_FREQUENCY);
        classesBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableFrame classesFrame = new TableFrame();
                classesFrame.setLayout(new BorderLayout());
                classesFrame.setResizable(true);
                classesFrame.setClosable(true);
                classesFrame.setIconifiable(true);
                classesFrame.setMaximizable(true);
                classesFrame.setPreferredSize(new Dimension(900, 450));
                classesFrame.setSize(900, 450);
                classesFrame.setLayer(JLayeredPane.MODAL_LAYER);
                classesFrame.setTitle(HistogramPlugIn.this.HISTOGRAM_PLOT + " (" + HistogramPlugIn.this.layerName + ") - Classes");
                JTable jTable = new JTable(HistogramPlugIn.toTableModel(statUtils.getCounts()));
                DefaultTableModel dtm = (DefaultTableModel)jTable.getModel();
                JTablePanel jTablePanel = new JTablePanel(dtm);
                jTablePanel.getCommandPanel().setVisible(false);
                classesFrame.add(jTablePanel);
                classesFrame.setVisible(true);
                context.getWorkbenchFrame().addInternalFrame(classesFrame, true, true);
            }
        });
        plot.plotToolBar.addSeparator();
        plot.plotToolBar.add((Component)statBtn);
        plot.plotToolBar.add((Component)classesBtn);
        AdditionalResults.addAdditionalResultAndShow(this.HISTOGRAM_PLOT + " (" + this.layerName + ")", (Object)plot);
        return true;
    }

    private boolean drawHistIntervals(final PlugInContext context, int ranges) throws Exception {
        final StatisticIndices statUtils = new StatisticIndices();
        statUtils.calculateDescriptiveStatistics(this.data);
        Plot2DPanelOJ plot = new Plot2DPanelOJ();
        if (this.typeHistogram.isSelected()) {
            plot.addHistogramPlot(this.HISTOGRAM_PLOT, this.color, this.data, statUtils.getMin(), statUtils.getMax(), ranges);
        } else {
            plot.addHistogramPlot(this.HISTOGRAM_PLOT, this.color, this.data, statUtils.getMin(), statUtils.getMax(), ranges);
        }
        plot.addHistogramPlot(this.HISTOGRAM_PLOT, this.color, this.data, statUtils.getMin(), statUtils.getMax(), ranges);
        plot.setFixedBounds(0, statUtils.getMin(), statUtils.getMax());
        plot.setFixedBounds(0, statUtils.getMin(), statUtils.getMax());
        plot.setEditable(false);
        plot.setNotable(true);
        plot.setName(rLayer.getFilePath());
        plot.setToolTipText(rLayer.getFilePath());
        plot.plotToolBar.setVisible(true);
        plot.setAxisLabel(0, VALUES);
        plot.setAxisLabel(1, this.FREQUENCY);
        plot.getAxis(0).setLightLabelFont(this.bold_font);
        plot.getAxis(0).setLabelFont(this.darkLabelFont);
        plot.getAxis(1).setLightLabelFont(this.bold_font);
        plot.getAxis(1).setLabelFont(this.darkLabelFont);
        plot.getAxis(0).setLabelPosition(new double[]{0.5, -0.15});
        plot.getAxis(1).setLabelPosition(new double[]{-0.15, 0.5});
        plot.getAxis(1).setLabelAngle(-1.5707963267948966);
        this.addPlotAccessories(statUtils, plot, rLayer);
        double[][] dataTableDouble = null;
        Object[][] dataTableObject = null;
        for (Plot plot2 : plot.getPlots()) {
            dataTableDouble = plot2.getData();
        }
        dataTableObject = plot.plotCanvas.reverseMapedData(dataTableDouble);
        final int length = dataTableObject.length;
        final Object[] minObject = plot.getXData_limits(false);
        final Object[] meanObject = plot.getXData();
        final Object[] maxObject = plot.getXData_limits(true);
        final Object[] absoluteFrequencyObject = plot.getYData();
        final Object[] cumulativeFrequencyObject = plot.getYData_CumulativeFrequency();
        final Object[] relativeFrequencyObject = plot.getYData_RelativeFrequency();
        JButton freqBtn = new JButton(IconLoader.icon("Row_16.gif"));
        freqBtn.setToolTipText(this.SHOW_FREQUENCY);
        freqBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HistogramPlugIn.this.calcStatistics(context, statUtils);
                TableFrame freqFrame = new TableFrame();
                freqFrame.setLayout(new BorderLayout());
                freqFrame.setResizable(true);
                freqFrame.setClosable(true);
                freqFrame.setIconifiable(true);
                freqFrame.setMaximizable(true);
                freqFrame.setPreferredSize(new Dimension(900, 450));
                freqFrame.setSize(900, 450);
                freqFrame.setLayer(JLayeredPane.MODAL_LAYER);
                freqFrame.setTitle(HistogramPlugIn.this.HISTOGRAM_PLOT + " (" + HistogramPlugIn.this.layerName + ") - " + HistogramPlugIn.this.FREQUENCY);
                JTable jTable = new JTable();
                Object[] numberIntervals = new Integer[length];
                Integer count = 1;
                for (int a = 0; a < numberIntervals.length; ++a) {
                    numberIntervals[a] = count;
                    Integer n = count;
                    Integer n2 = count = Integer.valueOf(count + 1);
                }
                Object[] objs = numberIntervals;
                DefaultTableModel dtm = (DefaultTableModel)jTable.getModel();
                dtm.addColumn((Object)I18N.getInstance().get("com.vividsolutions.jump.util.Frequency.classes"), objs);
                dtm.addColumn((Object)I18N.getInstance().get("com.vividsolutions.jump.util.Frequency.lower-value"), minObject);
                dtm.addColumn((Object)I18N.getInstance().get("com.vividsolutions.jump.util.Frequency.mean-value"), meanObject);
                dtm.addColumn((Object)I18N.getInstance().get("com.vividsolutions.jump.util.Frequency.upper-value"), maxObject);
                dtm.addColumn((Object)I18N.getInstance().get("com.vividsolutions.jump.util.Frequency.absolute-frequency"), absoluteFrequencyObject);
                dtm.addColumn((Object)I18N.getInstance().get("com.vividsolutions.jump.util.Frequency.cumulative-frequency"), cumulativeFrequencyObject);
                dtm.addColumn((Object)I18N.getInstance().get("com.vividsolutions.jump.util.Frequency.relative-frequency"), relativeFrequencyObject);
                JTablePanel jTablePanel = new JTablePanel(dtm);
                jTablePanel.getCommandPanel().setVisible(false);
                freqFrame.add(jTablePanel);
                freqFrame.setVisible(true);
                context.getWorkbenchFrame().addInternalFrame(freqFrame, true, true);
            }
        });
        JButton statBtn = new JButton(IconLoader.icon("statistics16.png"));
        statBtn.setToolTipText(this.SHOW_STATISTICS);
        statBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HistogramPlugIn.this.calcStatistics(context, statUtils);
            }
        });
        plot.plotToolBar.addSeparator();
        plot.plotToolBar.add((Component)statBtn);
        plot.plotToolBar.add((Component)freqBtn);
        AdditionalResults.addAdditionalResultAndShow(this.HISTOGRAM_PLOT + " (" + this.layerName + ")", (Object)plot);
        return true;
    }

    public static TableModel toTableModel(Map<?, ?> map) {
        double value;
        DefaultTableModel model = new DefaultTableModel(new Object[]{VALUES, I18N.getInstance().get("com.vividsolutions.jump.util.Frequency.absolute-frequency"), I18N.getInstance().get("com.vividsolutions.jump.util.Frequency.cumulative-frequency"), I18N.getInstance().get("com.vividsolutions.jump.util.Frequency.relative-frequency")}, 0);
        double frqValue = 0.0;
        double sum = 0.0;
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            value = ((Number)entry.getValue()).doubleValue();
            sum += value;
        }
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            value = ((Number)entry.getValue()).doubleValue();
            model.addRow(new Object[]{entry.getKey(), entry.getValue(), frqValue += value, frqValue / sum * 100.0});
        }
        return model;
    }

    public void addListElement(HTMLPanel out, String sText) {
        out.append("<li>");
        out.append("<font face=\"" + this.darkLabelFont + "\">" + sText);
        out.append("</li>\n");
    }

    protected void saved(File file) {
        JUMPWorkbench.getInstance().getFrame().setStatusMessage(this.sSaved + " :" + file.getAbsolutePath());
    }

    protected void notsaved(File file) {
        JOptionPane.showMessageDialog(null, this.SCouldNotSave + ": " + file.getName(), I18N.getInstance().get(this.NAME), 2);
    }

    public void calcStatistics(PlugInContext context, StatisticIndices statUtils) {
        DecimalFormat df = new DecimalFormat("##.###");
        HTMLPanel out = new HTMLPanel();
        out.getRecordPanel().removeAll();
        out.createNewDocument();
        out.setBackground(Color.lightGray);
        out.append("<h");
        out.append("2");
        out.append(" align=\"left\">");
        out.append(this.HISTOGRAM_PLOT + " (" + this.layerName + ") - " + this.LAYER_STATISTICS);
        out.append("</h");
        out.append("2");
        out.append("<ul>\n");
        this.addListElement(out, StatisticIndices.COUNT + ": " + df.format(statUtils.getCount()));
        this.addListElement(out, StatisticIndices.NUM_CLASSES + ": " + df.format(statUtils.getClasses()));
        this.addListElement(out, StatisticIndices.MIN + ": " + df.format(statUtils.getMin()));
        this.addListElement(out, StatisticIndices.MAX + ": " + df.format(statUtils.getMax()));
        this.addListElement(out, StatisticIndices.MEAN + ": " + df.format(statUtils.getMean()));
        this.addListElement(out, StatisticIndices.STANDARD_DEV + ": " + df.format(statUtils.getStdDev()));
        this.addListElement(out, StatisticIndices.PERCENTILE_25 + ": " + df.format(statUtils.get25Percentile()));
        this.addListElement(out, StatisticIndices.MEDIAN + ": " + df.format(statUtils.getMedian()));
        this.addListElement(out, StatisticIndices.PERCENTILE_75 + ": " + df.format(statUtils.get75Percentile()));
        this.addListElement(out, StatisticIndices.RMS + ": " + df.format(statUtils.getRMS()));
        this.addListElement(out, StatisticIndices.VARIANCE + ": " + df.format(statUtils.getVariance()));
        this.addListElement(out, this.NODATA + ": " + df.format(rLayer.getNoDataValue()));
        this.addListElement(out, StatisticIndices.SUM + ": " + df.format(statUtils.getSum()));
        this.addListElement(out, StatisticIndices.COEF_VARIATION + ": " + df.format(statUtils.getCoeffOfVar()));
        this.addListElement(out, StatisticIndices.SKEWNESS + ": " + df.format(statUtils.getSkewness()));
        this.addListElement(out, StatisticIndices.KURTOSIS + ": " + df.format(statUtils.getKurtosis()));
        out.append("</ul>\n");
        HTMLFrame frame = new HTMLFrame();
        frame.setTitle(this.HISTOGRAM_PLOT + this.LAYER_STATISTICS);
        frame.add(out);
        frame.setClosable(true);
        frame.setResizable(true);
        frame.setMaximizable(true);
        frame.setSize(280, 520);
        frame.setVisible(true);
        context.getWorkbenchFrame().addInternalFrame(frame, true, true);
    }

    public void addPlotAccessories(StatisticIndices statUtils, Plot2DPanelOJ plot, RasterImageLayer selLayer) {
        double[][] limits2show;
        if (this.rasterStatisticsBox.isSelected()) {
            DecimalFormat numberFormat = new DecimalFormat("#.0000");
            BaseLabel title0 = new BaseLabel(this.LAYER_STATISTICS, Color.BLACK, new double[]{1.1, 1.15});
            title0.setFont(this.big_font);
            BaseLabel title1 = new BaseLabel("max: " + statUtils.getMax(), Color.BLACK, new double[]{1.1, 1.0});
            BaseLabel title2 = new BaseLabel("min: " + statUtils.getMin(), Color.BLACK, new double[]{1.1, 1.05});
            BaseLabel title3 = new BaseLabel("mean: " + numberFormat.format(statUtils.getMean()), Color.BLACK, new double[]{1.1, 0.95});
            BaseLabel title4 = new BaseLabel("std. dev: " + numberFormat.format(statUtils.getStdDev()), Color.BLACK, new double[]{1.1, 0.9});
            BaseLabel title6 = new BaseLabel("25%: " + statUtils.get25Percentile(), Color.BLACK, new double[]{1.1, 0.85});
            BaseLabel title5 = new BaseLabel("median: " + statUtils.getMedian(), Color.BLACK, new double[]{1.1, 0.8});
            BaseLabel title7 = new BaseLabel("75%: " + statUtils.get75Percentile(), Color.BLACK, new double[]{1.1, 0.75});
            title1.setFont(this.darkLabelFont);
            plot.addPlotable((Plotable)title0);
            plot.addPlotable((Plotable)title1);
            plot.addPlotable((Plotable)title2);
            plot.addPlotable((Plotable)title3);
            plot.addPlotable((Plotable)title4);
            plot.addPlotable((Plotable)title5);
            plot.addPlotable((Plotable)title6);
            plot.addPlotable((Plotable)title7);
        }
        if (this.rasterMaxMinLimitsBox.isSelected()) {
            limits2show = new double[2][2];
            limits2show[0][0] = statUtils.getMin();
            limits2show[0][1] = 2.0 * Math.floor(selLayer.getOrigImageHeight() * selLayer.getOrigImageWidth() / this.numIntervals);
            limits2show[1][0] = statUtils.getMax();
            limits2show[1][1] = limits2show[0][1];
            plot.addBarPlot("limiti1", Color.red, limits2show);
            plot.addLabel("max", Color.RED, new double[]{limits2show[1][0], limits2show[0][1]});
            plot.addLabel("min", Color.RED, new double[]{limits2show[0][0], limits2show[0][1]});
        }
        if (this.rasterCentralTendencyBox.isSelected()) {
            limits2show = new double[3][2];
            limits2show[0][0] = statUtils.getMedian();
            limits2show[0][1] = 2.0 * Math.floor(selLayer.getOrigImageHeight() * selLayer.getOrigImageWidth() / this.numIntervals);
            limits2show[1][0] = statUtils.get25Percentile();
            limits2show[1][1] = limits2show[0][1];
            limits2show[2][0] = statUtils.get75Percentile();
            limits2show[2][1] = limits2show[0][1];
            plot.addBarPlot("limiti", Color.RED, limits2show);
            plot.addLabel("median", Color.RED, new double[]{statUtils.getMedian(), limits2show[0][1] * 110.0 / 100.0});
            plot.addLabel("25%", Color.RED, new double[]{statUtils.get25Percentile(), limits2show[0][1] * 110.0 / 100.0});
            plot.addLabel("75%", Color.RED, new double[]{statUtils.get75Percentile(), limits2show[0][1] * 110.0 / 100.0});
        }
        plot.plotToolBar.remove(5);
        plot.plotToolBar.remove(4);
        plot.plotToolBar.remove(3);
    }

    static {
        comboBox = new JComboBox();
    }
}

