/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.mousemenu;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.EditTransaction;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.ImageIcon;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateFilter;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.openjump.core.ui.images.IconLoader;

public class RotatePlugIn
extends AbstractPlugIn {
    private static final String sRotate = I18N.getInstance().get("org.openjump.core.ui.plugin.mousemenu.RotatePlugIn.Rotate");
    private static final String sRotateSelectedFeatures = I18N.getInstance().get("org.openjump.core.ui.plugin.mousemenu.RotatePlugIn.Rotate-Selected-Features");
    private static final String sRotateAbout = I18N.getInstance().get("org.openjump.core.ui.plugin.mousemenu.RotatePlugIn.Rotate-about");
    private static final String sTheAngleInDegreesClockwise = I18N.getInstance().get("org.openjump.core.ui.plugin.mousemenu.RotatePlugIn.The-angle-in-degrees-clockwise");
    private static final String METHOD_ABOUTCENTER = I18N.getInstance().get("org.openjump.core.ui.plugin.mousemenu.RotatePlugIn.Center");
    private static final String METHOD_ABOUTCLICKPOINT = I18N.getInstance().get("org.openjump.core.ui.plugin.mousemenu.RotatePlugIn.Click-Point");
    private static final String ANGLE = I18N.getInstance().get("org.openjump.core.ui.plugin.mousemenu.RotatePlugIn.Rotation-Angle");
    private static final String ROTATEABOUT = I18N.getInstance().get("org.openjump.core.ui.plugin.mousemenu.RotatePlugIn.Rotate-About");
    private final double Deg2Rad = 0.0174532925199432;
    private WorkbenchContext workbenchContext;
    private double rotateAngle = 45.0;
    private double radiansAngle = 0.0;
    private double cosAngle = 0.0;
    private double sinAngle = 0.0;
    private Coordinate rotationPoint = new Coordinate(0.0, 0.0);
    private Collection methodNames = new ArrayList();
    private String methodNameToRun = METHOD_ABOUTCENTER;
    public static final ImageIcon ICON = IconLoader.icon("Rotate16.gif");

    @Override
    public String getName() {
        return sRotate;
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
        this.methodNames.add(METHOD_ABOUTCENTER);
        this.methodNames.add(METHOD_ABOUTCLICKPOINT);
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        ArrayList<EditTransaction> transactions = new ArrayList<EditTransaction>();
        this.reportNothingToUndoYet(context);
        MultiInputDialog dialog = new MultiInputDialog(context.getWorkbenchFrame(), this.getName(), true);
        this.setDialogValues(dialog, context);
        dialog.setVisible(true);
        if (!dialog.wasOKPressed()) {
            return false;
        }
        this.getDialogValues(dialog);
        this.workbenchContext = context.getWorkbenchContext();
        Collection<Layer> layers = this.workbenchContext.getLayerViewPanel().getSelectionManager().getLayersWithSelectedItems();
        if (this.methodNameToRun.equals(METHOD_ABOUTCENTER)) {
            Envelope en = new Envelope();
            Collection<Geometry> geometries = context.getLayerViewPanel().getSelectionManager().getSelectedItems();
            for (Geometry geometry : geometries) {
                en.expandToInclude(geometry.getEnvelopeInternal());
            }
            this.rotationPoint.x = en.getMinX() + (en.getMaxX() - en.getMinX()) / 2.0;
            this.rotationPoint.y = en.getMinY() + (en.getMaxY() - en.getMinY()) / 2.0;
        } else if (this.methodNameToRun.equals(METHOD_ABOUTCLICKPOINT)) {
            this.rotationPoint = context.getLayerViewPanel().getViewport().toModelCoordinate(context.getLayerViewPanel().getLastClickedPoint());
        }
        this.radiansAngle = 0.0174532925199432 * this.rotateAngle;
        this.cosAngle = Math.cos(this.radiansAngle);
        this.sinAngle = Math.sin(this.radiansAngle);
        for (Layer layerWithSelectedItems : layers) {
            transactions.add(this.createTransaction(layerWithSelectedItems));
        }
        EditTransaction.commit(transactions);
        return true;
    }

    private void setDialogValues(MultiInputDialog dialog, PlugInContext context) {
        dialog.setSideBarImage(new ImageIcon(this.getClass().getResource("Rotate.png")));
        dialog.setSideBarDescription(sRotateSelectedFeatures);
        dialog.addComboBox(ROTATEABOUT, this.methodNameToRun, this.methodNames, sRotateAbout);
        dialog.addDoubleField(ANGLE, this.rotateAngle, 6, sTheAngleInDegreesClockwise);
    }

    private void getDialogValues(MultiInputDialog dialog) {
        this.methodNameToRun = dialog.getText(ROTATEABOUT);
        this.rotateAngle = dialog.getDouble(ANGLE);
    }

    private EditTransaction createTransaction(Layer layer) {
        EditTransaction transaction = EditTransaction.createTransactionOnSelection(new EditTransaction.SelectionEditor(){

            public Geometry edit(Geometry geometryWithSelectedItems, Collection selectedItems) {
                for (Geometry item : selectedItems) {
                    RotatePlugIn.this.rotate(item);
                }
                return geometryWithSelectedItems;
            }
        }, this.workbenchContext.getLayerViewPanel(), this.workbenchContext.getLayerViewPanel().getContext(), this.getName(), layer, false, false);
        return transaction;
    }

    private void rotate(Geometry geometry) {
        geometry.apply(new CoordinateFilter(){

            public void filter(Coordinate coordinate) {
                double x = coordinate.x - ((RotatePlugIn)RotatePlugIn.this).rotationPoint.x;
                double y = coordinate.y - ((RotatePlugIn)RotatePlugIn.this).rotationPoint.y;
                coordinate.x = ((RotatePlugIn)RotatePlugIn.this).rotationPoint.x + x * RotatePlugIn.this.cosAngle + y * RotatePlugIn.this.sinAngle;
                coordinate.y = ((RotatePlugIn)RotatePlugIn.this).rotationPoint.y + y * RotatePlugIn.this.cosAngle - x * RotatePlugIn.this.sinAngle;
            }
        });
    }

    public MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck()).add(checkFactory.createAtLeastNFeaturesMustHaveSelectedItemsCheck(1)).add(checkFactory.createSelectedItemsLayersMustBeEditableCheck());
    }
}

