/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.layer.pirolraster;

import com.sun.media.jai.codecimpl.util.RasterFactory;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.Viewport;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.File;
import java.util.Objects;
import java.util.Random;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.openjump.core.apitools.LayerTools;
import org.openjump.core.apitools.SelectionTools;
import org.openjump.core.rasterimage.CurrentLayerIsRasterImageLayerCheck;
import org.openjump.core.rasterimage.ImageAndMetadata;
import org.openjump.core.rasterimage.RasterImageIO;
import org.openjump.core.rasterimage.RasterImageLayer;
import org.openjump.core.rasterimage.Resolution;

public class ExtractSelectedPartOfImage
extends AbstractPlugIn {
    public String getIconString() {
        return "extractPart.png";
    }

    @Override
    public String getName() {
        return I18N.getInstance().get("org.openjump.core.ui.plugin.layer.pirolraster.ExtractSelectedPartOfImage.Extract-Selected-Part-Of-Image");
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        RasterImageIO rasterImageIO;
        RasterImageLayer rLayer = (RasterImageLayer)LayerTools.getSelectedLayerable(context, RasterImageLayer.class);
        Random rnd = new Random();
        int n = 1000 + rnd.nextInt(9000);
        String random = Integer.toString(n);
        String part = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.pirolraster.ExtractSelectedPartOfImage.part-of");
        String fileName = part + rLayer.getName() + "_" + random + ".tif";
        String newLayerName = context.getLayerManager().uniqueLayerName(I18N.getInstance().get("org.openjump.core.ui.plugin.layer.pirolraster.ExtractSelectedPartOfImage.part-of") + rLayer.getName() + ".tif");
        File outFile = new File(System.getProperty("java.io.tmpdir").concat(File.separator).concat(fileName));
        Geometry fence = SelectionTools.getFenceGeometry(context);
        Envelope envWanted = fence.getEnvelopeInternal().intersection(rLayer.getWholeImageEnvelope());
        Rectangle subset = rLayer.getRectangleFromEnvelope(envWanted);
        Raster raster = rLayer.getRasterData(subset);
        if (rLayer.getImage().getColorModel() instanceof IndexColorModel) {
            IndexColorModel indexColorModel = (IndexColorModel)rLayer.getImage().getColorModel();
            DataBuffer dataBufferIn = raster.getDataBuffer();
            DataBufferByte dataBufferOut = new DataBufferByte(subset.width * subset.height * 3, 3);
            int index = 0;
            int nCells = subset.height * subset.width;
            for (int r = 0; r < subset.height; ++r) {
                for (int c = 0; c < subset.width; ++c) {
                    int value = dataBufferIn.getElem(index);
                    dataBufferOut.setElem(0, index, indexColorModel.getRed(value));
                    dataBufferOut.setElem(1, index + nCells, indexColorModel.getGreen(value));
                    dataBufferOut.setElem(2, index + nCells * 2, indexColorModel.getBlue(value));
                    ++index;
                }
            }
            int[] bankIndices = new int[]{0, 1, 2};
            int[] bandOffsets = new int[]{0, raster.getWidth() * raster.getHeight(), 2 * raster.getWidth() * raster.getHeight()};
            WritableRaster wRaster = RasterFactory.createBandedRaster((DataBuffer)dataBufferOut, (int)raster.getWidth(), (int)raster.getHeight(), (int)raster.getWidth(), (int[])bankIndices, (int[])bandOffsets, (Point)new Point(0, 0));
            raster = wRaster;
        }
        RasterImageIO rasterImageIO2 = rasterImageIO = new RasterImageIO();
        Objects.requireNonNull(rasterImageIO2);
        rasterImageIO.writeImage(outFile, raster, envWanted, rasterImageIO2.new RasterImageIO.CellSizeXY(rLayer.getMetadata().getOriginalCellSize(), rLayer.getMetadata().getOriginalCellSize()), rLayer.getMetadata().getNoDataValue());
        String catName = StandardCategoryNames.WORKING;
        try {
            catName = ((Category)context.getLayerNamePanel().getSelectedCategories().toArray()[0]).getName();
        }
        catch (RuntimeException dataBufferOut) {
            // empty catch block
        }
        Point point = RasterImageIO.getImageDimensions(outFile.getAbsolutePath());
        Envelope env = RasterImageIO.getGeoReferencing(outFile.getAbsolutePath(), true, point);
        Viewport viewport = context.getWorkbenchContext().getLayerViewPanel().getViewport();
        Resolution requestedRes = RasterImageIO.calcRequestedResolution(viewport);
        ImageAndMetadata imageAndMetadata = rasterImageIO.loadImage(outFile.getAbsolutePath(), null, viewport.getEnvelopeInModelCoordinates(), requestedRes);
        RasterImageLayer ril = new RasterImageLayer(outFile.getName(), context.getWorkbenchContext().getLayerManager(), outFile.getAbsolutePath(), imageAndMetadata.getImage(), env);
        context.getLayerManager().addLayerable(catName, ril);
        ril.setName(newLayerName);
        return true;
    }

    protected boolean putImageIntoMap(BufferedImage partOfImage, Raster partOfRaster, Envelope envelope, RasterImageLayer rLayer, PlugInContext context) {
        if (partOfImage == null) {
            return false;
        }
        String newLayerName = context.getLayerManager().uniqueLayerName(I18N.getInstance().get("org.openjump.core.ui.plugin.layer.pirolraster.ExtractSelectedPartOfImage.part-of") + rLayer.getName());
        RasterImageLayer newRasterLayer = new RasterImageLayer(newLayerName, context.getLayerManager(), partOfImage, partOfRaster, envelope);
        String catName = StandardCategoryNames.WORKING;
        try {
            catName = ((Category)context.getLayerNamePanel().getSelectedCategories().toArray()[0]).getName();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        context.getLayerManager().addLayerable(catName, newRasterLayer);
        return true;
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        MultiEnableCheck multiEnableCheck = new MultiEnableCheck();
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        multiEnableCheck.add(checkFactory.createExactlyNLayerablesMustBeSelectedCheck(1, RasterImageLayer.class));
        multiEnableCheck.add(checkFactory.createFenceMustBeDrawnCheck());
        CurrentLayerIsRasterImageLayerCheck enableCheck = new CurrentLayerIsRasterImageLayerCheck(workbenchContext.createPlugInContext());
        multiEnableCheck.add(enableCheck);
        return multiEnableCheck;
    }
}

