/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.layer;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import java.util.List;
import javax.swing.ImageIcon;

public class SortCategorySavePlugIn
extends AbstractPlugIn {
    private static final ImageIcon ICON = null;
    private static String menuLabel = "Save";
    protected static final String BLACKBOARD_LAYER = "SortCategorySavePlugIn_Layer_Location";
    static final String BLACKBOARD_CATEGORY = "SortCategorySavePlugIn_Category_Location";

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
        menuLabel = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.SortCategorySavePlugIn.Save");
        context.getFeatureInstaller().addMainMenuItem(this, new String[]{MenuNames.LAYER, I18N.getInstance().get("org.openjump.core.ui.plugin.layer.SortCategoryAbstractPlugIn.Sort-Selected-Categories")}, menuLabel, false, ICON, null);
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        try {
            List<Category> categories = context.getWorkbenchContext().getLayerNamePanel().getLayerManager().getCategories();
            for (Category category : categories) {
                this.saveLayerLocation(category);
            }
            return true;
        }
        catch (Exception e) {
            context.getWorkbenchFrame().warnUser("Error: see output window");
            context.getWorkbenchFrame().getOutputFrame().createNewDocument();
            context.getWorkbenchFrame().getOutputFrame().addText(this.getName() + "PlugIn Exception:" + e.toString());
            return false;
        }
    }

    private void saveLayerLocation(Category category) {
        List<Layerable> layerables = category.getLayerables();
        int count = 0;
        for (Layerable layerable : layerables) {
            layerable.getBlackboard().put(BLACKBOARD_LAYER, count++);
            layerable.getBlackboard().put(BLACKBOARD_CATEGORY, category.getName());
        }
    }
}

