/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.layer;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public class SortCategoryRestorePlugIn
extends AbstractPlugIn {
    private static WorkbenchContext workbenchContext = JUMPWorkbench.getInstance().getContext();
    private static final ImageIcon ICON = null;
    private String menuLabel = "Restore";

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
        this.menuLabel = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.SortCategoryRestorePlugIn.Restore");
        context.getFeatureInstaller().addMainMenuItem(this, new String[]{MenuNames.LAYER, I18N.getInstance().get("org.openjump.core.ui.plugin.layer.SortCategoryAbstractPlugIn.Sort-Selected-Categories")}, this.menuLabel, false, ICON, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(PlugInContext context) throws Exception {
        try {
            LayerManager layerManager = context.getWorkbenchContext().getLayerManager();
            List<Layerable> allLayerables = context.getWorkbenchContext().getLayerNamePanel().getLayerManager().getLayerables(Layerable.class);
            TreeMap<LayerableLocation, Layerable> saved = new TreeMap<LayerableLocation, Layerable>(Collections.reverseOrder());
            ArrayList<Layerable> unsaved = new ArrayList<Layerable>();
            this.getSavedUnsavedLayerables(saved, unsaved, allLayerables);
            Map<Layerable, String> layerableToCategory = this.getLayerableToCategory(unsaved, layerManager.getCategories());
            try {
                this.removeLayers(layerManager, allLayerables);
                this.addUnSavedBack(layerManager, allLayerables, unsaved, layerableToCategory);
                this.addSavedBack(layerManager, allLayerables, saved);
            }
            finally {
                context.getLayerViewPanel().repaint();
                context.getWorkbenchFrame().repaint();
            }
            return true;
        }
        catch (Exception e) {
            context.getWorkbenchFrame().warnUser("Error: see output window");
            context.getWorkbenchFrame().getOutputFrame().createNewDocument();
            context.getWorkbenchFrame().getOutputFrame().addText(this.getName() + " PlugIn Exception:" + e.toString());
            return false;
        }
    }

    private Map<Layerable, String> getLayerableToCategory(List<Layerable> unsaved, List<Category> categories) {
        HashMap<Layerable, String> layerableToCategory = new HashMap<Layerable, String>();
        block0: for (Layerable layerable : unsaved) {
            for (Category category : categories) {
                if (!category.contains(layerable)) continue;
                layerableToCategory.put(layerable, category.getName());
                continue block0;
            }
        }
        return layerableToCategory;
    }

    private void addSavedBack(LayerManager layerManager, List<Layerable> allLayerables, Map<LayerableLocation, Layerable> saved) {
        for (Layerable layerable : saved.values()) {
            if (layerable.getBlackboard().get("SortCategorySavePlugIn_Category_Location") == null) continue;
            layerManager.addLayerable((String)layerable.getBlackboard().get("SortCategorySavePlugIn_Category_Location"), layerable);
        }
    }

    private void addUnSavedBack(LayerManager layerManager, List<Layerable> allLayerables, List<Layerable> unsaved, Map<Layerable, String> layerableToCategory) {
        Collections.reverse(unsaved);
        for (Layerable layerable : unsaved) {
            layerManager.addLayerable(layerableToCategory.get(layerable), layerable);
        }
    }

    private void getSavedUnsavedLayerables(Map<LayerableLocation, Layerable> saved, List<Layerable> unsaved, List<Layerable> allLayerables) {
        for (Layerable layerable : allLayerables) {
            if (layerable.getBlackboard().get("SortCategorySavePlugIn_Category_Location") != null && layerable != null) {
                saved.put(new LayerableLocation((String)layerable.getBlackboard().get("SortCategorySavePlugIn_Category_Location"), layerable.getBlackboard().getInt("SortCategorySavePlugIn_Layer_Location")), layerable);
                continue;
            }
            if (layerable != null) {
                unsaved.add(layerable);
                continue;
            }
            throw new IllegalStateException("Unknown layerable");
        }
    }

    private void removeLayers(LayerManager layerManager, List<Layerable> layers) {
        for (Layerable layerable : layers) {
            layerManager.remove(layerable);
        }
    }

    public static EnableCheck createSaveCategorySectionMustExistCheck() {
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                boolean notSaved = true;
                List<Layerable> layerCollection = workbenchContext.getLayerNamePanel().getLayerManager().getLayerables(Layerable.class);
                for (Layerable layer : layerCollection) {
                    if (layer.getBlackboard().get("SortCategorySavePlugIn_Layer_Location") == null) continue;
                    notSaved = false;
                }
                return notSaved ? "Use Save Category first." : null;
            }
        };
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        return new MultiEnableCheck().add(SortCategoryRestorePlugIn.createSaveCategorySectionMustExistCheck());
    }

    class LayerableLocation
    implements Comparable<LayerableLocation> {
        private String category;
        private Integer position;

        LayerableLocation(String category, Integer position) {
            this.category = category;
            this.position = position;
        }

        public String getCategory() {
            return this.category;
        }

        public void setCategory(String category) {
            this.category = category;
        }

        public Integer getPosition() {
            return this.position;
        }

        public void setPosition(Integer position) {
            this.position = position;
        }

        @Override
        public int compareTo(LayerableLocation location) {
            if (this.category.compareTo(location.getCategory()) == 0) {
                return this.position.compareTo(location.getPosition());
            }
            return this.category.compareTo(location.getCategory());
        }
    }
}

