/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.file.open;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.io.CompressedFile;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.datasource.LoadFileDataSourceQueryChooser;
import com.vividsolutions.jump.workbench.registry.Registry;
import com.vividsolutions.jump.workbench.ui.InputChangedListener;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import com.vividsolutions.jump.workbench.ui.wizard.WizardDialog;
import com.vividsolutions.jump.workbench.ui.wizard.WizardPanelV2;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.filechooser.FileFilter;
import org.openjump.core.ui.io.file.FileLayerLoader;
import org.openjump.core.ui.io.file.FileLayerLoaderExtensionFilter;
import org.openjump.core.ui.io.file.FileNameExtensionFilter;
import org.openjump.core.ui.plugin.file.open.JFCWithEnterAction;
import org.openjump.core.ui.plugin.file.open.OpenFileWizardState;
import org.openjump.swing.listener.InvokeMethodActionListener;

public class SelectFilesPanel
extends JFCWithEnterAction
implements WizardPanelV2 {
    private static final long serialVersionUID = 1081945397331254012L;
    public static final String KEY = SelectFilesPanel.class.getName();
    public static final String TITLE = I18N.getInstance().get(KEY);
    public static final String INSTRUCTIONS = I18N.getInstance().get(KEY + ".instructions");
    public static final String ALL_FILES = I18N.getInstance().get(KEY + ".all-files");
    public static final String ALL_SUPPORTED_FILES = I18N.getInstance().get(KEY + ".all-supported-files");
    public static final String ARCHIVED_FILES = I18N.getInstance().get(KEY + ".archived-files");
    public static final String COMPRESSED_FILES = I18N.getInstance().get(KEY + ".compressed-files");
    private Set<InputChangedListener> listeners = new LinkedHashSet<InputChangedListener>();
    private Blackboard blackboard;
    private OpenFileWizardState state;
    private WorkbenchContext workbenchContext;
    private boolean initialized = false;
    private WizardDialog dialog;
    private Class loaderFilter;

    public SelectFilesPanel(WorkbenchContext workbenchContext) {
        this.workbenchContext = workbenchContext;
    }

    public SelectFilesPanel(WorkbenchContext workbenchContext, Class loaderFilter) {
        this(workbenchContext);
        this.loaderFilter = loaderFilter;
    }

    public OpenFileWizardState getState() {
        return this.state;
    }

    public void setState(OpenFileWizardState state) {
        this.state = state;
    }

    public WizardDialog getDialog() {
        return this.dialog;
    }

    public void setDialog(WizardDialog dialog) {
        this.dialog = dialog;
    }

    private void initialize() {
        if (this.initialized) {
            return;
        }
        this.blackboard = PersistentBlackboardPlugIn.get(this.workbenchContext);
        Registry registry = this.workbenchContext.getRegistry();
        String savedDirectoryName = (String)this.blackboard.get(LoadFileDataSourceQueryChooser.FILE_CHOOSER_DIRECTORY_KEY);
        if (savedDirectoryName != null) {
            this.setCurrentDirectory(new File(savedDirectoryName));
        }
        this.setAcceptAllFileFilterUsed(false);
        this.setMultiSelectionEnabled(true);
        List loaders = registry.getEntries(FileLayerLoader.KEY);
        TreeSet<String> allExtensions = new TreeSet<String>();
        TreeMap<String, FileNameExtensionFilter> filters = new TreeMap<String, FileNameExtensionFilter>();
        String[] zipExtensions = CompressedFile.getArchiveExtensions();
        allExtensions.addAll(Arrays.asList(zipExtensions));
        FileNameExtensionFilter zipFilter = new FileNameExtensionFilter(ARCHIVED_FILES, zipExtensions);
        filters.put(((FileFilter)zipFilter).getDescription(), zipFilter);
        String[] packedExtensions = CompressedFile.getFileExtensions();
        allExtensions.addAll(Arrays.asList(packedExtensions));
        FileNameExtensionFilter packedFilter = new FileNameExtensionFilter(COMPRESSED_FILES, packedExtensions);
        filters.put(((FileFilter)packedFilter).getDescription(), packedFilter);
        for (Object loader : loaders) {
            if (this.loaderFilter != null && !this.loaderFilter.isInstance(loader)) continue;
            FileLayerLoader fileLayerLoader = (FileLayerLoader)loader;
            FileFilter filter = new FileLayerLoaderExtensionFilter(fileLayerLoader);
            allExtensions.addAll(fileLayerLoader.getFileExtensions());
            filters.put(((FileFilter)filter).getDescription(), (FileNameExtensionFilter)filter);
        }
        FileNameExtensionFilter filterNone = new FileNameExtensionFilter(" " + ALL_FILES, new String[]{"*"});
        filters.put(((FileFilter)filterNone).getDescription(), filterNone);
        FileNameExtensionFilter allFilter = new FileNameExtensionFilter(" " + ALL_SUPPORTED_FILES, allExtensions.toArray(new String[0]));
        filters.put(((FileFilter)allFilter).getDescription(), allFilter);
        for (FileFilter filter : filters.values()) {
            this.addChoosableFileFilter(filter);
        }
        this.setFileFilter(allFilter);
        this.setControlButtonsAreShown(false);
        PropertyChangeListener changeListener = new PropertyChangeListener(){
            Object lastNew = null;

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                File newFile;
                File[] newFiles;
                Object newNew = evt.getNewValue();
                if (newNew instanceof File[] && !(this.lastNew instanceof File[]) && (newFiles = (File[])newNew).length == 1 && ((Object)(newFile = newFiles[0])).equals(this.lastNew)) {
                    return;
                }
                this.lastNew = newNew;
                if (SelectFilesPanel.this.state.getCurrentPanel() != KEY) {
                    return;
                }
                SelectFilesPanel.this.changeState();
                SelectFilesPanel.this.fireInputChanged();
            }
        };
        this.addPropertyChangeListener(changeListener);
        this.addActionListener(new InvokeMethodActionListener(this.dialog, "next"));
        this.initialized = true;
    }

    private void changeState() {
        FileLayerLoader fileLayerLoader = null;
        File[] files = this.getSelectedFiles();
        FileFilter selectedFileFilter = this.getFileFilter();
        if (selectedFileFilter instanceof FileLayerLoaderExtensionFilter) {
            FileLayerLoaderExtensionFilter filter = (FileLayerLoaderExtensionFilter)selectedFileFilter;
            fileLayerLoader = filter.getFileLoader();
        }
        this.state.setupFileLoaders(files, fileLayerLoader);
    }

    public void enteredFromLeft(Map dataMap) {
        this.initialize();
        this.rescanCurrentDirectory();
        this.state.setCurrentPanel(KEY);
        this.changeState();
        this.fireInputChanged();
    }

    @Override
    public void enteredFromRight() throws Exception {
        this.state.setCurrentPanel(KEY);
    }

    @Override
    public void exitingToRight() throws Exception {
        this.blackboard.put(LoadFileDataSourceQueryChooser.FILE_CHOOSER_DIRECTORY_KEY, this.getCurrentDirectory().getAbsolutePath());
    }

    @Override
    public String getID() {
        return this.getClass().getName();
    }

    @Override
    public String getInstructions() {
        return INSTRUCTIONS;
    }

    @Override
    public String getNextID() {
        return this.state.getNextPanel(KEY);
    }

    @Override
    public String getTitle() {
        return TITLE;
    }

    @Override
    public boolean isInputValid() {
        return this.state.hasSelectedFiles();
    }

    @Override
    public void add(InputChangedListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void remove(InputChangedListener listener) {
        this.listeners.remove(listener);
    }

    private void fireInputChanged() {
        for (InputChangedListener listener : this.listeners) {
            listener.inputChanged();
        }
    }

    @Override
    public void exitingToLeft() {
    }
}

