/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.file;

import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.Viewport;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.locationtech.jts.geom.Envelope;

public class WorldFileWriter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeWorldFile(File imageFile, LayerViewPanel panel) throws IOException {
        double view_res;
        if (panel == null || imageFile == null) {
            throw new NullPointerException("WorldFileWriter");
        }
        double xrot = 0.0;
        double yrot = 0.0;
        Viewport viewport = panel.getViewport();
        Envelope vpEnvelope = viewport.getEnvelopeInModelCoordinates();
        double xres = view_res = 1.0 / viewport.getScale();
        double yres = -view_res;
        double halfPixel = 0.5 * view_res;
        double ulx = vpEnvelope.getMinX() + xres / 2.0;
        double uly = vpEnvelope.getMaxY() + yres / 2.0;
        try (PrintWriter outputStream = null;){
            String imagePath = imageFile.getCanonicalPath();
            int dotPos = imagePath.lastIndexOf(".");
            String worldExtention = imagePath.substring(dotPos).equalsIgnoreCase(".jpg") ? ".jgw" : ".pgw";
            String worldPath = imagePath.substring(0, dotPos) + worldExtention;
            outputStream = new PrintWriter(new FileWriter(worldPath));
            outputStream.println(xres);
            outputStream.println(xrot);
            outputStream.println(yrot);
            outputStream.println(yres);
            outputStream.println(ulx);
            outputStream.println(uly);
        }
    }
}

