/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.file;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import java.awt.Component;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.openjump.core.ui.plugin.file.open.JFCWithEnterAction;

public class FindFile {
    private static final String KEY = FindFile.class.getName();
    private static final String CHOOSE_LOCATION = I18N.getInstance().get(KEY + ".choose-current-location-of");
    private HashMap<Path, Path> prefixCache = new HashMap();
    private JFileChooser fileChooser;
    private Component window;

    public FindFile(Component window) {
        this.window = window;
        this.fileChooser = new JFCWithEnterAction();
        this.fileChooser = GUIUtil.createJFileChooserWithExistenceChecking();
        this.fileChooser.setDialogTitle(CHOOSE_LOCATION);
        this.fileChooser.setDialogType(0);
        this.fileChooser.setFileSelectionMode(0);
        this.fileChooser.setMultiSelectionEnabled(false);
    }

    public FindFile(Component window, JFileChooser fileChooser) {
        this(window);
        this.fileChooser = fileChooser;
    }

    public String getFileName(String filenamepath) throws Exception {
        return this.getFileName(filenamepath, null);
    }

    public String getFileName(String filenamepath, File startPath) throws Exception {
        Path oldFilePath = Paths.get(filenamepath, new String[0]);
        for (Map.Entry<Path, Path> entry : this.prefixCache.entrySet()) {
            Path newFilePath;
            File newFile;
            if (!oldFilePath.startsWith(entry.getKey()) || !(newFile = (newFilePath = entry.getValue().resolve(entry.getKey().relativize(oldFilePath))).toFile()).exists()) continue;
            return newFile.getPath();
        }
        this.fileChooser.setDialogTitle(CHOOSE_LOCATION + " " + filenamepath);
        this.fileChooser.setSelectedFile(new File(new File(filenamepath).getName()));
        if (startPath != null) {
            this.fileChooser.setCurrentDirectory(startPath);
        }
        GUIUtil.removeChoosableFileFilters(this.fileChooser);
        this.fileChooser.addChoosableFileFilter(GUIUtil.ALL_FILES_FILTER);
        String ext = "";
        int k = filenamepath.lastIndexOf(46);
        if (k > 0 && k < filenamepath.length() - 1) {
            ext = filenamepath.substring(k + 1);
            FileFilter fileFilter = GUIUtil.createFileFilter(ext.toUpperCase() + " Files", new String[]{ext.toLowerCase()});
            this.fileChooser.addChoosableFileFilter(fileFilter);
            this.fileChooser.setFileFilter(fileFilter);
        }
        if (0 == this.fileChooser.showOpenDialog(this.window)) {
            Path newPath;
            int newPathCount;
            String newParent = this.fileChooser.getSelectedFile().getParent() + File.separator;
            String oldParent = new File(filenamepath).getParent() + File.separator;
            Path oldPath = Paths.get(oldParent, new String[0]);
            int oldPathCount = oldPath.getNameCount();
            int max = oldPathCount < (newPathCount = (newPath = Paths.get(newParent, new String[0])).getNameCount()) ? oldPathCount : newPathCount;
            Path newPathFragment = null;
            for (int i = 1; i <= max; ++i) {
                Path newPart;
                Path oldPart = oldPath.getName(oldPathCount - i);
                if (oldPart.equals(newPart = newPath.getName(newPathCount - i))) continue;
                Path oldPathFragment = oldPath.getRoot().resolve(oldPath.subpath(0, oldPathCount - i + 1));
                newPathFragment = newPath.getRoot().resolve(newPath.subpath(0, newPathCount - i + 1));
                this.prefixCache.put(oldPathFragment, newPathFragment);
                break;
            }
            return this.fileChooser.getSelectedFile().getPath();
        }
        return "";
    }
}

