/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.edittoolbox.cursortools;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.Logger;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.ui.EditTransaction;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.LayerViewPanelContext;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.WorkbenchFrame;
import com.vividsolutions.jump.workbench.ui.cursortool.CursorTool;
import com.vividsolutions.jump.workbench.ui.cursortool.NClickTool;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.FeatureDrawingUtil;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import java.awt.BasicStroke;
import java.awt.Cursor;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.operation.buffer.BufferOp;
import org.locationtech.jts.operation.valid.IsValidOp;

public class DrawCircleWithGivenRadiusTool
extends NClickTool {
    protected Coordinate modelDestination = null;
    private FeatureDrawingUtil featureDrawingUtil;
    private Shape selectedFeaturesShape;
    private GeometryFactory geometryFactory = new GeometryFactory();
    private static double radius = 50.0;
    private int points = 8;
    private static double tolerance = 0.1;
    private String T1 = I18N.getInstance().get("org.openjump.core.ui.plugin.edittoolbox.cursortools.DrawCircleWithGivenRadiusTool.Cirlce-Radius") + ":";
    private String T2 = I18N.getInstance().get("org.openjump.core.ui.plugin.edittoolbox.cursortools.DrawCircleWithGivenRadiusTool.Number-of-segments-per-circle-quarter") + ":";
    private String name = I18N.getInstance().get("org.openjump.core.ui.plugin.edittoolbox.cursortools.DrawCircleWithGivenRadiusTool.Draw-circle-with-given-radius-and-center");
    private String sidebarstring = I18N.getInstance().get("org.openjump.core.ui.plugin.edittoolbox.cursortools.DrawCircleWithGivenRadiusTool.Draws-a-circle-by-specifiying-the-radius-and-the-circle-accuracy-and-the-centre-position-by-mouse-click");
    private String sAccuracy = I18N.getInstance().get("org.openjump.core.ui.plugin.edittoolbox.cursortools.DrawCircleWithGivenRadiusTool.Circle-Accuracy");
    private String sReset = I18N.getInstance().get("org.openjump.core.ui.plugin.edittoolbox.cursortools.DrawCircleWithGivenRadiusTool.too-small-tolerance-reset-to-300-segments");

    private DrawCircleWithGivenRadiusTool(WorkbenchContext context, FeatureDrawingUtil featureDrawingUtil) {
        super(context, 1);
        this.featureDrawingUtil = featureDrawingUtil;
        this.setStroke(new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{3.0f, 3.0f}, 0.0f));
        this.allowSnapping();
    }

    public static CursorTool create(WorkbenchContext context) {
        FeatureDrawingUtil featureDrawingUtil = new FeatureDrawingUtil(context);
        return featureDrawingUtil.prepare(new DrawCircleWithGivenRadiusTool(context, featureDrawingUtil), true);
    }

    @Override
    protected void gestureFinished() throws Exception {
        this.reportNothingToUndoYet();
        Point p = new GeometryFactory().createPoint(this.getModelDestination());
        double tmp = Math.acos((radius - tolerance) / radius);
        if (tmp != 0.0) {
            int pts = (int)Math.floor(Math.PI / tmp / 4.0);
            if (pts < 3) {
                pts = 3;
            }
            if (pts > 300) {
                pts = 300;
                this.getWorkbench().getFrame().warnUser(this.sReset);
            }
            this.points = pts;
        }
        Geometry circle = BufferOp.bufferOp((Geometry)p, (double)radius, (int)(this.points - 1));
        this.checkCircle(circle);
        if (circle instanceof Polygon) {
            this.featureDrawingUtil.drawRing((Polygon)circle, this.isRollingBackInvalidEdits(), this, this.getPanel());
        }
    }

    protected boolean checkCircle(Geometry circle) throws NoninvertibleTransformException {
        IsValidOp isValidOp = new IsValidOp(circle);
        if (!isValidOp.isValid()) {
            this.getPanel().getContext().warnUser(isValidOp.getValidationError().getMessage());
            if (PersistentBlackboardPlugIn.get(this.getWorkbenchContext()).get(EditTransaction.ROLLING_BACK_INVALID_EDITS_KEY, false)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void activate(LayerViewPanel layerViewPanel) {
        super.activate(layerViewPanel);
        try {
            Envelope viewportEnvelope = layerViewPanel.getViewport().getEnvelopeInModelCoordinates();
            double x = viewportEnvelope.getMinX() + viewportEnvelope.getWidth() / 2.0;
            double y = viewportEnvelope.getMinY() + viewportEnvelope.getHeight() / 2.0;
            Coordinate initCoords = new Coordinate(x, y);
            this.calculateCircle(initCoords, layerViewPanel);
            this.redrawShape();
        }
        catch (Exception e) {
            Logger.warn(e.getMessage(), e);
        }
    }

    @Override
    public Cursor getCursor() {
        return Cursor.getPredefinedCursor(12);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Icon getIcon() {
        return new ImageIcon(this.getClass().getResource("DrawCircleByRadius.gif"));
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        try {
            this.setViewDestination(e.getPoint());
            this.redrawShape();
        }
        catch (Throwable t) {
            this.getPanel().getContext().handleThrowable(t);
        }
    }

    @Override
    protected Shape getShape() {
        this.calculateCircle(this.modelDestination, this.getPanel());
        return this.selectedFeaturesShape;
    }

    private void calculateCircle(Coordinate middlePoint, LayerViewPanel panel) {
        Point p = new GeometryFactory().createPoint(middlePoint);
        Geometry buffer = p.buffer(radius);
        Geometry[] geomArray = new Geometry[]{buffer};
        GeometryCollection gc = this.geometryFactory.createGeometryCollection(geomArray);
        try {
            this.selectedFeaturesShape = panel.getJava2DConverter().toShape((Geometry)gc);
        }
        catch (NoninvertibleTransformException e) {
            System.out.println("DrawCircleWithGivenRadiusTool:Exception " + e);
        }
    }

    public boolean makeDialogThings(LayerViewPanel panel) throws Exception {
        LayerViewPanelContext context = panel.getContext();
        WorkbenchFrame fr = (WorkbenchFrame)context;
        MultiInputDialog dialog = new MultiInputDialog(fr, this.getName(), true);
        dialog.setCancelVisible(false);
        this.setDialogValues(dialog);
        GUIUtil.centreOnWindow(dialog);
        dialog.setVisible(true);
        if (!dialog.wasOKPressed()) {
            return false;
        }
        this.getDialogValues(dialog);
        return true;
    }

    private void setDialogValues(MultiInputDialog dialog) {
        dialog.setSideBarDescription(this.sidebarstring);
        dialog.addDoubleField(this.T1, radius, 7, this.T1);
        dialog.addDoubleField(this.sAccuracy, tolerance, 7, this.sAccuracy);
    }

    private void getDialogValues(MultiInputDialog dialog) {
        radius = dialog.getDouble(this.T1);
        tolerance = dialog.getDouble(this.sAccuracy);
    }

    protected void setViewDestination(Point2D destination) throws NoninvertibleTransformException {
        this.setModelDestination(this.getPanel().getViewport().toModelCoordinate(destination));
    }

    protected void setModelDestination(Coordinate destination) {
        this.modelDestination = this.snap(destination);
    }
}

