/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.edit;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.openjump.core.ui.plugin.edit.helpclassesselection.SelectItemsByCircleTool;

public class SelectItemsByCircleFromSelectedLayersPlugIn
extends AbstractPlugIn {
    private String T1 = "diameter";
    private String sidebarstring = "";
    private double diameter = 50.0;

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
        this.T1 = I18N.getInstance().get("org.openjump.core.ui.plugin.edit.SelectItemsByCirlceFromSelectedLayersPlugIn.cirlce-diameter") + ":";
        this.sidebarstring = I18N.getInstance().get("org.openjump.core.ui.plugin.edit.SelectItemsByCirlceFromSelectedLayersPlugIn.select-features-within-a-circle-from-currently-selected-layers");
        context.getFeatureInstaller().addMainMenuPlugin(this, new String[]{MenuNames.EDIT, MenuNames.SELECTION}, this.getName(), false, null, SelectItemsByCircleFromSelectedLayersPlugIn.createEnableCheck(context.getWorkbenchContext()));
    }

    @Override
    public String getName() {
        return I18N.getInstance().get("org.openjump.core.ui.plugin.edit.SelectItemsByCirlceFromSelectedLayersPlugIn.select-features-by-cirlce-from-selected-layers");
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createAtLeastNLayersMustExistCheck(1));
    }

    private boolean makeDialogThings(PlugInContext context) throws Exception {
        this.reportNothingToUndoYet(context);
        MultiInputDialog dialog = new MultiInputDialog(context.getWorkbenchFrame(), this.getName(), true);
        this.setDialogValues(dialog);
        GUIUtil.centreOnWindow(dialog);
        dialog.setVisible(true);
        if (!dialog.wasOKPressed()) {
            return false;
        }
        this.getDialogValues(dialog);
        return true;
    }

    private void setDialogValues(MultiInputDialog dialog) {
        dialog.setSideBarDescription(this.sidebarstring);
        dialog.addDoubleField(this.T1, this.diameter, 7, this.T1);
    }

    private void getDialogValues(MultiInputDialog dialog) {
        this.diameter = dialog.getDouble(this.T1);
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        try {
            if (this.makeDialogThings(context)) {
                Envelope viewportEnvelope = context.getLayerViewPanel().getViewport().getEnvelopeInModelCoordinates();
                double x = viewportEnvelope.getMinX() + viewportEnvelope.getWidth() / 2.0;
                double y = viewportEnvelope.getMinY() + viewportEnvelope.getHeight() / 2.0;
                Coordinate initCoords = new Coordinate(x, y);
                SelectItemsByCircleTool sit = new SelectItemsByCircleTool(context.getWorkbenchContext(), this.diameter, initCoords);
                context.getLayerViewPanel().setCurrentCursorTool(sit);
            }
        }
        catch (Exception e) {
            context.getWorkbenchFrame().warnUser("SelecItemsByCircleTool Exception:" + e.toString());
            return false;
        }
        return true;
    }
}

