/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.datastore.postgis;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.datastore.DataStoreConnection;
import com.vividsolutions.jump.datastore.DataStoreMetadata;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.datastore.ConnectionDescriptor;
import com.vividsolutions.jump.workbench.datastore.ConnectionManager;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.AbstractDriverPanel;
import com.vividsolutions.jump.workbench.ui.OKCancelPanel;
import com.vividsolutions.jump.workbench.ui.plugin.datastore.ConnectionPanel;
import java.awt.Color;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class PostGISSaveDriverPanel
extends AbstractDriverPanel
implements ActionListener {
    public static final String KEY = PostGISSaveDriverPanel.class.getName();
    static final String CREATE_HELP_STRING = I18N.getInstance().get(KEY + ".create-or-replace-help-string");
    static final String REPLACE_HELP_STRING = I18N.getInstance().get(KEY + ".replace-table-rows-help-string");
    static final String INSERT_HELP_STRING = I18N.getInstance().get(KEY + ".insert-only-help-string");
    static final String UPDATE_HELP_STRING = I18N.getInstance().get(KEY + ".insert-or-update-help-string");
    static final String DELETE_HELP_STRING = I18N.getInstance().get(KEY + ".insert-update-or-delete-help-string");
    static final String TITLE = I18N.getInstance().get(KEY + ".title");
    static final String SELECT_SAVE_METHOD = I18N.getInstance().get(KEY + ".select-save-method");
    static final String CREATE = I18N.getInstance().get(KEY + ".create-or-replace");
    static final String REPLACE = I18N.getInstance().get(KEY + ".replace-table-rows");
    static final String INSERT = I18N.getInstance().get(KEY + ".insert-only");
    static final String UPDATE = I18N.getInstance().get(KEY + ".insert-or-update");
    static final String DELETE = I18N.getInstance().get(KEY + ".insert-update-or-delete");
    static final String CHOOSE_PK = I18N.getInstance().get(KEY + ".primary_key");
    static final String CREATE_DB_PK = I18N.getInstance().get("org.openjump.core.ui.plugin.datastore.DataStoreSaveDriverPanel.create-database-primary-key");
    private ButtonGroup methodButtons;
    private JRadioButton createButton;
    private JRadioButton replaceButton;
    private JRadioButton insertButton;
    private JRadioButton updateButton;
    private JRadioButton deleteButton;
    private JLabel primaryKeyLabel;
    private JTextArea help;
    private JComboBox<String> primaryKeyComboBox;
    private ConnectionPanel connectionPanel;
    private JComboBox<String> tableComboBox;
    private JCheckBox createPrimaryKeyCheckBox;
    private OKCancelPanel okCancelPanel;
    private WorkbenchContext wbContext;
    private String lastUsedLayerName = null;
    private Map<String, String> layer2TableMap = new HashMap<String, String>();
    private DefaultComboBoxModel<String> tableList = new DefaultComboBoxModel();

    public PostGISSaveDriverPanel(PlugInContext context) {
        try {
            this.jbInit(context);
            this.wbContext = context.getWorkbenchContext();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void jbInit(PlugInContext context) throws Exception {
        GridBagLayout gbLayout = new GridBagLayout();
        GridBagConstraints gbConstraints = new GridBagConstraints();
        this.setLayout(gbLayout);
        gbConstraints.insets = new Insets(2, 2, 2, 2);
        gbConstraints.anchor = 17;
        JLabel title = new JLabel("<html><h2>" + TITLE + "</h2><br/></br></html>");
        gbConstraints.gridx = 0;
        gbConstraints.gridy = 0;
        gbConstraints.gridwidth = 3;
        gbLayout.setConstraints(title, gbConstraints);
        this.add(title);
        this.connectionPanel = new ConnectionPanel(context.getWorkbenchContext());
        this.connectionPanel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PostGISSaveDriverPanel.this.connectionChanged();
            }
        });
        this.addAncestorListener(new DPAncestorListener());
        gbConstraints.gridx = 0;
        gbConstraints.gridy = 4;
        gbConstraints.gridwidth = 3;
        gbConstraints.gridheight = 1;
        gbLayout.setConstraints(this.connectionPanel, gbConstraints);
        this.add(this.connectionPanel);
        JLabel tableLabel = new JLabel("Table");
        gbConstraints.gridx = 0;
        gbConstraints.gridy = 5;
        gbConstraints.gridwidth = 1;
        gbLayout.setConstraints(tableLabel, gbConstraints);
        this.add(tableLabel);
        this.tableComboBox = new JComboBox<String>(this.tableList);
        this.tableComboBox.setPrototypeDisplayValue("abcdefghijklmnopqrstuvwxyz0123456789.abcdefghijklmnopqrstuvwxyz0123456789");
        this.tableComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PostGISSaveDriverPanel.this.resetPKChooser();
            }
        });
        gbConstraints.gridx = 1;
        gbConstraints.gridy = 5;
        gbLayout.setConstraints(this.tableComboBox, gbConstraints);
        this.add(this.tableComboBox);
        JLabel methodLabel = new JLabel(SELECT_SAVE_METHOD);
        gbConstraints.gridx = 0;
        gbConstraints.gridy = 6;
        gbLayout.setConstraints(methodLabel, gbConstraints);
        this.add(methodLabel);
        this.createButton = new JRadioButton(CREATE);
        this.createButton.setActionCommand("Create");
        this.createButton.addActionListener(this);
        gbConstraints.gridx = 1;
        gbConstraints.gridy = 7;
        gbLayout.setConstraints(this.createButton, gbConstraints);
        this.add(this.createButton);
        this.replaceButton = new JRadioButton(REPLACE);
        this.replaceButton.setActionCommand("Replace");
        this.replaceButton.addActionListener(this);
        gbConstraints.gridx = 1;
        gbConstraints.gridy = 8;
        gbLayout.setConstraints(this.replaceButton, gbConstraints);
        this.add(this.replaceButton);
        this.insertButton = new JRadioButton(INSERT);
        this.insertButton.setActionCommand("Insert");
        this.insertButton.setSelected(true);
        this.insertButton.addActionListener(this);
        gbConstraints.gridy = 9;
        gbLayout.setConstraints(this.insertButton, gbConstraints);
        this.add(this.insertButton);
        this.updateButton = new JRadioButton(UPDATE);
        this.updateButton.setActionCommand("Update");
        this.updateButton.addActionListener(this);
        this.updateButton.setSelected(false);
        gbConstraints.gridy = 10;
        gbLayout.setConstraints(this.updateButton, gbConstraints);
        this.add(this.updateButton);
        this.deleteButton = new JRadioButton(DELETE);
        this.deleteButton.setActionCommand("Delete");
        this.deleteButton.addActionListener(this);
        this.deleteButton.setSelected(false);
        gbConstraints.gridy = 11;
        gbLayout.setConstraints(this.deleteButton, gbConstraints);
        this.add(this.deleteButton);
        this.methodButtons = new ButtonGroup();
        this.methodButtons.add(this.createButton);
        this.methodButtons.add(this.replaceButton);
        this.methodButtons.add(this.insertButton);
        this.methodButtons.add(this.updateButton);
        this.methodButtons.add(this.deleteButton);
        this.methodButtons.setSelected(this.createButton.getModel(), true);
        this.primaryKeyLabel = new JLabel(CHOOSE_PK);
        this.primaryKeyLabel.setEnabled(true);
        gbConstraints.gridx = 0;
        gbConstraints.gridy = 12;
        gbLayout.setConstraints(this.primaryKeyLabel, gbConstraints);
        this.add(this.primaryKeyLabel);
        this.primaryKeyComboBox = new JComboBox<String>(new String[0]);
        this.primaryKeyComboBox.setPrototypeDisplayValue("abcdefghijklmnopqrstuvwxyz");
        this.primaryKeyComboBox.setEnabled(false);
        gbConstraints.gridx = 1;
        gbLayout.setConstraints(this.primaryKeyComboBox, gbConstraints);
        this.add(this.primaryKeyComboBox);
        this.createPrimaryKeyCheckBox = new JCheckBox(CREATE_DB_PK);
        this.createPrimaryKeyCheckBox.setEnabled(this.createButton.isSelected());
        gbConstraints.gridx = 0;
        gbConstraints.gridy = 13;
        gbLayout.setConstraints(this.createPrimaryKeyCheckBox, gbConstraints);
        this.add(this.createPrimaryKeyCheckBox);
        JPanel helpPanel = new JPanel();
        helpPanel.setBorder(BorderFactory.createBevelBorder(2, Color.BLACK, Color.GRAY));
        this.help = new JTextArea(4, 32);
        this.help.setEditable(false);
        this.help.setLineWrap(true);
        this.help.setWrapStyleWord(true);
        this.help.setBackground(this.getBackground());
        this.help.setFont(new Font("Sans-Serif", 0, 12));
        gbConstraints.gridx = 2;
        gbConstraints.gridy = 7;
        gbConstraints.gridwidth = 1;
        gbConstraints.gridheight = 5;
        helpPanel.add(this.help);
        gbLayout.setConstraints(helpPanel, gbConstraints);
        this.add(helpPanel);
        this.help.setText(CREATE_HELP_STRING);
    }

    @Override
    public String getValidationError() {
        return null;
    }

    @Override
    public void addActionListener(ActionListener l) {
        this.okCancelPanel.addActionListener(l);
    }

    @Override
    public void removeActionListener(ActionListener l) {
        this.okCancelPanel.removeActionListener(l);
    }

    @Override
    public boolean wasOKPressed() {
        return this.okCancelPanel.wasOKPressed();
    }

    public ConnectionDescriptor getConnectionDescriptor() {
        return this.connectionPanel.getConnectionDescriptor();
    }

    public String getTableName() {
        this.layer2TableMap.put(this.lastUsedLayerName, (String)this.tableComboBox.getSelectedItem());
        return (String)this.tableComboBox.getSelectedItem();
    }

    public String getSaveMethod() {
        return this.methodButtons.getSelection().getActionCommand();
    }

    public String getPrimaryKey() {
        if (!this.primaryKeyComboBox.isEnabled()) {
            return null;
        }
        Object selection = this.primaryKeyComboBox.getSelectedItem();
        if (selection == null) {
            return null;
        }
        return selection.toString();
    }

    public boolean isCreatePrimaryKeyColumnSelected() {
        return this.createPrimaryKeyCheckBox.isEnabled() && this.createPrimaryKeyCheckBox.isSelected();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String action = ae.getActionCommand();
        if (action.equals("Create")) {
            this.tableComboBox.setEditable(true);
            this.primaryKeyLabel.setEnabled(false);
            this.resetPKChooser();
            this.primaryKeyComboBox.setEnabled(false);
            this.createPrimaryKeyCheckBox.setEnabled(true);
            this.help.setText(CREATE_HELP_STRING);
        }
        if (action.equals("Replace")) {
            this.tableComboBox.setEditable(false);
            this.primaryKeyLabel.setEnabled(false);
            this.primaryKeyComboBox.setEnabled(false);
            this.createPrimaryKeyCheckBox.setEnabled(false);
            this.help.setText(REPLACE_HELP_STRING);
        }
        if (action.equals("Insert")) {
            this.tableComboBox.setEditable(false);
            this.primaryKeyLabel.setEnabled(false);
            this.resetPKChooser();
            this.primaryKeyComboBox.setEnabled(false);
            this.createPrimaryKeyCheckBox.setEnabled(false);
            this.help.setText(INSERT_HELP_STRING);
        }
        if (action.equals("Update")) {
            this.tableComboBox.setEditable(false);
            this.primaryKeyLabel.setEnabled(true);
            this.resetPKChooser();
            this.primaryKeyComboBox.setEnabled(true);
            this.createPrimaryKeyCheckBox.setEnabled(false);
            this.help.setText(UPDATE_HELP_STRING);
        }
        if (action.equals("Delete")) {
            this.tableComboBox.setEditable(false);
            this.primaryKeyLabel.setEnabled(true);
            this.resetPKChooser();
            this.primaryKeyComboBox.setEnabled(true);
            this.createPrimaryKeyCheckBox.setEnabled(false);
            this.help.setText(DELETE_HELP_STRING);
        }
    }

    private void layerChanged() {
        this.createButton.setSelected(true);
        this.addItemToTableList(this.tableList, this.lastUsedLayerName);
    }

    private void connectionChanged() {
        try {
            if (ConnectionManager.instance(this.wbContext) == null || this.connectionPanel.getConnectionDescriptor() == null || this.getDSConnection() == null) {
                this.updateTableList(null);
            } else {
                DataStoreMetadata metadata = this.getDSConnection().getMetadata();
                this.updateTableList(metadata);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private DataStoreConnection getDSConnection() throws Exception {
        return ConnectionManager.instance(this.wbContext).getOpenConnection(this.connectionPanel.getConnectionDescriptor());
    }

    private void updateTableList(DataStoreMetadata metadata) {
        Layer[] layers = this.wbContext.getLayerNamePanel().getSelectedLayers();
        if (layers.length == 1 && this.createButton.isSelected()) {
            String layerName = layers[0].getName();
            this.addItemToTableList(this.tableList, layerName);
            this.tableComboBox.setSelectedItem(layerName);
        }
        if (metadata != null) {
            String[] tableNames;
            for (String t : tableNames = metadata.getDatasetNames()) {
                this.addItemToTableList(this.tableList, t);
            }
        }
        this.tableComboBox.setEditable(true);
        this.validate();
        if (this.tableComboBox.getSelectedItem() != null) {
            this.resetPKChooser();
        }
    }

    private void resetPKChooser() {
        Object oldValue = this.primaryKeyComboBox.getSelectedItem();
        Layer[] layers = this.wbContext.getLayerNamePanel().getSelectedLayers();
        if (layers.length == 1) {
            FeatureSchema schema = layers[0].getFeatureCollectionWrapper().getFeatureSchema();
            ArrayList<String> list = new ArrayList<String>();
            for (int i = 0; i < schema.getAttributeCount(); ++i) {
                if (schema.getAttributeType(i) != AttributeType.LONG && schema.getAttributeType(i) != AttributeType.STRING && schema.getAttributeType(i) != AttributeType.INTEGER && schema.getAttributeType(i) != AttributeType.OBJECT && schema.getExternalPrimaryKeyIndex() != i) continue;
                list.add(schema.getAttributeName(i));
            }
            this.primaryKeyComboBox.setModel(new DefaultComboBoxModel<String>(list.toArray(new String[list.size()])));
            if (oldValue != null && list.contains(oldValue.toString())) {
                this.primaryKeyComboBox.setSelectedItem(oldValue);
            }
            this.validate();
        }
    }

    private void addItemToTableList(DefaultComboBoxModel<String> model, String item) {
        for (int i = 0; i < model.getSize(); ++i) {
            String item_i = model.getElementAt(i);
            int compare = item.compareTo(item_i);
            if (compare < 0) {
                model.insertElementAt(item, i);
                return;
            }
            if (compare != 0) continue;
            return;
        }
        model.insertElementAt(item, model.getSize());
    }

    private boolean hasPrimaryKey() {
        Layer[] layers = this.wbContext.getLayerNamePanel().getSelectedLayers();
        return layers.length == 1 && layers[0].getFeatureCollectionWrapper().getFeatureSchema().getExternalPrimaryKeyIndex() >= 0;
    }

    class DPAncestorListener
    implements AncestorListener {
        DPAncestorListener() {
        }

        @Override
        public void ancestorAdded(AncestorEvent e) {
            Layer[] layers = PostGISSaveDriverPanel.this.wbContext.getLayerNamePanel().getSelectedLayers();
            if (layers.length == 1) {
                PostGISSaveDriverPanel.this.connectionChanged();
                String layerName = layers[0].getName();
                if (!layerName.equals(PostGISSaveDriverPanel.this.lastUsedLayerName)) {
                    PostGISSaveDriverPanel.this.lastUsedLayerName = layerName;
                    PostGISSaveDriverPanel.this.layerChanged();
                }
                if (PostGISSaveDriverPanel.this.layer2TableMap.get(layerName) != null) {
                    PostGISSaveDriverPanel.this.tableList.setSelectedItem(PostGISSaveDriverPanel.this.layer2TableMap.get(layerName));
                } else {
                    PostGISSaveDriverPanel.this.tableList.setSelectedItem(layerName);
                }
            }
        }

        @Override
        public void ancestorMoved(AncestorEvent event) {
        }

        @Override
        public void ancestorRemoved(AncestorEvent event) {
        }
    }
}

