/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.datastore.h2;

import com.vividsolutions.jump.datastore.AdhocQuery;
import com.vividsolutions.jump.datastore.SQLUtil;
import com.vividsolutions.jump.datastore.h2.H2DSConnection;
import com.vividsolutions.jump.datastore.h2.H2DataStoreDriver;
import com.vividsolutions.jump.datastore.h2.H2ServerDataStoreDriver;
import com.vividsolutions.jump.datastore.spatialdatabases.SpatialDatabasesDSConnection;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.io.FeatureInputStream;
import com.vividsolutions.jump.workbench.Logger;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.datastore.ConnectionDescriptor;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.locationtech.jts.geom.Coordinate;
import org.openjump.core.ui.plugin.datastore.WritableDataStoreDataSource;

public class H2DataStoreDataSource
extends WritableDataStoreDataSource {
    public H2DataStoreDataSource() {
    }

    public H2DataStoreDataSource(WorkbenchContext context) {
        this.context = context;
    }

    public H2DataStoreDataSource(ConnectionDescriptor connectionDescriptor, String datasetName, String geometryAttributeName, String identifierAttributeName, String txManagerClass, WorkbenchContext context) {
        super(connectionDescriptor, datasetName, geometryAttributeName, identifierAttributeName, txManagerClass, context);
    }

    @Override
    public void finalizeUpdate(SpatialDatabasesDSConnection conn) throws Exception {
    }

    @Override
    protected FeatureCollection createFeatureCollection() throws Exception {
        H2DSConnection h2Connection;
        Logger.debug("Create new FeatureCollection from " + this.getProperties().get("Dataset Name"));
        ConnectionDescriptor connectionDescriptor = (ConnectionDescriptor)this.getProperties().get("Connection Descriptor");
        if (connectionDescriptor.getDataStoreDriverClassName().equals(H2DataStoreDriver.class.getName())) {
            h2Connection = (H2DSConnection)new H2DataStoreDriver().createConnection(connectionDescriptor.getParameterList());
        } else if (connectionDescriptor.getDataStoreDriverClassName().equals(H2ServerDataStoreDriver.class.getName())) {
            h2Connection = (H2DSConnection)new H2ServerDataStoreDriver().createConnection(connectionDescriptor.getParameterList());
        } else {
            throw new IllegalArgumentException("The connection does not use a H2 Driver");
        }
        boolean hasPK = this.getProperties().get("External PK") != null;
        String PK = (String)this.getProperties().get("External PK");
        String query = this.buildQueryString(h2Connection);
        Logger.debug(query);
        AdhocQuery adhocQuery = new AdhocQuery(query);
        if (hasPK) {
            adhocQuery.setPrimaryKey(PK);
        }
        FeatureInputStream featureInputStream = null;
        FeatureDataset featureDataset = null;
        try {
            featureInputStream = h2Connection.execute(adhocQuery);
            featureDataset = new FeatureDataset(featureInputStream.getFeatureSchema());
            if (hasPK) {
                featureDataset.getFeatureSchema().setExternalPrimaryKeyIndex(featureDataset.getFeatureSchema().getAttributeIndex(PK));
            }
            while (featureInputStream.hasNext()) {
                featureDataset.add(featureInputStream.next());
            }
            return featureDataset;
        }
        catch (Exception e) {
            if (this.context != null) {
                this.context.getWorkbench().getFrame().handleThrowable(e);
            }
            featureDataset = new FeatureDataset(new FeatureSchema());
            return featureDataset;
        }
    }

    private String buildQueryString(SpatialDatabasesDSConnection conn) throws SQLException {
        String geometryColumn = (String)this.getProperties().get("Geometry Attribute Name");
        String[] columns = conn.getMetadata().getColumnNames(SQLUtil.unquote((String)this.getProperties().get("Dataset Name")));
        int table_srid = this.getTableSRID(conn.getJdbcConnection(), geometryColumn);
        boolean limited_to_view = (Boolean)this.getProperties().get("Limited To View");
        String extent = limited_to_view ? " AND (\"" + geometryColumn + "\" && ST_GeomFromText('" + this.getViewEnvelope().toText() + "'," + table_srid + "))" : "";
        String whereClause = (String)this.getProperties().get("Where Clause");
        whereClause = whereClause == null || whereClause.length() == 0 ? "true" : "(" + whereClause + ")";
        int max_features = (Integer)this.getProperties().get("Max Features");
        StringBuffer sb = new StringBuffer("SELECT \"").append(geometryColumn).append("\"");
        for (String col : columns) {
            if (col.equals(geometryColumn)) continue;
            sb.append(", \"").append(col).append("\"");
        }
        sb.append(" FROM \"").append(this.schemaName == null ? "" : SQLUtil.unquote(this.schemaName) + "\".\"").append(SQLUtil.unquote(this.tableName)).append("\" WHERE ").append(whereClause).append(extent).append(" LIMIT " + max_features).append(";");
        return sb.toString();
    }

    @Override
    protected void deleteTableQuery(SpatialDatabasesDSConnection conn) throws SQLException {
        conn.getJdbcConnection().createStatement().execute("DROP TABLE " + SQLUtil.compose(this.schemaName, this.tableName) + ";");
    }

    @Override
    protected void createAndPopulateTable(SpatialDatabasesDSConnection conn, FeatureCollection fc, int srid, String geometryType, boolean multi, int dim, boolean normalizedColumnNames) throws SQLException {
        FeatureSchema schema = fc.getFeatureSchema();
        String geometryColumn = normalizedColumnNames ? SQLUtil.normalize(schema.getAttributeName(schema.getGeometryIndex())) : schema.getAttributeName(schema.getGeometryIndex());
        try {
            conn.getJdbcConnection().createStatement().execute(conn.getMetadata().getCreateTableStatement(fc.getFeatureSchema(), this.schemaName, this.tableName, normalizedColumnNames));
        }
        catch (SQLException sqle) {
            throw new SQLException("Error executing query: " + conn.getMetadata().getCreateTableStatement(fc.getFeatureSchema(), this.schemaName, this.tableName, normalizedColumnNames), sqle);
        }
        try {
            conn.getJdbcConnection().createStatement().execute(conn.getMetadata().getAddGeometryColumnStatement(this.schemaName, this.tableName, geometryColumn, srid, geometryType, dim));
        }
        catch (SQLException sqle) {
            throw new SQLException("Error executing query: " + conn.getMetadata().getAddGeometryColumnStatement(this.schemaName, this.tableName, geometryColumn, srid, geometryType, dim), sqle);
        }
        this.populateTable(conn, fc, null, srid, multi, dim, normalizedColumnNames);
        try {
            conn.getJdbcConnection().createStatement().execute(conn.getMetadata().getAddSpatialIndexStatement(this.schemaName, this.tableName, geometryColumn));
        }
        catch (SQLException sqle) {
            throw new SQLException("Error executing query: " + conn.getMetadata().getAddSpatialIndexStatement(this.schemaName, this.tableName, geometryColumn), sqle);
        }
    }

    private void populateTable(SpatialDatabasesDSConnection conn, FeatureCollection fc, String primaryKey, int srid, boolean multi, int dim, boolean normalizedColumnNames) throws SQLException {
        PreparedStatement statement = this.insertStatement(conn, fc.getFeatureSchema(), multi, normalizedColumnNames);
        int count = 0;
        double replacementZ = this.getProperties().get("NaN Z to value") == null ? Double.NaN : (Double)this.getProperties().get("NaN Z to value");
        for (Feature f : fc) {
            if (dim == 3 && this.getProperties().get("Dimension") != null) {
                for (Coordinate c : f.getGeometry().getCoordinates()) {
                    if (!Double.isNaN(c.z)) continue;
                    c.z = replacementZ;
                }
            }
            statement = this.setAttributeValues(statement, f, srid, multi, dim);
            statement.addBatch();
            if (count++ % 10000 != 0) continue;
            statement.executeBatch();
            statement.clearBatch();
        }
        statement.executeBatch();
        statement.clearBatch();
    }

    @Override
    protected void addDBPrimaryKey(SpatialDatabasesDSConnection conn, String primaryKey) throws SQLException {
        String sql_create_dbid = "ALTER TABLE " + SQLUtil.compose(this.schemaName, this.tableName) + " ADD COLUMN \"" + primaryKey + "\" serial NOT NULL;";
        sql_create_dbid = sql_create_dbid + "\nCREATE PRIMARY KEY ON " + SQLUtil.compose(this.schemaName, this.tableName) + "(\"" + primaryKey + "\")";
        try {
            conn.getJdbcConnection().createStatement().execute(sql_create_dbid);
        }
        catch (SQLException sqle) {
            throw new SQLException(sql_create_dbid, sqle);
        }
    }

    @Override
    protected int getTableSRID(Connection conn, String column) throws SQLException {
        String sql = this.schemaName == null ? "SELECT srid FROM geometry_columns WHERE f_table_schema = 'public' AND f_table_name = '" + this.tableName + "'" : "SELECT srid FROM geometry_columns WHERE f_table_schema = '" + this.schemaName + "' AND f_table_name = '" + this.tableName + "'";
        Logger.debug(sql);
        ResultSet rs = conn.prepareStatement(sql).executeQuery();
        if (rs.next()) {
            return rs.getInt(1);
        }
        return 0;
    }
}

