/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.datastore;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.coordsys.CoordinateSystemRegistry;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.io.datasource.DataSourceQuery;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedBasePlugIn;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.TitledPopupMenu;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;
import com.vividsolutions.jump.workbench.ui.plugin.datastore.DataStoreQueryDataSource;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.openjump.core.ui.images.IconLoader;
import org.openjump.core.ui.plugin.file.open.OpenProjectWizard;

public class RefreshDataStoreQueryPlugIn
extends ThreadedBasePlugIn {
    public static final ImageIcon ICON = IconLoader.icon("arrow_refresh_sql.png");

    @Override
    public void initialize(PlugInContext context) throws Exception {
        WorkbenchContext workbenchContext = context.getWorkbenchContext();
        EnableCheck enableCheck = this.createEnableCheck(workbenchContext);
        FeatureInstaller installer = context.getFeatureInstaller();
        TitledPopupMenu popupMenu = workbenchContext.getWorkbench().getFrame().getLayerNamePopupMenu();
        installer.addPopupMenuPlugin(popupMenu, this, new String[]{MenuNames.DATASTORE}, this.getName(), false, ICON, enableCheck);
    }

    @Override
    public String getName() {
        return I18N.getInstance().get("org.openjump.core.ui.plugin.datastore.RefreshDataStoreQueryPlugIn.Refresh-datastore-query");
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        return true;
    }

    @Override
    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        Layer[] selectedLayers;
        for (final Layer layer : selectedLayers = context.getSelectedLayers()) {
            DataSourceQuery dsq = layer.getDataSourceQuery();
            if (dsq == null || !(dsq.getDataSource() instanceof DataStoreQueryDataSource)) continue;
            FeatureSchema oldSchema = layer.getFeatureCollectionWrapper().getFeatureSchema();
            OpenProjectWizard.load(layer, CoordinateSystemRegistry.instance(context.getWorkbenchContext().getBlackboard()), monitor);
            FeatureSchema schema = layer.getFeatureCollectionWrapper().getFeatureSchema();
            if (oldSchema.equals(schema, false)) {
                for (int i = 0; i < oldSchema.getAttributeCount(); ++i) {
                    String name = oldSchema.getAttributeName(i);
                    int index = schema.getAttributeIndex(name);
                    schema.setOperation(index, oldSchema.getOperation(i));
                    schema.setAttributeReadOnly(index, oldSchema.isAttributeReadOnly(i));
                }
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    layer.setFeatureCollectionModified(false);
                }
            });
        }
    }

    public EnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        final WorkbenchContext wc = workbenchContext;
        EnableCheckFactory enableCheckFactory = EnableCheckFactory.getInstance(workbenchContext);
        MultiEnableCheck enableCheck = new MultiEnableCheck();
        enableCheck.add(enableCheckFactory.createWindowWithLayerManagerMustBeActiveCheck());
        enableCheck.add(enableCheckFactory.createAtLeastNLayerablesMustBeSelectedCheck(1, Layerable.class));
        enableCheck.add(new EnableCheck(){

            @Override
            public String check(JComponent component) {
                Layer[] selectedLayers;
                for (Layer layer : selectedLayers = wc.getLayerableNamePanel().getSelectedLayers()) {
                    if (layer.getDataSourceQuery() != null && layer.getDataSourceQuery().getDataSource() instanceof DataStoreQueryDataSource) continue;
                    return I18N.getInstance().get("org.openjump.core.ui.plugin.datastore.RefreshDataStoreQueryPlugIn.Only-datastore-query-layers-must-be-selected");
                }
                return null;
            }
        });
        return enableCheck;
    }
}

