/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.customize;

import bsh.util.JConsole;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.JUMPException;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.toolbox.ToolboxDialog;
import com.vividsolutions.jump.workbench.ui.toolbox.ToolboxPlugInV2;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.net.URL;
import java.nio.file.Paths;
import java.util.Properties;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import org.openjump.util.python.JUMP_GIS_Framework;
import org.openjump.util.python.ModifyGeometry;
import org.openjump.util.python.PythonInteractiveInterpreter;
import org.python.core.PySystemState;

public class PythonToolsPlugIn
extends ToolboxPlugInV2 {
    private static final ImageIcon icon = IconLoader.icon("famfam/application_python.png");

    @Override
    public String getName() {
        return I18N.getInstance().get("org.openjump.core.ui.plugin.customize.PythonToolsPlugIn.Python-Console-and-Tools");
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
        context.getFeatureInstaller().addMainMenuPlugin(this, new String[]{MenuNames.CUSTOMIZE});
    }

    @Override
    protected ToolboxDialog initializeToolbox() throws Exception {
        WorkbenchContext context = JUMPWorkbench.getInstance().getContext();
        ClassLoader classLoader = context.getWorkbench().getPlugInManager().getClassLoader();
        Properties preProperties = new Properties(System.getProperties());
        String homepath = preProperties.getProperty("user.home");
        String sep = File.separator;
        String libPath = "";
        URL res = classLoader.getResource("jython/startup.py");
        if (res == null) {
            throw new JUMPException("missing jython/startup.py in classpath.");
        }
        File file = Paths.get(res.toURI()).toFile();
        String startupfile = file.getPath();
        String startuppath = file.getParentFile().getPath() + sep;
        String extPath = file.getParentFile().getParent() + sep;
        libPath = file.getParentFile().getParentFile().getParent() + sep;
        ToolboxDialog toolbox = new ToolboxDialog(context);
        toolbox.setTitle(this.getName());
        JConsole console = new JConsole();
        console.setPreferredSize(new Dimension(450, 120));
        console.println((Icon)new ImageIcon(this.getClass().getResource("jython_small_c.png")));
        toolbox.getCenterPanel().add((Component)console, "Center");
        toolbox.setTitle("Jython");
        toolbox.setInitialLocation(new GUIUtil.Location(0, true, 0, true));
        toolbox.setResizable(true);
        toolbox.setIconImage(icon.getImage());
        Properties postProperties = new Properties();
        postProperties.put("python.home", homepath);
        postProperties.put("python.path", startuppath);
        PySystemState.initialize((Properties)preProperties, (Properties)postProperties, (String[])new String[]{""}, (ClassLoader)classLoader);
        PySystemState.add_extdir((String)libPath);
        PySystemState.add_extdir((String)extPath);
        PythonInteractiveInterpreter interpreter = new PythonInteractiveInterpreter(console);
        interpreter.set("wc", toolbox.getContext());
        interpreter.set("toolbox", toolbox);
        interpreter.set("startuppath", startuppath);
        interpreter.exec("import sys");
        JUMP_GIS_Framework.setWorkbenchContext(toolbox.getContext());
        ModifyGeometry.setWorkbenchContext(toolbox.getContext());
        toolbox.addToolBar();
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(new JMenu(MenuNames.TOOLS));
        toolbox.setJMenuBar(jMenuBar);
        if (new File(startupfile).exists()) {
            interpreter.execfile(startupfile);
        }
        new Thread(interpreter).start();
        return toolbox;
    }

    @Override
    public Icon getIcon() {
        return icon;
    }

    @Override
    public EnableCheck getEnableCheck() {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(this.getWorkbenchContext());
        return new MultiEnableCheck().add(super.getEnableCheck()).add(checkFactory.createTaskWindowMustBeActiveCheck());
    }
}

