/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.rasterimage.styler.ui;

import com.vividsolutions.jump.util.Range;
import com.vividsolutions.jump.util.StringUtil;
import com.vividsolutions.jump.workbench.Logger;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.LayerEventType;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.ui.ErrorDialog;
import com.vividsolutions.jump.workbench.ui.renderer.style.ColorThemingStylePanel;
import com.vividsolutions.jump.workbench.ui.style.StylePanel;
import de.fho.jump.pirol.utilities.settings.PirolPlugInSettings;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.NoninvertibleTransformException;
import java.io.File;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import org.openjump.core.rasterimage.RasterImageLayer;
import org.openjump.core.rasterimage.RasterSymbology;
import org.openjump.core.rasterimage.Stats;
import org.openjump.core.rasterimage.styler.I18N;
import org.openjump.core.rasterimage.styler.SLDHandler;
import org.openjump.core.rasterimage.styler.Utils;
import org.openjump.core.rasterimage.styler.ui.GUIUtils;
import org.openjump.core.rasterimage.styler.ui.IntervalPanel;
import org.openjump.core.rasterimage.styler.ui.SingleValuesPanel;
import org.openjump.core.rasterimage.styler.ui.StretchedPanel;
import org.openjump.core.ui.io.file.FileNameExtensionFilter;

public class RasterStylesDialog
extends JDialog {
    private JButton jButton_Apply;
    private JButton jButton_Cancel;
    private JButton jButton_Load;
    private JButton jButton_NoDataValueColor;
    private JButton jButton_OK;
    private JButton jButton_Restore;
    private JButton jButton_Save;
    private JCheckBox jCheckBox_NoDataValue;
    private JLabel jLabel_Transp_0;
    private JLabel jLabel_Transp_100;
    private JLabel jLabel_Transparency;
    private JPanel jPanel_OtherParams;
    private JSlider jSlider_Transparency;
    private JTabbedPane jTabbedPane_Type;
    private JTextField jTextField_TranspValue;
    private Color noDataColor;
    private final WorkbenchContext context;
    private final RasterImageLayer rasterImageLayer;
    private final int band;
    private StretchedPanel stretchedPanel;
    private IntervalPanel intervalPanel;
    private SingleValuesPanel singleValuesPanel;
    private final MyVerifier verifier = new MyVerifier();
    private RasterSymbology finalRasterSymbolizer;

    public RasterStylesDialog(Frame parent, boolean modal, WorkbenchContext context, RasterImageLayer rasterImageLayer, int band) throws Exception {
        super(parent, modal);
        this.context = context;
        this.rasterImageLayer = rasterImageLayer;
        this.band = band;
        try {
            this.initComponents();
            this.fixComponents();
        }
        catch (Exception e) {
            Logger.error(e);
            context.getErrorHandler().handleThrowable(e);
        }
    }

    private void initComponents() {
        this.jTabbedPane_Type = new JTabbedPane();
        this.jPanel_OtherParams = new JPanel();
        this.jButton_NoDataValueColor = new JButton();
        this.jLabel_Transparency = new JLabel();
        this.jLabel_Transp_0 = new JLabel();
        this.jSlider_Transparency = new JSlider();
        this.jLabel_Transp_100 = new JLabel();
        this.jCheckBox_NoDataValue = new JCheckBox();
        this.jTextField_TranspValue = new JTextField();
        this.jButton_Load = new JButton();
        this.jButton_Save = new JButton();
        this.jButton_Cancel = new JButton();
        this.jButton_Restore = new JButton();
        this.jButton_Apply = new JButton();
        this.jButton_OK = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(420, 450));
        this.getContentPane().setLayout(new GridBagLayout());
        this.jTabbedPane_Type.setAlignmentX(1.0f);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jTabbedPane_Type, gridBagConstraints);
        this.jPanel_OtherParams.setBorder(BorderFactory.createEtchedBorder());
        this.jPanel_OtherParams.setMinimumSize(new Dimension(400, 100));
        this.jPanel_OtherParams.setPreferredSize(new Dimension(400, 100));
        this.jPanel_OtherParams.setLayout(new GridBagLayout());
        this.jButton_NoDataValueColor.setBackground(new Color(204, 204, 204));
        this.jButton_NoDataValueColor.setForeground(new Color(204, 204, 204));
        this.jButton_NoDataValueColor.setText(I18N.get("org.openjump.core.rasterimage.styler.ui.RasterStylesDialog.jButton_NoDataValueColor.text"));
        this.jButton_NoDataValueColor.setBorder(BorderFactory.createEtchedBorder());
        this.jButton_NoDataValueColor.setContentAreaFilled(false);
        this.jButton_NoDataValueColor.setDoubleBuffered(true);
        this.jButton_NoDataValueColor.setMaximumSize(new Dimension(40, 25));
        this.jButton_NoDataValueColor.setMinimumSize(new Dimension(40, 25));
        this.jButton_NoDataValueColor.setOpaque(true);
        this.jButton_NoDataValueColor.setPreferredSize(new Dimension(40, 25));
        this.jButton_NoDataValueColor.addActionListener(this::jButton_NoDataValueColorActionPerformed);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.jPanel_OtherParams.add((Component)this.jButton_NoDataValueColor, gridBagConstraints);
        this.jLabel_Transparency.setText(I18N.get("org.openjump.core.rasterimage.styler.ui.RasterStylesDialog.jLabel_Transparency.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.jPanel_OtherParams.add((Component)this.jLabel_Transparency, gridBagConstraints);
        this.jLabel_Transp_0.setBackground(new Color(0, 0, 0));
        this.jLabel_Transp_0.setText(I18N.get("org.openjump.core.rasterimage.styler.ui.RasterStylesDialog.jLabel_Transp_0.text"));
        this.jLabel_Transp_0.setBorder(BorderFactory.createEtchedBorder());
        this.jLabel_Transp_0.setMaximumSize(new Dimension(10, 10));
        this.jLabel_Transp_0.setMinimumSize(new Dimension(10, 10));
        this.jLabel_Transp_0.setOpaque(true);
        this.jLabel_Transp_0.setPreferredSize(new Dimension(10, 10));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.jPanel_OtherParams.add((Component)this.jLabel_Transp_0, gridBagConstraints);
        this.jSlider_Transparency.setFont(new Font("Tahoma", 0, 5));
        this.jSlider_Transparency.setForeground(new Color(102, 102, 102));
        this.jSlider_Transparency.setMajorTickSpacing(20);
        this.jSlider_Transparency.setMinorTickSpacing(5);
        this.jSlider_Transparency.setPaintTicks(true);
        this.jSlider_Transparency.setSnapToTicks(true);
        this.jSlider_Transparency.setValue(0);
        this.jSlider_Transparency.setMinimumSize(new Dimension(150, 31));
        this.jSlider_Transparency.setPreferredSize(new Dimension(150, 31));
        this.jSlider_Transparency.addChangeListener(this::jSlider_TransparencyStateChanged);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(9, 0, 0, 0);
        this.jPanel_OtherParams.add((Component)this.jSlider_Transparency, gridBagConstraints);
        this.jLabel_Transp_100.setText(I18N.get("org.openjump.core.rasterimage.styler.ui.RasterStylesDialog.jLabel_Transp_100.text"));
        this.jLabel_Transp_100.setBorder(BorderFactory.createEtchedBorder());
        this.jLabel_Transp_100.setMaximumSize(new Dimension(10, 10));
        this.jLabel_Transp_100.setMinimumSize(new Dimension(10, 10));
        this.jLabel_Transp_100.setPreferredSize(new Dimension(10, 10));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.jPanel_OtherParams.add((Component)this.jLabel_Transp_100, gridBagConstraints);
        this.jCheckBox_NoDataValue.setText(I18N.get("org.openjump.core.rasterimage.styler.ui.RasterStylesDialog.jCheckBox_NoDataValue.text"));
        this.jCheckBox_NoDataValue.setMaximumSize(new Dimension(70, 23));
        this.jCheckBox_NoDataValue.setMinimumSize(new Dimension(70, 23));
        this.jCheckBox_NoDataValue.addActionListener(this::jCheckBox_NoDataValueActionPerformed);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.jPanel_OtherParams.add((Component)this.jCheckBox_NoDataValue, gridBagConstraints);
        this.jTextField_TranspValue.setText(I18N.get("org.openjump.core.rasterimage.styler.ui.RasterStylesDialog.jTextField_TranspValue.text"));
        this.jTextField_TranspValue.setMinimumSize(new Dimension(40, 20));
        this.jTextField_TranspValue.setPreferredSize(new Dimension(40, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 20);
        this.jPanel_OtherParams.add((Component)this.jTextField_TranspValue, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 6;
        this.getContentPane().add((Component)this.jPanel_OtherParams, gridBagConstraints);
        this.jButton_Load.setText(I18N.get("org.openjump.core.rasterimage.styler.ui.RasterStylesDialog.jButton_Load.text"));
        this.jButton_Load.addActionListener(this::jButton_LoadActionPerformed);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        this.getContentPane().add((Component)this.jButton_Load, gridBagConstraints);
        this.jButton_Save.setText(I18N.get("org.openjump.core.rasterimage.styler.ui.RasterStylesDialog.jButton_Save.text"));
        this.jButton_Save.addActionListener(this::jButton_SaveActionPerformed);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        this.getContentPane().add((Component)this.jButton_Save, gridBagConstraints);
        this.jButton_Cancel.setText(I18N.get("org.openjump.core.rasterimage.styler.ui.RasterStylesDialog.jButton_Cancel.text"));
        this.jButton_Cancel.addActionListener(this::jButton_CancelActionPerformed);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 20, 5, 10);
        this.getContentPane().add((Component)this.jButton_Cancel, gridBagConstraints);
        this.jButton_Restore.setText(I18N.get("org.openjump.core.rasterimage.styler.ui.RasterStylesDialog.jButton_Restore.text"));
        this.jButton_Restore.addActionListener(this::jButton_RestoreActionPerformed);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.jButton_Restore, gridBagConstraints);
        this.jButton_Apply.setText(I18N.get("org.openjump.core.rasterimage.styler.ui.RasterStylesDialog.jButton_Apply.text"));
        this.jButton_Apply.addActionListener(this::jButton_ApplyActionPerformed);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.jButton_Apply, gridBagConstraints);
        this.jButton_OK.setText(I18N.get("org.openjump.core.rasterimage.styler.ui.RasterStylesDialog.jButton_OK.text"));
        this.jButton_OK.addActionListener(this::jButton_OKActionPerformed);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.jButton_OK, gridBagConstraints);
        this.pack();
    }

    private void jButton_NoDataValueColorActionPerformed(ActionEvent evt) {
        if (this.jCheckBox_NoDataValue.isSelected()) {
            this.noDataColor = JColorChooser.showDialog(this, I18N.get("org.openjump.core.rasterimage.styler.ui.RasterStylesDialog.chooseNoDataColor"), this.jButton_NoDataValueColor.getBackground());
            if (this.noDataColor != null) {
                this.jButton_NoDataValueColor.setBackground(this.noDataColor);
            }
        }
    }

    private void jCheckBox_NoDataValueActionPerformed(ActionEvent evt) {
        this.jButton_NoDataValueColor.setEnabled(this.jCheckBox_NoDataValue.isSelected());
    }

    private void jButton_LoadActionPerformed(ActionEvent evt) {
        this.loadSld();
    }

    private void jButton_SaveActionPerformed(ActionEvent evt) {
        this.saveSld();
    }

    private void jButton_CancelActionPerformed(ActionEvent evt) {
        this.closeDialog();
    }

    private void jButton_ApplyActionPerformed(ActionEvent evt) {
        try {
            this.updateRasterImageLayer();
        }
        catch (Exception ex) {
            Logger.error(ex);
        }
    }

    private void jSlider_TransparencyStateChanged(ChangeEvent evt) {
        this.jTextField_TranspValue.setText(Integer.toString(this.jSlider_Transparency.getValue()));
    }

    private void jButton_RestoreActionPerformed(ActionEvent evt) {
        try {
            Collection<Layerable> layerables = this.context.getLayerableNamePanel().getSelectedLayerables();
            for (Layerable lyr : layerables) {
                this.jButton_NoDataValueColor.setBackground(new Color(204, 204, 204));
                this.jButton_NoDataValueColor.setForeground(new Color(204, 204, 204));
                this.jSlider_Transparency.setValue(0);
                this.jTextField_TranspValue.setText("0");
                this.jCheckBox_NoDataValue.setSelected(false);
                this.stretchedPanel.reset();
                this.intervalPanel.reset();
                this.singleValuesPanel.reset();
                this.finalRasterSymbolizer.setColorMapType("RAMP");
                if (!(lyr instanceof RasterImageLayer)) continue;
                this.restoreToOriginal((RasterImageLayer)lyr);
            }
        }
        catch (Exception ex) {
            Logger.error(ex);
        }
    }

    private void jButton_OKActionPerformed(ActionEvent evt) {
        try {
            this.updateRasterImageLayer();
            this.closeDialog();
        }
        catch (Exception ex) {
            Logger.error(ex);
        }
    }

    private void fixComponents() throws Exception {
        DummyPanel pan;
        this.setTitle("Raster Styles");
        this.jTextField_TranspValue.setInputVerifier(this.verifier);
        this.jTextField_TranspValue.addActionListener(this.verifier);
        this.jTextField_TranspValue.setText(Integer.toString(this.jSlider_Transparency.getValue()));
        Stats stats = this.rasterImageLayer.getMetadata().getStats();
        Range minMaxValues = new Range(stats.getMin(this.band), true, stats.getMax(this.band), true);
        double[] values = Utils.purgeNoData(this.rasterImageLayer.getRasterData(null), this.rasterImageLayer);
        this.stretchedPanel = new StretchedPanel(minMaxValues);
        this.intervalPanel = new IntervalPanel(this, this.rasterImageLayer, minMaxValues);
        this.singleValuesPanel = new SingleValuesPanel(this, Utils.purgeNoData(this.rasterImageLayer.getRasterData(null), this.rasterImageLayer), this.rasterImageLayer);
        if (stats.getMin(this.band) == stats.getMax(this.band)) {
            pan = new DummyPanel(I18N.get("org.openjump.core.rasterimage.styler.ui.RasterStylesDialog.no_stretched_only_one_value", stats.getMax(this.band)));
            this.jTabbedPane_Type.addTab(I18N.get("org.openjump.core.rasterimage.styler.ui.RasterStylesDialog.tabStretched"), pan);
            this.jTabbedPane_Type.addTab(I18N.get("org.openjump.core.rasterimage.styler.ui.RasterStylesDialog.tabIntervals"), this.intervalPanel);
            for (Component c2 : this.intervalPanel.getComponents()) {
                c2.setEnabled(false);
            }
            this.singleValuesPanel = new SingleValuesPanel(this, Utils.purgeNoData(this.rasterImageLayer.getRasterData(null), this.rasterImageLayer), this.rasterImageLayer);
            this.jTabbedPane_Type.addTab(I18N.get("org.openjump.core.rasterimage.styler.ui.RasterStylesDialog.tabSingleValues"), this.singleValuesPanel);
        } else if (values.length > 2048) {
            this.jTabbedPane_Type.addTab(I18N.get("org.openjump.core.rasterimage.styler.ui.RasterStylesDialog.tabStretched"), this.stretchedPanel);
            this.jTabbedPane_Type.addTab(I18N.get("org.openjump.core.rasterimage.styler.ui.RasterStylesDialog.tabIntervals"), this.intervalPanel);
            pan = new DummyPanel(I18N.get("org.openjump.core.rasterimage.styler.ui.RasterStylesDialog.no_single_too_many_values", values.length));
            this.jTabbedPane_Type.addTab(I18N.get("org.openjump.core.rasterimage.styler.ui.RasterStylesDialog.tabSingleValues"), pan);
        } else {
            this.jTabbedPane_Type.addTab(I18N.get("org.openjump.core.rasterimage.styler.ui.RasterStylesDialog.tabStretched"), this.stretchedPanel);
            this.jTabbedPane_Type.addTab(I18N.get("org.openjump.core.rasterimage.styler.ui.RasterStylesDialog.tabIntervals"), this.intervalPanel);
            this.singleValuesPanel = new SingleValuesPanel(this, Utils.purgeNoData(this.rasterImageLayer.getRasterData(null), this.rasterImageLayer), this.rasterImageLayer);
            this.jTabbedPane_Type.addTab(I18N.get("org.openjump.core.rasterimage.styler.ui.RasterStylesDialog.tabSingleValues"), this.singleValuesPanel);
        }
        this.pack();
        if (this.rasterImageLayer.getSymbology() != null) {
            this.finalRasterSymbolizer = this.rasterImageLayer.getSymbology();
            this.updateGUI();
        }
        String bboardKey = GUIUtils.getBBKey(String.valueOf(this.rasterImageLayer.getUUID()));
        this.context.getBlackboard().put(bboardKey, this);
    }

    public void updateRasterImageLayer() throws Exception {
        if (this.jTabbedPane_Type.getSelectedComponent() instanceof StretchedPanel) {
            this.finalRasterSymbolizer = this.stretchedPanel.getRasterStyler();
        } else if (this.jTabbedPane_Type.getSelectedComponent() instanceof IntervalPanel) {
            this.finalRasterSymbolizer = this.intervalPanel.getRasterStyler();
        } else if (this.jTabbedPane_Type.getSelectedComponent() instanceof SingleValuesPanel) {
            this.finalRasterSymbolizer = this.singleValuesPanel.getRasterStyler();
        }
        this.finalRasterSymbolizer.setTransparency(GUIUtils.getAlpha_DecimalRange(Integer.parseInt(this.jTextField_TranspValue.getText())));
        if (this.jCheckBox_NoDataValue.isSelected()) {
            this.finalRasterSymbolizer.addColorMapEntry(this.rasterImageLayer.getNoDataValue(), this.jButton_NoDataValueColor.getBackground());
        } else {
            this.finalRasterSymbolizer.addColorMapEntry(this.rasterImageLayer.getNoDataValue(), null);
        }
        Collection<Layerable> layerables = this.context.getLayerableNamePanel().getSelectedLayerables();
        for (Layerable lyr : layerables) {
            if (!(lyr instanceof RasterImageLayer)) continue;
            this.apply((RasterImageLayer)lyr);
        }
    }

    public void apply(RasterImageLayer rasterImageLayer) throws Exception {
        rasterImageLayer.setSymbology(this.finalRasterSymbolizer);
        this.context.getLayerManager().fireLayerChanged(rasterImageLayer, LayerEventType.APPEARANCE_CHANGED);
    }

    private void restoreToOriginal(RasterImageLayer rasterImageLayer) throws NoninvertibleTransformException {
        rasterImageLayer.setSymbology(null);
    }

    private void saveSld() {
        if (this.finalRasterSymbolizer == null) {
            return;
        }
        JFileChooser chooser = new JFileChooser(PirolPlugInSettings.configDirectory());
        String extension = "sld";
        FileNameExtensionFilter filter = new FileNameExtensionFilter(I18N.get("org.openjump.core.rasterimage.styler.ui.RasterStylesDialog.fileChooser.sld"), extension);
        chooser.setFileFilter(filter);
        int returnVal = chooser.showSaveDialog(this);
        if (returnVal == 0) {
            try {
                File sldFile = chooser.getSelectedFile();
                if (!sldFile.getAbsolutePath().endsWith(extension)) {
                    sldFile = new File(sldFile + "." + extension);
                }
                SLDHandler.write(this.finalRasterSymbolizer, null, sldFile);
            }
            catch (Exception ex) {
                ErrorDialog.show(this, StringUtil.toFriendlyName(ex.getClass().getName()), ex.toString(), StringUtil.stackTrace(ex));
            }
        }
    }

    private void loadSld() {
        JFileChooser chooser = new JFileChooser(PirolPlugInSettings.configDirectory());
        FileNameExtensionFilter filter = new FileNameExtensionFilter(I18N.get("org.openjump.core.rasterimage.styler.ui.RasterStylesDialog.fileChooser.sld"), "sld");
        chooser.setFileFilter(filter);
        chooser.setMultiSelectionEnabled(false);
        int returnVal = chooser.showOpenDialog(this);
        if (returnVal == 0) {
            try {
                File sldFile = chooser.getSelectedFile();
                this.finalRasterSymbolizer = SLDHandler.read(sldFile);
                this.updateGUI();
            }
            catch (Exception ex) {
                ErrorDialog.show(this, StringUtil.toFriendlyName(ex.getClass().getName()), ex.toString(), StringUtil.stackTrace(ex));
            }
        }
    }

    private void closeDialog() {
        GUIUtils.clearRasterStylerFromBlackBoard(this.context);
        this.setVisible(false);
    }

    public double getNoDataValue() {
        return this.rasterImageLayer.getNoDataValue();
    }

    private void updateGUI() throws Exception {
        if (this.finalRasterSymbolizer.getColorMapType().equals("RAMP")) {
            this.stretchedPanel.plugRasterSymbology(this.finalRasterSymbolizer);
            this.jTabbedPane_Type.setSelectedIndex(0);
        } else if (this.finalRasterSymbolizer.getColorMapType().equals("INTERVALS")) {
            this.intervalPanel.plugRasterSymbology(this.finalRasterSymbolizer);
            this.jTabbedPane_Type.setSelectedIndex(1);
        } else if (this.finalRasterSymbolizer.getColorMapType().equals("SINGLE")) {
            this.singleValuesPanel.plugRasterSymbology(this.finalRasterSymbolizer);
            this.jTabbedPane_Type.setSelectedIndex(2);
        }
    }

    public RasterSymbology getFinalRasterSymbolizer() {
        return this.finalRasterSymbolizer;
    }

    private class DummyPanel
    extends JPanel
    implements StylePanel {
        private static final long serialVersionUID = 2217457292163045134L;

        private DummyPanel(String label) {
            super(new GridBagLayout());
            this.add(new JLabel(label));
        }

        @Override
        public String getTitle() {
            return ColorThemingStylePanel.TITLE;
        }

        @Override
        public void updateStyles() {
        }

        @Override
        public String validateInput() {
            return null;
        }
    }

    class MyVerifier
    extends InputVerifier
    implements ActionListener {
        MyVerifier() {
        }

        @Override
        public boolean verify(JComponent input) {
            String value = RasterStylesDialog.this.jTextField_TranspValue.getText();
            String sliderValue = Integer.toString(RasterStylesDialog.this.jSlider_Transparency.getValue());
            if (value == null || value.equals("")) {
                RasterStylesDialog.this.jTextField_TranspValue.setText(sliderValue);
            } else {
                try {
                    int number = Integer.parseInt(value);
                    if (number < 0 || number > 100) {
                        RasterStylesDialog.this.jTextField_TranspValue.setText(sliderValue);
                    } else {
                        RasterStylesDialog.this.jSlider_Transparency.setValue(number);
                    }
                }
                catch (NumberFormatException ex) {
                    RasterStylesDialog.this.jTextField_TranspValue.setText(sliderValue);
                }
            }
            return true;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

