/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.rasterimage.styler.ui;

import com.vividsolutions.jump.util.Range;
import com.vividsolutions.jump.workbench.Logger;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.openjump.core.attributeoperations.Classifier1D;
import org.openjump.core.rasterimage.RasterImageLayer;
import org.openjump.core.rasterimage.RasterSymbology;
import org.openjump.core.rasterimage.styler.ColorMapEntry;
import org.openjump.core.rasterimage.styler.ColorUtils;
import org.openjump.core.rasterimage.styler.I18N;
import org.openjump.core.rasterimage.styler.RasterClassifier1D;
import org.openjump.core.rasterimage.styler.Utils;
import org.openjump.core.rasterimage.styler.ui.ColorsTablePanel;
import org.openjump.core.rasterimage.styler.ui.GUIUtils;
import org.openjump.core.rasterimage.styler.ui.GradientCanvas;
import org.openjump.core.rasterimage.styler.ui.GradientComboBox;

public class IntervalPanel
extends JPanel {
    private JButton jButton_AddRow;
    private JButton jButton_Ramp;
    private JButton jButton_RemoveRow;
    private JButton jButton_Values;
    private JComboBox jComboBox_Method;
    private JLabel jLabel_Classes;
    private JLabel jLabel_Method;
    private JPanel jPanel_Table;
    private JTextField jTextField_Classes;
    private final Component parent;
    private final Map<ClassificationMethod, String> classMethods_m = new EnumMap<ClassificationMethod, String>(ClassificationMethod.class);
    private RasterImageLayer rasterImageLayer = null;
    private ColorsTablePanel colorsTablePanel = null;
    private final Range minMaxValues;
    private GradientComboBox jComboBox_Gradient;
    private boolean firstTimeShown = true;

    public IntervalPanel(Component parent, RasterImageLayer rasterImageLayer, Range minMaxValues) {
        this.initComponents();
        this.parent = parent;
        this.rasterImageLayer = rasterImageLayer;
        this.minMaxValues = minMaxValues;
        this.fixComponents();
    }

    public void reset() {
        try {
            this.jComboBox_Method.setSelectedItem(this.classMethods_m.get((Object)ClassificationMethod.JENKS));
            this.jTextField_Classes.setText("5");
            this.jComboBox_Gradient.setSelectedIndex(0);
            this.rampAll();
        }
        catch (Exception ex) {
            Logger.error(ex);
        }
    }

    private void initComponents() {
        this.jLabel_Method = new JLabel();
        this.jComboBox_Method = new JComboBox();
        this.jButton_Values = new JButton();
        this.jLabel_Classes = new JLabel();
        this.jTextField_Classes = new JTextField();
        this.jPanel_Table = new JPanel();
        this.jButton_AddRow = new JButton();
        this.jButton_RemoveRow = new JButton();
        this.jButton_Ramp = new JButton();
        this.setMinimumSize(new Dimension(365, 160));
        this.setPreferredSize(new Dimension(365, 160));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent evt) {
                IntervalPanel.this.formComponentShown(evt);
            }
        });
        GridBagLayout layout = new GridBagLayout();
        layout.columnWidths = new int[]{0, 5, 0, 5, 0};
        layout.rowHeights = new int[]{0, 5, 0, 5, 0, 5, 0, 5, 0};
        this.setLayout(layout);
        this.jLabel_Method.setText(I18N.get("IntervalPanel.jLabel.method"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.jLabel_Method, gridBagConstraints);
        this.jComboBox_Method.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBox_Method.addActionListener(this::jComboBox_MethodActionPerformed);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 3;
        this.add((Component)this.jComboBox_Method, gridBagConstraints);
        this.jButton_Values.setText(I18N.get("IntervalPanel.jButton.RampAll"));
        this.jButton_Values.addActionListener(this::jButton_ValuesActionPerformed);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        this.add((Component)this.jButton_Values, gridBagConstraints);
        this.jLabel_Classes.setText(I18N.get("IntervalPanel.jLabel.Classes"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.add((Component)this.jLabel_Classes, gridBagConstraints);
        this.jTextField_Classes.setText("5");
        this.jTextField_Classes.setMinimumSize(new Dimension(70, 20));
        this.jTextField_Classes.setPreferredSize(new Dimension(70, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jTextField_Classes, gridBagConstraints);
        this.jPanel_Table.setBorder(BorderFactory.createEtchedBorder());
        this.jPanel_Table.setName("");
        this.jPanel_Table.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 0.5;
        this.add((Component)this.jPanel_Table, gridBagConstraints);
        this.jButton_AddRow.setText(I18N.get("IntervalPanel.jButton.AddRow"));
        this.jButton_AddRow.addActionListener(this::jButton_AddRowActionPerformed);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        this.add((Component)this.jButton_AddRow, gridBagConstraints);
        this.jButton_RemoveRow.setText(I18N.get("IntervalPanel.jButton.RemoveRow"));
        this.jButton_RemoveRow.addActionListener(this::jButton_RemoveRowActionPerformed);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        this.add((Component)this.jButton_RemoveRow, gridBagConstraints);
        this.jButton_Ramp.setText(I18N.get("IntervalPanel.jButton.Ramp"));
        this.jButton_Ramp.addActionListener(this::jButton_RampActionPerformed);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        this.add((Component)this.jButton_Ramp, gridBagConstraints);
    }

    private void jButton_ValuesActionPerformed(ActionEvent evt) {
        try {
            this.rampAll();
        }
        catch (Exception ex) {
            Logger.error(ex);
        }
    }

    private void jButton_AddRowActionPerformed(ActionEvent evt) {
        this.addRow();
    }

    private void jButton_RemoveRowActionPerformed(ActionEvent evt) {
        this.removeRow();
    }

    private void jButton_RampActionPerformed(ActionEvent evt) {
        try {
            this.rampColors();
        }
        catch (Exception ex) {
            Logger.error(ex);
        }
    }

    private void jComboBox_MethodActionPerformed(ActionEvent evt) {
    }

    private void formComponentShown(ComponentEvent evt) {
        if (this.firstTimeShown) {
            this.firstTimeShown = false;
            try {
                this.rampAll();
            }
            catch (Exception ex) {
                Logger.error(ex);
            }
        }
    }

    private void fixComponents() {
        this.classMethods_m.put(ClassificationMethod.EQUAL_RANGE, I18N.get("org.openjump.core.rasterimage.styler.ui.IntervalPanel.classMethods.EqualInterval"));
        this.classMethods_m.put(ClassificationMethod.GIVEN_INTERVAL, I18N.get("org.openjump.core.rasterimage.styler.ui.IntervalPanel.classMethods.GivenInterval"));
        this.classMethods_m.put(ClassificationMethod.JENKS, I18N.get("org.openjump.core.rasterimage.styler.ui.IntervalPanel.classMethods.Jenks"));
        this.classMethods_m.put(ClassificationMethod.MAX_BREAKS, I18N.get("org.openjump.core.rasterimage.styler.ui.IntervalPanel.classMethods.MaxBreaks"));
        this.classMethods_m.put(ClassificationMethod.MEAN_STDEV, I18N.get("org.openjump.core.rasterimage.styler.ui.IntervalPanel.classMethods.MeanStDev"));
        this.classMethods_m.put(ClassificationMethod.QUANTILE, I18N.get("org.openjump.core.rasterimage.styler.ui.IntervalPanel.classMethods.Quantiles"));
        this.jComboBox_Method.removeAllItems();
        this.jComboBox_Method.addItem(this.classMethods_m.get((Object)ClassificationMethod.EQUAL_RANGE));
        this.jComboBox_Method.addItem(this.classMethods_m.get((Object)ClassificationMethod.GIVEN_INTERVAL));
        this.jComboBox_Method.addItem(this.classMethods_m.get((Object)ClassificationMethod.JENKS));
        this.jComboBox_Method.addItem(this.classMethods_m.get((Object)ClassificationMethod.MAX_BREAKS));
        this.jComboBox_Method.addItem(this.classMethods_m.get((Object)ClassificationMethod.MEAN_STDEV));
        this.jComboBox_Method.addItem(this.classMethods_m.get((Object)ClassificationMethod.QUANTILE));
        this.jComboBox_Method.setSelectedItem(this.classMethods_m.get((Object)ClassificationMethod.JENKS));
        this.jComboBox_Method.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClassificationMethod classMethod = (ClassificationMethod)((Object)IntervalPanel.getKeyByValue(IntervalPanel.this.classMethods_m, IntervalPanel.this.jComboBox_Method.getSelectedItem().toString()));
                if (classMethod == ClassificationMethod.GIVEN_INTERVAL) {
                    IntervalPanel.this.jLabel_Classes.setText(I18N.get("org.openjump.core.rasterimage.styler.ui.IntervalPanel.jLabel.classwidth"));
                } else {
                    IntervalPanel.this.jLabel_Classes.setText(I18N.get("org.openjump.core.rasterimage.styler.ui.IntervalPanel.jLabel.Classes"));
                }
            }
        });
        this.jComboBox_Gradient = GUIUtils.createStandardGradientComboBox(200, 18);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jComboBox_Gradient, gridBagConstraints);
        GUIUtils.addGradientComboBoxToList(this.jComboBox_Gradient);
    }

    private void rampAll() throws Exception {
        int classesCount = 5;
        try {
            classesCount = Integer.parseInt(this.jTextField_Classes.getText());
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, I18N.get("org.openjump.core.rasterimage.styler.ui.IntervalPanel.numberOfClassesError"), "Raster Styles", 2);
            return;
        }
        double classWidth = 0.0;
        double[] breaks = null;
        double[] rasterData = Utils.purgeNoData(this.rasterImageLayer.getActualRasterData(), this.rasterImageLayer);
        ClassificationMethod classMethod = IntervalPanel.getKeyByValue(this.classMethods_m, this.jComboBox_Method.getSelectedItem().toString());
        switch (classMethod) {
            case EQUAL_RANGE: {
                breaks = Classifier1D.classifyEqualRange(rasterData, classesCount);
                break;
            }
            case GIVEN_INTERVAL: {
                breaks = RasterClassifier1D.classifyGivenInterval(this.rasterImageLayer, 0, classesCount);
                classWidth = classesCount;
                classesCount = breaks.length;
                break;
            }
            case JENKS: {
                int top = 1000;
                if (rasterData.length > top) {
                    ArrayList<Double> sampled_l = new ArrayList<Double>();
                    sampled_l.add((Double)this.minMaxValues.getMin());
                    sampled_l.add((Double)this.minMaxValues.getMax());
                    for (int v = 0; v < rasterData.length; v += rasterData.length / top) {
                        sampled_l.add(rasterData[v]);
                    }
                    double[] sampledRasterData = new double[sampled_l.size()];
                    for (int v = 0; v < sampled_l.size(); ++v) {
                        sampledRasterData[v] = (Double)sampled_l.get(v);
                    }
                    breaks = Classifier1D.classifyNaturalBreaks(sampledRasterData, classesCount);
                    break;
                }
                breaks = Classifier1D.classifyNaturalBreaks(rasterData, classesCount);
                break;
            }
            case MAX_BREAKS: {
                breaks = Classifier1D.classifyMaxBreaks(rasterData, classesCount);
                break;
            }
            case MEAN_STDEV: {
                breaks = Classifier1D.classifyMeanStandardDeviation(rasterData, classesCount);
                break;
            }
            case QUANTILE: {
                breaks = Classifier1D.classifyEqualNumber(rasterData, classesCount);
            }
        }
        if (breaks == null) {
            throw new Exception(I18N.get("org.openjump.core.rasterimage.styler.ui.IntervalPanel.message.ErrorWhileClassifying"));
        }
        ColorMapEntry[] paletteColorMapEntries = ((GradientCanvas)this.jComboBox_Gradient.getSelectedItem()).getColorMapEntries();
        ColorUtils colorUtils = new ColorUtils();
        ColorMapEntry[] colorMapEntries = new ColorMapEntry[classesCount];
        int colorsCount = paletteColorMapEntries.length;
        double minVal = (Double)this.minMaxValues.getMin();
        if (classMethod == ClassificationMethod.GIVEN_INTERVAL) {
            minVal = Math.floor((Double)this.minMaxValues.getMin() / classWidth) * classWidth;
        }
        colorMapEntries[0] = new ColorMapEntry(minVal, paletteColorMapEntries[0].getColor());
        for (int c = 1; c < classesCount; ++c) {
            double cellRelDistance = (double)c / (double)(classesCount - 1);
            double colorRelDistance = cellRelDistance * (double)(colorsCount - 1);
            Color startColor = paletteColorMapEntries[(int)Math.floor(colorRelDistance)].getColor();
            Color endColor = paletteColorMapEntries[(int)Math.ceil(colorRelDistance)].getColor();
            Color color = colorUtils.interpolateColor(startColor, endColor, cellRelDistance);
            colorMapEntries[c] = new ColorMapEntry(breaks[c - 1], color);
        }
        this.updateTable(colorMapEntries);
    }

    private void addRow() {
        this.colorsTablePanel.addRows();
    }

    private void removeRow() {
        this.colorsTablePanel.removeRow();
    }

    private void rampColors() throws Exception {
        if (this.colorsTablePanel.getSelectedRowsCount() != 2) {
            JOptionPane.showMessageDialog(this, I18N.get("org.openjump.core.rasterimage.styler.ui.IntervalPanel.classMethods.EqualInterval.SelectTowRowsToRamp"), "Raster Styles", 2);
        }
        this.colorsTablePanel.rampColors();
    }

    public static <T, E> T getKeyByValue(Map<T, E> map, E value) {
        for (Map.Entry<T, E> entry : map.entrySet()) {
            if (!value.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    public void plugRasterSymbology(RasterSymbology rasterSymbology) {
        this.updateTable(rasterSymbology.getColorMapEntries());
    }

    private void updateTable(ColorMapEntry[] colorMapEntries) {
        if (this.colorsTablePanel == null) {
            this.colorsTablePanel = new ColorsTablePanel(this.parent, ColorsTablePanel.TableType.INTERVALS, colorMapEntries, this.rasterImageLayer.getNoDataValue(), false);
            GridBagLayout layout = (GridBagLayout)this.getLayout();
            GridBagConstraints gbc = layout.getConstraints(this.jPanel_Table);
            this.remove(this.jPanel_Table);
            this.add(this.colorsTablePanel, gbc, 5);
            this.validate();
        } else {
            this.colorsTablePanel.updateTable(colorMapEntries);
        }
    }

    public RasterSymbology getRasterStyler() throws Exception {
        RasterSymbology rasterSymbolizer = new RasterSymbology("INTERVALS");
        for (ColorMapEntry colorMapEntry : this.colorsTablePanel.getColorMapEntries()) {
            rasterSymbolizer.addColorMapEntry(colorMapEntry.getUpperValue(), colorMapEntry.getColor());
        }
        return rasterSymbolizer;
    }

    public GradientComboBox getjComboBox_Gradient() {
        return this.jComboBox_Gradient;
    }

    public static enum ClassificationMethod {
        UNIQUE_VALUE,
        EQUAL_RANGE,
        GIVEN_INTERVAL,
        QUANTILE,
        MEAN_STDEV,
        MAX_BREAKS,
        JENKS;

    }
}

