/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.rasterimage.styler.ui;

import com.vividsolutions.jump.util.Range;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JPanel;
import org.openjump.core.rasterimage.RasterImageLayer;
import org.openjump.core.rasterimage.styler.ColorMapEntry;
import org.openjump.core.rasterimage.styler.ui.GradientCanvas;
import org.openjump.core.rasterimage.styler.ui.GradientComboBox;
import org.openjump.core.rasterimage.styler.ui.GradientComboRenderer;
import org.openjump.core.rasterimage.styler.ui.StandardGradientColors;

public class GUIUtils {
    private static List gradientComboBoxes = null;

    public static Range getMinMaxRasterValue(double[] rasterData, RasterImageLayer rasterImageLayer) {
        double minValue = Double.MAX_VALUE;
        double maxValue = -minValue;
        for (int v = 0; v < rasterData.length; ++v) {
            if (rasterData[v] < minValue && !rasterImageLayer.isNoData(rasterData[v])) {
                minValue = rasterData[v];
            }
            if (!(rasterData[v] > maxValue) || rasterImageLayer.isNoData(rasterData[v])) continue;
            maxValue = rasterData[v];
        }
        return new Range(minValue, true, maxValue, true);
    }

    public static int getAlpha_0_255Range(int range_0_100_Value) {
        int traspValue_100 = 100 - range_0_100_Value;
        int alphaValue = 255 * traspValue_100 / 100;
        return alphaValue;
    }

    public static float getAlpha_DecimalRange(int range_0_100_Value) {
        float alphaValue = (float)range_0_100_Value / 100.0f;
        return alphaValue;
    }

    public void setGradientPanel(JPanel panel, ColorMapEntry[] colorMapEntries) {
        panel.removeAll();
        int width = panel.getPreferredSize().width;
        int height = panel.getPreferredSize().height;
        GradientCanvas gc = new GradientCanvas(colorMapEntries, width, height, GradientCanvas.GradientType.VERTICAL);
        gc.setPreferredSize(new Dimension(width, height));
        panel.setLayout(new BorderLayout());
        panel.add((Component)gc, "Center");
    }

    public static double round(double value, int decimalPlace) {
        double factor = Math.pow(10.0, decimalPlace);
        double roundValue = (double)Math.round(value * factor) / factor;
        return roundValue;
    }

    public static GradientComboBox createStandardGradientComboBox(int width, int height) {
        GradientComboBox jComboBox_Gradient = new GradientComboBox();
        jComboBox_Gradient.setRenderer(new GradientComboRenderer(width, height));
        List<ColorMapEntry[]> colorMaps_l = StandardGradientColors.getStandardGradientColors();
        for (ColorMapEntry[] colorMap : colorMaps_l) {
            GradientCanvas gradientCanvas = new GradientCanvas(colorMap, 200, 18, GradientCanvas.GradientType.HORIZONTAL);
            jComboBox_Gradient.addItem(gradientCanvas);
        }
        return jComboBox_Gradient;
    }

    public static void clearRasterStylerFromBlackBoard(WorkbenchContext context) {
        HashMap<String, Object> start_hm = context.getBlackboard().getProperties();
        String[] start_keys = start_hm.keySet().toArray(new String[start_hm.size()]);
        HashMap<String, Object> end_hm = new HashMap<String, Object>();
        ArrayList<String> rasterStylerKeys = new ArrayList<String>();
        for (String start_key : start_keys) {
            if (start_key.endsWith("_Styles")) {
                rasterStylerKeys.add(start_key);
                continue;
            }
            end_hm.put(start_key, start_hm.get(start_key));
        }
        List<RasterImageLayer> layers = context.getLayerManager().getLayerables(RasterImageLayer.class);
        block1: for (String rasterStylerKey : rasterStylerKeys) {
            for (RasterImageLayer ril : layers) {
                if (!rasterStylerKey.equals(ril.getUUID() + "_Styles")) continue;
                end_hm.put(rasterStylerKey, start_hm.get(rasterStylerKey));
                continue block1;
            }
        }
        context.getBlackboard().setProperties(end_hm);
    }

    public static void updateGradientComboBoxes(ColorMapEntry[] colorMapEntries, int width, int height) {
        GradientCanvas gc = new GradientCanvas(colorMapEntries, width, height, GradientCanvas.GradientType.HORIZONTAL);
        for (Object gradientComboBoxe : gradientComboBoxes) {
            GradientComboBox gcb = (GradientComboBox)gradientComboBoxe;
            gcb.addItem(gc);
        }
    }

    public static void addGradientComboBoxToList(GradientComboBox gradientCB) {
        if (gradientComboBoxes == null) {
            gradientComboBoxes = new ArrayList();
        }
        gradientComboBoxes.add(gradientCB);
    }

    public static String getBBKey(String rasterPath) {
        String key = rasterPath.concat("_Styles");
        return key;
    }
}

