/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.rasterimage.styler.ui;

import com.vividsolutions.jump.I18N;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JComponent;

public class ColorsLabelLegendComponent
extends JComponent {
    private final TreeMap<Double, Color> colorMapEntries_tm;
    private final double noDataValue;
    private Dimension dimension;
    private final String rasterName;

    public ColorsLabelLegendComponent(TreeMap<Double, Color> colorMapEntries, double noDataValue, String rasterName) throws Exception {
        this.colorMapEntries_tm = colorMapEntries;
        this.noDataValue = noDataValue;
        this.rasterName = rasterName;
    }

    @Override
    public void paintComponent(Graphics g) {
        int y;
        super.paintComponent(g);
        int x = 20;
        int startY = 45;
        int step = 30;
        int maxWidth = 100;
        FontMetrics m = g.getFontMetrics();
        int i = 0;
        Color noDataColor = null;
        g.setColor(Color.white);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(Color.black);
        g.setFont(new Font("Tahoma", 1, 14));
        g.drawString(this.rasterName, 20, 20);
        g.setFont(new Font("Tahoma", 0, 12));
        for (Map.Entry<Double, Color> colorMapEntry : this.colorMapEntries_tm.entrySet()) {
            if (colorMapEntry.getKey() == this.noDataValue) {
                noDataColor = colorMapEntry.getValue();
                continue;
            }
            y = 45 + 30 * i++;
            Color color = colorMapEntry.getValue();
            g.setColor(color);
            g.fillRect(20, y, 40, 25);
            g.setColor(Color.black);
            g.drawRect(20, y, 40, 25);
            String value = Double.toString(colorMapEntry.getKey());
            g.drawString(value, 80, y + 18);
            int w = m.stringWidth(value);
            if (w <= maxWidth) continue;
            maxWidth = w;
        }
        y = 45 + 30 * i++;
        g.setFont(new Font("Tahoma", 0, 12));
        String jLabel_NoDataTitle = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.nodata.nodata");
        g.drawString(jLabel_NoDataTitle, 20, y + 20);
        g.setFont(new Font("Tahoma", 0, 11));
        y = 45 + 30 * i++;
        g.setColor(Color.BLACK);
        g.drawRect(20, y, 40, 25);
        if (noDataColor != null) {
            g.setColor(noDataColor);
            g.fillRect(20, y, 40, 25);
            g.setColor(Color.BLACK);
        }
        g.drawString(Double.toString(this.noDataValue), 80, y + 18);
        this.dimension = new Dimension(maxWidth, 45 + 30 * i++);
        this.setPreferredSize(this.dimension);
    }
}

