/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.rasterimage.algorithms;

import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.Logger;
import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.ui.Viewport;
import com.vividsolutions.jump.workbench.ui.WorkbenchFrame;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Objects;
import javax.media.jai.PlanarImage;
import org.locationtech.jts.geom.Envelope;
import org.openjump.core.rasterimage.ImageAndMetadata;
import org.openjump.core.rasterimage.RasterImageIO;
import org.openjump.core.rasterimage.RasterImageLayer;
import org.openjump.core.rasterimage.Resolution;
import org.openjump.core.ui.util.LayerableUtil;

public class KernelAlgorithm {
    public static WorkbenchFrame frame = JUMPWorkbench.getInstance().getFrame();
    public String Description01_Gradient = "Gradient filters can be used for edge detection in 45-degree increments";
    public String Description02_Laplace = "Laplacian filters are often used for edge detection. They are often applied to an image that has first been smoothed to reduce its sensitivity to noise.";
    public String Description03_LineDetection = "Line detection filters, like the gradient filters, can be used to perform edge detection. You may get better results if you apply a smoothing algorithm before an edge detection algorithm.";
    public String Description04_Roberts = "Roberts filters uses two 2 by 2 kernels to measure gradients in opposing diagonal directions";
    public String Description05_Prewit = "Mathematically, the operator uses two 3\ufffd3 kernels which are convolved with the original image to calculate approximations of the derivatives - one for horizontal changes, and one for vertical";
    public String Description06_Sharpening = "The Sharpening (high-pass) filter accentuates the comparative difference in the values with its neighbors.";
    public String Description07_Smoothing = "Smoothing (low-pass) filters smooth the data by reducing local variation and removing noise.The low-pass filter calculates the average (mean) value for each neighborhood. ";
    public String Description08_Point = "The point spread function portrays the distribution of light from a point source through a lense. This will introduce a slight blurring effect.";
    public String Description08_Others = "Blur and Emboss filters";
    public String Description10_Sobel = "Sobel filters are used to edge detection. The operator uses two 3\ufffd3 kernels which are convolved with the original image to calculate approximations of the derivatives \ufffd one for horizontal changes, and one for vertical.";
    public String S_gradientEast = "Gradient East";
    public String S_gradientNord = "Gradient North";
    public String S_gradientNorthEast = "Gradient North-East";
    public String S_gradientNorthWest = "Gradient North-West";
    public String S_gradientSouth = "Gradient South";
    public String S_gradientWest = "Gradient West";
    public String S_laplace3x3 = "Laplace 3x3";
    public String S_laplace5x5 = "Laplace 5x5";
    public String S_linedet_horizontal = "Line detection horizontal";
    public String S_linedet_leftdiagonal = "Line detection left diagonal";
    public String S_linedet_rightdiagonal = "Line detection right diagonal";
    public String S_linedet_vertical = "Line detection vertical";
    public String S_sobel_horizontal = "Sobel horizontal";
    public String S_sobel_vertical = "Soblel vertical";
    public String S_roberts_horizontal = "Roberts horizontal";
    public String S_roberts_vertical = "Roberts vertical";
    public String S_prewitt_vertical = "Prewit vertical";
    public String S_prewitt_horizontal = "Prewit horizontal";
    public String S_sharpening3x3 = "Sharpening 3x3";
    public String S_sharpening5x5 = "Sharpening 5x5";
    public String S_sharpeningI = "Sharpening I";
    public String S_sharpeningII = "Sharpening II";
    public String S_smoothing3x3 = "Smoothing 3x3";
    public String S_smoothing5x5 = "Smoothing 5x5";
    public String S_unsharpMasking = "Unsharp masking";
    public String S_pointspread = "Point spread";
    public String S_averageblur = "Avarage blur";
    public String S_smoothaverageblur = "Smooth avarage blur";
    public String S_gaussianblur = "Gaussian blur";
    public String S_emboss = "Emboss";
    public float[] gradientEast = new float[]{1.0f, 0.0f, -1.0f, 2.0f, 0.0f, -2.0f, 1.0f, 0.0f, -1.0f};
    public float[] gradientNord = new float[]{-1.0f, -2.0f, -1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 2.0f, 1.0f};
    public float[] gradientNorthEast = new float[]{0.0f, -1.0f, -2.0f, 1.0f, 0.0f, -1.0f, 2.0f, 1.0f, 0.0f};
    public float[] gradientNorthWest = new float[]{-2.0f, -1.0f, 0.0f, -1.0f, 0.0f, 1.0f, 0.0f, 1.0f, 2.0f};
    public float[] gradientSouth = new float[]{1.0f, 2.0f, 1.0f, 0.0f, 0.0f, 0.0f, -1.0f, -2.0f, -1.0f};
    public float[] gradientWest = new float[]{-1.0f, 0.0f, 1.0f, -2.0f, 0.0f, 2.0f, -1.0f, 0.0f, 1.0f};
    public float[] laplace3x3 = new float[]{0.0f, -1.0f, 0.0f, -1.0f, 4.0f, -1.0f, 0.0f, -1.0f, 0.0f};
    public float[] laplace5x5 = new float[]{0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 0.0f, -1.0f, -2.0f, -1.0f, 0.0f, -1.0f, -2.0f, 17.0f, -2.0f, -1.0f, 0.0f, -1.0f, -2.0f, -1.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f};
    public float[] linedet_horizontal = new float[]{-1.0f, -1.0f, -1.0f, -2.0f, -2.0f, -2.0f, -1.0f, -1.0f, -1.0f};
    public float[] linedet_leftdiagonal = new float[]{2.0f, -1.0f, -1.0f, -1.0f, 2.0f, -1.0f, -1.0f, -1.0f, 2.0f};
    public float[] linedet_rightdiagonal = new float[]{-1.0f, -1.0f, 2.0f, -1.0f, 2.0f, -1.0f, 2.0f, -1.0f, -1.0f};
    public float[] linedet_vertical = new float[]{-1.0f, 0.0f, -1.0f, -1.0f, 2.0f, -1.0f, -1.0f, 0.0f, -1.0f};
    public float[] sobel_horizontal = new float[]{-1.0f, -2.0f, -1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 2.0f, 1.0f};
    public float[] sobel_vertical = new float[]{-1.0f, 0.0f, 1.0f, -2.0f, 0.0f, 2.0f, -1.0f, 0.0f, -1.0f};
    public float[] roberts_horizontal = new float[]{0.0f, -1.0f, 1.0f, 0.0f};
    public float[] roberts_vertical = new float[]{-1.0f, 0.0f, 0.0f, 1.0f};
    public float[] prewitt_vertical = new float[]{-1.0f, 0.0f, 1.0f, -1.0f, 0.0f, 1.0f, -1.0f, 0.0f, 1.0f};
    public float[] prewitt_horizontal = new float[]{-1.0f, -1.0f, -1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
    public float[] sharpening3x3 = new float[]{-1.0f, -1.0f, -1.0f, -1.0f, 9.0f, -1.0f, -1.0f, -1.0f, -1.0f};
    public float[] sharpening5x5 = new float[]{-1.0f, -3.0f, -4.0f, -3.0f, -1.0f, -3.0f, 0.0f, 6.0f, 0.0f, -3.0f, -4.0f, 6.0f, 21.0f, 6.0f, -4.0f, -3.0f, 0.0f, 6.0f, 0.0f, -3.0f, -1.0f, -3.0f, -4.0f, -3.0f, -1.0f};
    public float[] sharpeningI = new float[]{0.0f, -0.25f, 0.0f, -0.25f, 2.0f, -0.25f, 0.0f, -0.25f, 0.0f};
    public float[] sharpeningII = new float[]{-0.25f, -0.25f, -0.25f, -0.25f, 3.0f, -0.25f, -0.25f, -0.25f, -0.25f};
    public float[] smoothing_arithmatic_mean = new float[]{0.111f, 0.111f, 0.111f, 0.111f, 0.111f, 0.111f, 0.111f, 0.111f, 0.111f};
    public float[] smoothing3x3 = new float[]{1.0f, 2.0f, 1.0f, 2.0f, 4.0f, 2.0f, 1.0f, 2.0f, 1.0f};
    public float[] smoothing5x5 = new float[]{1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 4.0f, 4.0f, 4.0f, 1.0f, 1.0f, 4.0f, 12.0f, 4.0f, 1.0f, 1.0f, 4.0f, 4.0f, 4.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f};
    public float[] pointspread = new float[]{-0.627f, 0.352f, -0.627f, -0.352f, 2.923f, -0.352f, -0.627f, 0.352f, -0.627f};
    public float[] averageblur = new float[]{0.11111111f, 0.11111111f, 0.11111111f, 0.11111111f, 0.11111111f, 0.11111111f, 0.11111111f, 0.11111111f, 0.11111111f};
    public float[] smoothaverageblur = new float[]{0.0f, 0.125f, Float.POSITIVE_INFINITY, 0.125f, 0.5f, 0.125f, 0.0f, 0.125f, 0.0f};
    public float[] gaussianblur = new float[]{0.00390625f, 0.015625f, 0.0234375f, 0.015625f, 0.00390625f, 0.015625f, 0.0625f, 0.09375f, 0.0625f, 0.015625f, 0.0234375f, 0.09375f, 0.140625f, 0.09375f, 0.0234375f, 0.015625f, 0.0625f, 0.09375f, 0.0625f, 0.015625f, 0.00390625f, 0.015625f, 0.0234375f, 0.015625f, 0.00390625f};
    public float[] unsharp_masking = new float[]{-0.00390625f, -0.015625f, -0.0234375f, -0.015625f, -0.00390625f, -0.015625f, -0.0625f, -0.09375f, -0.0625f, -0.015625f, -0.0234375f, -0.09375f, 1.078125f, -0.09375f, -0.0234375f, -0.015625f, -0.0625f, -0.09375f, -0.0625f, -0.015625f, -0.00390625f, -0.015625f, -0.0234375f, -0.015625f, -0.00390625f};
    public float[] emboss = new float[]{2.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 0.0f, -1.0f};

    public LinkedHashMap<String, float[]> createDataMap() {
        LinkedHashMap<String, float[]> map = new LinkedHashMap<String, float[]>();
        map.put(this.S_gradientEast, this.gradientEast);
        map.put(this.S_gradientNord, this.gradientNord);
        map.put(this.S_gradientNorthEast, this.gradientNorthEast);
        map.put(this.S_gradientNorthWest, this.gradientNorthWest);
        map.put(this.S_gradientSouth, this.gradientSouth);
        map.put(this.S_gradientWest, this.gradientWest);
        map.put(this.S_laplace3x3, this.laplace3x3);
        map.put(this.S_laplace5x5, this.laplace5x5);
        map.put(this.S_linedet_horizontal, this.linedet_horizontal);
        map.put(this.S_linedet_leftdiagonal, this.linedet_leftdiagonal);
        map.put(this.S_linedet_rightdiagonal, this.linedet_rightdiagonal);
        map.put(this.S_linedet_vertical, this.linedet_vertical);
        map.put(this.S_sobel_horizontal, this.sobel_horizontal);
        map.put(this.S_sobel_vertical, this.sobel_vertical);
        map.put(this.S_roberts_horizontal, this.roberts_horizontal);
        map.put(this.S_roberts_vertical, this.roberts_vertical);
        map.put(this.S_prewitt_vertical, this.prewitt_vertical);
        map.put(this.S_prewitt_horizontal, this.prewitt_horizontal);
        map.put(this.S_sharpening3x3, this.sharpening3x3);
        map.put(this.S_sharpening5x5, this.sharpening5x5);
        map.put(this.S_sharpeningI, this.sharpeningI);
        map.put(this.S_sharpeningII, this.sharpeningII);
        map.put(this.S_smoothing3x3, this.smoothing3x3);
        map.put(this.S_smoothing5x5, this.smoothing5x5);
        map.put(this.S_pointspread, this.pointspread);
        map.put(this.S_averageblur, this.averageblur);
        map.put(this.S_smoothaverageblur, this.smoothaverageblur);
        map.put(this.S_gaussianblur, this.gaussianblur);
        map.put(this.S_emboss, this.emboss);
        map.put(this.S_unsharpMasking, this.unsharp_masking);
        return map;
    }

    public LinkedHashMap<String, String> createTextMap() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put(this.S_gradientEast, this.Description01_Gradient);
        map.put(this.S_gradientNord, this.Description01_Gradient);
        map.put(this.S_gradientNorthEast, this.Description01_Gradient);
        map.put(this.S_gradientNorthWest, this.Description01_Gradient);
        map.put(this.S_gradientSouth, this.Description01_Gradient);
        map.put(this.S_gradientWest, this.Description01_Gradient);
        map.put(this.S_laplace3x3, this.Description02_Laplace);
        map.put(this.S_laplace5x5, this.Description02_Laplace);
        map.put(this.S_linedet_horizontal, this.Description03_LineDetection);
        map.put(this.S_linedet_leftdiagonal, this.Description03_LineDetection);
        map.put(this.S_linedet_rightdiagonal, this.Description03_LineDetection);
        map.put(this.S_linedet_vertical, this.Description03_LineDetection);
        map.put(this.S_sobel_horizontal, this.Description10_Sobel);
        map.put(this.S_sobel_vertical, this.Description10_Sobel);
        map.put(this.S_roberts_horizontal, this.Description04_Roberts);
        map.put(this.S_roberts_vertical, this.Description04_Roberts);
        map.put(this.S_prewitt_vertical, this.Description05_Prewit);
        map.put(this.S_prewitt_horizontal, this.Description05_Prewit);
        map.put(this.S_sharpening3x3, this.Description06_Sharpening);
        map.put(this.S_sharpening5x5, this.Description06_Sharpening);
        map.put(this.S_sharpeningI, this.Description06_Sharpening);
        map.put(this.S_sharpeningII, this.Description06_Sharpening);
        map.put(this.S_smoothing3x3, this.Description07_Smoothing);
        map.put(this.S_smoothing5x5, this.Description07_Smoothing);
        map.put(this.S_pointspread, this.Description08_Point);
        map.put(this.S_averageblur, this.Description08_Point);
        map.put(this.S_smoothaverageblur, this.Description08_Others);
        map.put(this.S_gaussianblur, this.Description08_Others);
        map.put(this.S_emboss, this.Description08_Others);
        map.put(this.S_unsharpMasking, this.Description08_Others);
        return map;
    }

    public void filterRaster(File file, RasterImageLayer rLayer, float[] kernel) throws Exception {
        double dim = Math.sqrt(kernel.length);
        int val = (int)dim;
        ConvolveOp blur = new ConvolveOp(new Kernel(val, val, kernel));
        BufferedImage src = rLayer.getImage();
        int type = LayerableUtil.isMonoband(rLayer) ? 11 : 4;
        BufferedImage result = blur.filter(src, new BufferedImage(src.getWidth(), src.getHeight(), type));
        RasterImageIO rasterImageIO = new RasterImageIO();
        Raster raster = result.getData();
        Envelope envelope = rLayer.getWholeImageEnvelope();
        RasterImageIO rasterImageIO2 = rasterImageIO;
        Objects.requireNonNull(rasterImageIO2);
        rasterImageIO.writeImage(file, raster, envelope, new RasterImageIO.CellSizeXY(rasterImageIO2, rLayer.getMetadata().getOriginalCellSize(), rLayer.getMetadata().getOriginalCellSize()), rLayer.getMetadata().getNoDataValue());
    }

    public void filterRaster2(File file, RasterImageLayer rLayer, float[] kernel) throws Exception {
        int type;
        BufferedImage src;
        double dim = Math.sqrt(kernel.length);
        int val = (int)dim;
        ConvolveOp blur = new ConvolveOp(new Kernel(val, val, kernel));
        if (LayerableUtil.isMonoband(rLayer)) {
            src = rLayer.getImage();
            type = 11;
        } else {
            Raster r = rLayer.getRasterData(rLayer.getRectangleFromEnvelope(rLayer.getWholeImageEnvelope()));
            SampleModel sm = r.getSampleModel();
            ColorModel colorModel = PlanarImage.createColorModel((SampleModel)sm);
            src = new BufferedImage(colorModel, (WritableRaster)r, false, null);
            type = 13;
        }
        BufferedImage result = blur.filter(src, new BufferedImage(src.getWidth(), src.getHeight(), type));
        RasterImageIO rasterImageIO = new RasterImageIO();
        Raster raster = result.getData();
        Envelope envelope = rLayer.getWholeImageEnvelope();
        RasterImageIO rasterImageIO2 = rasterImageIO;
        Objects.requireNonNull(rasterImageIO2);
        rasterImageIO.writeImage(file, raster, envelope, new RasterImageIO.CellSizeXY(rasterImageIO2, rLayer.getMetadata().getOriginalCellSize(), rLayer.getMetadata().getOriginalCellSize()), rLayer.getMetadata().getNoDataValue());
    }

    public void load(File outFile, String name, String category) throws Exception {
        RasterImageIO rasterImageIO = new RasterImageIO();
        Point point = RasterImageIO.getImageDimensions(outFile.getAbsolutePath());
        Envelope env = RasterImageIO.getGeoReferencing(outFile.getAbsolutePath(), true, point);
        Viewport viewport = frame.getContext().getLayerViewPanel().getViewport();
        Resolution requestedRes = RasterImageIO.calcRequestedResolution(viewport);
        ImageAndMetadata imageAndMetadata = rasterImageIO.loadImage(outFile.getAbsolutePath(), null, viewport.getEnvelopeInModelCoordinates(), requestedRes);
        RasterImageLayer ril = new RasterImageLayer(name, frame.getContext().getLayerManager(), outFile.getAbsolutePath(), imageAndMetadata.getImage(), env);
        try {
            category = ((Category)frame.getContext().getLayerableNamePanel().getSelectedCategories().toArray()[0]).getName();
        }
        catch (RuntimeException e) {
            Logger.warn("KernelAlgorithm.load(\"" + outFile + "\",\"" + name + "\",\"" + category + "\") : error trying to get the name of the currently selected category", e);
        }
        frame.getContext().getLayerManager().addLayerable(category, ril);
    }
}

