/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.rasterimage;

import java.util.ArrayList;
import java.util.List;
import org.openjump.core.rasterimage.Overview;
import org.openjump.core.rasterimage.Resolution;

public class Overviews {
    private int overviewsCount = 0;
    private int internalOverviewsCount = 0;
    private int externalOverviewsCount = 0;
    private final List<Overview> overviews_l = new ArrayList<Overview>();

    public void addOverview(Overview overview) {
        this.overviews_l.add(overview);
        ++this.overviewsCount;
        if (overview.getOverviewLocation() == OverviewLocation.INTERNAL) {
            ++this.internalOverviewsCount;
        }
        if (overview.getOverviewLocation() == OverviewLocation.EXTERNAL) {
            ++this.externalOverviewsCount;
        }
    }

    public int getOverviewsCount() {
        return this.overviewsCount;
    }

    public int getInternalOverviewsCount() {
        return this.internalOverviewsCount;
    }

    public int getExternalOverviewsCount() {
        return this.externalOverviewsCount;
    }

    public int pickOverviewLevel(Resolution requestedRes) {
        double reqx = requestedRes.getX();
        double reqy = requestedRes.getY();
        double doubleDistance = Double.MAX_VALUE;
        int overviewIndex = 0;
        for (int o = 0; o < this.overviews_l.size(); ++o) {
            double tempDoubleDistance;
            if (!(this.overviews_l.get(o).getMinResolution() < reqx) || !(this.overviews_l.get(o).getMinResolution() < reqy) || !((tempDoubleDistance = reqx - this.overviews_l.get(o).getMinResolution() + (reqy - this.overviews_l.get(o).getMinResolution())) < doubleDistance)) continue;
            doubleDistance = tempDoubleDistance;
            overviewIndex = o;
        }
        return overviewIndex;
    }

    public static enum OverviewLocation {
        INTERNAL,
        EXTERNAL;

    }
}

