/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.graph.delauneySimplexInsert;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.operation.polygonize.Polygonizer;
import org.openjump.core.graph.delauneySimplexInsert.DelaunayTriangulation;
import org.openjump.core.graph.delauneySimplexInsert.Pnt;
import org.openjump.core.graph.delauneySimplexInsert.Simplex;

public class DTriangulationForJTS {
    private DelaunayTriangulation dt;
    private Simplex initialTriangle;
    private int initialSize = 10000;
    private boolean isVoronoi;
    private double dx = 0.0;
    private double dy = 0.0;
    private Pnt lowerLeftPnt = null;
    public boolean debug = false;

    public DTriangulationForJTS(ArrayList pointList) {
        double argmaxx = 0.0;
        double argmaxy = 0.0;
        double argminx = 0.0;
        double argminy = 0.0;
        int count = 0;
        for (Point pt : pointList) {
            if (count == 0) {
                argmaxx = pt.getX();
                argminx = pt.getX();
                argmaxy = pt.getY();
                argminy = pt.getY();
            } else {
                if (pt.getX() < argminx) {
                    argminx = pt.getX();
                }
                if (pt.getX() > argmaxx) {
                    argmaxx = pt.getX();
                }
                if (pt.getY() < argminy) {
                    argminy = pt.getY();
                }
                if (pt.getY() > argmaxy) {
                    argmaxy = pt.getY();
                }
            }
            ++count;
        }
        this.dx = argmaxx - argminx;
        this.dy = argmaxy - argminy;
        this.initialTriangle = new Simplex(new Pnt[]{new Pnt(argminx - 1.5 * this.dx, argminy - this.dy), new Pnt(argmaxx + 1.5 * this.dx, argminy - this.dy), new Pnt(argminx + this.dx / 2.0, argmaxy + 1.5 * this.dy)});
        this.lowerLeftPnt = new Pnt(argminx - 1.5 * this.dx, argminy - this.dy);
        this.dt = new DelaunayTriangulation(this.initialTriangle);
        this.addPoints(pointList);
    }

    public DTriangulationForJTS(ArrayList pointList, Envelope envelope) {
        double argmaxx = 0.0;
        double argmaxy = 0.0;
        double argminx = 0.0;
        double argminy = 0.0;
        int count = 0;
        for (Point pt : pointList) {
            if (count == 0) {
                argmaxx = pt.getX();
                argminx = pt.getX();
                argmaxy = pt.getY();
                argminy = pt.getY();
            } else {
                if (pt.getX() < argminx) {
                    argminx = pt.getX();
                }
                if (pt.getX() > argmaxx) {
                    argmaxx = pt.getX();
                }
                if (pt.getY() < argminy) {
                    argminy = pt.getY();
                }
                if (pt.getY() > argmaxy) {
                    argmaxy = pt.getY();
                }
            }
            ++count;
        }
        if (envelope.getMinX() < argminx) {
            argminx = envelope.getMinX();
        }
        if (envelope.getMaxX() > argmaxx) {
            argmaxx = envelope.getMaxX();
        }
        if (envelope.getMinY() < argminy) {
            argminy = envelope.getMinY();
        }
        if (envelope.getMaxY() > argmaxy) {
            argmaxy = envelope.getMaxY();
        }
        this.dx = argmaxx - argminx;
        this.dy = argmaxy - argminy;
        this.initialTriangle = new Simplex(new Pnt[]{new Pnt(argminx - 1.5 * this.dx, argminy - this.dy), new Pnt(argmaxx + 1.5 * this.dx, argminy - this.dy), new Pnt(argminx + this.dx / 2.0, argmaxy + 1.5 * this.dy)});
        this.lowerLeftPnt = new Pnt(argminx - 1.5 * this.dx, argminy - this.dy);
        this.dt = new DelaunayTriangulation(this.initialTriangle);
        this.addPoints(pointList);
    }

    public void addPoints(ArrayList pointList) {
        Iterator iter = pointList.iterator();
        while (iter.hasNext()) {
            try {
                Geometry element = (Geometry)iter.next();
                if (element instanceof Point) {
                    Point jtsPt = (Point)element;
                    Pnt point = new Pnt(jtsPt.getX(), jtsPt.getY());
                    this.dt.delaunayPlace(point);
                    continue;
                }
                if (!this.debug) continue;
                System.out.println("no point geometry");
            }
            catch (Exception e) {
                if (!this.debug) continue;
                System.out.println("no geometry");
            }
        }
    }

    public void addPoint(double x, double y) {
        Pnt point = new Pnt(x, y);
        if (this.debug) {
            System.out.println("Click " + point);
        }
        this.dt.delaunayPlace(point);
    }

    public ArrayList drawAllDelaunay() {
        GeometryFactory gf = new GeometryFactory();
        ArrayList<LineString> lines = new ArrayList<LineString>();
        Iterator it = this.dt.iterator();
        while (it.hasNext()) {
            Simplex triangle = (Simplex)it.next();
            for (Set facet : triangle.facets()) {
                Pnt[] endpoint = facet.toArray(new Pnt[2]);
                Coordinate[] coords = new Coordinate[]{new Coordinate(endpoint[0].coord(0), endpoint[0].coord(1)), new Coordinate(endpoint[1].coord(0), endpoint[1].coord(1))};
                LineString ls = gf.createLineString(coords);
                lines.add(ls);
            }
        }
        return lines;
    }

    public ArrayList drawAllVoronoi() {
        GeometryFactory gf = new GeometryFactory();
        ArrayList<LineString> lines = new ArrayList<LineString>();
        Iterator it = this.dt.iterator();
        while (it.hasNext()) {
            Simplex triangle = (Simplex)it.next();
            for (Simplex other : this.dt.neighbors(triangle)) {
                Pnt p = Pnt.circumcenter(triangle.toArray(new Pnt[0]));
                Pnt q = Pnt.circumcenter(other.toArray(new Pnt[0]));
                Coordinate[] coords = new Coordinate[]{new Coordinate(p.coord(0), p.coord(1)), new Coordinate(q.coord(0), q.coord(1))};
                LineString ls = gf.createLineString(coords);
                lines.add(ls);
            }
        }
        return lines;
    }

    public ArrayList drawAllSites() {
        GeometryFactory gf = new GeometryFactory();
        ArrayList<Point> points = new ArrayList<Point>();
        Iterator it = this.dt.iterator();
        while (it.hasNext()) {
            for (Pnt pt : (Simplex)it.next()) {
                Coordinate coord = new Coordinate(pt.coord(0), pt.coord(1));
                Point jtsPt = gf.createPoint(coord);
                points.add(jtsPt);
            }
        }
        return points;
    }

    public ArrayList drawAllCircles() {
        GeometryFactory gf = new GeometryFactory();
        ArrayList<Geometry> circles = new ArrayList<Geometry>();
        Iterator it = this.dt.iterator();
        block0: while (it.hasNext()) {
            Simplex triangle = (Simplex)it.next();
            for (Pnt p : this.initialTriangle) {
                if (!triangle.contains(p)) continue;
                continue block0;
            }
            Pnt c = Pnt.circumcenter(triangle.toArray(new Pnt[0]));
            double radius = c.subtract((Pnt)triangle.iterator().next()).magnitude();
            Coordinate coord = new Coordinate(c.coord(0), c.coord(1));
            Point jtsPt = gf.createPoint(coord);
            circles.add(jtsPt.buffer(radius));
        }
        return circles;
    }

    public DelaunayTriangulation getDelaunayTriangulation() {
        return this.dt;
    }

    public ArrayList getInitialSimmplexAsJTSPoints() {
        GeometryFactory gf = new GeometryFactory();
        ArrayList<Point> points = new ArrayList<Point>();
        for (Pnt pt : this.initialTriangle) {
            Coordinate coord = new Coordinate(pt.coord(0), pt.coord(1));
            Point jtsPt = gf.createPoint(coord);
            points.add(jtsPt);
        }
        return points;
    }

    public Geometry getThiessenBoundingBox() {
        GeometryFactory gf = new GeometryFactory();
        Coordinate[] coords = new Coordinate[]{new Coordinate(this.lowerLeftPnt.coord(0) + 1.0 * this.dx, this.lowerLeftPnt.coord(1) + 0.5 * this.dy), new Coordinate(this.lowerLeftPnt.coord(0) + 3.0 * this.dx, this.lowerLeftPnt.coord(1) + 0.5 * this.dy), new Coordinate(this.lowerLeftPnt.coord(0) + 3.0 * this.dx, this.lowerLeftPnt.coord(1) + 2.5 * this.dy), new Coordinate(this.lowerLeftPnt.coord(0) + 1.0 * this.dx, this.lowerLeftPnt.coord(1) + 2.5 * this.dy), new Coordinate(this.lowerLeftPnt.coord(0) + 1.0 * this.dx, this.lowerLeftPnt.coord(1) + 0.5 * this.dy)};
        LinearRing lr = gf.createLinearRing(coords);
        Polygon bbox = gf.createPolygon(lr, null);
        return bbox;
    }

    public ArrayList getThiessenPolys() {
        if (this.debug) {
            System.out.println("get voronoi egdes");
        }
        ArrayList edges = this.drawAllVoronoi();
        if (this.debug) {
            System.out.println("merge voronoi egdes to multiLineString");
        }
        Geometry mls = (Geometry)edges.get(0);
        for (int i = 1; i < edges.size(); ++i) {
            Geometry line = (Geometry)edges.get(i);
            mls = mls.union(line);
        }
        if (this.debug) {
            System.out.println("polygonize");
        }
        Polygonizer poly = new Polygonizer();
        poly.add(mls);
        Collection polys = poly.getPolygons();
        Geometry bbox = this.getThiessenBoundingBox();
        if (this.debug) {
            System.out.println("get intersections and final polys..");
        }
        ArrayList<Geometry> finalPolys = new ArrayList<Geometry>();
        for (Geometry candPoly : polys) {
            Geometry intersection = bbox.intersection(candPoly);
            if (intersection == null || !(intersection.getArea() > 0.0)) continue;
            finalPolys.add(intersection);
        }
        return finalPolys;
    }
}

