/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.attributeoperations;

import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureSchema;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.math.array.DoubleArray;
import org.math.array.StatisticSample;

public class AttributeOp {
    public static final int MAJORITY = 0;
    public static final int MINORITY = 1;
    public static final int MEAN = 2;
    public static final int MEDIAN = 3;
    public static final int MIN = 4;
    public static final int MAX = 5;
    public static final int STD = 6;
    public static final int SUM = 7;
    public static final int COUNT = 8;

    public static String getName(int attributeOP) {
        String retval = "";
        if (attributeOP == 0) {
            retval = "major";
        } else if (attributeOP == 1) {
            retval = "minor";
        } else if (attributeOP == 2) {
            retval = "mean";
        } else if (attributeOP == 3) {
            retval = "median";
        } else if (attributeOP == 4) {
            retval = "min";
        } else if (attributeOP == 5) {
            retval = "max";
        } else if (attributeOP == 6) {
            retval = "std";
        } else if (attributeOP == 7) {
            retval = "sum";
        } else if (attributeOP == 8) {
            retval = "count";
        }
        return retval;
    }

    public static double evaluateAttributes(int attributeOp, Feature[] features, String attributeName) {
        ArrayList<Feature> featureL = new ArrayList<Feature>(Arrays.asList(features));
        return AttributeOp.evaluateAttributes(attributeOp, featureL, attributeName);
    }

    public static double evaluateAttributes(int attributeOp, List<Feature> features, String attributeName) {
        double result = Double.NaN;
        if (features.size() > 0) {
            Feature firstF = features.get(0);
            FeatureSchema fs = firstF.getSchema();
            if (fs.hasAttribute(attributeName)) {
                boolean doEval = true;
                AttributeType at = fs.getAttributeType(attributeName);
                int n = features.size();
                double[] vals = StatisticSample.fill((int)n, (double)0.0);
                int count = 0;
                for (Feature f : features) {
                    Object value = f.getAttribute(attributeName);
                    if (value != null) {
                        Number val;
                        if (at == AttributeType.DOUBLE) {
                            val = (Double)value;
                            vals[count] = (Double)val;
                        } else if (at == AttributeType.INTEGER) {
                            val = (Integer)value;
                            vals[count] = ((Integer)val).doubleValue();
                        } else if (at == AttributeType.GEOMETRY) {
                            vals[count] = 1.0;
                        } else {
                            System.out.println("AttributeOp: attribute type not supported");
                            doEval = false;
                        }
                    }
                    ++count;
                }
                if (doEval) {
                    if (attributeOp == 0) {
                        result = AttributeOp.majorityEval(vals);
                    } else if (attributeOp == 1) {
                        result = AttributeOp.minorityEval(vals);
                    } else if (attributeOp == 5) {
                        result = DoubleArray.max((double[])vals);
                    } else if (attributeOp == 4) {
                        result = DoubleArray.min((double[])vals);
                    } else if (attributeOp == 2) {
                        result = StatisticSample.mean((double[])vals);
                    } else if (attributeOp == 6) {
                        result = StatisticSample.stddeviation((double[])vals);
                    } else if (attributeOp == 3) {
                        double[] sortvals = DoubleArray.sort((double[])vals);
                        int index = (int)Math.ceil((double)vals.length / 2.0);
                        result = sortvals[index - 1];
                    } else if (attributeOp == 7) {
                        result = DoubleArray.sum((double[])vals);
                    } else if (attributeOp == 8) {
                        result = vals.length;
                    } else {
                        System.out.println("AttributeOp: attribute operation not supported");
                    }
                }
            } else {
                System.out.println("AttributeOp: attribute does not exist");
            }
        } else if (attributeOp == 8) {
            result = 0.0;
        }
        return result;
    }

    private static double majorityEval(double[] values) {
        ArrayList<Double> vals = new ArrayList<Double>();
        for (int i = 0; i < values.length; ++i) {
            double val = values[i];
            if (i == 0) {
                vals.add(val);
                continue;
            }
            int stop = 0;
            int count = 0;
            boolean found = false;
            while (stop == 0) {
                Double d = (Double)vals.get(count);
                if (val == d) {
                    stop = 1;
                    found = true;
                }
                if (++count != vals.size()) continue;
                stop = 1;
            }
            if (found) continue;
            vals.add(val);
        }
        int[] countVals = new int[vals.size()];
        for (int i = 0; i < countVals.length; ++i) {
            countVals[i] = 0;
        }
        for (double val : values) {
            boolean stop = false;
            int count = 0;
            while (!stop) {
                Double d = (Double)vals.get(count);
                if (val == d) {
                    int oldVal = countVals[count];
                    countVals[count] = oldVal + 1;
                    stop = true;
                }
                if (++count != countVals.length) continue;
                stop = true;
            }
        }
        int maxcount = 0;
        int pos = 0;
        for (int i = 0; i < countVals.length; ++i) {
            if (countVals[i] <= maxcount) continue;
            maxcount = countVals[i];
            pos = i;
        }
        double result = (Double)vals.get(pos);
        return result;
    }

    private static double minorityEval(double[] values) {
        ArrayList<Double> vals = new ArrayList<Double>();
        for (int i = 0; i < values.length; ++i) {
            double val = values[i];
            if (i == 0) {
                vals.add(val);
                continue;
            }
            int stop = 0;
            int count = 0;
            boolean found = false;
            while (stop == 0) {
                Double d = (Double)vals.get(count);
                if (val == d) {
                    stop = 1;
                    found = true;
                }
                if (++count != vals.size()) continue;
                stop = 1;
            }
            if (found) continue;
            vals.add(val);
        }
        int[] countVals = new int[vals.size()];
        for (int i = 0; i < countVals.length; ++i) {
            countVals[i] = 0;
        }
        for (double val : values) {
            boolean stop = false;
            int count = 0;
            while (!stop) {
                Double d = (Double)vals.get(count);
                if (val == d) {
                    int oldVal = countVals[count];
                    countVals[count] = oldVal + 1;
                    stop = true;
                }
                if (++count != countVals.length) continue;
                stop = true;
            }
        }
        int mincount = countVals[0];
        int pos = 0;
        for (int i = 1; i < countVals.length; ++i) {
            if (countVals[i] >= mincount) continue;
            mincount = countVals[i];
            pos = i;
        }
        double result = (Double)vals.get(pos);
        return result;
    }
}

