/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.dbffile;

import com.vividsolutions.jump.io.EndianDataOutputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Vector;
import org.geotools.dbffile.DbfConsts;
import org.geotools.dbffile.DbfFieldDef;
import org.geotools.dbffile.DbfFileException;
import org.geotools.misc.FormatedString;

public class DbfFileWriter
implements DbfConsts {
    private static final boolean DEBUG = false;
    private static final String DBC = "DbFW>";
    int NoFields = 1;
    int NoRecs = 0;
    int recLength = 0;
    DbfFieldDef[] fields;
    EndianDataOutputStream ls;
    private boolean header = false;
    private Charset charset = Charset.defaultCharset();

    public DbfFileWriter(String file) throws IOException {
        this.ls = new EndianDataOutputStream(new BufferedOutputStream(Files.newOutputStream(Paths.get(file, new String[0]), new OpenOption[0])));
    }

    public void writeHeader(DbfFieldDef[] f, int nrecs) throws IOException {
        int i;
        this.NoFields = f.length;
        this.NoRecs = nrecs;
        this.fields = new DbfFieldDef[this.NoFields];
        System.arraycopy(f, 0, this.fields, 0, this.NoFields);
        this.ls.writeByteLE(3);
        GregorianCalendar calendar = new GregorianCalendar();
        Date trialTime = new Date();
        calendar.setTime(trialTime);
        this.ls.writeByteLE(calendar.get(1) - 1900);
        this.ls.writeByteLE(calendar.get(2) + 1);
        this.ls.writeByteLE(calendar.get(5));
        int dataOffset = 32 * this.NoFields + 32 + 1;
        for (i = 0; i < this.NoFields; ++i) {
            this.recLength += this.fields[i].fieldlen;
        }
        ++this.recLength;
        this.ls.writeIntLE(this.NoRecs);
        this.ls.writeShortLE(dataOffset);
        this.ls.writeShortLE(this.recLength);
        for (i = 0; i < 20; ++i) {
            this.ls.writeByteLE(0);
        }
        for (i = 0; i < this.NoFields; ++i) {
            int j;
            this.ls.write(this.fields[i].fieldname.toString().getBytes(this.charset.name()), 0, 11);
            this.ls.writeByteLE(this.fields[i].fieldtype);
            for (j = 0; j < 4; ++j) {
                this.ls.writeByteLE(0);
            }
            this.ls.writeByteLE(this.fields[i].fieldlen);
            this.ls.writeByteLE(this.fields[i].fieldnumdec);
            for (j = 0; j < 14; ++j) {
                this.ls.writeByteLE(0);
            }
        }
        this.ls.writeByteLE(13);
        this.header = true;
    }

    public void writeRecords(Vector<Object>[] recs) throws DbfFileException, IOException {
        if (!this.header) {
            throw new DbfFileException("Must write header before records");
        }
        int i = 0;
        try {
            for (i = 0; i < recs.length; ++i) {
                if (recs[i].size() != this.NoFields) {
                    throw new DbfFileException("wrong number of records in " + i + "th record " + recs[i].size() + " expected " + this.NoFields);
                }
                this.writeRecord(recs[i]);
            }
        }
        catch (DbfFileException e) {
            throw new DbfFileException("DbFW>at rec " + i + "\n" + e);
        }
    }

    public void writeRecord(Vector<Object> rec) throws DbfFileException, IOException {
        if (!this.header) {
            throw new DbfFileException("DbFW>Must write header before records");
        }
        if (rec.size() != this.NoFields) {
            throw new DbfFileException("DbFW>wrong number of fields " + rec.size() + " expected " + this.NoFields);
        }
        this.ls.writeByteLE(32);
        block6: for (int i = 0; i < this.NoFields; ++i) {
            int len = this.fields[i].fieldlen;
            int numdec = this.fields[i].fieldnumdec;
            Object o = rec.elementAt(i);
            switch (this.fields[i].fieldtype) {
                case 'C': 
                case 'D': 
                case 'G': 
                case 'M': 
                case 'c': {
                    if (o == null) {
                        o = "";
                    }
                    StringBuilder tmps = new StringBuilder((String)o);
                    while (tmps.toString().getBytes(this.charset.name()).length < len) {
                        tmps.append("                ");
                    }
                    tmps.setLength(len);
                    this.ls.write(tmps.toString().getBytes(this.charset.name()), this.fields[i].fieldstart, len);
                    continue block6;
                }
                case 'N': 
                case 'n': {
                    byte[] byteArray;
                    if (o == null) {
                        byte space = 32;
                        byteArray = new byte[len];
                        Arrays.fill(byteArray, space);
                        this.ls.write(byteArray, 0, len);
                        continue block6;
                    }
                    if (numdec == 0) {
                        String fs = "";
                        if (o instanceof Integer) {
                            fs = FormatedString.format((Integer)o, len);
                        } else if (o instanceof Long) {
                            fs = FormatedString.format(((Long)o).toString(), 0, len);
                        } else if (o instanceof BigDecimal) {
                            fs = FormatedString.format(o.toString(), 0, len);
                        }
                        if (fs.length() > this.fields[i].fieldlen) {
                            fs = FormatedString.format(0, len);
                        }
                        this.ls.writeBytesLE(fs);
                        continue block6;
                    }
                    String fs = "";
                    if (o instanceof Double) {
                        fs = FormatedString.format(o.toString(), numdec, len);
                    } else if (o instanceof BigDecimal) {
                        fs = FormatedString.format(o.toString(), numdec, len);
                    }
                    if (fs.length() > this.fields[i].fieldlen) {
                        fs = FormatedString.format("0.0", numdec, len);
                    }
                    this.ls.writeBytesLE(fs);
                    continue block6;
                }
                case 'F': 
                case 'f': {
                    byte[] byteArray;
                    if (o == null) {
                        byte space = 32;
                        byteArray = new byte[len];
                        Arrays.fill(byteArray, space);
                        this.ls.write(byteArray, 0, len);
                        continue block6;
                    }
                    String x = FormatedString.format(o.toString(), numdec, len);
                    this.ls.writeBytesLE(x);
                    continue block6;
                }
                case 'L': {
                    if (o == null || o.equals("") || o.equals(" ") || o.equals("?")) {
                        this.ls.writeBytesLE(" ");
                        continue block6;
                    }
                    boolean b = (Boolean)o;
                    this.ls.writeBytesLE(b ? "T" : "F");
                }
            }
        }
    }

    public void close() throws IOException {
        this.ls.writeByteLE(26);
        this.ls.close();
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }
}

