/*
 * Decompiled with CFR 0.152.
 */
package de.fho.jump.pirol.utilities.plugIns;

import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.ErrorHandler;
import com.vividsolutions.jump.workbench.ui.task.TaskMonitorDialog;
import de.fho.jump.pirol.utilities.debugOutput.PersonalLogger;
import de.fho.jump.pirol.utilities.i18n.PirolPlugInMessages;
import de.fho.jump.pirol.utilities.settings.PirolPlugInSettings;
import java.awt.Frame;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.locationtech.jts.geom.GeometryFactory;
import org.openjump.core.apitools.FeatureCollectionTools;
import org.openjump.core.apitools.LayerTools;
import org.openjump.core.apitools.SelectionTools;

public abstract class StandardPirolPlugIn
extends AbstractPlugIn
implements ErrorHandler {
    protected StringBuffer messages = new StringBuffer();
    protected boolean bringUpMessages = false;
    protected static EnableCheckFactory checkFactory = null;
    protected ImageIcon icon = null;
    protected boolean useToolIconSize = false;
    protected static GeometryFactory geometryFactory = new GeometryFactory();
    protected PersonalLogger logger = null;

    public StandardPirolPlugIn(PersonalLogger logger) {
        this.logger = logger;
    }

    public String getShortClassName() {
        int pointPos = this.getClass().getName().lastIndexOf(".");
        if (pointPos > -1) {
            return this.getClass().getName().substring(this.getClass().getName().lastIndexOf(".") + 1);
        }
        this.logger.printWarning("class name is very short: " + this.getClass().getName());
        return this.getClass().getName();
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext, boolean needFence) {
        if (checkFactory == null) {
            checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        }
        MultiEnableCheck multiEnableCheck = new MultiEnableCheck();
        multiEnableCheck.add(checkFactory.createAtLeastNLayersMustExistCheck(1));
        multiEnableCheck.add(checkFactory.createAtLeastNLayersMustBeSelectedCheck(1));
        if (needFence) {
            multiEnableCheck.add(checkFactory.createFenceMustBeDrawnCheck());
        }
        return multiEnableCheck;
    }

    public abstract String getIconString();

    @Override
    public abstract boolean execute(PlugInContext var1) throws Exception;

    @Override
    public String getName() {
        try {
            return PirolPlugInMessages.getString(this.getShortClassName());
        }
        catch (RuntimeException e) {
            return super.getName();
        }
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
        context.getFeatureInstaller().addMainMenuItem(this, new String[]{PirolPlugInSettings.getName_PirolMenu(), this.getCategoryName()}, this.getName(), false, null, StandardPirolPlugIn.createEnableCheck(context.getWorkbenchContext(), false));
    }

    public String getCategoryName() {
        return PirolPlugInMessages.getString("unsorted");
    }

    public void initialize(PlugInContext context, String subMenuName) throws Exception {
        if (this.logger != null) {
            this.logger.printDebug("subMenuName: " + subMenuName);
        }
        context.getFeatureInstaller().addMainMenuItem(this, new String[]{PirolPlugInSettings.getName_PirolMenu(), subMenuName}, this.getName(), false, null, StandardPirolPlugIn.createEnableCheck(context.getWorkbenchContext(), false));
    }

    public static TaskMonitorDialog getMonitor(PlugInContext context) {
        return new TaskMonitorDialog((Frame)context.getWorkbenchFrame(), context.getWorkbenchFrame());
    }

    protected void println(String function, String msg) {
        if (this.logger != null) {
            this.logger.printDebug(msg);
        } else {
            StandardPirolPlugIn.println(this.getClass(), function, msg);
        }
    }

    public static void println(Class c, String function, String message) {
        System.out.println(c.getName() + "." + function + "(): " + message);
    }

    public static void warnUser(PlugInContext context, String msg) {
        context.getWorkbenchFrame().warnUser(msg);
    }

    public static Layer[] getSelectedLayers(PlugInContext context, int num) {
        return LayerTools.getSelectedLayers(context, num);
    }

    public static Layer getSelectedLayer(PlugInContext context) {
        return LayerTools.getSelectedLayer(context);
    }

    protected boolean finishExecution(PlugInContext context, boolean retVal) {
        this.postMessagesToGui(context);
        return retVal;
    }

    protected void postMessagesToGui(PlugInContext context) {
        if (this.messages.length() != 0 && context != null) {
            context.getOutputFrame().createNewDocument();
            context.getOutputFrame().addText(this.messages.toString());
            if (this.bringUpMessages) {
                context.getOutputFrame().surface();
            }
            this.messages.delete(0, this.messages.length());
        } else if (context == null) {
            this.println("postMessagesToGui(PlugInContext context)", "-> context == null!");
        }
    }

    @Override
    public void handleThrowable(Throwable t) {
        if (t.getMessage() == null || t.getMessage().equals("null")) {
            StackTraceElement[] stre = t.getStackTrace();
            for (int i = 0; i < stre.length; ++i) {
                this.messages.append(stre[i].toString() + "\n");
            }
        } else if (t.getMessage() != null) {
            this.messages.append(t.getMessage() + "\n");
        }
    }

    @Override
    public Icon getIcon() {
        if (this.icon == null && this.getIconString() != null) {
            InputStream in = this.getClass().getResourceAsStream(this.getIconString());
            BufferedImage img = null;
            Image scaledImg = null;
            try {
                img = ImageIO.read(in);
                scaledImg = img.getScaledInstance(this.useToolIconSize ? 24 : 16, this.useToolIconSize ? 24 : 16, img.getType());
            }
            catch (IOException e) {
                e.printStackTrace();
                img = null;
                this.icon = null;
            }
            if (scaledImg != null) {
                this.icon = new ImageIcon(scaledImg);
            }
        }
        return this.icon;
    }

    public static Feature[] getFeaturesInFenceOrInLayer(PlugInContext context, Layer layer) {
        SelectionTools st = new SelectionTools(context);
        Feature[] featureToBeUsed = null;
        featureToBeUsed = st.getFenceGeometry() == null ? FeatureCollectionTools.FeatureCollection2FeatureArray(layer.getFeatureCollectionWrapper().getUltimateWrappee()) : SelectionTools.getFeaturesInFenceInLayer(layer, st.getFenceGeometry());
        return featureToBeUsed;
    }

    public PersonalLogger getLogger() {
        return this.logger;
    }

    public void setLogger(PersonalLogger logger) {
        this.logger = logger;
    }

    public void setUseInToolbox(boolean toolboxUse) {
        this.useToolIconSize = toolboxUse;
    }
}

