/*
 * Decompiled with CFR 0.152.
 */
package de.fho.jump.pirol.ui.panels;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.AttributeType;
import de.fho.jump.pirol.utilities.attributes.AttributeInfo;
import de.fho.jump.pirol.utilities.debugOutput.DebugUserIds;
import de.fho.jump.pirol.utilities.debugOutput.PersonalLogger;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.openjump.core.apitools.FeatureCollectionTools;

public class NewAttributePanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = -2577345752815728142L;
    protected JTextField nameTextField = new JTextField();
    protected JTextField defValueTextField = new JTextField();
    protected JComboBox typeDropDown = new JComboBox();
    protected String drownActionCommand = "selectType";
    protected AttributeType[] onlyTypes = null;
    protected PersonalLogger logger = new PersonalLogger(DebugUserIds.ALL);
    protected String typeLabelText = I18N.getInstance().get("pirol.ui.panels.type-of-new-attribute");
    protected String nameLabelText = I18N.getInstance().get("pirol.ui.panels.name-of-new-attribute");
    protected String defValLabelText = I18N.getInstance().get("pirol.ui.panels.default-value-for-new-attribute");
    protected JLabel nameLabel = new JLabel();
    protected JLabel defValLabel = new JLabel();
    protected JLabel typeLabel = new JLabel();
    protected boolean needDefaultValue = true;

    public NewAttributePanel(boolean arg0, boolean needDefaultValue) {
        super(arg0);
        this.typeDropDown.setActionCommand(this.drownActionCommand);
        this.typeDropDown.addItem(AttributeType.DOUBLE);
        this.typeDropDown.addItem(AttributeType.INTEGER);
        this.typeDropDown.addItem(AttributeType.STRING);
        this.typeDropDown.setSelectedIndex(0);
        this.typeDropDown.addActionListener(this);
        this.needDefaultValue = needDefaultValue;
        this.setupUI();
    }

    public NewAttributePanel(boolean arg0, AttributeType[] onlyTypes, boolean needDefaultValue) {
        super(arg0);
        this.onlyTypes = onlyTypes;
        this.typeDropDown.setActionCommand(this.drownActionCommand);
        for (int i = 0; i < this.onlyTypes.length; ++i) {
            this.typeDropDown.addItem(this.onlyTypes[i]);
        }
        this.typeDropDown.setSelectedIndex(0);
        this.typeDropDown.addActionListener(this);
        this.needDefaultValue = needDefaultValue;
        this.setupUI();
    }

    protected void setupUI() {
        this.setLayout(new GridLayout(this.needDefaultValue ? 3 : 2, 2));
        this.nameLabel = new JLabel(this.nameLabelText);
        this.add(this.nameLabel);
        this.add(this.nameTextField);
        this.typeLabel = new JLabel(this.typeLabelText);
        this.add(this.typeLabel);
        this.add(this.typeDropDown);
        if (this.needDefaultValue) {
            this.defValLabel = new JLabel(this.defValLabelText);
            this.add(this.defValLabel);
            this.add(this.defValueTextField);
        }
    }

    public void setAttributeName(String attrName) {
        this.nameTextField.setText(attrName);
    }

    public AttributeInfo getAttributeInfo() {
        String newAttrName = this.nameTextField.getText();
        if (newAttrName == null || newAttrName.length() == 0) {
            newAttrName = "NEW_ATTRIBUTE";
        }
        AttributeInfo attrInfo = new AttributeInfo((AttributeType)this.typeDropDown.getSelectedItem(), newAttrName);
        if (this.needDefaultValue) {
            attrInfo.setNullValue(this.getDefaultValue());
        }
        return attrInfo;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (JComboBox.class.isInstance(event.getSource()) && this.needDefaultValue && FeatureCollectionTools.isAttributeTypeNumeric((AttributeType)this.typeDropDown.getSelectedItem())) {
            AttributeType at = (AttributeType)this.typeDropDown.getSelectedItem();
            if (at.equals(AttributeType.INTEGER)) {
                try {
                    Integer.parseInt(this.defValueTextField.getText());
                }
                catch (Exception e) {
                    this.defValueTextField.setText("0");
                }
            } else {
                try {
                    Double.parseDouble(this.defValueTextField.getText());
                }
                catch (Exception e) {
                    this.defValueTextField.setText("0.0");
                }
            }
        }
    }

    public boolean isDataValid() {
        boolean dataValid = true;
        if (this.needDefaultValue) {
            try {
                this.getDefaultValue();
            }
            catch (Exception e) {
                dataValid = false;
            }
        }
        if (this.nameTextField.getText() == null || this.nameTextField.getText().length() == 0) {
            dataValid = false;
        }
        return dataValid;
    }

    protected Object getDefaultValue() {
        if (FeatureCollectionTools.isAttributeTypeNumeric((AttributeType)this.typeDropDown.getSelectedItem())) {
            AttributeType at = (AttributeType)this.typeDropDown.getSelectedItem();
            if (at.equals(AttributeType.INTEGER)) {
                int i = Integer.parseInt(this.defValueTextField.getText());
                return new Integer(i);
            }
            double d = Double.parseDouble(this.defValueTextField.getText());
            return new Double(d);
        }
        return this.defValueTextField.getText();
    }

    public void addActionListenerToDefValueTextfield(ActionListener arg0) {
        this.defValueTextField.addActionListener(arg0);
    }

    public void addActionListenerToNameTextfield(ActionListener arg0) {
        this.nameTextField.addActionListener(arg0);
    }

    public void addActionListenerToTypeDropDown(ActionListener arg0) {
        this.typeDropDown.addActionListener(arg0);
    }

    public void setDefValLabel(String defValLabel) {
        this.defValLabelText = defValLabel;
        this.defValLabel.setText(this.defValLabelText);
    }

    public void setNameLabel(String nameLabel) {
        this.nameLabelText = nameLabel;
        this.nameLabel.setText(this.nameLabelText);
    }

    public void setTypeLabel(String typeLabel) {
        this.typeLabelText = typeLabel;
        this.typeLabel.setText(this.typeLabelText);
    }
}

