/*
 * Decompiled with CFR 0.152.
 */
package de.fho.jump.pirol.plugins.EditAttributeByFormula;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.workbench.Logger;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import de.fho.jump.pirol.plugins.EditAttributeByFormula.EditAttributeByFormulaDialog;
import de.fho.jump.pirol.utilities.FormulaParsing.FormulaValue;
import de.fho.jump.pirol.utilities.attributes.AttributeInfo;
import de.fho.jump.pirol.utilities.plugIns.StandardPirolPlugIn;
import de.fho.jump.pirol.utilities.settings.PirolPlugInSettings;
import org.openjump.core.apitools.FeatureCollectionTools;
import org.openjump.core.apitools.objecttyperoles.PirolFeatureCollection;
import org.openjump.io.PropertiesHandler;
import org.openjump.util.metaData.MetaInformationHandler;

public class EditAttributeByFormulaPlugIn
extends AbstractPlugIn {
    protected static PropertiesHandler storedFormulas = null;
    protected static final String storedFormulasFileName = "Formula.properties";

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
        context.getFeatureInstaller().addMainMenuItem(this, new String[]{MenuNames.TOOLS, MenuNames.TOOLS_EDIT_ATTRIBUTES}, this.getName(), false, null, EditAttributeByFormulaPlugIn.createEnableCheck(context.getWorkbenchContext()));
    }

    @Override
    public String getName() {
        return I18N.getInstance().get("pirol.plugIns.EditAttributeByFormulaPlugIn.Attribute-Calculator");
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createAtLeastNLayersMustBeSelectedCheck(1)).add(checkFactory.createSelectedLayersMustBeEditableCheck());
    }

    public String getIconString() {
        return null;
    }

    public String getCategoryName() {
        return PirolPlugInSettings.getName_AttributeMenu();
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        Layer layer = StandardPirolPlugIn.getSelectedLayer(context);
        if (layer == null) {
            StandardPirolPlugIn.warnUser(context, I18N.getInstance().get("pirol.plugIns.EditAttributeByFormulaPlugIn.no-layer-selected"));
            return false;
        }
        if (!layer.isEditable()) {
            StandardPirolPlugIn.warnUser(context, I18N.getInstance().get("pirol.plugIns.EditAttributeByFormulaPlugIn.layer-not-editable"));
            return false;
        }
        try {
            storedFormulas = new PropertiesHandler(storedFormulasFileName);
        }
        catch (Exception e1) {
            Logger.warn(e1.getMessage());
        }
        EditAttributeByFormulaDialog dialog = new EditAttributeByFormulaDialog(context.getWorkbenchFrame(), I18N.getInstance().get("pirol.plugIns.EditAttributeByFormulaPlugIn.specify-attribute-and-formula"), true, I18N.getInstance().get("pirol.plugIns.EditAttributeByFormulaPlugIn.editByFormula-explaining-text"), layer.getFeatureCollectionWrapper().getFeatureSchema());
        GUIUtil.centreOnWindow(dialog);
        dialog.setVisible(true);
        String formula = dialog.getFormula();
        if (!dialog.wasOkClicked() || formula == null || formula.length() == 0) {
            return false;
        }
        AttributeInfo attrInfo = dialog.getAttributeInfo();
        FeatureCollection oldFc = layer.getFeatureCollectionWrapper().getUltimateWrappee();
        attrInfo.setUniqueAttributeName(FeatureCollectionTools.getUniqueAttributeName(oldFc, attrInfo.getAttributeName()));
        try {
            FormulaValue parsedFormula = dialog.getParsedFormula();
            PirolFeatureCollection newFc = FeatureCollectionTools.applyFormulaToFeatureCollection(oldFc, attrInfo, parsedFormula, true);
            layer.setFeatureCollection(newFc);
            MetaInformationHandler metaInfHandler = new MetaInformationHandler(layer);
            metaInfHandler.addMetaInformation(I18N.getInstance().get("pirol.plugIns.EditAttributeByFormulaPlugIn.formula-for") + attrInfo.getUniqueAttributeName(), formula);
            if (storedFormulas != null) {
                storedFormulas.setProperty(attrInfo.toString(), formula);
                storedFormulas.store(I18N.getInstance().get("pirol.plugIns.EditAttributeByFormulaPlugIn.editByFormula-properties-comment"));
            }
        }
        catch (Exception e) {
            Logger.debug(e);
            return false;
        }
        return false;
    }
}

