/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.warp;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.JUMPException;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.warp.ProjectiveTransform;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.imagery.ReferencedImageStyle;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.warp.WarpingVectorLayerFinder;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.util.AssertionFailedException;
import org.openjump.core.apitools.LayerTools;

public class ProjectiveTransformPlugIn
extends AbstractPlugIn {
    public static String path;

    public static EnableCheck getEnableCheck(EnableCheckFactory enableCheckFactory) {
        return new MultiEnableCheck().add(enableCheckFactory.createAtLeastNLayerablesMustExistCheck(1)).add(enableCheckFactory.createExactlyNVectorsMustBeDrawnCheck(4));
    }

    @Override
    public String getName() {
        return I18N.getInstance().get("com.vividsolutions.jump.workbench.ui.warp.ProjectiveTransformPlugIn");
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
        context.getFeatureInstaller().addMainMenuPlugin(this, new String[]{MenuNames.TOOLS, MenuNames.TOOLS_WARP}, this.getName(), false, null, ProjectiveTransformPlugIn.getEnableCheck(context.getCheckFactory()));
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.reportNothingToUndoYet(context);
        Layerable layer = LayerTools.getSelectedLayerable(context, Layerable.class);
        if (!(layer instanceof Layer) || ((Layer)layer).getStyle(ReferencedImageStyle.class) != null) {
            if (layer instanceof Layer && ((Layer)layer).getStyle(ReferencedImageStyle.class) != null) {
                JOptionPane.showMessageDialog(null, I18N.getInstance().get("com.vividsolutions.jump.workbench.ui.warp.AffineTransformPlugIn.message1"), null, 1);
                return false;
            }
            JOptionPane.showMessageDialog(null, I18N.getInstance().get("com.vividsolutions.jump.workbench.ui.warp.AffineTransformPlugIn.message2"), null, 1);
            return false;
        }
        ProjectiveTransformPlugIn.affineTransformVector(context);
        return true;
    }

    public static void affineTransformVector(PlugInContext context) throws JUMPException {
        ProjectiveTransform transform = ProjectiveTransformPlugIn.projectiveTransform(context);
        FeatureCollection featureCollection = transform.transform(context.getSelectedLayer(0).getFeatureCollectionWrapper());
        context.getLayerManager().addLayer(StandardCategoryNames.WORKING, I18N.getInstance().get("ui.warp.AffineTransformPlugIn.affined") + " " + context.getSelectedLayer(0).getName(), featureCollection);
        ProjectiveTransformPlugIn.checkValid(featureCollection, context);
    }

    public static void checkValid(FeatureCollection featureCollection, PlugInContext context) {
        for (Feature feature : featureCollection) {
            if (feature.getGeometry().isValid()) continue;
            context.getLayerViewPanel().getContext().warnUser(I18N.getInstance().get("ui.warp.AffineTransformPlugIn.some-geometries-are-not-valid"));
            return;
        }
    }

    private static Coordinate vectorCoordinate(int n, boolean tip, PlugInContext context, WarpingVectorLayerFinder vectorLayerManager) {
        LineString vector = (LineString)vectorLayerManager.getVectors().get(n);
        return tip ? vector.getCoordinateN(1) : vector.getCoordinateN(0);
    }

    private static ProjectiveTransform projectiveTransform(PlugInContext context) {
        WarpingVectorLayerFinder vlm = new WarpingVectorLayerFinder(context);
        Integer numVectors = vlm.getVectors().size();
        if (numVectors < 4) {
            JUMPWorkbench.getInstance().getFrame().getContext().getLayerViewPanel().getContext().setStatusMessage(I18N.getInstance().get("Warping vectors: {0}", numVectors + "\n Especting 4"));
        } else {
            if (numVectors == 4) {
                return new ProjectiveTransform(ProjectiveTransformPlugIn.vectorCoordinate(0, false, context, vlm), ProjectiveTransformPlugIn.vectorCoordinate(0, true, context, vlm), ProjectiveTransformPlugIn.vectorCoordinate(1, false, context, vlm), ProjectiveTransformPlugIn.vectorCoordinate(1, true, context, vlm), ProjectiveTransformPlugIn.vectorCoordinate(2, false, context, vlm), ProjectiveTransformPlugIn.vectorCoordinate(2, true, context, vlm), ProjectiveTransformPlugIn.vectorCoordinate(3, false, context, vlm), ProjectiveTransformPlugIn.vectorCoordinate(3, true, context, vlm));
            }
            JUMPWorkbench.getInstance().getFrame().getContext().getLayerViewPanel().getContext().warnUser(I18N.getInstance().get("ui.warp.WarpingPanel.warning_1"));
        }
        return null;
    }

    public static void warning(String paramString) {
        throw new AssertionFailedException(paramString != null ? paramString : "");
    }

    private static Coordinate vectorCoordinatePublic(int n, boolean tip, WarpingVectorLayerFinder vectorLayerManager) {
        LineString vector = (LineString)vectorLayerManager.getVectors().get(n);
        return tip ? vector.getCoordinateN(1) : vector.getCoordinateN(0);
    }

    public static ProjectiveTransform getTransform() {
        WarpingVectorLayerFinder vlm = new WarpingVectorLayerFinder(JUMPWorkbench.getInstance().getContext());
        Integer numVectors = vlm.getVectors().size();
        if (numVectors == 4) {
            return new ProjectiveTransform(ProjectiveTransformPlugIn.vectorCoordinatePublic(0, false, vlm), ProjectiveTransformPlugIn.vectorCoordinatePublic(0, true, vlm), ProjectiveTransformPlugIn.vectorCoordinatePublic(1, false, vlm), ProjectiveTransformPlugIn.vectorCoordinatePublic(1, true, vlm), ProjectiveTransformPlugIn.vectorCoordinatePublic(2, false, vlm), ProjectiveTransformPlugIn.vectorCoordinatePublic(2, true, vlm), ProjectiveTransformPlugIn.vectorCoordinatePublic(3, false, vlm), ProjectiveTransformPlugIn.vectorCoordinatePublic(3, true, vlm));
        }
        JUMPWorkbench.getInstance().getFrame().getContext().getLayerViewPanel().getContext().warnUser(I18N.getInstance().get("ui.warp.WarpingPanel.warning_2"));
        return null;
    }

    public Icon createEnableCheck(WorkbenchContext workbenchContext) {
        return null;
    }
}

