/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.warp;

import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.AbstractVectorLayerFinder;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerManagerProxy;
import com.vividsolutions.jump.workbench.model.UndoableCommand;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.warp.AbstractDeleteVectorTool;
import com.vividsolutions.jump.workbench.ui.warp.IncrementalWarpingVectorLayerFinder;
import com.vividsolutions.jump.workbench.ui.warp.WarpingPanel;
import com.vividsolutions.jump.workbench.ui.warp.WarpingVectorLayerFinder;
import java.awt.Cursor;
import java.awt.geom.NoninvertibleTransformException;
import java.util.Collection;
import javax.swing.Icon;
import org.locationtech.jts.util.Assert;

public class DeleteIncrementalWarpingVectorTool
extends AbstractDeleteVectorTool {
    private WarpingPanel warpingPanel;

    public DeleteIncrementalWarpingVectorTool(WorkbenchContext context, WarpingPanel warpingPanel) {
        super(context);
        this.warpingPanel = warpingPanel;
    }

    @Override
    protected AbstractVectorLayerFinder createVectorLayerFinder(LayerManagerProxy layerManagerProxy) {
        return new WarpingVectorLayerFinder(layerManagerProxy);
    }

    protected AbstractVectorLayerFinder createIncrementalVectorLayerFinder(LayerManagerProxy layerManagerProxy) {
        return new IncrementalWarpingVectorLayerFinder(layerManagerProxy);
    }

    @Override
    protected UndoableCommand createCommand() throws NoninvertibleTransformException {
        return this.warpingPanel.addWarping(this.warpingPanel.addWarpingVectorGeneration(this.createBaseCommand()));
    }

    @Override
    public Icon getIcon() {
        return IconLoader.icon("DeleteVectors.gif");
    }

    @Override
    public Cursor getCursor() {
        return DeleteIncrementalWarpingVectorTool.createCursor(IconLoader.icon("DeleteVectorCursor.gif").getImage());
    }

    protected UndoableCommand createBaseCommand() throws NoninvertibleTransformException {
        final UndoableCommand superCommand = super.createCommand();
        final AbstractVectorLayerFinder incrementalVectorLayerFinder = this.createIncrementalVectorLayerFinder(this.getPanel());
        Assert.isTrue((incrementalVectorLayerFinder != null ? 1 : 0) != 0);
        Layer layer = incrementalVectorLayerFinder.getLayer();
        Assert.isTrue((layer != null ? 1 : 0) != 0);
        boolean oldVisible = layer.isVisible();
        layer.setVisible(true);
        final Collection incrementalVectorFeaturesToDelete = this.layerToSpecifiedFeaturesMap().get(layer);
        layer.setVisible(oldVisible);
        Assert.isTrue((incrementalVectorFeaturesToDelete != null ? 1 : 0) != 0);
        Assert.isTrue((!incrementalVectorFeaturesToDelete.isEmpty() ? 1 : 0) != 0);
        return new UndoableCommand(this.getName()){

            @Override
            public void execute() {
                superCommand.execute();
                incrementalVectorLayerFinder.getLayer().getFeatureCollectionWrapper().removeAll(incrementalVectorFeaturesToDelete);
                DeleteIncrementalWarpingVectorTool.this.showAnimation(incrementalVectorFeaturesToDelete);
            }

            @Override
            public void unexecute() {
                superCommand.unexecute();
                incrementalVectorLayerFinder.getLayer().getFeatureCollectionWrapper().addAll(incrementalVectorFeaturesToDelete);
            }
        };
    }
}

