/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.renderer.style;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.util.StringUtil;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.Viewport;
import com.vividsolutions.jump.workbench.ui.renderer.style.AlphaSetting;
import com.vividsolutions.jump.workbench.ui.renderer.style.BasicFillPattern;
import com.vividsolutions.jump.workbench.ui.renderer.style.Style;
import com.vividsolutions.jump.workbench.ui.renderer.style.StyleUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.util.List;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.simplify.TopologyPreservingSimplifier;
import org.locationtech.jts.util.Assert;
import org.openjump.util.SLDImporter;

public class BasicStyle
implements Style,
SLDImporter.StrokeFillStyle,
AlphaSetting {
    public static final String RGB_ATTRIBUTE_NAME = "R_G_B";
    private boolean renderingFill = true;
    private boolean renderingLine = true;
    private boolean renderingLinePattern = false;
    private boolean renderingFillPattern = false;
    public static final Color DEFAULT_FILL_COLOR;
    public static final Color DEFAULT_LINE_COLOR;
    public static final BasicStroke DEFAULT_FILL_STROKE;
    private Color fillColor = DEFAULT_FILL_COLOR;
    private Color lineColor = DEFAULT_LINE_COLOR;
    private BasicStroke lineStroke;
    private Stroke fillStroke = DEFAULT_FILL_STROKE;
    private boolean enabled = true;
    private String linePattern = "3";
    private boolean interiorBorder = false;
    private boolean renderingVertices = true;
    private Paint fillPattern;

    public BasicStyle(Color fillColor) {
        this.setFillColor(fillColor);
        this.setLineColor(Layer.defaultLineColor(fillColor));
        this.setLineWidth(1);
    }

    public BasicStyle() {
        this(Color.black);
    }

    public boolean isRenderingFillPattern() {
        return this.renderingFillPattern;
    }

    public BasicStyle setRenderingFillPattern(boolean renderingFillPattern) {
        this.renderingFillPattern = renderingFillPattern;
        return this;
    }

    public Paint getFillPattern() {
        return this.fillPattern;
    }

    public BasicStyle setFillPattern(Paint fillPattern) {
        this.fillPattern = fillPattern;
        if (fillPattern instanceof BasicFillPattern) {
            ((BasicFillPattern)fillPattern).setColor(this.fillColor);
        }
        return this;
    }

    public String getLinePattern() {
        return this.linePattern;
    }

    public boolean getRenderingVertices() {
        return this.renderingVertices;
    }

    public void setRenderingVertices(boolean renderingVertices) {
        this.renderingVertices = renderingVertices;
    }

    @Override
    public BasicStyle setLinePattern(String linePattern) {
        this.linePattern = linePattern;
        this.lineStroke = this.createLineStroke(this.lineStroke.getLineWidth());
        return this;
    }

    @Override
    public void initialize(Layer layer) {
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void paint(Feature f, Graphics2D g, Viewport viewport) throws Exception {
        Color fillColor = this.fillColor;
        Color lineColor = this.lineColor;
        Color featureColor = this.getFeatureColor(f);
        if (featureColor != null) {
            fillColor = featureColor;
            lineColor = featureColor.darker();
        }
        if (!this.renderingVertices && f.getGeometry() instanceof Point) {
            return;
        }
        StyleUtil.paint(f.getGeometry(), g, viewport, this.renderingFill, this.fillStroke, this.renderingFillPattern && this.fillPattern != null ? this.fillPattern : fillColor, this.renderingLine && !this.interiorBorder, this.lineStroke, lineColor);
        if (this.interiorBorder) {
            double scale = viewport.getScale();
            double width = (double)this.getLineWidth() / scale;
            TopologyPreservingSimplifier simplifier = new TopologyPreservingSimplifier(f.getGeometry());
            simplifier.setDistanceTolerance(0.5 / scale);
            Geometry simplified = simplifier.getResultGeometry();
            if (f.getGeometry().getDimension() == 2) {
                Geometry geom = simplified.difference(simplified.buffer(-width, 4));
                StyleUtil.paint(geom, g, viewport, true, this.fillStroke, this.renderingFillPattern && this.fillPattern != null ? this.fillPattern : fillColor, false, new BasicStroke(), Color.BLACK);
            }
        }
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            Assert.shouldNeverReachHere();
            return null;
        }
    }

    public boolean isRenderingFill() {
        return this.renderingFill;
    }

    public boolean isRenderingLine() {
        return this.renderingLine;
    }

    public boolean isRenderingLinePattern() {
        return this.renderingLinePattern;
    }

    public void setRenderingFill(boolean renderingFill) {
        this.renderingFill = renderingFill;
    }

    public void setRenderingLine(boolean renderingLine) {
        this.renderingLine = renderingLine;
    }

    @Override
    public BasicStyle setRenderingLinePattern(boolean renderingLinePattern) {
        this.renderingLinePattern = renderingLinePattern;
        this.lineStroke = this.createLineStroke(this.lineStroke.getLineWidth());
        return this;
    }

    @Override
    public void setFillColor(Color fillColor) {
        this.setFillColor(fillColor, this.getAlpha());
    }

    private BasicStyle setFillColor(Color fillColor, int alpha) {
        this.fillColor = GUIUtil.alphaColor(fillColor, alpha);
        if (this.fillPattern instanceof BasicFillPattern) {
            ((BasicFillPattern)this.fillPattern).setColor(this.fillColor);
        }
        return this;
    }

    @Override
    public void setLineColor(Color lineColor) {
        this.lineColor = GUIUtil.alphaColor(lineColor, this.getAlpha());
    }

    @Override
    public void setLineWidth(int lineWidth) {
        this.lineStroke = this.createLineStroke(lineWidth);
    }

    public void setFractionalLineWidth(float lineWidth) {
        this.lineStroke = this.createLineStroke(lineWidth);
    }

    private BasicStroke createLineStroke(float lineWidth) {
        return this.renderingLinePattern && this.linePattern.trim().length() != 0 && lineWidth > 0.0f ? new BasicStroke(lineWidth, 0, 2, 1.0f, BasicStyle.toArray(this.linePattern, lineWidth), 0.0f) : new BasicStroke(lineWidth, 0, 2);
    }

    public boolean hasInteriorBorder() {
        return this.interiorBorder;
    }

    public void setInteriorBorder(boolean interiorBorder) {
        this.interiorBorder = interiorBorder;
    }

    public static float[] toArray(String linePattern, float lineWidth) {
        List<String> strings = StringUtil.fromCommaDelimitedString(linePattern);
        float[] array = new float[strings.size()];
        for (int i = 0; i < strings.size(); ++i) {
            String string = strings.get(i);
            array[i] = Float.parseFloat(string) * lineWidth;
            if (!(array[i] <= 0.0f)) continue;
            throw new IllegalArgumentException(I18N.getInstance().get("ui.renderer.style.BasicStyle.negative-dash-length"));
        }
        return array;
    }

    @Override
    public int getAlpha() {
        return this.fillColor.getAlpha();
    }

    public Color getFillColor() {
        return GUIUtil.alphaColor(this.fillColor, 255);
    }

    public Color getLineColor() {
        return GUIUtil.alphaColor(this.lineColor, 255);
    }

    public int getLineWidth() {
        return (int)this.lineStroke.getLineWidth();
    }

    @Override
    public void setAlpha(int alpha) {
        this.setFillColor(this.fillColor, alpha);
        this.lineColor = GUIUtil.alphaColor(this.lineColor, alpha);
    }

    public BasicStroke getLineStroke() {
        return this.lineStroke;
    }

    public Color getFeatureColor(Feature f) {
        String colorStr;
        if (f.getSchema().hasAttribute(RGB_ATTRIBUTE_NAME) && (colorStr = (String)f.getAttribute(RGB_ATTRIBUTE_NAME)) != null && colorStr.trim().length() == 6) {
            try {
                int r = Integer.parseInt(colorStr.substring(0, 2), 16);
                int g = Integer.parseInt(colorStr.substring(2, 4), 16);
                int b = Integer.parseInt(colorStr.substring(4, 6), 16);
                return new Color(r, g, b, this.getAlpha());
            }
            catch (NumberFormatException ex) {
                return null;
            }
        }
        return null;
    }

    static {
        DEFAULT_LINE_COLOR = DEFAULT_FILL_COLOR = new Color(0, 0, 0, 255);
        DEFAULT_FILL_STROKE = new BasicStroke(1.0f);
    }
}

