/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.wms;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.Logger;
import com.vividsolutions.jump.workbench.model.WMSLayer;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.ui.TransparencyPanel;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.wms.MapLayerPanel;
import com.vividsolutions.jump.workbench.ui.plugin.wms.MapLayerWizardPanel;
import com.vividsolutions.jump.workbench.ui.plugin.wms.SelectUrlWithAuthPanel;
import com.vividsolutions.jump.workbench.ui.plugin.wms.URLWizardPanel;
import com.vividsolutions.wms.MapLayer;
import com.vividsolutions.wms.MapStyle;
import com.vividsolutions.wms.WMService;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang3.ArrayUtils;
import org.openjump.core.ui.plugin.wms.AddWmsLayerWizard;
import org.openjump.util.UriUtil;

public class EditWMSQueryPanel
extends JPanel {
    private final MapLayerPanel mapLayerPanel = new MapLayerPanel();
    private final JComboBox<String> srsComboBox = new JComboBox();
    private final JComboBox<String> formatComboBox = new JComboBox();
    private final JComboBox<MapStyle> styleComboBox = new JComboBox();
    private final JTextField moreParametersTextField = new JTextField(16);
    private final TransparencyPanel transparencyPanel = new TransparencyPanel();
    private SelectUrlWithAuthPanel urlPanel;
    String[] savedUrlList;
    private JButton connectButton;
    private final EnableCheck[] enableChecks = new EnableCheck[]{component -> this.mapLayerPanel.getChosenMapLayers().isEmpty() ? I18N.getInstance().get("ui.plugin.wms.EditWMSQueryPanel.at-least-one-wms-must-be-chosen") : null, component -> this.srsComboBox.getSelectedItem() == null ? MapLayerWizardPanel.NO_COMMON_SRS_MESSAGE : null};
    private final WMSLayer layer;

    public EditWMSQueryPanel(WMSLayer layer) {
        this.layer = layer;
        try {
            WMService service = layer.getService();
            if (service != null) {
                this.jbInit();
                this.mapLayerPanel.init(service, layer.getLayerNames());
                this.refreshParamCombos();
                this.mapLayerPanel.add(this::refreshParamCombos);
                this.setAlpha(layer.getAlpha());
            }
        }
        catch (Exception e) {
            Logger.warn(e);
        }
    }

    private void resetConnection() {
        this.mapLayerPanel.reset();
        this.refreshParamCombos();
        this.connectButton.setEnabled(true);
    }

    private void refreshParamCombos() {
        WMService service = this.mapLayerPanel.getService();
        this.refreshComboBox(this.srsComboBox, this.layer.getSRS(), this.mapLayerPanel.commonSRSList().toArray(new String[0]));
        this.refreshComboBox(this.formatComboBox, this.layer.getFormat(), service.getCapabilities().getMapFormats());
        this.refreshComboBox(this.styleComboBox, this.layer.getStyle(), this.mapLayerPanel.commonStyleList().toArray(new MapStyle[0]));
    }

    private <T> void refreshComboBox(JComboBox<T> comboBox, T defaultValue, T[] newList) {
        WMService service = this.mapLayerPanel.getService();
        if (service == null) {
            comboBox.setModel(new DefaultComboBoxModel());
        } else {
            Object prevSelected = comboBox.getSelectedItem();
            if (prevSelected == null) {
                prevSelected = defaultValue;
            }
            DefaultComboBoxModel<T> model = new DefaultComboBoxModel<T>(newList);
            comboBox.setModel(model);
            comboBox.setSelectedItem(prevSelected);
            if (comboBox.getSelectedItem() == null && comboBox.getItemCount() > 0) {
                comboBox.setSelectedIndex(0);
            }
        }
    }

    public int getAlpha() {
        return 255 - this.transparencyPanel.getSlider().getValue();
    }

    private void setAlpha(int alpha) {
        this.transparencyPanel.getSlider().setValue(255 - alpha);
    }

    public String getSRS() {
        int index = this.srsComboBox.getSelectedIndex();
        return this.mapLayerPanel.commonSRSList().get(index);
    }

    public String[] getUrlList() {
        return (String[])this.savedUrlList.clone();
    }

    public MapStyle getStyle() {
        return (MapStyle)this.styleComboBox.getSelectedItem();
    }

    public String getMoreParameters() {
        return this.moreParametersTextField.getText();
    }

    public String getFormat() {
        return (String)this.formatComboBox.getSelectedItem();
    }

    void jbInit() throws Exception {
        JLabel transparencyLabel = new JLabel(I18N.getInstance().get("ui.plugin.wms.EditWMSQueryPanel.transparency"));
        Border border1 = BorderFactory.createEmptyBorder(10, 10, 10, 10);
        this.setLayout(new GridBagLayout());
        this.setBorder(border1);
        this.setToolTipText("");
        this.srsComboBox.setToolTipText("");
        Insets defaultInsets = new Insets(3, 3, 3, 3);
        this.add((Component)this.mapLayerPanel, new GridBagConstraints(1, 2, 5, 1, 1.0, 1.0, 10, 1, new Insets(10, 0, 10, 0), 0, 0));
        Insets zeroInsets = new Insets(0, 0, 0, 0);
        this.add((Component)this.createParametersPanel(), new GridBagConstraints(1, 3, 5, 1, 0.0, 0.0, 17, 0, defaultInsets, 0, 0));
        this.add((Component)transparencyLabel, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 17, 0, defaultInsets, 0, 0));
        this.add((Component)this.transparencyPanel, new GridBagConstraints(2, 5, 5, 1, 1.0, 0.0, 17, 2, defaultInsets, 0, 0));
        String urlString = (String)PersistentBlackboardPlugIn.getInstance().get("AddWMSQueryPlugin.CACHED_URL");
        this.savedUrlList = urlString != null ? urlString.split(",") : AddWmsLayerWizard.DEFAULT_URLS;
        LinkedHashSet<String> newUrlList = new LinkedHashSet<String>();
        newUrlList.add(this.layer.getService().getServerUrl());
        newUrlList.addAll(Arrays.asList(this.savedUrlList));
        this.urlPanel = new SelectUrlWithAuthPanel(newUrlList.toArray(new String[0]));
        this.urlPanel.setBorder(BorderFactory.createTitledBorder(URLWizardPanel.TITLE));
        this.add((Component)this.urlPanel, new GridBagConstraints(1, 0, 7, 1, 0.0, 0.0, 17, 2, zeroInsets, 0, 0));
        final DocumentListener doli = new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.reset();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.reset();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.reset();
            }

            private void reset() {
                EditWMSQueryPanel.this.resetConnection();
            }
        };
        JPanel versionPanel = URLWizardPanel.getInstance().createVersionPanel();
        versionPanel.setBorder(BorderFactory.createTitledBorder(I18N.getInstance().get("GenericNames.version")));
        this.add((Component)versionPanel, new GridBagConstraints(1, 1, 3, 1, 1.0, 0.0, 10, 2, zeroInsets, 0, 0));
        final ActionListener ali = e -> this.resetConnection();
        final Component[] cs = (Component[])ArrayUtils.addAll((Object[])versionPanel.getComponents(), (Object[])this.urlPanel.getComponents());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (Component c : cs) {
                    if (c instanceof AbstractButton) {
                        ((AbstractButton)c).addActionListener(ali);
                        continue;
                    }
                    if (c instanceof JTextField) {
                        ((JTextField)c).getDocument().addDocumentListener(doli);
                        continue;
                    }
                    if (!(c instanceof JComboBox)) continue;
                    ((JComboBox)c).addActionListener(ali);
                    Component editor = ((JComboBox)c).getEditor().getEditorComponent();
                    if (!(editor instanceof JTextComponent)) continue;
                    ((JTextComponent)editor).getDocument().addDocumentListener(doli);
                }
            }
        });
        this.connectButton = new JButton(I18N.getInstance().get("GenericNames.reconnect"));
        this.connectButton.addActionListener(e -> this.reinitializeService());
        this.connectButton.setEnabled(false);
        this.add((Component)this.connectButton, new GridBagConstraints(4, 1, 2, 1, 0.0, 0.0, 10, 0, zeroInsets, 0, 0));
    }

    private JPanel createParametersPanel() {
        JPanel panel = new JPanel(new FlowLayout());
        JLabel srsLabel = new JLabel(I18N.getInstance().get("ui.plugin.wms.EditWMSQueryPanel.coordinate-reference-system"));
        JLabel formatLabel = new JLabel(I18N.getInstance().get("ui.plugin.wms.SRSWizardPanel.image-format"));
        JLabel stylesLabel = new JLabel(I18N.getInstance().get("ui.plugin.wms.SRSWizardPanel.styles"));
        JLabel moreParametersLabel = new JLabel(I18N.getInstance().get("ui.plugin.wms.SRSWizardPanel.more-parameters"));
        panel.add(srsLabel);
        panel.add(this.srsComboBox);
        panel.add(stylesLabel);
        panel.add(this.styleComboBox);
        panel.add(moreParametersLabel);
        panel.add(this.moreParametersTextField);
        panel.add(formatLabel);
        panel.add(this.formatComboBox);
        return panel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reinitializeService() {
        String url = this.urlPanel.getUrl();
        url = UriUtil.urlAddCredentials(url, this.urlPanel.getUser(), this.urlPanel.getPass()).trim();
        WMService service = new WMService(url, URLWizardPanel.wmsVersion);
        try {
            service.initialize(true);
            this.mapLayerPanel.init(service, this.layer.getLayerNames());
            this.connectButton.setEnabled(false);
        }
        catch (Exception e) {
            this.mapLayerPanel.reset();
            JUMPWorkbench.getInstance().getFrame().handleThrowable(e);
        }
        finally {
            this.refreshParamCombos();
        }
    }

    public List<MapLayer> getChosenMapLayers() {
        return this.mapLayerPanel.getChosenMapLayers();
    }

    public EnableCheck[] getEnableChecks() {
        return this.enableChecks;
    }

    public WMService getService() {
        return this.mapLayerPanel.getService();
    }
}

