/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.skin;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.workbench.Logger;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.OptionsPanel;
import com.vividsolutions.jump.workbench.ui.TrackedPopupMenu;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.skin.LookAndFeelProxy;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.util.Collection;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class SkinOptionsPanel
extends JPanel
implements OptionsPanel {
    private static final String CURRENT_SKIN_KEY = SkinOptionsPanel.class + " - CURRENT SKIN";
    public static final String SKINS_KEY = SkinOptionsPanel.class + " - SKINS";
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JComboBox comboBox = new JComboBox();
    private JPanel fillerPanel = new JPanel();
    private JLabel label = new JLabel();
    private PlugInContext context;
    private Blackboard blackboard;
    private Blackboard blackboard_persist;

    public SkinOptionsPanel(PlugInContext plc) {
        this.blackboard = plc.getWorkbenchContext().getWorkbench().getBlackboard();
        this.blackboard_persist = PersistentBlackboardPlugIn.get(plc.getWorkbenchContext());
        this.context = plc;
        String saved_skin = (String)this.blackboard_persist.get(CURRENT_SKIN_KEY);
        String cur_skin = UIManager.getLookAndFeel().getClass().getName();
        try {
            this.jbInit();
            DefaultComboBoxModel<LookAndFeelProxy> model = new DefaultComboBoxModel<LookAndFeelProxy>();
            for (LookAndFeelProxy proxy : (Collection)this.blackboard.get(SKINS_KEY)) {
                String proxy_skin = null;
                try {
                    proxy_skin = proxy.getLookAndFeel().getClass().getName();
                }
                catch (NullPointerException e) {
                    Logger.error(e);
                    continue;
                }
                model.addElement(proxy);
                if (saved_skin instanceof String && saved_skin.equals(proxy_skin) && cur_skin instanceof String && !cur_skin.equals(proxy_skin)) {
                    this.updateAll(proxy.getLookAndFeel());
                    cur_skin = proxy_skin;
                }
                if (cur_skin != proxy_skin) continue;
                model.setSelectedItem(proxy);
            }
            this.comboBox.setModel(model);
        }
        catch (Exception ex) {
            this.context.getWorkbenchFrame().handleThrowable(ex);
        }
    }

    void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout1);
        this.label.setText(I18N.getInstance().get("ui.plugin.skin.InstallSkinsPlugIn.skins") + ":");
        this.add((Component)this.comboBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 0, 10, 10), 0, 0));
        this.add((Component)this.fillerPanel, new GridBagConstraints(2, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.label, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 10, 10, 4), 0, 0));
    }

    @Override
    public void init() {
    }

    @Override
    public void okPressed() {
        this.updateAll(((LookAndFeelProxy)this.comboBox.getSelectedItem()).getLookAndFeel());
    }

    private void updateAll(LookAndFeel laf) {
        if (UIManager.getLookAndFeel().getClass().equals(laf.getClass())) {
            return;
        }
        try {
            UIManager.setLookAndFeel(laf);
        }
        catch (UnsupportedLookAndFeelException e) {
            this.context.getWorkbenchFrame().handleThrowable(e);
        }
        SwingUtilities.updateComponentTreeUI(this);
        this.updateFrames();
        this.updatePopupMenus();
        this.blackboard_persist.put(CURRENT_SKIN_KEY, laf.getClass().getName());
    }

    private void updatePopupMenus() {
        for (JPopupMenu menu : TrackedPopupMenu.trackedPopupMenus()) {
            SwingUtilities.updateComponentTreeUI(menu);
        }
    }

    private void updateFrames() {
        Frame[] frames = Frame.getFrames();
        for (int i = 0; i < frames.length; ++i) {
            Window[] windows = frames[i].getOwnedWindows();
            for (int j = 0; j < windows.length; ++j) {
                this.updateWindow(windows[j]);
            }
            SwingUtilities.updateComponentTreeUI(frames[i]);
        }
    }

    private void updateWindow(Window w) {
        Window[] children = w.getOwnedWindows();
        for (int i = 0; i < children.length; ++i) {
            this.updateWindow(children[i]);
        }
        SwingUtilities.updateComponentTreeUI(w);
        w.pack();
    }

    @Override
    public String validateInput() {
        return null;
    }
}

