/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.imagery;

import com.sun.media.jai.codec.FileSeekableStream;
import com.sun.media.jai.codec.TIFFDecodeParam;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollectionWrapper;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.datasource.SaveFileDataSourceQueryChooser;
import com.vividsolutions.jump.workbench.imagery.ImageryLayerDataset;
import com.vividsolutions.jump.workbench.imagery.ReferencedImageException;
import com.vividsolutions.jump.workbench.imagery.geoimg.GeoReferencedRaster;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Locale;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.JAI;
import javax.media.jai.PerspectiveTransform;
import javax.media.jai.RenderedOp;
import javax.media.jai.WarpPerspective;
import javax.swing.JOptionPane;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.util.AffineTransformation;
import org.openjump.core.apitools.IOTools;
import org.openjump.core.rasterimage.GridAscii;
import org.openjump.core.rasterimage.GridFloat;
import org.openjump.core.rasterimage.RasterImageLayer;
import org.openjump.core.ui.io.file.FileNameExtensionFilter;
import org.openjump.core.ui.plugin.file.open.JFCWithEnterAction;

public class ImageryUtils {
    static String fileNameOrURL = "";
    static String sourcePathImage = null;
    private static final String FILE_CHOOSER_DIRECTORY_KEY = SaveFileDataSourceQueryChooser.class.getName() + " - FILE CHOOSER DIRECTORY";
    private static final JFCWithEnterAction fileChooser = new GUIUtil.FileChooserWithOverwritePrompting();
    private static final FileNameExtensionFilter filter = new FileNameExtensionFilter("GeoTIFF", "tif");
    private static final String SAVE = I18N.getInstance().get("jump.plugin.edit.AffineTransformationPlugIn.save");
    private static final String ALLOWED_IMAGES = I18N.getInstance().get("jump.plugin.edit.AffineTransformationPlugIn.allowed-files");
    static WorkbenchContext wcontex = JUMPWorkbench.getInstance().getContext();

    @Deprecated
    public static boolean saveToTiff(File tiffFile, BufferedImage bufferedImage) {
        ImageOutputStream ios = null;
        ImageWriter writer = null;
        try {
            Iterator<ImageWriter> it = ImageIO.getImageWritersByFormatName("TIF");
            if (!it.hasNext()) {
                return false;
            }
            writer = it.next();
            ios = ImageIO.createImageOutputStream(tiffFile);
            writer.setOutput(ios);
            ImageWriteParam writeParam = new ImageWriteParam(Locale.ENGLISH);
            writeParam.setCompressionMode(2);
            writeParam.setCompressionType("LZW");
            IIOImage iioImage = new IIOImage(bufferedImage, null, null);
            writer.write(null, iioImage, writeParam);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean saveToPng(File pngFile, BufferedImage image) {
        try {
            ImageIO.write((RenderedImage)image, "png", pngFile);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean hasBeenModified(Layer layer) {
        FeatureCollectionWrapper featureCollection = layer.getFeatureCollectionWrapper();
        for (Feature feature : featureCollection) {
            sourcePathImage = feature.getString(ImageryLayerDataset.ATTR_URI);
            if (sourcePathImage == null || sourcePathImage.length() < 5) {
                sourcePathImage = "";
                continue;
            }
            sourcePathImage = sourcePathImage.substring(5);
        }
        fileNameOrURL = sourcePathImage.replace("%20", " ");
        GeoReferencedRaster geoRaster = null;
        try {
            geoRaster = new GeoReferencedRaster(fileNameOrURL);
        }
        catch (ReferencedImageException e) {
            e.printStackTrace();
        }
        Envelope originalEnv = geoRaster.getOriginalEnvelope();
        Envelope targetEnv = geoRaster.getEnvelope();
        return !targetEnv.equals((Object)originalEnv);
    }

    public static boolean isCompatibleImageLayer(Layer layer) {
        FeatureCollectionWrapper featureCollection = layer.getFeatureCollectionWrapper();
        for (Feature feature : featureCollection) {
            sourcePathImage = feature.getString(ImageryLayerDataset.ATTR_URI);
            if (sourcePathImage == null || sourcePathImage.length() < 5) {
                sourcePathImage = "";
                continue;
            }
            sourcePathImage = sourcePathImage.substring(5);
        }
        fileNameOrURL = sourcePathImage.replace("%20", " ");
        return fileNameOrURL.toLowerCase().endsWith(".jpg") || fileNameOrURL.toLowerCase().endsWith(".jpeg") || fileNameOrURL.toLowerCase().endsWith(".gif") || fileNameOrURL.toLowerCase().endsWith(".png") || fileNameOrURL.toLowerCase().endsWith(".bmp") || fileNameOrURL.toLowerCase().endsWith(".jp2") || fileNameOrURL.toLowerCase().endsWith(".tif") || fileNameOrURL.toLowerCase().endsWith(".tiff");
    }

    public static BufferedImage getBufferFromReferenceImageLayer2(Layer layer) throws IOException {
        FeatureCollectionWrapper featureCollection = layer.getFeatureCollectionWrapper();
        for (Feature feature : featureCollection) {
            sourcePathImage = feature.getString(ImageryLayerDataset.ATTR_URI);
            if (sourcePathImage == null || sourcePathImage.length() < 5) {
                sourcePathImage = "";
                continue;
            }
            sourcePathImage = sourcePathImage.substring(5);
        }
        fileNameOrURL = sourcePathImage.replace("%20", " ");
        BufferedImage bImage = null;
        FileImageInputStream is = new FileImageInputStream(new File(fileNameOrURL));
        ImageReader reader = ImageIO.getImageReaders(is).next();
        reader.setInput(is);
        bImage = reader.read(0);
        return bImage;
    }

    public static BufferedImage getBufferFromReferenceImageLayer(Layer layer) throws IOException {
        FeatureCollectionWrapper featureCollection = layer.getFeatureCollectionWrapper();
        for (Feature feature : featureCollection) {
            sourcePathImage = feature.getString(ImageryLayerDataset.ATTR_URI);
            if (sourcePathImage == null || sourcePathImage.length() < 5) {
                sourcePathImage = "";
                continue;
            }
            sourcePathImage = sourcePathImage.substring(5);
        }
        fileNameOrURL = sourcePathImage.replace("%20", " ");
        BufferedImage bImage = null;
        if (fileNameOrURL.toLowerCase().endsWith(".jpg") || fileNameOrURL.toLowerCase().endsWith(".gif") || fileNameOrURL.toLowerCase().endsWith(".png") || fileNameOrURL.toLowerCase().endsWith(".bmp") || fileNameOrURL.toLowerCase().endsWith(".jp2")) {
            try {
                bImage = ImageIO.read(new File(fileNameOrURL));
            }
            catch (Exception ex) {
                bImage = JAI.create((String)"fileload", (Object)fileNameOrURL).getAsBufferedImage();
            }
        }
        if (fileNameOrURL.toLowerCase().endsWith(".tif") || fileNameOrURL.toLowerCase().endsWith(".tiff")) {
            try {
                bImage = ImageIO.read(new File(fileNameOrURL));
            }
            catch (Exception ex) {
                FileSeekableStream stream = new FileSeekableStream(fileNameOrURL);
                TIFFDecodeParam decodeParam = new TIFFDecodeParam();
                decodeParam.setDecodePaletteAsShorts(true);
                ParameterBlock params = new ParameterBlock();
                params.add(stream);
                RenderedOp image1 = JAI.create((String)"tiff", (ParameterBlock)params);
                bImage = image1.getAsBufferedImage();
            }
        } else if (fileNameOrURL.toLowerCase().endsWith(".flt")) {
            try {
                GridFloat gf = new GridFloat(fileNameOrURL);
                gf.readGrid(null);
                bImage = gf.getBufferedImage();
            }
            catch (Exception ex) {
                bImage = ImageIO.read(new File(fileNameOrURL));
            }
        } else if (fileNameOrURL.toLowerCase().endsWith(".asc") || fileNameOrURL.toLowerCase().endsWith(".txt")) {
            try {
                GridAscii ga = new GridAscii(fileNameOrURL);
                ga.readGrid(null);
                bImage = ga.getBufferedImage();
            }
            catch (Exception ex) {
                bImage = ImageIO.read(new File(fileNameOrURL));
            }
        } else if (fileNameOrURL.toLowerCase().endsWith(".ecw")) {
            try {
                bImage = ImageIO.read(new File(fileNameOrURL));
            }
            catch (Exception ex) {
                bImage = ImageIO.read(new File(fileNameOrURL));
            }
        }
        return bImage;
    }

    public static BufferedImage addAlphaChannel(BufferedImage image) {
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics2D g2 = bufferedImage.createGraphics();
        g2.drawImage((Image)image, 0, 0, null);
        g2.dispose();
        return bufferedImage;
    }

    public static BufferedImage resizeImage(BufferedImage bufferedImage, int width, int height) {
        BufferedImage resizedImage = new BufferedImage(width, height, 2);
        Graphics2D g = resizedImage.createGraphics();
        g.drawImage(bufferedImage.getScaledInstance(width, height, 4), 0, 0, null);
        g.dispose();
        return resizedImage;
    }

    public static BufferedImage resizeImage_test(BufferedImage bufferedImage, int width, int height) {
        BufferedImage resizedImage = new BufferedImage(width, height, 2);
        Graphics2D g = resizedImage.createGraphics();
        g.drawImage(bufferedImage, 0, 0, width, height, null);
        g.setComposite(AlphaComposite.Src);
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.dispose();
        return resizedImage;
    }

    public static void affineTransformation(Layer layer, AffineTransformation trans, boolean resizeImageToHalf) throws Exception {
        try {
            fileChooser.setDialogTitle(SAVE);
            fileChooser.setFileFilter(filter);
            fileChooser.setDialogType(1);
            fileChooser.addChoosableFileFilter(filter);
            if (PersistentBlackboardPlugIn.get(wcontex).get(FILE_CHOOSER_DIRECTORY_KEY) != null) {
                fileChooser.setCurrentDirectory(new File((String)PersistentBlackboardPlugIn.get(wcontex).get(FILE_CHOOSER_DIRECTORY_KEY)));
            }
            File outFile = null;
            int option = fileChooser.showSaveDialog(wcontex.getWorkbench().getFrame());
            if (option == 0) {
                outFile = fileChooser.getSelectedFile();
                String filePath = outFile.getAbsolutePath();
                outFile = new File(filePath + ".tif");
                Envelope inEnvelope = new Envelope();
                BufferedImage InImageBuffer = ImageryUtils.getBufferFromReferenceImageLayer2(layer);
                InImageBuffer = ImageryUtils.addAlphaChannel(InImageBuffer);
                if (resizeImageToHalf) {
                    InImageBuffer = ImageryUtils.resizeImage(InImageBuffer, InImageBuffer.getWidth() / 2, InImageBuffer.getHeight() / 2);
                }
                inEnvelope.expandToInclude(layer.getFeatureCollectionWrapper().getEnvelope());
                Point P0 = new GeometryFactory().createPoint(new Coordinate(inEnvelope.getMinX(), inEnvelope.getMinY()));
                Point P1 = new GeometryFactory().createPoint(new Coordinate(inEnvelope.getMaxX(), inEnvelope.getMinY()));
                Point P2 = new GeometryFactory().createPoint(new Coordinate(inEnvelope.getMaxX(), inEnvelope.getMaxY()));
                Point P3 = new GeometryFactory().createPoint(new Coordinate(inEnvelope.getMinX(), inEnvelope.getMaxY()));
                Geometry P0_ = trans.transform((Geometry)P0);
                Geometry P1_ = trans.transform((Geometry)P1);
                Geometry P2_ = trans.transform((Geometry)P2);
                Geometry P3_ = trans.transform((Geometry)P3);
                WarpPerspective warp = new WarpPerspective(PerspectiveTransform.getQuadToQuad((double)P0.getCoordinate().x, (double)P0.getCoordinate().y, (double)P1.getCoordinate().x, (double)P1.getCoordinate().y, (double)P2.getCoordinate().x, (double)P2.getCoordinate().y, (double)P3.getCoordinate().x, (double)P3.getCoordinate().y, (double)P0_.getCoordinate().x, (double)P0_.getCoordinate().y, (double)P1_.getCoordinate().x, (double)P1_.getCoordinate().y, (double)P2_.getCoordinate().x, (double)P2_.getCoordinate().y, (double)P3_.getCoordinate().x, (double)P3_.getCoordinate().y));
                ParameterBlock pb = new ParameterBlock();
                pb.addSource(InImageBuffer);
                pb.add(warp);
                pb.add(new InterpolationNearest());
                RenderedOp outputOp = JAI.create((String)"warp", (ParameterBlock)pb);
                BufferedImage outImageBuffer = outputOp.getAsBufferedImage();
                GeometryFactory gf = new GeometryFactory();
                Geometry outGeometry = trans.transform(gf.toGeometry(inEnvelope));
                Envelope outEnvelope = outGeometry.getEnvelope().getEnvelopeInternal();
                layer.setVisible(false);
                outputOp.dispose();
                IOTools.saveGeoTIFF(outImageBuffer, outEnvelope, outFile);
                IOTools.loadImageAsLayer(outFile, wcontex, "tif");
            } else if (option == 1) {
                return;
            }
        }
        catch (RuntimeException localRuntimeException) {
            JOptionPane.showMessageDialog(null, ALLOWED_IMAGES, null, 1);
        }
    }

    public static void affineTransformation(RasterImageLayer layer, AffineTransformation trans, boolean resizeImageToHalf) throws Exception {
        try {
            fileChooser.setDialogTitle(SAVE);
            fileChooser.setFileFilter(filter);
            fileChooser.setDialogType(1);
            fileChooser.addChoosableFileFilter(filter);
            if (PersistentBlackboardPlugIn.get(wcontex).get(FILE_CHOOSER_DIRECTORY_KEY) != null) {
                fileChooser.setCurrentDirectory(new File((String)PersistentBlackboardPlugIn.get(wcontex).get(FILE_CHOOSER_DIRECTORY_KEY)));
            }
            File outFile = null;
            int option = fileChooser.showSaveDialog(wcontex.getWorkbench().getFrame());
            if (option == 0) {
                outFile = fileChooser.getSelectedFile();
                String filePath = outFile.getAbsolutePath();
                outFile = new File(filePath + ".tif");
                Envelope inEnvelope = new Envelope();
                BufferedImage InImageBuffer = layer.getImage();
                InImageBuffer = ImageryUtils.addAlphaChannel(InImageBuffer);
                if (resizeImageToHalf) {
                    InImageBuffer = ImageryUtils.resizeImage(InImageBuffer, InImageBuffer.getWidth() / 2, InImageBuffer.getHeight() / 2);
                }
                inEnvelope.expandToInclude(layer.getWholeImageEnvelope());
                Point P0 = new GeometryFactory().createPoint(new Coordinate(inEnvelope.getMinX(), inEnvelope.getMinY()));
                Point P1 = new GeometryFactory().createPoint(new Coordinate(inEnvelope.getMaxX(), inEnvelope.getMinY()));
                Point P2 = new GeometryFactory().createPoint(new Coordinate(inEnvelope.getMaxX(), inEnvelope.getMaxY()));
                Point P3 = new GeometryFactory().createPoint(new Coordinate(inEnvelope.getMinX(), inEnvelope.getMaxY()));
                Geometry P0_ = trans.transform((Geometry)P0);
                Geometry P1_ = trans.transform((Geometry)P1);
                Geometry P2_ = trans.transform((Geometry)P2);
                Geometry P3_ = trans.transform((Geometry)P3);
                WarpPerspective warp = new WarpPerspective(PerspectiveTransform.getQuadToQuad((double)P0.getCoordinate().x, (double)P0.getCoordinate().y, (double)P1.getCoordinate().x, (double)P1.getCoordinate().y, (double)P2.getCoordinate().x, (double)P2.getCoordinate().y, (double)P3.getCoordinate().x, (double)P3.getCoordinate().y, (double)P0_.getCoordinate().x, (double)P0_.getCoordinate().y, (double)P1_.getCoordinate().x, (double)P1_.getCoordinate().y, (double)P2_.getCoordinate().x, (double)P2_.getCoordinate().y, (double)P3_.getCoordinate().x, (double)P3_.getCoordinate().y));
                ParameterBlock pb = new ParameterBlock();
                pb.addSource(InImageBuffer);
                pb.add(warp);
                pb.add(new InterpolationNearest());
                RenderedOp outputOp = JAI.create((String)"warp", (ParameterBlock)pb);
                BufferedImage outImageBuffer = outputOp.getAsBufferedImage();
                GeometryFactory gf = new GeometryFactory();
                Geometry outGeometry = trans.transform(gf.toGeometry(inEnvelope));
                Envelope outEnvelope = outGeometry.getEnvelope().getEnvelopeInternal();
                layer.setVisible(false);
                outputOp.dispose();
                IOTools.saveGeoTIFF(outImageBuffer, outEnvelope, outFile);
                IOTools.loadImageAsLayer(outFile, wcontex, "tif");
            } else if (option == 1) {
                return;
            }
        }
        catch (RuntimeException localRuntimeException) {
            JOptionPane.showMessageDialog(null, ALLOWED_IMAGES, null, 1);
        }
    }
}

