/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.analysis;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureCollectionWrapper;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedPlugIn;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.GenericNames;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.SelectionManager;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.plugin.analysis.GeometryPredicate;
import com.vividsolutions.jump.workbench.ui.plugin.analysis.SpatialQueryExecuter;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JTextField;

public class SpatialQueryPlugIn
extends AbstractPlugIn
implements ThreadedPlugIn {
    private static String UPDATE_SRC = I18N.getInstance().get("ui.plugin.analysis.SpatialQueryPlugIn.Select-features-in-the-source-layer");
    private static String CREATE_LYR = I18N.getInstance().get("ui.plugin.analysis.SpatialQueryPlugIn.Create-a-new-layer-for-the-results");
    private static String MASK_LAYER = GenericNames.MASK_LAYER;
    private static String SRC_LAYER = GenericNames.SOURCE_LAYER;
    private static String PREDICATE = I18N.getInstance().get("ui.plugin.analysis.SpatialQueryPlugIn.Relation");
    private static String PARAM = GenericNames.PARAMETER;
    private static String DIALOG_COMPLEMENT = I18N.getInstance().get("ui.plugin.analysis.SpatialQueryPlugIn.Complement-Result");
    private static String ALLOW_DUPS = I18N.getInstance().get("ui.plugin.analysis.SpatialQueryPlugIn.Allow-Duplicates-in-Result");
    private JTextField paramField;
    private Collection functionNames;
    private Layer maskLyr;
    private Layer srcLayer;
    private String funcNameToRun;
    private GeometryPredicate functionToRun = null;
    private boolean complementResult = false;
    private boolean allowDups = false;
    private boolean createLayer = true;
    private double[] params = new double[2];
    private String categoryName = StandardCategoryNames.RESULT;

    public SpatialQueryPlugIn() {
        this.functionNames = GeometryPredicate.getNames();
    }

    public void setCategoryName(String value) {
        this.categoryName = value;
    }

    @Override
    public String getName() {
        return I18N.getInstance().get("ui.plugin.analysis.SpatialQueryPlugIn.Spatial-Query");
    }

    @Override
    public ImageIcon getIcon() {
        return IconLoader.icon("spatial_query.png");
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
        context.getFeatureInstaller().addMainMenuPlugin(this, new String[]{MenuNames.TOOLS, MenuNames.TOOLS_QUERIES});
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()).add(checkFactory.createAtLeastNLayersMustExistCheck(1));
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        MultiInputDialog dialog = new MultiInputDialog(context.getWorkbenchFrame(), this.getName(), true);
        this.setDialogValues(dialog, context);
        GUIUtil.centreOnWindow(dialog);
        dialog.setVisible(true);
        if (!dialog.wasOKPressed()) {
            return false;
        }
        this.getDialogValues(dialog);
        return true;
    }

    @Override
    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        monitor.allowCancellationRequests();
        if (this.functionToRun == null) {
            return;
        }
        if (this.maskLyr == null) {
            return;
        }
        if (this.srcLayer == null) {
            return;
        }
        monitor.report(I18N.getInstance().get("ui.plugin.analysis.SpatialQueryPlugIn.Executing-query") + " " + this.functionToRun.getName() + "...");
        FeatureCollectionWrapper maskFC = this.maskLyr.getFeatureCollectionWrapper();
        FeatureCollectionWrapper sourceFC = this.srcLayer.getFeatureCollectionWrapper();
        SpatialQueryExecuter executer = new SpatialQueryExecuter(maskFC, sourceFC);
        executer.setAllowDuplicates(this.allowDups);
        executer.setComplementResult(this.complementResult);
        executer.setCreateNewLayer(this.createLayer);
        FeatureCollection resultFC = executer.getResultFC();
        executer.execute(monitor, this.functionToRun, this.params, resultFC);
        if (monitor.isCancelRequested()) {
            return;
        }
        if (this.createLayer) {
            String outputLayerName = this.srcLayer.getName() + "_" + this.funcNameToRun + "_";
            if (this.functionToRun.getParameterCount() == 1) {
                outputLayerName = outputLayerName + this.paramField.getText() + "_";
            }
            outputLayerName = outputLayerName + this.maskLyr.getName();
            if (this.complementResult) {
                outputLayerName = outputLayerName + "_" + I18N.getInstance().get("ui.plugin.analysis.SpatialQueryPlugIn.Complement");
            }
            context.getLayerManager().addCategory(this.categoryName);
            context.addLayer(this.categoryName, outputLayerName, resultFC);
        } else {
            SelectionManager selectionManager = context.getLayerViewPanel().getSelectionManager();
            selectionManager.clear();
            selectionManager.getFeatureSelection().selectItems(this.srcLayer, resultFC.getFeatures());
        }
        if (executer.isExceptionThrown()) {
            context.getWorkbenchFrame().warnUser(I18N.getInstance().get("ui.plugin.analysis.SpatialQueryPlugIn.Errors-found-while-executing-query") + ":" + executer.getException());
        }
    }

    private void setDialogValues(MultiInputDialog dialog, PlugInContext context) {
        dialog.setSideBarDescription(I18N.getInstance().get("ui.plugin.analysis.SpatialQueryPlugIn.Finds-the-Source-features-which-have-a-given-spatial-relationship-to-some-feature-in-the-Mask-layer") + " (" + I18N.getInstance().get("ui.plugin.analysis.SpatialQueryPlugIn.ie-where-Source.Relationship(Mask)-is-true") + ")");
        Layer initLayer = context.getCandidateLayer(0);
        dialog.addLayerComboBox(SRC_LAYER, initLayer, context.getLayerManager());
        JComboBox<String> functionComboBox = dialog.addComboBox(PREDICATE, this.funcNameToRun, this.functionNames, null);
        functionComboBox.addItemListener(new MethodItemListener());
        this.maskLyr = context.getLayerManager().size() > 1 ? context.getCandidateLayer(1) : initLayer;
        dialog.addLayerComboBox(MASK_LAYER, this.maskLyr, context.getLayerManager());
        this.paramField = dialog.addDoubleField(PARAM, this.params[0], 10);
        dialog.addCheckBox(ALLOW_DUPS, this.allowDups);
        dialog.addCheckBox(DIALOG_COMPLEMENT, this.complementResult);
        String OUTPUT_GROUP = "OUTPUT_GROUP";
        dialog.addRadioButton(CREATE_LYR, "OUTPUT_GROUP", this.createLayer, CREATE_LYR);
        dialog.addRadioButton(UPDATE_SRC, "OUTPUT_GROUP", !this.createLayer, UPDATE_SRC);
        this.updateUIForFunction(this.funcNameToRun);
    }

    private void getDialogValues(MultiInputDialog dialog) {
        this.maskLyr = dialog.getLayer(MASK_LAYER);
        this.srcLayer = dialog.getLayer(SRC_LAYER);
        this.funcNameToRun = dialog.getText(PREDICATE);
        this.functionToRun = GeometryPredicate.getPredicate(this.funcNameToRun);
        this.params[0] = dialog.getDouble(PARAM);
        this.allowDups = dialog.getBoolean(ALLOW_DUPS);
        this.complementResult = dialog.getBoolean(DIALOG_COMPLEMENT);
        this.createLayer = dialog.getBoolean(CREATE_LYR);
    }

    private void updateUIForFunction(String funcName) {
        boolean paramUsed = false;
        GeometryPredicate func = GeometryPredicate.getPredicate(funcName);
        if (func != null) {
            paramUsed = func.getParameterCount() > 0;
        }
        this.paramField.setEnabled(paramUsed);
        this.paramField.setOpaque(paramUsed);
    }

    private class MethodItemListener
    implements ItemListener {
        private MethodItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            SpatialQueryPlugIn.this.updateUIForFunction((String)e.getItem());
        }
    }
}

