/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.analysis;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.FeatureEventType;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.AttributeTypeFilter;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.locationtech.jts.geom.Geometry;

public class CalculateAreasAndLengthsPlugIn
extends AbstractPlugIn {
    private static String LAYER_COMBO_BOX = I18N.getInstance().get("ui.plugin.analysis.CalculateAreasAndLengthsPlugIn.layer");
    private static String AREA_COMBO_BOX = I18N.getInstance().get("ui.plugin.analysis.CalculateAreasAndLengthsPlugIn.area-attribute-name");
    private static String LENGTH_COMBO_BOX = I18N.getInstance().get("ui.plugin.analysis.CalculateAreasAndLengthsPlugIn.length-attribute-name");
    private static String LENGTH_CHECK_BOX = I18N.getInstance().get("ui.plugin.analysis.CalculateAreasAndLengthsPlugIn.calculate-length");
    private static String AREA_CHECK_BOX = I18N.getInstance().get("ui.plugin.analysis.CalculateAreasAndLengthsPlugIn.calculate-area");
    private Layer layer;
    private boolean setLength;
    private boolean setArea;
    private String lengthAttribute;
    private String areaAttribute;
    private Map<AttributeType, Converter> typeToConverterMap = new HashMap<AttributeType, Converter>(){
        {
            this.put(AttributeType.STRING, new Converter(){

                @Override
                public Object convert(double d) {
                    return "" + d;
                }
            });
            this.put(AttributeType.INTEGER, new Converter(){

                @Override
                public Object convert(double d) {
                    return (int)d;
                }
            });
            this.put(AttributeType.LONG, new Converter(){

                @Override
                public Object convert(double d) {
                    return (long)d;
                }
            });
            this.put(AttributeType.DOUBLE, new Converter(){

                @Override
                public Object convert(double d) {
                    return d;
                }
            });
        }
    };

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
        context.getFeatureInstaller().addMainMenuPlugin(this, new String[]{MenuNames.TOOLS, MenuNames.TOOLS_EDIT_ATTRIBUTES}, this.getName() + "...", false, null, this.createEnableCheck(context.getWorkbenchContext()));
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        MultiInputDialog dialog = this.prompt(context);
        if (!dialog.wasOKPressed()) {
            return false;
        }
        this.getDialogValues(dialog);
        if (this.setArea) {
            this.updateAreas(this.layer, this.areaAttribute);
        }
        if (this.setLength) {
            this.updateLengths(this.layer, this.lengthAttribute);
        }
        context.getLayerManager().fireFeaturesChanged(this.layer.getFeatureCollectionWrapper().getFeatures(), FeatureEventType.ATTRIBUTES_MODIFIED, this.layer);
        return true;
    }

    private MultiInputDialog prompt(PlugInContext context) {
        MultiInputDialog dialog = new MultiInputDialog(context.getWorkbenchFrame(), this.getName(), true);
        dialog.addLayerComboBox(LAYER_COMBO_BOX, context.getLayerableNamePanel().chooseEditableLayer(), "", context.getLayerManager().getEditableLayers());
        dialog.addCheckBox(AREA_CHECK_BOX, this.setArea);
        dialog.addAttributeComboBox(AREA_COMBO_BOX, LAYER_COMBO_BOX, AttributeTypeFilter.NUMSTRING_FILTER, "");
        dialog.addCheckBox(LENGTH_CHECK_BOX, this.setLength);
        dialog.addAttributeComboBox(LENGTH_COMBO_BOX, LAYER_COMBO_BOX, AttributeTypeFilter.NUMSTRING_FILTER, "");
        this.initEnableChecks(dialog);
        GUIUtil.centreOnWindow(dialog);
        dialog.setVisible(true);
        return dialog;
    }

    private void getDialogValues(MultiInputDialog dialog) {
        this.layer = dialog.getLayer(LAYER_COMBO_BOX);
        this.setLength = dialog.getBoolean(LENGTH_CHECK_BOX);
        this.lengthAttribute = dialog.getText(LENGTH_COMBO_BOX);
        this.setArea = dialog.getBoolean(AREA_CHECK_BOX);
        this.areaAttribute = dialog.getText(AREA_COMBO_BOX);
    }

    private void initEnableChecks(final MultiInputDialog dialog) {
        dialog.addEnableChecks(LENGTH_COMBO_BOX, new EnableCheck(){

            @Override
            public String check(JComponent component) {
                return dialog.getBoolean(AREA_CHECK_BOX) && dialog.getBoolean(LENGTH_CHECK_BOX) && dialog.getText(AREA_COMBO_BOX).equals(dialog.getText(LENGTH_COMBO_BOX)) ? I18N.getInstance().get("ui.plugin.analysis.CalculateAreasAndLengthsPlugIn.area-and-length-attribute-names-must-be-different") : null;
            }
        });
    }

    private void updateLengths(Layer layer, String attributeName) {
        this.update(layer, attributeName, new Op(){

            @Override
            public double compute(Geometry g) {
                return g.getLength();
            }
        });
    }

    private void update(Layer layer, String attributeName, Op op) {
        int attributeIndex = layer.getFeatureCollectionWrapper().getFeatureSchema().getAttributeIndex(attributeName);
        AttributeType attributeType = layer.getFeatureCollectionWrapper().getFeatureSchema().getAttributeType(attributeIndex);
        for (Feature feature : layer.getFeatureCollectionWrapper().getFeatures()) {
            feature.setAttribute(attributeIndex, this.convert(op.compute(feature.getGeometry()), attributeType));
        }
    }

    private Object convert(double d, AttributeType attributeType) {
        return this.typeToConverterMap.get(attributeType).convert(d);
    }

    private void updateAreas(Layer layer, String attributeName) {
        this.update(layer, attributeName, new Op(){

            @Override
            public double compute(Geometry g) {
                return g.getArea();
            }
        });
    }

    public MultiEnableCheck createEnableCheck(final WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerManagerMustBeActiveCheck()).add(checkFactory.createAtLeastNLayersMustExistCheck(1)).add(checkFactory.createAtLeastNLayersMustBeEditableCheck(1)).add(new EnableCheck(){

            @Override
            public String check(JComponent component) {
                List<Layer> layers = AttributeTypeFilter.NUMSTRING_FILTER.filter(workbenchContext.getLayerManager());
                boolean candidateLayerFound = false;
                for (Layer layer : layers) {
                    if (!layer.isEditable()) continue;
                    candidateLayerFound = true;
                    break;
                }
                if (candidateLayerFound) {
                    return null;
                }
                return I18N.getInstance().get("ui.plugin.analysis.CalculateAreasAndLengthsPlugIn.no-editable-layer-with-required-attributes");
            }
        });
    }

    private static interface Op {
        public double compute(Geometry var1);
    }

    private static interface Converter {
        public Object convert(double var1);
    }
}

