/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.plugin.PlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.AttributeTab;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.TitledPopupMenu;
import com.vividsolutions.jump.workbench.ui.WorkbenchToolBar;
import com.vividsolutions.jump.workbench.ui.cursortool.CursorTool;
import com.vividsolutions.jump.workbench.ui.cursortool.DelegatingTool;
import com.vividsolutions.jump.workbench.ui.cursortool.LeftClickFilter;
import com.vividsolutions.jump.workbench.ui.cursortool.MultiClickTool;
import com.vividsolutions.jump.workbench.ui.cursortool.NClickTool;
import com.vividsolutions.jump.workbench.ui.cursortool.QuasimodeTool;
import com.vividsolutions.jump.workbench.ui.cursortool.ShortcutsDescriptor;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.EditingPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;
import com.vividsolutions.jump.workbench.ui.plugin.ShortcutKeysPlugIn;
import de.soldin.awt.VerticalFlowLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import org.openjump.core.ui.plugin.edittoolbox.cursortools.ConstrainedMultiClickTool;

final class ShortcutKeysFrame
extends JFrame {
    JLabel shortsLabel = new JLabel();
    JPanel shortsPanel = new JPanel();
    JPanel buttonPanel = new JPanel();
    JButton okButton = new JButton();
    private PlugInContext context;

    protected ShortcutKeysFrame(PlugInContext context) {
        super(ShortcutKeysPlugIn.NAME);
        this.context = context;
        try {
            this.setIconImage(ShortcutKeysPlugIn.ICON.getImage());
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        VerticalFlowLayout l = new VerticalFlowLayout(0);
        l.setHgap(20);
        l.setVgap(0);
        l.setDefaultRatio(1.0);
        this.shortsPanel.setLayout(l);
        for (String html : this.buildOverviews()) {
            for (JLabel lbl : this.buildTableLabels(html, 3)) {
                this.shortsPanel.add(lbl);
            }
            this.shortsPanel.add(Box.createRigidArea(new Dimension(10, 10)));
        }
        for (String html : this.buildQuasiModeOverviews()) {
            this.shortsPanel.add(this.buildTableLabel(html));
            this.shortsPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        }
        for (String html : this.buildEditingOverviews()) {
            this.shortsPanel.add(this.buildTableLabel(html, 300));
        }
        this.shortsPanel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        JScrollPane scroll = new JScrollPane(this.shortsPanel);
        this.add((Component)scroll, "Center");
        this.okButton.setText(I18N.getInstance().get("ui.OKCancelPanel.ok"));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShortcutKeysFrame.this.setVisible(false);
            }
        });
        this.add((Component)this.buttonPanel, "South");
        this.buttonPanel.add((Component)this.okButton, null);
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.pack();
            GUIUtil.centre(this, this.context.getWorkbenchFrame());
        }
        super.setVisible(b);
    }

    private static MenuElement[] getAllMenuElements(MenuElement menu_in) {
        Vector<MenuElement> elements = new Vector<MenuElement>();
        for (MenuElement menu_element : menu_in.getSubElements()) {
            if (menu_element.getSubElements().length > 0) {
                elements.addAll(Arrays.asList(ShortcutKeysFrame.getAllMenuElements(menu_element)));
                continue;
            }
            elements.add(menu_element);
        }
        return elements.toArray(new MenuElement[0]);
    }

    private List<String> buildOverviews() {
        JUMPWorkbench wb = JUMPWorkbench.getInstance();
        FeatureInstaller finst = this.context.getFeatureInstaller();
        JMenuBar mainMenu = finst.menuBar();
        JPopupMenu layerview_popup = LayerViewPanel.popupMenu();
        TitledPopupMenu layername_popup = wb.getFrame().getLayerNamePopupMenu();
        TitledPopupMenu layernamecategory_popup = wb.getFrame().getCategoryPopupMenu();
        TitledPopupMenu attribute_popup = AttributeTab.popupMenu(JUMPWorkbench.getInstance().getContext());
        WorkbenchToolBar toolbar = wb.getFrame().getToolBar();
        WorkbenchToolBar edittoolbar = ((EditingPlugIn)JUMPWorkbench.getInstance().getContext().getBlackboard().get(EditingPlugIn.KEY)).getToolbox(wb.getContext()).getToolBar();
        LinkedHashMap<String, HashMap<KeyStroke, PlugIn>> categories = new LinkedHashMap<String, HashMap<KeyStroke, PlugIn>>();
        for (MenuElement main_menu_entry : mainMenu.getSubElements()) {
            if (!(main_menu_entry instanceof JMenuItem)) continue;
            JMenuItem main_menu_item = (JMenuItem)main_menu_entry;
            Vector<MenuElement> menu_elements = new Vector<MenuElement>();
            menu_elements.addAll(Arrays.asList(ShortcutKeysFrame.getAllMenuElements(main_menu_entry)));
            if (main_menu_item.getText() == MenuNames.EDIT) {
                menu_elements.addAll(Arrays.asList(ShortcutKeysFrame.getAllMenuElements(layerview_popup)));
                menu_elements.addAll(Arrays.asList(ShortcutKeysFrame.getAllMenuElements(attribute_popup)));
            } else if (main_menu_item.getText() == MenuNames.LAYER) {
                menu_elements.addAll(Arrays.asList(ShortcutKeysFrame.getAllMenuElements(layername_popup)));
                menu_elements.addAll(Arrays.asList(ShortcutKeysFrame.getAllMenuElements(layernamecategory_popup)));
            }
            LinkedHashMap<String, PlugIn> shortcut_plugins = new LinkedHashMap<String, PlugIn>();
            categories.put(main_menu_item.getText(), shortcut_plugins);
            for (MenuElement menu_entry : menu_elements) {
                if (!(menu_entry instanceof JMenuItem)) continue;
                JMenuItem menu_item = (JMenuItem)menu_entry;
                KeyStroke stroke = ((JMenuItem)menu_entry).getAccelerator();
                if (stroke == null) continue;
                PlugIn plugin = wb.getFrame().getKeyboardShortcutPlugin(stroke);
                if (plugin != null) {
                    if (this.strokeInMap(stroke, categories)) continue;
                    shortcut_plugins.put(this.getKeyStrokeText(stroke), plugin);
                    continue;
                }
                System.err.println(this.getClass().getSimpleName() + " menuitem '" + menu_item.getText() + "' has a shortcut which is not registered with the workbench.");
            }
        }
        LinkedHashMap<String, PlugIn> shortcut_plugins = new LinkedHashMap<String, PlugIn>();
        categories.put(I18N.getInstance().get(ShortcutKeysPlugIn.getClassName() + ".more"), shortcut_plugins);
        for (KeyStroke key : wb.getFrame().getKeyboardShortcuts()) {
            if (this.strokeInMap(key, categories)) continue;
            shortcut_plugins.put(this.getKeyStrokeText(key), wb.getFrame().getKeyboardShortcutPlugin(key));
        }
        ArrayList<String> overviews = new ArrayList<String>();
        for (String name : ((HashMap)categories).keySet()) {
            String out = "";
            HashMap entries = (HashMap)((HashMap)categories).get(name);
            for (Map.Entry entry : entries.entrySet()) {
                String description = entry.getValue() instanceof PlugIn ? ((PlugIn)entry.getValue()).getName() : (entry.getValue() instanceof CursorTool ? ((CursorTool)entry.getValue()).getName() : entry.getValue().toString());
                out = out + "<tr><td>" + GUIUtil.escapeHTML(description) + "</td><td width=100>" + GUIUtil.escapeHTML((String)entry.getKey()) + "</td></tr>\n";
            }
            if (out.length() <= 0) continue;
            overviews.add("<tr><td colspan=2><b><center><u>" + GUIUtil.escapeHTML(name) + "</u></center></b></td></tr>\n" + out);
        }
        return overviews;
    }

    private List<String> buildQuasiModeOverviews() {
        HashMap categories = new HashMap();
        LinkedHashMap<String, CursorTool> shortcut_plugins = new LinkedHashMap<String, CursorTool>();
        categories.put(I18N.getInstance().get(ShortcutKeysPlugIn.getClassName() + ".cursortools-quasimodes"), shortcut_plugins);
        for (QuasimodeTool.ModifierKeySpec key : QuasimodeTool.getDefaultKeyboardShortcuts()) {
            CursorTool ct = QuasimodeTool.getDefaultKeyboardShortcutTool(key);
            if (ct == null || shortcut_plugins.values().contains(ct)) continue;
            shortcut_plugins.put(key.toString(), ct);
        }
        ArrayList<String> overviews = new ArrayList<String>();
        for (String name : categories.keySet()) {
            String out = "";
            HashMap entries = (HashMap)categories.get(name);
            for (Map.Entry entry : entries.entrySet()) {
                String description = entry.getValue() instanceof PlugIn ? ((PlugIn)entry.getValue()).getName() : (entry.getValue() instanceof CursorTool ? ((CursorTool)entry.getValue()).getName() : entry.getValue().toString());
                out = out + "<tr><td>" + GUIUtil.escapeHTML(description) + "</td><td>" + GUIUtil.escapeHTML((String)entry.getKey()) + "</td></tr>\n";
            }
            overviews.add("<tr><td colspan=2><b><center><u>" + GUIUtil.escapeHTML(name) + "</u></center></b></td></tr>\n" + out);
        }
        return overviews;
    }

    private List<String> buildEditingOverviews() {
        LinkedHashMap editing_options = new LinkedHashMap();
        String tools_out = "";
        List tools = EditingPlugIn.getInstance().getToolbox().getPluginsTools();
        tools.add(0, new ShortcutsDescriptor(){

            @Override
            public String getName() {
                return I18N.getInstance().get(ShortcutKeysPlugIn.getClassName() + ".all-editing-tools");
            }

            @Override
            public Map<QuasimodeTool.ModifierKeySpec, String> describeShortcuts() {
                HashMap<QuasimodeTool.ModifierKeySpec, String> map = new HashMap<QuasimodeTool.ModifierKeySpec, String>();
                map.put(new QuasimodeTool.ModifierKeySpec(new int[]{32}), I18N.getInstance().get(ShortcutKeysPlugIn.getClassName() + ".temporarily-switch-off-snapping"));
                return map;
            }
        });
        tools.add(1, new ShortcutsDescriptor(){

            @Override
            public String getName() {
                List tools = EditingPlugIn.getInstance().getToolbox().getPluginsTools();
                String out = "";
                for (Object tool : tools) {
                    if (!((tool = ShortcutKeysFrame.this.unWrapTool(tool)) instanceof ConstrainedMultiClickTool) && (!(tool instanceof MultiClickTool) || tool instanceof NClickTool && ((NClickTool)tool).numClicks() < 2)) continue;
                    out = out + (out.length() > 0 ? ", " : "") + ((CursorTool)tool).getName();
                }
                return out;
            }

            @Override
            public Map<QuasimodeTool.ModifierKeySpec, String> describeShortcuts() {
                HashMap<QuasimodeTool.ModifierKeySpec, String> map = new HashMap<QuasimodeTool.ModifierKeySpec, String>();
                map.put(new QuasimodeTool.ModifierKeySpec(new int[]{8}), I18N.getInstance().get(MultiClickTool.class.getName() + ".erase-last-segment-or-point"));
                map.put(new QuasimodeTool.ModifierKeySpec(new int[]{27}), I18N.getInstance().get(MultiClickTool.class.getName() + ".cancel-drawing"));
                map.put(new QuasimodeTool.ModifierKeySpec(new int[]{10}), I18N.getInstance().get(MultiClickTool.class.getName() + ".finish-drawing"));
                return map;
            }
        });
        int i = 0;
        ArrayList<String> entries = new ArrayList<String>();
        for (Object tool : tools) {
            String tool_out = "";
            tool = this.unWrapTool(tool);
            ++i;
            if (tool instanceof ShortcutsDescriptor) {
                ShortcutsDescriptor shorty = (ShortcutsDescriptor)tool;
                Map<QuasimodeTool.ModifierKeySpec, String> description = shorty.describeShortcuts();
                if (description == null) continue;
                tool_out = tool_out + "<tr><td colspan=3><b>" + (tool_out.length() < 1 ? "" : "&nbsp;<br>") + "" + GUIUtil.escapeHTML(shorty.getName()) + "</b></td></tr>\n";
                Map<QuasimodeTool.ModifierKeySpec, String> options = description;
                for (QuasimodeTool.ModifierKeySpec sc : options.keySet()) {
                    tool_out = tool_out + "<tr><td>&nbsp;</td><td>" + GUIUtil.escapeHTML(options.get(sc)) + "</td><td>" + GUIUtil.escapeHTML(sc.toString()) + "</td></tr>\n";
                }
            }
            if (i == 1) {
                tool_out = "<tr><td colspan=2><b><center><u>" + GUIUtil.escapeHTML(I18N.getInstance().get(ShortcutKeysPlugIn.getClassName() + ".editing-tools-options")) + "</u></center></b></td></tr>\n" + tool_out;
            }
            if (i <= 2) {
                entries.add(tool_out);
                continue;
            }
            tools_out = tools_out + tool_out;
        }
        entries.add(tools_out);
        return entries;
    }

    private JLabel buildTableLabel(String in) {
        return this.buildTableLabel(in, 300);
    }

    private JLabel buildTableLabel(String in, int width) {
        return new JLabel("<html><body><table width=" + width + ">\n" + in + "\n</table></body></html>");
    }

    private List<JLabel> buildTableLabels(String in, int linecount) {
        String[] lines = in.split("\n");
        Vector<JLabel> labels = new Vector<JLabel>();
        String buf = "";
        for (int i = 0; i < lines.length; ++i) {
            buf = buf + lines[i] + "\n";
            if ((i + 1) % linecount != 0) continue;
            labels.add(this.buildTableLabel(buf));
            buf = "";
        }
        if (buf.length() > 0) {
            labels.add(this.buildTableLabel(buf));
        }
        return labels;
    }

    private String getKeyStrokeText(KeyStroke stroke) {
        String mod = KeyEvent.getModifiersExText(stroke.getModifiers());
        String out = (mod.length() > 0 ? mod + "+" : "") + KeyEvent.getKeyText(stroke.getKeyCode());
        return out;
    }

    private boolean strokeInMap(KeyStroke st, HashMap<String, HashMap<KeyStroke, PlugIn>> map) {
        for (HashMap<KeyStroke, PlugIn> submap : map.values()) {
            if (!submap.containsKey(this.getKeyStrokeText(st))) continue;
            return true;
        }
        return false;
    }

    private Object unWrapTool(Object tool) {
        boolean unwrapped;
        do {
            unwrapped = false;
            if (tool instanceof QuasimodeTool) {
                tool = ((QuasimodeTool)tool).getDefaultTool();
                unwrapped = true;
            }
            if (tool instanceof LeftClickFilter) {
                tool = ((LeftClickFilter)tool).getWrappee();
                unwrapped = true;
            }
            if (!(tool instanceof DelegatingTool)) continue;
            tool = ((DelegatingTool)tool).getDelegate();
            unwrapped = true;
        } while (unwrapped);
        return tool;
    }
}

