/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.FileUtil;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.plugin.SaveProjectAsPlugIn;
import java.util.Collection;
import javax.swing.ImageIcon;
import org.openjump.core.ui.plugin.file.SaveLayersWithoutDataSourcePlugIn;

public class SaveProjectPlugIn
extends SaveProjectAsPlugIn {
    public static final ImageIcon ICON = IconLoader.icon("disk_oj.v3.png");

    public SaveProjectPlugIn() {
        this.setShortcutKeys(83);
        this.setShortcutModifiers(2);
    }

    @Override
    public String getName() {
        return I18N.getInstance().get("ui.plugin.SaveProjectPlugIn.save-project");
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.reportNothingToUndoYet(context);
        if (context.getTask().getProjectFile() == null) {
            return super.execute(context);
        }
        Collection<Layer> collection = this.ignoredLayers(context.getTask());
        if (collection.size() > 0) {
            new SaveLayersWithoutDataSourcePlugIn().execute(context, collection, FileUtil.removeExtensionIfAny(context.getTask().getProjectFile()));
        }
        this.save(context.getTask(), context.getTask().getProjectFile(), context.getWorkbenchFrame());
        return true;
    }
}

