/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.util.FileUtil;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.plugin.AbstractSaveProjectPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import java.io.File;
import java.util.Collection;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.openjump.core.ui.plugin.file.SaveLayersWithoutDataSourcePlugIn;

public class SaveProjectAsPlugIn
extends AbstractSaveProjectPlugIn {
    public static final ImageIcon ICON = IconLoader.icon("disk_oj_dots.png");
    public static final String FILE_CHOOSER_DIRECTORY_KEY = SaveProjectAsPlugIn.class.getName() + " - FILE CHOOSER DIRECTORY";
    public static final FileFilter JUMP_PROJECT_FILE_FILTER = GUIUtil.createFileFilter(I18N.getInstance().get("ui.plugin.SaveProjectAsPlugIn.jump-project-files"), new String[]{"jmp", "jcs"});
    private JFileChooser fileChooser;

    public SaveProjectAsPlugIn() {
        this.setShortcutKeys(83);
        this.setShortcutModifiers(3);
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
        this.fileChooser = GUIUtil.createJFileChooserWithOverwritePrompting("jmp");
        this.fileChooser.setDialogTitle(I18N.getInstance().get("ui.plugin.SaveProjectAsPlugIn.save-project"));
        GUIUtil.removeChoosableFileFilters(this.fileChooser);
        this.fileChooser.addChoosableFileFilter(JUMP_PROJECT_FILE_FILTER);
        this.fileChooser.addChoosableFileFilter(GUIUtil.ALL_FILES_FILTER);
        this.fileChooser.setFileFilter(JUMP_PROJECT_FILE_FILTER);
        Blackboard blackboard = PersistentBlackboardPlugIn.get(context.getWorkbenchContext());
        String dir = (String)blackboard.get(FILE_CHOOSER_DIRECTORY_KEY);
        if (dir != null && new File(dir).exists()) {
            try {
                this.fileChooser.setCurrentDirectory(new File(dir));
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    @Override
    public String getName() {
        return I18N.getInstance().get("ui.plugin.SaveProjectAsPlugIn.save-project-as");
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.reportNothingToUndoYet(context);
        if (context.getTask().getProjectFile() != null) {
            this.fileChooser.setSelectedFile(context.getTask().getProjectFile());
        }
        if (0 != this.fileChooser.showSaveDialog(context.getWorkbenchFrame())) {
            return false;
        }
        File file = this.fileChooser.getSelectedFile();
        Collection<Layer> collection = this.ignoredLayers(context.getTask());
        if (collection.size() > 0) {
            new SaveLayersWithoutDataSourcePlugIn().execute(context, collection, FileUtil.removeExtensionIfAny(file));
        }
        file = FileUtil.addExtensionIfNone(file, "jmp");
        this.save(context.getTask(), file, context.getWorkbenchFrame());
        context.getWorkbenchContext().getBlackboard().put(FILE_CHOOSER_DIRECTORY_KEY, file.getAbsoluteFile().getParent());
        PersistentBlackboardPlugIn.get(context.getWorkbenchContext()).put(FILE_CHOOSER_DIRECTORY_KEY, file.getAbsoluteFile().getParent());
        return true;
    }
}

