/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.model.UndoableCommand;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.LayerNamePanel;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.locationtech.jts.util.Assert;

public class RemoveSelectedCategoriesPlugIn
extends AbstractPlugIn {
    private Category pickUnselectedCategory(LayerNamePanel layerNamePanel, LayerManager layerManager) {
        Collection<Category> selectedCategories = layerNamePanel.getSelectedCategories();
        Category workingCategory = layerManager.getCategory(StandardCategoryNames.WORKING);
        if (workingCategory != null && !selectedCategories.contains(workingCategory)) {
            return workingCategory;
        }
        for (Category category : layerManager.getCategories()) {
            if (selectedCategories.contains(category)) continue;
            return category;
        }
        return null;
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.execute(this.toCategorySpecToLayerablesMap(this.toOrderedCategories(context.getLayerNamePanel().getSelectedCategories())), this.pickUnselectedCategory(context.getLayerNamePanel(), context.getLayerManager()), context);
        return true;
    }

    private List<Category> toOrderedCategories(Collection<Category> unorderedCategories) {
        ArrayList<Category> orderedCategories = new ArrayList<Category>(unorderedCategories);
        Collections.sort(orderedCategories, new Comparator<Category>(){

            @Override
            public int compare(Category c1, Category c2) {
                return new Integer(c1.getLayerManager().indexOf(c1)).compareTo(new Integer(c2.getLayerManager().indexOf(c2)));
            }
        });
        return orderedCategories;
    }

    private Map<CategorySpec, List<Layerable>> toCategorySpecToLayerablesMap(List<Category> selectedCategoriesInOrder) {
        LinkedHashMap<CategorySpec, List<Layerable>> map = new LinkedHashMap<CategorySpec, List<Layerable>>();
        for (Category category : selectedCategoriesInOrder) {
            map.put(new CategorySpec(category.getName(), category.getLayerManager().indexOf(category)), new ArrayList<Layerable>(category.getLayerables()));
        }
        return map;
    }

    private void execute(final Map originalCategorySpecToLayerablesMap, final Category newCategory, final PlugInContext context) throws Exception {
        this.execute(new UndoableCommand(this.getName()){

            @Override
            public void execute() {
                for (CategorySpec originalCategorySpec : originalCategorySpecToLayerablesMap.keySet()) {
                    List layers = (List)originalCategorySpecToLayerablesMap.get(originalCategorySpec);
                    for (Layerable layerable : layers) {
                        context.getLayerManager().remove(layerable);
                        context.getLayerManager().addLayerable(newCategory.getName(), layerable);
                    }
                    context.getLayerManager().removeIfEmpty(context.getLayerManager().getCategory(originalCategorySpec.name));
                }
            }

            @Override
            public void unexecute() {
                for (CategorySpec originalCategorySpec : originalCategorySpecToLayerablesMap.keySet()) {
                    List layers = (List)originalCategorySpecToLayerablesMap.get(originalCategorySpec);
                    Assert.isTrue((null == context.getLayerManager().getCategory(originalCategorySpec.name) ? 1 : 0) != 0);
                    context.getLayerManager().addCategory(originalCategorySpec.name, originalCategorySpec.index);
                    for (Layerable layerable : layers) {
                        Assert.isTrue((context.getLayerManager().getCategory(layerable) == newCategory ? 1 : 0) != 0);
                        context.getLayerManager().remove(layerable);
                        context.getLayerManager().addLayerable(originalCategorySpec.name, layerable);
                    }
                }
            }
        }, context);
    }

    public MultiEnableCheck createEnableCheck(final WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()).add(checkFactory.createAtLeastNCategoriesMustBeSelectedCheck(1)).add(new EnableCheck(){

            @Override
            public String check(JComponent component) {
                return RemoveSelectedCategoriesPlugIn.this.pickUnselectedCategory(workbenchContext.getLayerNamePanel(), workbenchContext.getLayerManager()) == null ? I18N.getInstance().get("ui.plugin.RemoveSelectedCategoriesPlugIn.at-least-1-category-must-be-left-unselected") : null;
            }
        });
    }

    @Override
    public Icon getIcon() {
        return IconLoader.icon("fugue/folder--minus-round.png");
    }

    private static class CategorySpec {
        private int index;
        private String name;

        public CategorySpec(String name, int index) {
            this.name = name;
            this.index = index;
        }
    }
}

