/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool.editing;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.geom.EnvelopeUtil;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.FenceLayerFinder;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.ui.cursortool.AbstractCursorTool;
import com.vividsolutions.jump.workbench.ui.cursortool.SpecifyFeaturesTool;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.SnapVerticesOp;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.plugin.VerticesInFencePlugIn;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Shape;
import java.awt.geom.NoninvertibleTransformException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;

public class SnapVerticesTool
extends SpecifyFeaturesTool {
    private final EnableCheckFactory checkFactory;

    public SnapVerticesTool(WorkbenchContext context) {
        super(context);
        this.checkFactory = EnableCheckFactory.getInstance(context);
        this.setColor(Color.green.darker());
        this.setStroke(new BasicStroke(1.0f, 0, 2, 0.0f));
        this.setViewClickBuffer(8);
    }

    @Override
    protected void gestureFinished() throws Exception {
        this.reportNothingToUndoYet();
        if (!this.check(this.checkFactory.createAtLeastNLayersMustBeEditableCheck(1))) {
            return;
        }
        Coordinate suggestedTarget = EnvelopeUtil.centre(this.getBoxInModelCoordinates());
        final Feature targetFeature = this.targetFeature(suggestedTarget, this.getBoxInModelCoordinates());
        if (!this.check(new EnableCheck(){

            @Override
            public String check(JComponent component) {
                return targetFeature == null ? I18N.getInstance().get("ui.cursortool.editing.SnapVerticesTool.no-vertices-or-edges-here") : null;
            }
        })) {
            return;
        }
        this.snapVertices(this.getPanel().getLayerManager().getEditableLayers(), suggestedTarget, targetFeature);
    }

    protected void snapVertices(Collection<Layer> editableLayers, Coordinate suggestedTarget, Feature targetFeature) throws Exception {
        new SnapVerticesOp().execute(EnvelopeUtil.toGeometry(this.getBoxInModelCoordinates()), editableLayers, this.isRollingBackInvalidEdits(), this.getPanel(), this.getTaskFrame().getTask(), suggestedTarget, targetFeature, this.getWorkbenchContext().getBlackboard().get(SnapVerticesOp.INSERT_VERTICES_IF_NECESSARY_KEY, true));
    }

    private Feature targetFeature(Coordinate suggestedTarget, Envelope fence) throws NoninvertibleTransformException {
        Feature targetFeature = this.targetFeature(suggestedTarget, fence, false);
        if (targetFeature == null) {
            targetFeature = this.targetFeature(suggestedTarget, fence, true);
        }
        return targetFeature;
    }

    private Feature targetFeature(Coordinate suggestedTarget, Envelope fence, boolean fromEditableLayers) throws NoninvertibleTransformException {
        ArrayList candidateFeatures = new ArrayList();
        Map<Layer, Set<Feature>> layerToSpecifiedFeaturesMap = this.layerToSpecifiedFeaturesMap();
        for (Layer layer : layerToSpecifiedFeaturesMap.keySet()) {
            if (layer.isEditable() != fromEditableLayers || layer.getName().equals(FenceLayerFinder.LAYER_NAME)) continue;
            candidateFeatures.addAll(layerToSpecifiedFeaturesMap.get(layer));
        }
        Feature targetFeature = null;
        double distanceToTargetVertices = -1.0;
        for (Feature candidate : candidateFeatures) {
            double distanceToCandidateVertices = this.distanceToVertices(suggestedTarget, candidate, fence);
            if (distanceToCandidateVertices == -1.0 || targetFeature != null && !(distanceToCandidateVertices < distanceToTargetVertices)) continue;
            targetFeature = candidate;
            distanceToTargetVertices = distanceToCandidateVertices;
        }
        return targetFeature;
    }

    private double distanceToVertices(Coordinate referenceCoordinate, Feature feature, Envelope vertexFilter) {
        double distanceToVertices = -1.0;
        for (Coordinate vertex : VerticesInFencePlugIn.verticesInFence(feature.getGeometry(), EnvelopeUtil.toGeometry(vertexFilter), true).getCoordinates()) {
            double distanceToVertex = vertex.distance(referenceCoordinate);
            if (distanceToVertices != -1.0 && !(distanceToVertex < distanceToVertices)) continue;
            distanceToVertices = distanceToVertex;
        }
        return distanceToVertices;
    }

    @Override
    public Icon getIcon() {
        return IconLoader.icon("QuickSnap.gif");
    }

    @Override
    public Cursor getCursor() {
        return AbstractCursorTool.createCursor(IconLoader.icon("QuickSnapCursor.gif").getImage());
    }

    @Override
    protected Envelope getBoxInModelCoordinates() {
        return EnvelopeUtil.expand(new Envelope(this.getModelSource(), this.getModelDestination()), this.modelClickBuffer());
    }

    @Override
    protected Shape getShape() throws Exception {
        return this.getPanel().getViewport().toViewRectangle(this.getBoxInModelCoordinates());
    }
}

