/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.util.Block;
import com.vividsolutions.jump.util.CollectionUtil;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.ui.cursortool.AbstractClickSelectedLineStringsTool;
import com.vividsolutions.jump.workbench.ui.cursortool.SplitLineStringsOp;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import java.awt.Color;
import java.awt.geom.NoninvertibleTransformException;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.Icon;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;

public class NodeLineStringsTool
extends AbstractClickSelectedLineStringsTool {
    private static final String sNoIntersectionsHere = I18N.getInstance().get("com.vividsolutions.jump.workbench.ui.cursortool.NodeLineStringsTool.No-intersections-here");

    public NodeLineStringsTool(WorkbenchContext context) {
        super(context);
    }

    @Override
    public String getName() {
        return I18N.getInstance().get("com.vividsolutions.jump.workbench.ui.cursortool.NodeLineStringsTool.Node-LineStrings");
    }

    @Override
    protected void gestureFinished(Collection<Feature> nearbyLineStringFeatures) throws NoninvertibleTransformException {
        Intersection intersection = this.closest(this.getModelClickPoint(), CollectionUtil.select(this.properIntersections(nearbyLineStringFeatures, this.layerToSpecifiedFeaturesMap()), new Block(){

            @Override
            public Object yield(Object intersection) {
                try {
                    return NodeLineStringsTool.this.getBoxInModelCoordinates().contains(((Intersection)intersection).coordinate) ? Boolean.TRUE : Boolean.FALSE;
                }
                catch (NoninvertibleTransformException e) {
                    return Boolean.FALSE;
                }
            }
        }));
        if (intersection == null) {
            this.getWorkbench().getFrame().warnUser(sNoIntersectionsHere);
            return;
        }
        if (!intersection.layerA.isEditable()) {
            this.warnLayerNotEditable(intersection.layerA);
            return;
        }
        if (!intersection.layerB.isEditable()) {
            this.warnLayerNotEditable(intersection.layerB);
            return;
        }
        new SplitLineStringsOp(Color.magenta).addSplit(intersection.featureA, intersection.coordinate, intersection.layerA, true).addSplit(intersection.featureB, intersection.coordinate, intersection.layerB, true).execute(this.getName(), this.isRollingBackInvalidEdits(), this.getPanel());
    }

    private Intersection closest(Point p, Collection<Intersection> intersections) {
        Intersection closestIntersection = null;
        double closestDistance = Double.MAX_VALUE;
        for (Intersection intersection : intersections) {
            double distance = intersection.coordinate.distance(p.getCoordinate());
            if (!(distance < closestDistance)) continue;
            closestIntersection = intersection;
            closestDistance = distance;
        }
        return closestIntersection;
    }

    private Set<Intersection> properIntersections(Collection<Feature> nearbyLineStringFeatures, Map<Layer, Set<Feature>> layerToFeaturesMap) {
        TreeSet<Intersection> intersections = new TreeSet<Intersection>();
        for (Feature a : nearbyLineStringFeatures) {
            for (Feature b : nearbyLineStringFeatures) {
                if (a == b) continue;
                for (Coordinate coordinate : a.getGeometry().intersection(b.getGeometry()).getCoordinates()) {
                    if (coordinate.equals2D(this.first(a)) || coordinate.equals2D(this.last(a)) || coordinate.equals2D(this.first(b)) || coordinate.equals2D(this.last(b))) continue;
                    intersections.add(new Intersection(coordinate, a, this.layer(a, layerToFeaturesMap), b, this.layer(b, layerToFeaturesMap)));
                }
            }
        }
        return intersections;
    }

    private Coordinate first(Feature lineStringFeature) {
        return this.lineString(lineStringFeature).getCoordinateN(0);
    }

    private LineString lineString(Feature feature) {
        return (LineString)feature.getGeometry();
    }

    private Coordinate last(Feature lineStringFeature) {
        return this.lineString(lineStringFeature).getCoordinateN(this.lineString(lineStringFeature).getNumPoints() - 1);
    }

    @Override
    public Icon getIcon() {
        return IconLoader.icon("SplitLinestringsAtIntersection.gif");
    }

    private static class Intersection
    implements Comparable<Intersection> {
        private final Coordinate coordinate;
        private final Feature featureA;
        private final Feature featureB;
        private final Layer layerA;
        private final Layer layerB;

        public Intersection(Coordinate coordinate, Feature featureA, Layer layerA, Feature featureB, Layer layerB) {
            this.coordinate = coordinate;
            this.featureA = featureA;
            this.layerA = layerA;
            this.featureB = featureB;
            this.layerB = layerB;
        }

        @Override
        public int compareTo(Intersection o) {
            return this.coordinate.compareTo(o.coordinate);
        }
    }
}

