/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui;

import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.ui.AbstractSelection;
import com.vividsolutions.jump.workbench.ui.FeatureSelection;
import com.vividsolutions.jump.workbench.ui.LineStringSelection;
import com.vividsolutions.jump.workbench.ui.SelectionManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.util.Assert;

public class PartSelection
extends AbstractSelection {
    @Override
    public List<Geometry> items(Geometry geometry) {
        int partNumber = geometry.getNumGeometries();
        ArrayList<Geometry> items = new ArrayList<Geometry>(partNumber);
        if (partNumber > 1) {
            for (int i = 0; i < partNumber; ++i) {
                items.addAll(this.items(geometry.getGeometryN(i)));
            }
        } else {
            items.add(geometry);
        }
        return items;
    }

    public PartSelection(SelectionManager selectionManager) {
        super(selectionManager);
    }

    @Override
    public String getRendererContentID() {
        return "SELECTED_PARTS";
    }

    @Override
    protected boolean selectedInAncestors(Layer layer, Feature feature, Geometry item) {
        Assert.isTrue((boolean)(this.getParent() instanceof FeatureSelection));
        return this.getParent().getFeaturesWithSelectedItems().contains(feature);
    }

    @Override
    protected void unselectInDescendants(Layer layer, Feature feature, Collection<Geometry> items) {
        Assert.isTrue((boolean)(this.getChild() instanceof LineStringSelection));
        for (Geometry part : items) {
            List<Geometry> partLineStrings = this.getChild().items(part);
            for (Geometry selectedItem : this.getChild().getSelectedItems(layer, feature)) {
                LineString selectedLineString = (LineString)selectedItem;
                if (!partLineStrings.contains(selectedLineString)) continue;
                this.getChild().unselectItem(layer, feature, partLineStrings.indexOf(selectedLineString));
            }
        }
    }
}

