/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui;

import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.LayerTreeModel;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.ui.LayerNameRenderer;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.renderer.LayerRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.RenderingManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import org.locationtech.jts.util.Assert;

public class LayerTreeCellRenderer
implements TreeCellRenderer {
    private final LayerNameRenderer layerNameRenderer = new LayerNameRenderer();
    private final JLabel rootRendererComponent = new JLabel("Root");
    private final DefaultTreeCellRenderer categoryRenderer = new DefaultTreeCellRenderer();
    private final RenderingManager renderingManager;
    private final Icon ctg_open = IconLoader.icon("fugue/folder-open.png");
    private final Icon ctg_closed = IconLoader.icon("fugue/folder.png");
    private static final Color GREY = new Color(128, 128, 128);

    public LayerTreeCellRenderer(RenderingManager renderingManager) {
        this.renderingManager = renderingManager;
        this.layerNameRenderer.setCheckBoxVisible(true);
        this.layerNameRenderer.setIndicatingEditability(true);
        this.layerNameRenderer.setIndicatingProgress(true, renderingManager);
    }

    public LayerNameRenderer getLayerNameRenderer() {
        return this.layerNameRenderer;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Object node = value;
        if (node instanceof LayerTreeModel.Root) {
            return this.getTreeCellRendererComponent((LayerTreeModel.Root)node);
        }
        if (node instanceof Category) {
            this.categoryRenderer.setBackgroundNonSelectionColor(tree.getBackground());
            JLabel categoryRendererComponent = (JLabel)this.categoryRenderer.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            categoryRendererComponent.setFont(new JLabel().getFont().deriveFont(1));
            categoryRendererComponent.setBorder(new EmptyBorder(new Insets(0, 0, 1, 0)));
            categoryRendererComponent.setText(((Category)node).getName());
            if (expanded) {
                categoryRendererComponent.setIcon(this.ctg_open);
            } else {
                categoryRendererComponent.setIcon(this.ctg_closed);
            }
            return categoryRendererComponent;
        }
        if (node instanceof Layerable) {
            this.layerNameRenderer.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            if (!LayerRenderer.withinVisibleScaleRange((Layerable)node, this.renderingManager.getPanel())) {
                this.layerNameRenderer.getLabel().setForeground(selected ? GREY : GREY);
            }
            return this.layerNameRenderer;
        }
        Assert.shouldNeverReachHere((String)node.getClass().toString());
        return null;
    }

    private Component getTreeCellRendererComponent(LayerTreeModel.Root root) {
        return this.rootRendererComponent;
    }
}

