/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.Logger;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.RowFilter;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.openjump.core.apitools.IOTools;
import org.openjump.core.ui.io.file.FileNameExtensionFilter;
import org.openjump.core.ui.util.LayerableUtil;

public class FeatureCollectionPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final FeatureCollection featureCollection;
    private JScrollPane pane = new JScrollPane();
    private final JPanel filterPanel = new JPanel(new BorderLayout());
    private JTable jTable = new JTable();
    private final JTable subtable = new JTable();
    private final JLabel jLabel = new JLabel();
    private final DefaultTableModel model = new DefaultTableModel();
    private final Color LIGHT_GRAY = new Color(230, 230, 230);
    private JPanel southPanel = new JPanel();
    private final String sSaved = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.RasterImageLayerPropertiesPlugIn.file.saved");
    private final String SCouldNotSave = I18N.getInstance().get("org.openjump.sextante.gui.additionalResults.AdditionalResultsPlugIn.Could-not-save-selected-result");

    public FeatureCollectionPanel(FeatureCollection featureCollection) {
        this.featureCollection = featureCollection;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            Logger.error(e);
        }
    }

    public JTable getTable() {
        return this.jTable;
    }

    private void jbInit() throws Exception {
        this.setLayout(new BorderLayout());
        this.jLabel.setText(I18N.getInstance().get("ui.AttributeTablePanel.featurecollection") + " - (" + this.featureCollection.size() + " " + I18N.getInstance().get("ui.AttributeTablePanel.features") + ")");
        this.jLabel.setFont(this.jLabel.getFont().deriveFont(1));
        this.jTable = new JTable();
        this.jTable.setGridColor(Color.WHITE);
        this.jTable.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                c.setBackground(row % 2 == 0 ? Color.white : FeatureCollectionPanel.this.LIGHT_GRAY);
                if (isSelected) {
                    c.setBackground(Color.black);
                }
                return c;
            }
        });
        this.pane = new JScrollPane(this.jTable, 20, 30);
        this.jTable.setModel(this.setTableModelFromFeatureCollection());
        this.jTable.setEnabled(true);
        this.southPanel = new JPanel(new BorderLayout());
        this.southPanel.add((Component)this.commandPanel(), "North");
        this.southPanel.add((Component)this.savePanel(), "Center");
        this.add((Component)this.jLabel, "North");
        this.add((Component)this.pane, "Center");
        this.add((Component)this.southPanel, "South");
    }

    private JPanel savePanel() {
        JPanel save = new JPanel();
        save.setLayout(new FlowLayout(2));
        JButton saveButton = new JButton(I18N.getInstance().get("deejump.plugin.SaveLegendPlugIn.Save"));
        saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    FileNameExtensionFilter filter2 = new FileNameExtensionFilter("Comma-Separated Values (csv)", "csv");
                    FileNameExtensionFilter filter3 = new FileNameExtensionFilter("JUMP Markup Language (JML)", "jml");
                    FileNameExtensionFilter filter = new FileNameExtensionFilter("ESRI Shapefile (SHP)", "shp");
                    GUIUtil.FileChooserWithOverwritePrompting fc = new GUIUtil.FileChooserWithOverwritePrompting();
                    if (!LayerableUtil.isMixedGeometryType(FeatureCollectionPanel.this.featureCollection)) {
                        fc.setFileFilter(filter);
                    }
                    fc.setFileFilter(filter3);
                    fc.setFileFilter(filter2);
                    fc.addChoosableFileFilter(filter2);
                    int returnVal = fc.showSaveDialog(JUMPWorkbench.getInstance().getFrame());
                    if (returnVal == 0) {
                        if (fc.getFileFilter().equals(filter3)) {
                            File file = new File(((JFileChooser)fc).getSelectedFile() + ".jml");
                            IOTools.saveJMLFile(FeatureCollectionPanel.this.featureCollection, file.getAbsolutePath());
                            FeatureCollectionPanel.this.saved(file);
                        } else if (fc.getFileFilter().equals(filter)) {
                            File file = new File(((JFileChooser)fc).getSelectedFile() + ".shp");
                            IOTools.saveShapefile(FeatureCollectionPanel.this.featureCollection, file.getAbsolutePath());
                            FeatureCollectionPanel.this.saved(file);
                        } else if (fc.getFileFilter().equals(filter2)) {
                            File file = new File(((JFileChooser)fc).getSelectedFile() + ".csv");
                            IOTools.saveCSV(FeatureCollectionPanel.this.jTable, file.getAbsolutePath());
                            FeatureCollectionPanel.this.saved(file);
                        }
                    }
                }
                catch (Exception ex) {
                    FeatureCollectionPanel.this.notsaved();
                }
            }
        });
        save.add(saveButton);
        return save;
    }

    private JPanel commandPanel() {
        final TableRowSorter<DefaultTableModel> sorter = new TableRowSorter<DefaultTableModel>(this.model);
        this.jTable.setRowSorter(sorter);
        final JTextField txtFilter = new JTextField();
        JButton btnOK = new JButton(IconLoader.icon("search.png"));
        btnOK.setToolTipText("Search");
        btnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                String expr = txtFilter.getText();
                sorter.setRowFilter(RowFilter.regexFilter(expr, new int[0]));
                sorter.setSortKeys(null);
                FeatureCollectionPanel.this.subtable.setRowSorter(sorter);
            }
        });
        JButton btSave = new JButton(IconLoader.icon("disk.png"));
        btSave.setToolTipText("Save search");
        btSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    FileNameExtensionFilter filter2 = new FileNameExtensionFilter("Comma-Separated Values (csv)", "csv");
                    GUIUtil.FileChooserWithOverwritePrompting fc = new GUIUtil.FileChooserWithOverwritePrompting();
                    fc.setFileFilter(filter2);
                    fc.setFileFilter(filter2);
                    fc.addChoosableFileFilter(filter2);
                    int returnVal = fc.showSaveDialog(JUMPWorkbench.getInstance().getFrame());
                    if (returnVal == 0) {
                        File file = new File(((JFileChooser)fc).getSelectedFile() + ".csv");
                        IOTools.saveCSV(FeatureCollectionPanel.this.subtable, file.getAbsolutePath());
                        FeatureCollectionPanel.this.saved(file);
                    }
                }
                catch (Exception ex) {
                    FeatureCollectionPanel.this.notsaved();
                }
            }
        });
        JPanel jbuttonpan = new JPanel();
        jbuttonpan.add((Component)btnOK, "West");
        jbuttonpan.add((Component)btSave, "East");
        this.filterPanel.add((Component)txtFilter, "Center");
        this.filterPanel.add((Component)jbuttonpan, "East");
        return this.filterPanel;
    }

    public FeatureCollection getFeatureCollection() {
        return this.featureCollection;
    }

    private TableModel setTableModelFromFeatureCollection() {
        int iCount = this.featureCollection.getFeatures().size();
        FeatureSchema schema = this.featureCollection.getFeatureSchema();
        ArrayList<String> ar = new ArrayList<String>();
        for (int j = 0; j < schema.getAttributeNames().size(); ++j) {
            String name = schema.getAttributeName(j).toString();
            ar.add(name);
        }
        Object[] fields = ar.toArray(new String[0]);
        Object[][] data = new String[iCount][fields.length];
        for (int i = 0; i < this.featureCollection.size(); ++i) {
            Feature feat = this.featureCollection.getFeatures().get(i);
            for (int j = 0; j < schema.getAttributeCount(); ++j) {
                if (feat.getSchema().getAttributeType(j) != AttributeType.GEOMETRY) {
                    data[i][j] = feat.getAttribute(j).toString();
                    continue;
                }
                String geomType = feat.getGeometry().getClass().getName();
                int dotPos = geomType.lastIndexOf(".");
                if (dotPos > 0) {
                    geomType = geomType.substring(dotPos + 1);
                }
                data[i][j] = geomType.toUpperCase();
            }
        }
        this.model.setDataVector(data, fields);
        return this.model;
    }

    public JPanel getCommandPanel() {
        return this.commandPanel();
    }

    public JPanel getSavePanel() {
        return this.savePanel();
    }

    public JPanel getSouthPanel() {
        return this.southPanel;
    }

    protected void saved(File file) {
        JUMPWorkbench.getInstance().getFrame().setStatusMessage(this.sSaved + " :" + file.getAbsolutePath());
    }

    protected void notsaved() {
        JUMPWorkbench.getInstance().getFrame().warnUser(this.SCouldNotSave);
    }
}

