/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.util.FlexibleDateParser;
import com.vividsolutions.jump.workbench.Logger;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.CategoryEvent;
import com.vividsolutions.jump.workbench.model.FeatureEvent;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerEvent;
import com.vividsolutions.jump.workbench.model.LayerEventType;
import com.vividsolutions.jump.workbench.model.LayerListener;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.AttributeTablePanelListener;
import com.vividsolutions.jump.workbench.ui.FeatureInfoWriter;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.InfoFrame;
import com.vividsolutions.jump.workbench.ui.LayerNameRenderer;
import com.vividsolutions.jump.workbench.ui.LayerTableModel;
import com.vividsolutions.jump.workbench.ui.LayerViewPanelListener;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.plugin.EditSelectedFeaturePlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.DefaultListSelectionModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.openjump.core.ui.plugin.view.ViewOptionsPlugIn;

public class AttributeTablePanel
extends JPanel
implements AttributeTablePanelListener,
HierarchyListener {
    private static final String ATTRIBUTE_COLUMNS_WIDTH_MAP = "AttributeColumnsWidthMap";
    private static final String DATE_FORMAT_KEY = ViewOptionsPlugIn.DATE_FORMAT_KEY;
    private static final String SELECTION_SYNC_KEY = ViewOptionsPlugIn.SELECTION_SYNC_KEY;
    private static SimpleDateFormat DEFAULT_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private Blackboard blackboard;
    private ImageIcon nullObject = IconLoader.icon("null1.png");
    private ImageIcon nullString = IconLoader.icon("null1.png");
    private FeatureEditor featureEditor = new FeatureEditor(){

        @Override
        public void edit(PlugInContext context, Feature feature, final Layer myLayer) throws Exception {
            new EditSelectedFeaturePlugIn(){

                @Override
                protected Layer layer(PlugInContext context) {
                    return myLayer;
                }
            }.execute(context, feature, myLayer.isEditable());
        }
    };
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private MyTable table;
    private TableCellRenderer headerRenderer;
    private LayerNameRenderer layerListCellRenderer;
    private ArrayList<AttributeTablePanelListener> listeners = new ArrayList();
    private WorkbenchContext workbenchContext;
    private Layer layer;
    private HashMap<Object, Integer> columnsWidthMap;
    private AttributeTableLayerViewPanelListener layerViewPanelListener = null;
    public LayerListener layerListener;

    private ImageIcon buildPartlyEmptyIcon(ImageIcon icon) {
        ImageIcon empty = this.buildEmptyIcon(icon);
        BufferedImage mask = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        Graphics2D g = mask.createGraphics();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, mask.getWidth(), mask.getHeight());
        g.setColor(Color.BLACK);
        g.fillRect(mask.getWidth() / 2 - 1, 0, mask.getWidth(), mask.getHeight());
        icon = GUIUtil.overlay(icon, empty, 0, 0, 1.0f, mask);
        return icon;
    }

    private ImageIcon buildEmptyIcon(ImageIcon icon) {
        ImageIcon gray = GUIUtil.toGrayScale(icon);
        BufferedImage red = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        Graphics2D g = red.createGraphics();
        g.setColor(Color.PINK);
        g.fillRect(0, 0, red.getWidth(), red.getHeight());
        return GUIUtil.overlay(new ImageIcon(red), gray, 0, 0, 1.0f, null);
    }

    private JLabel buildIconLabel(ImageIcon icon) {
        icon = GUIUtil.pad(icon, 2);
        return new JLabel(icon);
    }

    private JLabel buildEmptyIconLabel(ImageIcon icon) {
        icon = GUIUtil.pad(icon, 2);
        return this.buildIconLabel(this.buildEmptyIcon(icon));
    }

    private JLabel buildPartlyEmptyIconLabel(ImageIcon icon) {
        icon = GUIUtil.pad(icon, 2);
        return this.buildIconLabel(this.buildPartlyEmptyIcon(icon));
    }

    private boolean isPartlyEmpty(Geometry g) {
        if (g.isEmpty()) {
            return false;
        }
        for (int i = 0; i < g.getNumGeometries(); ++i) {
            Geometry inner = g.getGeometryN(i);
            if (!inner.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public AttributeTablePanel(final LayerTableModel model, boolean addScrollPane, final WorkbenchContext workbenchContext) {
        this(workbenchContext);
        this.layer = model.getLayer();
        SelectionModelWrapper selectionModel = new SelectionModelWrapper(this);
        DefaultListSelectionModel defaultSelectionModel = new DefaultListSelectionModel();
        this.table.setSelectionModel(selectionModel);
        selectionModel.setSelectionMode(2);
        this.layerViewPanelListener = new AttributeTableLayerViewPanelListener(workbenchContext, this, selectionModel, defaultSelectionModel);
        if (addScrollPane) {
            this.remove(this.table);
            this.remove(this.table.getTableHeader());
            JScrollPane scrollPane = new JScrollPane();
            scrollPane.getViewport().add(this.table);
            this.add((Component)scrollPane, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
        this.updateGrid(model.getLayer());
        this.layerListener = new LayerListener(){

            @Override
            public void categoryChanged(CategoryEvent e) {
            }

            @Override
            public void featuresChanged(FeatureEvent e) {
            }

            @Override
            public void layerChanged(LayerEvent e) {
                if (e.getLayerable() != model.getLayer()) {
                    return;
                }
                if (e.getType() == LayerEventType.METADATA_CHANGED) {
                    if (model.getLayer().getFeatureCollectionWrapper().size() == 0 || workbenchContext.getLayerViewPanel().getSelectionManager().getFeaturesWithSelectedItems(model.getLayer()).size() == 0) {
                        for (JInternalFrame iFrame : workbenchContext.getWorkbench().getFrame().getInternalFrames()) {
                            if (!(iFrame instanceof InfoFrame)) continue;
                            ((InfoFrame)iFrame).getModel().remove(model.getLayer());
                        }
                    }
                    AttributeTablePanel.this.updateGrid(model.getLayer());
                    AttributeTablePanel.this.repaint();
                }
            }
        };
        model.getLayer().getLayerManager().addLayerListener(this.layerListener);
        try {
            JList list = new JList();
            list.setBackground(new JLabel().getBackground());
            this.layerListCellRenderer.getListCellRendererComponent((JList<?>)list, model.getLayer(), -1, false, false);
            this.table.setModel(model);
            model.addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent e) {
                    if (e.getFirstRow() == -1) {
                        AttributeTablePanel.this.initColumnWidths();
                    }
                }
            });
            this.layerListCellRenderer.getLabel().setFont(this.layerListCellRenderer.getLabel().getFont().deriveFont(1));
            model.addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent e) {
                    AttributeTablePanel.this.updateLabel();
                }
            });
            this.updateLabel();
            this.table.getTableHeader().setDefaultRenderer(this.headerRenderer);
            this.initColumnWidths();
            this.setToolTips();
            this.setBorder(BorderFactory.createMatteBorder(0, 5, 0, 0, new FeatureInfoWriter().sidebarColor(model.getLayer())));
            this.table.getTableHeader().addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    try {
                        int column = AttributeTablePanel.this.table.columnAtPoint(e.getPoint());
                        if (column < 0) {
                            return;
                        }
                        if (AttributeTablePanel.this.isEditButtonColumn(column)) {
                            return;
                        }
                        if (SwingUtilities.isLeftMouseButton(e)) {
                            model.sort(AttributeTablePanel.this.table.getColumnName(column));
                            AttributeTablePanel.this.layerViewPanelListener.selectionChanged();
                        }
                    }
                    catch (Throwable t) {
                        workbenchContext.getErrorHandler().handleThrowable(t);
                    }
                }
            });
            this.table.addMouseListener(new MouseAdapter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void mouseClicked(MouseEvent e) {
                    block5: {
                        try {
                            int column = AttributeTablePanel.this.table.columnAtPoint(e.getPoint());
                            int row = AttributeTablePanel.this.table.rowAtPoint(e.getPoint());
                            if (!AttributeTablePanel.this.isEditButtonColumn(column)) break block5;
                            PlugInContext context = new PlugInContext(workbenchContext, null, model.getLayer(), null, null);
                            model.getLayer().getLayerManager().getUndoableEditReceiver().startReceiving();
                            try {
                                AttributeTablePanel.this.featureEditor.edit(context, model.getFeature(row), model.getLayer());
                            }
                            finally {
                                model.getLayer().getLayerManager().getUndoableEditReceiver().stopReceiving();
                            }
                        }
                        catch (Throwable t) {
                            workbenchContext.getErrorHandler().handleThrowable(t);
                        }
                    }
                }
            });
            workbenchContext.getLayerViewPanel().addListener(this.layerViewPanelListener);
            this.addListener(this);
            this.addHierarchyListener(this);
            this.layerViewPanelListener.selectionChanged();
        }
        catch (Throwable t) {
            workbenchContext.getErrorHandler().handleThrowable(t);
        }
    }

    @Override
    public void hierarchyChanged(HierarchyEvent e) {
        if (e.getChanged() instanceof JInternalFrame && !this.isDisplayable()) {
            this.workbenchContext.getLayerViewPanel().removeListener(this.layerViewPanelListener);
        }
    }

    private AttributeTablePanel(WorkbenchContext workbenchContext) {
        this.layerListCellRenderer = new LayerNameRenderer();
        this.layerListCellRenderer.setCheckBoxVisible(false);
        this.layerListCellRenderer.setProgressIconLabelVisible(false);
        this.workbenchContext = workbenchContext;
        this.blackboard = PersistentBlackboardPlugIn.get(workbenchContext);
        this.table = new MyTable();
        this.headerRenderer = new TableCellRenderer(){
            private Icon clearIcon = IconLoader.icon("Clear.gif");
            private Icon downIcon = IconLoader.icon("Down.gif");
            private TableCellRenderer originalRenderer = AttributeTablePanel.access$1400(AttributeTablePanel.this).getTableHeader().getDefaultRenderer();
            private Icon upIcon = IconLoader.icon("Up.gif");

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JLabel label = (JLabel)this.originalRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (AttributeTablePanel.this.getModel().getSortedColumnName() == null || !AttributeTablePanel.this.getModel().getSortedColumnName().equals(table.getColumnName(column))) {
                    label.setIcon(this.clearIcon);
                } else if (AttributeTablePanel.this.getModel().isSortAscending()) {
                    label.setIcon(this.upIcon);
                } else {
                    label.setIcon(this.downIcon);
                }
                label.setHorizontalTextPosition(2);
                return label;
            }
        };
        try {
            this.jbInit();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void updateGrid(Layer layer) {
        this.table.setShowGrid(layer.isEditable());
    }

    private boolean isEditButtonColumn(int column) {
        return this.getModel().getColumnName(0).equals(this.table.getColumnName(column));
    }

    private void updateLabel() {
        if (this.getModel().getRowCount() == 1) {
            this.layerListCellRenderer.getLabel().setText(this.getModel().getLayer().getName() + " (" + this.getModel().getRowCount() + " " + I18N.getInstance().get("ui.AttributeTablePanel.feature") + ")");
        } else {
            this.layerListCellRenderer.getLabel().setText(this.getModel().getLayer().getName() + " (" + this.getModel().getRowCount() + " " + I18N.getInstance().get("ui.AttributeTablePanel.features") + ")");
        }
    }

    public LayerTableModel getModel() {
        return (LayerTableModel)this.table.getModel();
    }

    public JTable getTable() {
        return this.table;
    }

    public void addListener(AttributeTablePanelListener listener) {
        this.listeners.add(listener);
    }

    void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout1);
        this.add((Component)this.layerListCellRenderer, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.table.getTableHeader(), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.table, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void initColumnWidths() {
        HashMap savedWidthMap;
        GUIUtil.chooseGoodColumnWidths(this.table);
        int editButtonWidth = 16;
        this.table.getColumnModel().getColumn(0).setMinWidth(editButtonWidth);
        this.table.getColumnModel().getColumn(0).setMaxWidth(editButtonWidth);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(editButtonWidth);
        if (this.layer.getDataSourceQuery() != null && (savedWidthMap = (HashMap)this.layer.getDataSourceQuery().getDataSource().getProperties().get(ATTRIBUTE_COLUMNS_WIDTH_MAP)) != null) {
            this.columnsWidthMap = savedWidthMap;
        }
        this.changeColumnWidths(this.table.getColumnModel(), false);
        this.table.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            @Override
            public void columnAdded(TableColumnModelEvent e) {
                AttributeTablePanel.this.changeColumnWidths((TableColumnModel)e.getSource(), false);
            }

            @Override
            public void columnRemoved(TableColumnModelEvent e) {
                AttributeTablePanel.this.changeColumnWidths((TableColumnModel)e.getSource(), false);
            }

            @Override
            public void columnMoved(TableColumnModelEvent e) {
                AttributeTablePanel.this.changeColumnWidths((TableColumnModel)e.getSource(), false);
            }

            @Override
            public void columnMarginChanged(ChangeEvent e) {
                AttributeTablePanel.this.changeColumnWidths((TableColumnModel)e.getSource(), true);
            }

            @Override
            public void columnSelectionChanged(ListSelectionEvent e) {
            }
        });
    }

    private void changeColumnWidths(TableColumnModel columnModel, boolean override) {
        if (this.columnsWidthMap == null) {
            this.columnsWidthMap = new HashMap(columnModel.getColumnCount());
        }
        for (int i = 0; i < columnModel.getColumnCount(); ++i) {
            Integer savedWidth = this.columnsWidthMap.get(columnModel.getColumn(i).getHeaderValue());
            Integer curWidth = columnModel.getColumn(i).getWidth();
            if (savedWidth != null && !override) {
                columnModel.getColumn(i).setPreferredWidth(savedWidth);
                continue;
            }
            this.columnsWidthMap.put(columnModel.getColumn(i).getHeaderValue(), curWidth);
        }
        if (this.layer.getDataSourceQuery() == null) {
            return;
        }
        this.layer.getDataSourceQuery().getDataSource().getProperties().put(ATTRIBUTE_COLUMNS_WIDTH_MAP, this.columnsWidthMap);
    }

    private void setToolTips() {
        this.table.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                int column = AttributeTablePanel.this.table.columnAtPoint(e.getPoint());
                if (column == -1) {
                    return;
                }
                AttributeTablePanel.this.table.setToolTipText(AttributeTablePanel.this.table.getColumnName(column) + " [" + AttributeTablePanel.this.getModel().getLayer().getName() + "]");
            }
        });
    }

    private void fireSelectionReplaced() {
        for (AttributeTablePanelListener listener : this.listeners) {
            listener.selectionReplaced();
        }
    }

    public Collection getSelectedFeatures() {
        ArrayList<Feature> selectedFeatures = new ArrayList<Feature>();
        if (this.getModel().getRowCount() == 0) {
            return selectedFeatures;
        }
        for (int index : this.table.getSelectedRows()) {
            selectedFeatures.add(this.getModel().getFeature(index));
        }
        return selectedFeatures;
    }

    LayerNameRenderer getLayerNameRenderer() {
        return this.layerListCellRenderer;
    }

    public void setFeatureEditor(FeatureEditor featureEditor) {
        this.featureEditor = featureEditor;
    }

    @Override
    public void selectionReplaced() {
        boolean sync;
        Object syncObject = PersistentBlackboardPlugIn.get(this.workbenchContext).get(SELECTION_SYNC_KEY);
        boolean bl = sync = syncObject != null && Boolean.parseBoolean(syncObject.toString());
        if (!sync) {
            return;
        }
        this.workbenchContext.getLayerViewPanel().getSelectionManager().unselectItems(this.getModel().getLayer());
        HashMap<Feature, List<Geometry>> map = new HashMap<Feature, List<Geometry>>();
        for (int index : this.table.getSelectedRows()) {
            Feature feature = this.getModel().getFeature(index);
            map.put(feature, Collections.singletonList(feature.getGeometry()));
        }
        this.workbenchContext.getLayerViewPanel().getSelectionManager().getFeatureSelection().selectItems(this.getModel().getLayer(), map);
    }

    static /* synthetic */ JLabel access$700(AttributeTablePanel x0, ImageIcon x1) {
        return x0.buildIconLabel(x1);
    }

    static /* synthetic */ JLabel access$800(AttributeTablePanel x0, ImageIcon x1) {
        return x0.buildEmptyIconLabel(x1);
    }

    static /* synthetic */ JLabel access$900(AttributeTablePanel x0, ImageIcon x1) {
        return x0.buildPartlyEmptyIconLabel(x1);
    }

    private static class AttributeTableLayerViewPanelListener
    implements LayerViewPanelListener {
        final WorkbenchContext workbenchContext;
        final AttributeTablePanel attributeTablePanel;
        final SelectionModelWrapper selectionModel;
        final DefaultListSelectionModel defaultSelectionModel;

        AttributeTableLayerViewPanelListener(WorkbenchContext context, AttributeTablePanel attributeTablePanel, SelectionModelWrapper selectionModel, DefaultListSelectionModel defaultSelectionModel) {
            this.workbenchContext = context;
            this.attributeTablePanel = attributeTablePanel;
            this.selectionModel = selectionModel;
            this.defaultSelectionModel = defaultSelectionModel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void selectionChanged() {
            Object syncObject = PersistentBlackboardPlugIn.get(this.workbenchContext).get(SELECTION_SYNC_KEY);
            boolean sync = syncObject != null && Boolean.parseBoolean(syncObject.toString());
            try {
                if (this.workbenchContext.getWorkbench().getFrame().getActiveInternalFrame().isAncestorOf(this.attributeTablePanel)) {
                    return;
                }
                if (this.workbenchContext.getWorkbench().getFrame().getActiveInternalFrame().isAncestorOf(this.attributeTablePanel)) {
                    return;
                }
                if (!sync) {
                    return;
                }
                Collection<Feature> selection = this.workbenchContext.getLayerViewPanel().getSelectionManager().getFeaturesWithSelectedItems(this.attributeTablePanel.layer);
                PersistentBlackboardPlugIn.get(this.workbenchContext).put(ViewOptionsPlugIn.SELECTION_SYNC_KEY, false);
                this.attributeTablePanel.table.clearSelection();
                HashMap<Integer, Integer> mapIdRow = new HashMap<Integer, Integer>();
                int rowCount = this.attributeTablePanel.getModel().getRowCount();
                for (int row = 0; row < rowCount; ++row) {
                    mapIdRow.put(this.attributeTablePanel.getModel().getFeature(row).getID(), row);
                }
                if (selection.size() > 0) {
                    ArrayList<Feature> newFeatures = new ArrayList<Feature>();
                    for (Feature obj : selection) {
                        int fid = obj.getID();
                        if (mapIdRow.containsKey(fid)) continue;
                        newFeatures.add(obj);
                    }
                    this.attributeTablePanel.getModel().addAll(newFeatures);
                    for (int row = 0; row < this.attributeTablePanel.getModel().getRowCount(); ++row) {
                        mapIdRow.put(this.attributeTablePanel.getModel().getFeature(row).getID(), row);
                    }
                }
                TreeSet<Integer> rowset = new TreeSet<Integer>();
                Iterator<Feature> row = selection.iterator();
                while (row.hasNext()) {
                    Feature obj;
                    Feature f = obj = row.next();
                    int id = f.getID();
                    Integer i = (Integer)mapIdRow.get(id);
                    rowset.add(i);
                }
                int rowini = -2;
                int rowfin = -2;
                this.attributeTablePanel.table.setSelectionModel(this.defaultSelectionModel);
                Iterator iterator = rowset.iterator();
                while (iterator.hasNext()) {
                    int row2 = (Integer)iterator.next();
                    if (row2 == rowfin + 1) {
                        rowfin = row2;
                        continue;
                    }
                    if (row2 <= rowfin + 1) continue;
                    if (rowfin >= rowini && rowini > -1) {
                        this.selectionModel.addSelectionInterval(rowini, rowfin);
                    }
                    rowini = row2;
                    rowfin = row2;
                }
                if (rowfin >= rowini && rowini > -1) {
                    this.selectionModel.addSelectionInterval(rowini, rowfin);
                }
                this.attributeTablePanel.table.setSelectionModel(this.selectionModel);
            }
            finally {
                PersistentBlackboardPlugIn.get(this.workbenchContext).put(ViewOptionsPlugIn.SELECTION_SYNC_KEY, sync);
            }
        }

        @Override
        public void cursorPositionChanged(String x, String y) {
        }

        @Override
        public void painted(Graphics graphics) {
        }
    }

    private class SelectionModelWrapper
    implements ListSelectionModel {
        private AttributeTablePanel panel;
        private ListSelectionModel selectionModel;

        private boolean isSynchronized() {
            Object sync = AttributeTablePanel.this.blackboard.get(SELECTION_SYNC_KEY);
            return sync != null && Boolean.parseBoolean(sync.toString());
        }

        SelectionModelWrapper(AttributeTablePanel panel) {
            this.panel = panel;
            this.selectionModel = panel.table.getSelectionModel();
        }

        @Override
        public void setAnchorSelectionIndex(int index) {
            this.selectionModel.setAnchorSelectionIndex(index);
        }

        @Override
        public void setLeadSelectionIndex(int index) {
            this.selectionModel.setLeadSelectionIndex(index);
        }

        @Override
        public void setSelectionInterval(int index0, int index1) {
            this.selectionModel.setSelectionInterval(index0, index1);
            if (this.isSynchronized()) {
                this.panel.fireSelectionReplaced();
            }
        }

        @Override
        public void setSelectionMode(int selectionMode) {
            this.selectionModel.setSelectionMode(selectionMode);
        }

        @Override
        public void setValueIsAdjusting(boolean valueIsAdjusting) {
            this.selectionModel.setValueIsAdjusting(valueIsAdjusting);
        }

        @Override
        public int getAnchorSelectionIndex() {
            return this.selectionModel.getAnchorSelectionIndex();
        }

        @Override
        public int getLeadSelectionIndex() {
            return this.selectionModel.getLeadSelectionIndex();
        }

        @Override
        public int getMaxSelectionIndex() {
            return this.selectionModel.getMaxSelectionIndex();
        }

        @Override
        public int getMinSelectionIndex() {
            return this.selectionModel.getMinSelectionIndex();
        }

        @Override
        public int getSelectionMode() {
            return this.selectionModel.getSelectionMode();
        }

        @Override
        public boolean getValueIsAdjusting() {
            return this.selectionModel.getValueIsAdjusting();
        }

        @Override
        public boolean isSelectedIndex(int index) {
            return this.selectionModel.isSelectedIndex(index);
        }

        @Override
        public boolean isSelectionEmpty() {
            return this.selectionModel.isSelectionEmpty();
        }

        @Override
        public void addListSelectionListener(ListSelectionListener x) {
            this.selectionModel.addListSelectionListener(x);
        }

        @Override
        public void addSelectionInterval(int index0, int index1) {
            this.selectionModel.addSelectionInterval(index0, index1);
            if (this.isSynchronized()) {
                this.panel.fireSelectionReplaced();
            }
        }

        @Override
        public void clearSelection() {
            this.selectionModel.clearSelection();
            if (this.isSynchronized()) {
                this.panel.fireSelectionReplaced();
            }
        }

        @Override
        public void insertIndexInterval(int index, int length, boolean before) {
            this.selectionModel.insertIndexInterval(index, length, before);
            if (this.isSynchronized()) {
                this.panel.fireSelectionReplaced();
            }
        }

        @Override
        public void removeIndexInterval(int index0, int index1) {
            this.selectionModel.removeIndexInterval(index0, index1);
            if (this.isSynchronized()) {
                this.panel.fireSelectionReplaced();
            }
        }

        @Override
        public void removeListSelectionListener(ListSelectionListener x) {
            this.selectionModel.removeListSelectionListener(x);
        }

        @Override
        public void removeSelectionInterval(int index0, int index1) {
            this.selectionModel.removeSelectionInterval(index0, index1);
            if (this.isSynchronized()) {
                this.panel.fireSelectionReplaced();
            }
        }
    }

    private class GeometryCellRenderer
    implements TableCellRenderer {
        private ImageIcon gc = IconLoader.icon("EditGeometryCollection.gif");
        private ImageIcon point = IconLoader.icon("EditPoint.gif");
        private ImageIcon mpoint = IconLoader.icon("EditMultiPoint.gif");
        private ImageIcon line = IconLoader.icon("EditLineString.gif");
        private ImageIcon mline = IconLoader.icon("EditMultiLineString.gif");
        private ImageIcon poly = IconLoader.icon("EditPolygon.gif");
        private ImageIcon mpoly = IconLoader.icon("EditMultiPolygon.gif");
        private ImageIcon lring = IconLoader.icon("EditLinearRing.gif");
        private JLabel buttonPoint = AttributeTablePanel.access$700(AttributeTablePanel.this, this.point);
        private JLabel buttonMultiPoint = AttributeTablePanel.access$700(AttributeTablePanel.this, this.mpoint);
        private JLabel buttonLineString = AttributeTablePanel.access$700(AttributeTablePanel.this, this.line);
        private JLabel buttonMultiLineString = AttributeTablePanel.access$700(AttributeTablePanel.this, this.mline);
        private JLabel buttonPolygon = AttributeTablePanel.access$700(AttributeTablePanel.this, this.poly);
        private JLabel buttonMultiPolygon = AttributeTablePanel.access$700(AttributeTablePanel.this, this.mpoly);
        private JLabel buttonGC = AttributeTablePanel.access$700(AttributeTablePanel.this, this.gc);
        private JLabel buttonLinearRing = AttributeTablePanel.access$700(AttributeTablePanel.this, this.lring);
        private JLabel buttonPointEmpty = AttributeTablePanel.access$800(AttributeTablePanel.this, this.point);
        private JLabel buttonMultiPointEmpty = AttributeTablePanel.access$800(AttributeTablePanel.this, this.mpoint);
        private JLabel buttonLineStringEmpty = AttributeTablePanel.access$800(AttributeTablePanel.this, this.line);
        private JLabel buttonMultiLineStringEmpty = AttributeTablePanel.access$800(AttributeTablePanel.this, this.mline);
        private JLabel buttonPolygonEmpty = AttributeTablePanel.access$800(AttributeTablePanel.this, this.poly);
        private JLabel buttonMultiPolygonEmpty = AttributeTablePanel.access$800(AttributeTablePanel.this, this.mpoly);
        private JLabel buttonGCEmpty = AttributeTablePanel.access$800(AttributeTablePanel.this, this.gc);
        private JLabel buttonLinearRingEmpty = AttributeTablePanel.access$800(AttributeTablePanel.this, this.lring);
        private JLabel buttonMultiPointPartlyEmpty = AttributeTablePanel.access$900(AttributeTablePanel.this, this.mpoint);
        private JLabel buttonMultiLineStringPartlyEmpty = AttributeTablePanel.access$900(AttributeTablePanel.this, this.mline);
        private JLabel buttonMultiPolygonPartlyEmpty = AttributeTablePanel.access$900(AttributeTablePanel.this, this.mpoly);
        private JLabel buttonGCPartlyEmpty = AttributeTablePanel.access$900(AttributeTablePanel.this, this.gc);

        GeometryCellRenderer() {
            JLabel[] buttons;
            String text = I18N.getInstance().get("ui.AttributeTablePanel.feature.view-edit");
            for (JLabel button : buttons = new JLabel[]{this.buttonPoint, this.buttonMultiPoint, this.buttonLineString, this.buttonMultiLineString, this.buttonPolygon, this.buttonMultiPolygon, this.buttonGC, this.buttonLinearRing, this.buttonPointEmpty, this.buttonMultiPointEmpty, this.buttonLineStringEmpty, this.buttonMultiLineStringEmpty, this.buttonPolygonEmpty, this.buttonMultiPolygonEmpty, this.buttonGCEmpty, this.buttonLinearRingEmpty}) {
                button.setToolTipText(text);
            }
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Feature f = (Feature)value;
            Geometry g = f.getGeometry();
            if (g instanceof LinearRing) {
                return g.isEmpty() ? this.buttonLinearRingEmpty : this.buttonLinearRing;
            }
            if (g instanceof Point) {
                return g.isEmpty() ? this.buttonPointEmpty : this.buttonPoint;
            }
            if (g instanceof MultiPoint) {
                return g.isEmpty() ? this.buttonMultiPointEmpty : (AttributeTablePanel.this.isPartlyEmpty(g) ? this.buttonMultiPointPartlyEmpty : this.buttonMultiPoint);
            }
            if (g instanceof LineString) {
                return g.isEmpty() ? this.buttonLineStringEmpty : this.buttonLineString;
            }
            if (g instanceof MultiLineString) {
                return g.isEmpty() ? this.buttonMultiLineStringEmpty : (AttributeTablePanel.this.isPartlyEmpty(g) ? this.buttonMultiLineStringPartlyEmpty : this.buttonMultiLineString);
            }
            if (g instanceof Polygon) {
                return g.isEmpty() ? this.buttonPolygonEmpty : this.buttonPolygon;
            }
            if (g instanceof MultiPolygon) {
                return g.isEmpty() ? this.buttonMultiPolygonEmpty : (AttributeTablePanel.this.isPartlyEmpty(g) ? this.buttonMultiPolygonPartlyEmpty : this.buttonMultiPolygon);
            }
            return g.isEmpty() ? this.buttonGCEmpty : (AttributeTablePanel.this.isPartlyEmpty(g) ? this.buttonGCPartlyEmpty : this.buttonGC);
        }
    }

    private class NullifyMouseAdapter
    extends MouseAdapter {
        JTable table;
        final PopUpNullifyCell menu;
        final long delay = 500L;
        boolean leftButtonPressed;

        NullifyMouseAdapter(JTable table) {
            this.menu = new PopUpNullifyCell();
            this.delay = 500L;
            this.leftButtonPressed = false;
            this.table = table;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.leftButtonPressed = true;
            if (SwingUtilities.isLeftMouseButton(e)) {
                int row = this.table.convertRowIndexToModel(this.table.getEditingRow());
                int column = this.table.convertColumnIndexToModel(this.table.getEditingColumn());
                this.menu.anItem.addActionListener(e1 -> {
                    this.table.removeEditor();
                    this.table.getModel().setValueAt(null, row, column);
                });
                new Thread(() -> {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (this.leftButtonPressed) {
                        this.menu.show(e.getComponent(), e.getX(), e.getY());
                    }
                }).start();
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.leftButtonPressed = false;
            this.menu.setVisible(false);
        }
    }

    private class PopUpNullifyCell
    extends JPopupMenu {
        JMenuItem anItem;

        PopUpNullifyCell() {
            this.anItem = new JMenuItem(AttributeTablePanel.this.nullString);
            this.add(this.anItem);
        }
    }

    private class NullableCheckBox
    extends JCheckBox
    implements TableCellRenderer {
        NullableCheckBox() {
            this.setHorizontalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) {
                this.setIcon(AttributeTablePanel.this.nullObject);
            } else {
                super.setSelected((Boolean)value);
            }
            return this;
        }
    }

    private class MyTable
    extends JTable {
        private final Color LIGHT_GRAY = new Color(230, 230, 230);
        private final GeometryCellRenderer geomCellRenderer = new GeometryCellRenderer();

        MyTable() {
            SimpleDateFormat formatter;
            this.setAutoResizeMode(0);
            GUIUtil.doNotRoundDoubles(this);
            AttributeTablePanel.this.blackboard = PersistentBlackboardPlugIn.get(AttributeTablePanel.this.workbenchContext);
            this.setRowHeight(18);
            try {
                formatter = AttributeTablePanel.this.blackboard.get(DATE_FORMAT_KEY) == null ? DEFAULT_DATE_FORMAT : new SimpleDateFormat(AttributeTablePanel.this.blackboard.get(DATE_FORMAT_KEY).toString());
            }
            catch (IllegalArgumentException e) {
                formatter = DEFAULT_DATE_FORMAT;
            }
            this.setDefaultEditor(Date.class, new FlexibleDateParser.CellEditor(formatter));
        }

        private boolean isLayerEditable() {
            return AttributeTablePanel.this.getModel().getLayer().isEditable();
        }

        private boolean isColumnEditable(int column) {
            LayerTableModel model = AttributeTablePanel.this.getModel();
            FeatureSchema schema = model.getLayer().getFeatureCollectionWrapper().getFeatureSchema();
            String colName = model.getColumn(column).getName();
            return !colName.equals("FID") && !colName.equals(" ") && !schema.isAttributeReadOnly(schema.getAttributeIndex(colName));
        }

        private boolean isCellEditable(int column) {
            return this.isLayerEditable() && this.isColumnEditable(column);
        }

        @Override
        public Component prepareEditor(TableCellEditor editor, int row, int column) {
            Component c = super.prepareEditor(editor, row, column);
            if (c instanceof JTextField) {
                ((JTextField)c).setEditable(this.isCellEditable(column));
                ((JTextField)c).setBorder(null);
            } else if (c instanceof JCheckBox) {
                c.setEnabled(this.isCellEditable(column));
            }
            for (MouseListener ml : c.getMouseListeners()) {
                if (!(ml instanceof NullifyMouseAdapter)) continue;
                c.removeMouseListener(ml);
            }
            if (this.isCellEditable(column)) {
                c.addMouseListener(new NullifyMouseAdapter(this));
            }
            return c;
        }

        @Override
        public TableCellRenderer getCellRenderer(int row, int column) {
            SimpleDateFormat dateFormatter;
            if (AttributeTablePanel.this.isEditButtonColumn(column)) {
                return this.geomCellRenderer;
            }
            JComponent renderer = (JComponent)((Object)super.getCellRenderer(row, column));
            try {
                dateFormatter = AttributeTablePanel.this.blackboard.get(DATE_FORMAT_KEY) == null ? DEFAULT_DATE_FORMAT : new SimpleDateFormat(AttributeTablePanel.this.blackboard.get(DATE_FORMAT_KEY).toString());
            }
            catch (IllegalArgumentException e) {
                dateFormatter = DEFAULT_DATE_FORMAT;
            }
            final SimpleDateFormat finalDateFormatter = dateFormatter;
            DefaultTableCellRenderer dateRenderer = new DefaultTableCellRenderer(){

                @Override
                public void setValue(Object value) {
                    if (value == null || value.toString().isEmpty()) {
                        this.setIcon(AttributeTablePanel.this.nullString);
                        this.setHorizontalAlignment(0);
                    } else {
                        try {
                            this.setText(finalDateFormatter.format(value));
                        }
                        catch (IllegalArgumentException e) {
                            Logger.warn(e);
                            this.setIcon(AttributeTablePanel.this.nullString);
                        }
                    }
                }
            };
            this.setDefaultRenderer(Date.class, dateRenderer);
            this.setDefaultRenderer(Boolean.class, new NullableCheckBox());
            DefaultTableCellRenderer toStringRenderer = new DefaultTableCellRenderer(){

                @Override
                public void setValue(Object value) {
                    if (value == null) {
                        this.setIcon(AttributeTablePanel.this.nullObject);
                        this.setHorizontalAlignment(0);
                    } else {
                        this.setText(value.toString());
                    }
                }
            };
            this.setDefaultRenderer(Object.class, toStringRenderer);
            if (!this.isColumnEditable(column)) {
                renderer.setBackground(this.LIGHT_GRAY);
            } else {
                renderer.setBackground(this.isCellEditable(column) || row % 2 == 0 ? Color.white : this.LIGHT_GRAY);
            }
            return (TableCellRenderer)((Object)renderer);
        }
    }

    public static interface FeatureEditor {
        public void edit(PlugInContext var1, Feature var2, Layer var3) throws Exception;
    }
}

